/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.transfer.module;

import com.elluminate.engine.CommandExecutionException;
import com.elluminate.engine.CommandParameterException;
import com.elluminate.engine.command.AbstractCommand;
import com.elluminate.engine.command.LoadFileCommand;
import com.elluminate.groupware.transfer.module.StringsProperties;
import com.elluminate.groupware.transfer.module.TransferBean;
import com.elluminate.util.I18n;
import com.elluminate.util.PropertiesEnum;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Locale;

public class LoadFileCmd
extends AbstractCommand
implements LoadFileCommand {
    private String fileURL = null;
    private boolean prompt = true;
    private I18n i18n = I18n.create((Object)((Object)this));
    private Provider<TransferBean> beanProvider;

    @Inject
    public void initChatBeanProvider(Provider<TransferBean> bp) {
        this.beanProvider = bp;
    }

    public void setFile(String fileURL) {
        this.fileURL = fileURL;
    }

    public void setPromptParticipants(boolean prompt) {
        this.prompt = prompt;
    }

    protected void doexecute() throws CommandExecutionException {
        this.validateIsOnlineAndIsChair();
        if (this.fileURL == null || this.fileURL.length() < 1) {
            throw new CommandParameterException("File parameter must be set", this.i18n.getString((PropertiesEnum)StringsProperties.LOADFILECMD_BADPARAMFILENOTSET));
        }
        try {
            URL u = new URL(this.fileURL);
            String proto = u.getProtocol().toLowerCase(Locale.ENGLISH);
            if (!(proto.equals("agenda") || proto.equals("http") || proto.equals("ftp") || proto.equals("https"))) {
                throw new CommandParameterException("Disallowed URL: " + this.fileURL, this.i18n.getString((PropertiesEnum)StringsProperties.LOADFILECMD_BADPARAMURLNOTSUPPORTED, new Object[]{this.fileURL}));
            }
            ((TransferBean)this.beanProvider.get()).addURL(u, this.prompt);
        }
        catch (MalformedURLException ex) {
            throw new CommandParameterException("Invalid URL: " + this.fileURL, this.i18n.getString((PropertiesEnum)StringsProperties.LOADFILECMD_BADPARAMINVALIDURL, new Object[]{this.fileURL}));
        }
    }
}

