/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.nio;

import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.CipherHelper;
import com.hazelcast.nio.Connection;
import com.hazelcast.nio.IOService;
import com.hazelcast.nio.IOUtil;
import com.hazelcast.nio.Packet;
import com.hazelcast.nio.SocketWriter;
import java.nio.ByteBuffer;
import java.util.logging.Level;
import javax.crypto.Cipher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SocketPacketWriter
implements SocketWriter<Packet> {
    private final PacketWriter packetWriter;
    final Connection connection;
    final ILogger logger;

    SocketPacketWriter(Connection connection) {
        this.connection = connection;
        IOService ioService = connection.getConnectionManager().ioService;
        this.logger = ioService.getLogger(SocketPacketWriter.class.getName());
        boolean symmetricEncryptionEnabled = CipherHelper.isSymmetricEncryptionEnabled(ioService);
        boolean asymmetricEncryptionEnabled = CipherHelper.isAsymmetricEncryptionEnabled(ioService);
        if (asymmetricEncryptionEnabled || symmetricEncryptionEnabled) {
            if (asymmetricEncryptionEnabled && symmetricEncryptionEnabled) {
                this.logger.log(Level.INFO, "Incorrect encryption configuration.");
                this.logger.log(Level.INFO, "You can enable either SymmetricEncryption or AsymmetricEncryption.");
                throw new RuntimeException();
            }
            if (symmetricEncryptionEnabled) {
                this.packetWriter = new SymmetricCipherPacketWriter();
                this.logger.log(Level.INFO, "Writer started with SymmetricEncryption");
            } else {
                this.packetWriter = new AsymmetricCipherPacketWriter();
                this.logger.log(Level.INFO, "Writer started with AsymmetricEncryption");
            }
        } else {
            this.packetWriter = new DefaultPacketWriter();
        }
    }

    @Override
    public boolean write(Packet socketWritable, ByteBuffer socketBuffer) throws Exception {
        return this.packetWriter.writePacket(socketWritable, socketBuffer);
    }

    class AsymmetricCipherPacketWriter
    implements PacketWriter {
        final ByteBuffer cipherBuffer = ByteBuffer.allocate(65536);
        final Cipher cipher;
        final int writeBlockSize;
        boolean aliasWritten = false;

        AsymmetricCipherPacketWriter() {
            Cipher c = null;
            try {
                c = CipherHelper.createAsymmetricWriterCipher(SocketPacketWriter.this.connection.getConnectionManager().ioService);
            }
            catch (Exception e) {
                SocketPacketWriter.this.logger.log(Level.SEVERE, "Asymmetric Cipher for WriteHandler cannot be initialized.", e);
                this.cipher = null;
                this.writeBlockSize = 0;
                CipherHelper.handleCipherException(e, SocketPacketWriter.this.connection);
                return;
            }
            this.cipher = c;
            this.writeBlockSize = this.cipher.getBlockSize();
        }

        public boolean writePacket(Packet packet, ByteBuffer socketBB) throws Exception {
            boolean complete;
            if (!this.aliasWritten) {
                String localAlias = CipherHelper.getKeyAlias(SocketPacketWriter.this.connection.getConnectionManager().ioService);
                byte[] localAliasBytes = localAlias.getBytes();
                socketBB.putInt(localAliasBytes.length);
                socketBB.put(localAliasBytes);
                this.aliasWritten = true;
            }
            if (complete = this.encryptAndWrite(packet, socketBB)) {
                this.aliasWritten = false;
            }
            return complete;
        }

        public final boolean encryptAndWrite(Packet packet, ByteBuffer socketBB) throws Exception {
            if (this.cipherBuffer.position() > 0 && socketBB.hasRemaining()) {
                this.cipherBuffer.flip();
                IOUtil.copyToDirectBuffer(this.cipherBuffer, socketBB);
                if (this.cipherBuffer.hasRemaining()) {
                    this.cipherBuffer.compact();
                } else {
                    this.cipherBuffer.clear();
                }
            }
            packet.totalWritten += this.encryptAndWriteToSocket(packet.bbSizes, socketBB);
            packet.totalWritten += this.encryptAndWriteToSocket(packet.bbHeader, socketBB);
            if (packet.getKey() != null && packet.getKey().size() > 0 && socketBB.hasRemaining()) {
                packet.totalWritten += this.encryptAndWriteToSocket(packet.getKey().buffer, socketBB);
            }
            if (packet.getValue() != null && packet.getValue().size() > 0 && socketBB.hasRemaining()) {
                packet.totalWritten += this.encryptAndWriteToSocket(packet.getValue().buffer, socketBB);
            }
            return packet.totalWritten >= packet.totalSize;
        }

        private int encryptAndWriteToSocket(ByteBuffer src, ByteBuffer socketBB) throws Exception {
            int remaining = src.remaining();
            if (src.hasRemaining()) {
                this.doCipherUpdate(src);
                this.cipherBuffer.flip();
                IOUtil.copyToDirectBuffer(this.cipherBuffer, socketBB);
                if (this.cipherBuffer.hasRemaining()) {
                    this.cipherBuffer.compact();
                } else {
                    this.cipherBuffer.clear();
                }
                return remaining - src.remaining();
            }
            return 0;
        }

        private void doCipherUpdate(ByteBuffer src) throws Exception {
            while (src.hasRemaining()) {
                int remaining = src.remaining();
                if (remaining > this.writeBlockSize) {
                    int oldLimit = src.limit();
                    src.limit(src.position() + this.writeBlockSize);
                    int outputAppendSize = this.cipher.doFinal(src, this.cipherBuffer);
                    src.limit(oldLimit);
                    continue;
                }
                int n = this.cipher.doFinal(src, this.cipherBuffer);
            }
        }
    }

    class DefaultPacketWriter
    implements PacketWriter {
        DefaultPacketWriter() {
        }

        public boolean writePacket(Packet packet, ByteBuffer socketBB) {
            return packet.writeToSocketBuffer(socketBB);
        }
    }

    static interface PacketWriter {
        public boolean writePacket(Packet var1, ByteBuffer var2) throws Exception;
    }

    class SymmetricCipherPacketWriter
    implements PacketWriter {
        boolean sizeWritten = false;
        final ByteBuffer cipherBuffer = ByteBuffer.allocate(32768);
        final Cipher cipher;

        SymmetricCipherPacketWriter() {
            Cipher c = null;
            try {
                c = CipherHelper.createSymmetricWriterCipher(SocketPacketWriter.this.connection.getConnectionManager().ioService);
            }
            catch (Exception e) {
                SocketPacketWriter.this.logger.log(Level.SEVERE, "Symmetric Cipher for WriteHandler cannot be initialized.", e);
                CipherHelper.handleCipherException(e, SocketPacketWriter.this.connection);
            }
            this.cipher = c;
        }

        public boolean writePacket(Packet packet, ByteBuffer socketBB) throws Exception {
            boolean complete;
            if (this.cipherBuffer.position() > 0 && socketBB.hasRemaining()) {
                this.cipherBuffer.flip();
                IOUtil.copyToDirectBuffer(this.cipherBuffer, socketBB);
                if (this.cipherBuffer.hasRemaining()) {
                    this.cipherBuffer.compact();
                } else {
                    this.cipherBuffer.clear();
                }
            }
            if (!this.sizeWritten) {
                int cipherSize = this.cipher.getOutputSize(packet.totalSize);
                socketBB.putInt(cipherSize);
                this.sizeWritten = true;
            }
            packet.totalWritten += this.encryptAndWriteToSocket(packet.bbSizes, socketBB);
            packet.totalWritten += this.encryptAndWriteToSocket(packet.bbHeader, socketBB);
            if (packet.getKey() != null && packet.getKey().size() > 0 && socketBB.hasRemaining()) {
                packet.totalWritten += this.encryptAndWriteToSocket(packet.getKey().buffer, socketBB);
            }
            if (packet.getValue() != null && packet.getValue().size() > 0 && socketBB.hasRemaining()) {
                packet.totalWritten += this.encryptAndWriteToSocket(packet.getValue().buffer, socketBB);
            }
            boolean bl = complete = packet.totalWritten >= packet.totalSize;
            if (complete) {
                if (socketBB.remaining() >= this.cipher.getOutputSize(0)) {
                    this.sizeWritten = false;
                    socketBB.put(this.cipher.doFinal());
                } else {
                    return false;
                }
            }
            return complete;
        }

        private int encryptAndWriteToSocket(ByteBuffer src, ByteBuffer socketBB) throws Exception {
            int remaining = src.remaining();
            if (src.hasRemaining() && this.cipherBuffer.hasRemaining()) {
                int outputSize = this.cipher.getOutputSize(src.remaining());
                if (outputSize <= this.cipherBuffer.remaining()) {
                    this.cipher.update(src, this.cipherBuffer);
                } else {
                    int min = Math.min(src.remaining(), this.cipherBuffer.remaining());
                    int len = min / 2;
                    if (len > 0) {
                        int limitOld = src.limit();
                        src.limit(src.position() + len);
                        this.cipher.update(src, this.cipherBuffer);
                        src.limit(limitOld);
                    } else {
                        return 0;
                    }
                }
                this.cipherBuffer.flip();
                IOUtil.copyToDirectBuffer(this.cipherBuffer, socketBB);
                if (this.cipherBuffer.hasRemaining()) {
                    this.cipherBuffer.compact();
                } else {
                    this.cipherBuffer.clear();
                }
                return remaining - src.remaining();
            }
            return 0;
        }
    }
}

