/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.jinx.core.metrics;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.util.StatusPrinter;
import com.elluminate.jinx.core.metrics.DefaultMetricsInstanceImpl;
import com.elluminate.jinx.core.metrics.MetricsInstance;
import com.elluminate.jinx.core.metrics.MetricsLogger;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DefaultMetricsLogger
implements MetricsLogger {
    private static final String SHOW_METRIC_LOG_STATUS_ARG = "showMetricsLoggingStatus";
    private static final String LOGGING_CONFIGURED_ARG = "loggingConfigured";
    private final boolean LOGGING_CONFIGURED = System.getProperty("loggingConfigured", null) != null;
    private final boolean SHOW_METRIC_LOG_STATUS = System.getProperty("showMetricsLoggingStatus", null) != null;
    private final HashMap<String, MetricsInstance> metricsInstanceByLoggerMap = new HashMap();
    protected String serverName = "127.0.0.1";
    private boolean enableLogging = false;
    private boolean announceLog = this.SHOW_METRIC_LOG_STATUS;

    DefaultMetricsLogger() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MetricsInstance getMetricsLogger(String metric) {
        HashMap<String, MetricsInstance> hashMap = this.metricsInstanceByLoggerMap;
        synchronized (hashMap) {
            MetricsInstance metricsInstance = this.metricsInstanceByLoggerMap.get(metric);
            if (metricsInstance == null) {
                Logger logger = null;
                if (this.LOGGING_CONFIGURED && this.enableLogging) {
                    logger = LoggerFactory.getLogger((String)("metrics." + metric));
                    if (this.announceLog && logger instanceof ch.qos.logback.classic.Logger) {
                        LoggerContext lc = (LoggerContext)LoggerFactory.getILoggerFactory();
                        StatusPrinter.print((Context)lc);
                    }
                    this.announceLog = false;
                } else if (this.announceLog) {
                    System.out.println("Metrics logging is NOT Configured.");
                    this.announceLog = false;
                }
                metricsInstance = new DefaultMetricsInstanceImpl(logger, metric);
                this.metricsInstanceByLoggerMap.put(metric, metricsInstance);
            }
            return metricsInstance;
        }
    }

    @Override
    public void enableLogging(boolean enableLoggingArg) {
        this.enableLogging = enableLoggingArg && this.LOGGING_CONFIGURED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() {
        HashMap<String, MetricsInstance> hashMap = this.metricsInstanceByLoggerMap;
        synchronized (hashMap) {
            this.metricsInstanceByLoggerMap.clear();
        }
    }

    @Override
    public boolean isLoggingEnabled() {
        return this.enableLogging;
    }

    @Override
    public void setServerName(String serverNameArg) {
        this.serverName = serverNameArg;
    }
}

