/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.jinx;

import com.elluminate.jinx.AppointmentScheduler;
import com.elluminate.jinx.BandwidthLimit;
import com.elluminate.jinx.DebugFlags;
import com.elluminate.jinx.LimitSet;
import com.elluminate.util.TimerResolution;
import com.elluminate.util.log.LogSupport;

public class XmitScheduler {
    public static final int NO_MAXIMUM = -1;
    private long resolution = TimerResolution.get();
    private Object lock = new Object();
    private Runnable callback;
    private LimitSet limits;
    private AppointmentScheduler scheduler = AppointmentScheduler.getInstance();
    private long callbackAt = -1L;
    private String callbackBy = null;
    private long rescheduleAt = -1L;
    private String rescheduleBy = null;
    private boolean preempted = false;
    private Runnable appointment;

    public XmitScheduler(Runnable callback, BandwidthLimit[] limits) {
        this.callback = callback;
        this.limits = new LimitSet(limits);
        this.appointment = new Runnable(){

            @Override
            public void run() {
                XmitScheduler.this.onAppointment();
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long schedule(int nBytes, int limit, String by, long now) {
        long schedAt = 0L;
        if (DebugFlags.BANDWIDTH_OFF.isEnabled()) {
            return 0L;
        }
        Object object = this.lock;
        synchronized (object) {
            long delay;
            if (this.callbackAt > 0L && !this.preempted) {
                throw new IllegalStateException("Schedule I/O when one is already scheduled by " + this.callbackBy);
            }
            long time = this.limits.schedule(now, nBytes);
            if (limit > 0 && time > now + (long)limit) {
                time = now + (long)limit;
            }
            if ((delay = time - now) <= 2L * this.resolution) {
                schedAt = 0L;
            } else if (this.preempted) {
                this.rescheduleAt = time;
                this.rescheduleBy = by;
                this.preempted = false;
                schedAt = this.rescheduleAt;
            } else {
                schedAt = this.scheduler.schedule(this.appointment, time);
                if (schedAt > 0L) {
                    this.callbackAt = schedAt;
                    this.callbackBy = by;
                }
            }
            if (schedAt == 0L) {
                this.complete(now, nBytes);
            }
        }
        return schedAt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void complete(long now, int actual) {
        Object object = this.lock;
        synchronized (object) {
            this.limits.actual(now, actual);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void immediate(long now, int actual) {
        Object object = this.lock;
        synchronized (object) {
            this.limits.actual(now, actual);
            if (this.callbackAt > 0L) {
                this.preempted = true;
                this.rescheduleAt = -1L;
                this.rescheduleBy = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onAppointment() {
        boolean doNotify = false;
        Object object = this.lock;
        synchronized (object) {
            this.callbackAt = -1L;
            this.callbackBy = null;
            if (this.rescheduleAt > 0L) {
                long at = this.rescheduleAt;
                String by = this.rescheduleBy;
                this.rescheduleAt = -1L;
                this.rescheduleBy = null;
                if ((at = this.scheduler.schedule(this.appointment, at)) == 0L) {
                    doNotify = true;
                } else {
                    this.callbackAt = at;
                    this.callbackBy = by;
                }
            } else if (!this.preempted) {
                doNotify = true;
            }
            this.preempted = false;
        }
        if (doNotify) {
            this.doCallback();
        }
    }

    private void doCallback() {
        try {
            this.callback.run();
        }
        catch (Throwable t) {
            LogSupport.exception((Object)this, (String)"doCallback", (Throwable)t, (boolean)true);
        }
    }
}

