/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.jinx;

import com.elluminate.jinx.DebugFlags;
import com.elluminate.jinx.DuplicateAnnotationException;
import com.elluminate.jinx.JinxTuning;
import com.elluminate.jinx.MessageEvent;
import com.elluminate.jinx.ProtocolBuffer;
import com.elluminate.jinx.StringsProperties;
import com.elluminate.jinx.VCRBufferEvent;
import com.elluminate.jinx.VCRBufferListener;
import com.elluminate.jinx.VCREntry;
import com.elluminate.jinx.VCRException;
import com.elluminate.util.Debug;
import com.elluminate.util.I18n;
import com.elluminate.util.I18nMessage;
import com.elluminate.util.LightweightTimer;
import com.elluminate.util.PropertiesEnum;
import com.elluminate.util.QuickHash;
import com.elluminate.util.StringUtils;
import com.elluminate.util.crypto.DES;
import com.elluminate.util.event.BufferFillEvent;
import com.elluminate.util.event.BufferFillListener;
import com.elluminate.util.event.DataChangeEvent;
import com.elluminate.util.event.DataChangeListener;
import com.elluminate.util.event.DataProvider;
import com.elluminate.util.event.FiringFunctor;
import com.elluminate.util.event.ListenerRegistry;
import com.elluminate.util.event.ThrowableListener;
import com.elluminate.util.event.URLFillErrorListener;
import com.elluminate.util.io.RandomAccessURL;
import com.elluminate.util.io.RandomDataInput;
import com.elluminate.util.io.RandomInputFile;
import com.elluminate.util.log.LogSupport;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.io.StreamCorruptedException;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.nio.channels.FileLock;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Random;
import java.util.Set;
import java.util.zip.CRC32;
import java.util.zip.Checksum;

public class VCRFile
implements BufferFillListener {
    public static final char MODE_READ = 'r';
    public static final char MODE_WRITE = 'w';
    public static final char MODE_APPEND = 'a';
    public static final String USERNAME = " recorder";
    public static final String ANNOT_CONFERENCE_NAME = " conferenceName ";
    public static final int VCR_TAG = 1447252480;
    public static final int VCR_VER_14 = 825111552;
    public static final int VCR_MAGIC_MSG = 785386625;
    public static final int VCR_MAGIC_MRK = 785386626;
    public static final int VCR_MAGIC_ANN = 785386627;
    public static final int VCR_MAGIC_IDX = 785386628;
    public static final long VCR_TAG_OFFSET = 0L;
    public static final long VCR_VER_OFFSET = 4L;
    public static final long VCR_TIME_OFFSET = 8L;
    public static final long VCR_ANNO_OFFSET = 16L;
    public static final long VCR_IDX_OFFSET = 24L;
    public static final long VCR_MSG_OFFSET = 28L;
    public static final byte VCR_START_MARK = -1;
    public static final byte VCR_MESSAGE = 0;
    public static final byte VCR_DISCONNECT = 1;
    public static final byte VCR_NEW_SESSION = 2;
    public static final byte VCR_INDEX_MARK = 3;
    public static final byte VCR_ANNOTATION = 4;
    private static final byte LOOK_HEADER = 1;
    private static final byte LOOK_INDEX_LENGTH = 2;
    private static final byte LOOK_MAGIC = 3;
    private static final byte LOOK_TIMESTAMP = 4;
    private static final byte LOOK_DATA_LEN = 5;
    private static final byte LOOK_DATA_CKSUM = 6;
    private static final byte LOOK_INDEX_DATA = 7;
    private static final byte LOOK_HASH_DATA = 8;
    private static final byte LOOK_RESYNC = 9;
    private static final String[] LOOK_NAME = new String[]{"N/A", "VCR", "INDEX#", "MAGIC", "TIMESTAMP", "DATA_LEN", "CHECKSUM", "IDX_DATA", "HASH_DATA", "RESYNC"};
    private static final byte SKIP_HEADER_BYTES = 8;
    private static final byte SKIP_MAGIC_BYTES = 4;
    private static final byte SKIP_LEN_OFFSET = 8;
    private static final byte SKIP_LEN_BYTES = 4;
    private static final byte SKIP_CHECKSUM_BYTES = 2;
    private static final byte SKIP_TS_BYTES = 8;
    private static final byte SKIP_MARKER_OFFSET = 1;
    private static final byte SKIP_OFFSET_BYTES = 8;
    private static final byte[] ANNOT_KEY = new byte[]{86, 67, 82, 0, 78, 111, 116, 101};
    private static final int ANNOT_TAG = 1315927141;
    private static final int OUT_BUFFER_SIZE = 65536;
    private static final long FLUSH_LIMIT = 60000L;
    private static final HashMap<String, VCRFile> OPEN_FILES = new HashMap(1000);
    private I18n i18n = I18n.create((Object)this);
    private URL url = null;
    private URLFillErrorListener pendingFillListener = null;
    private File file = null;
    private RandomInputFile writer = null;
    private RandomDataInput reader = null;
    private volatile long lastTime = -1L;
    private volatile int indexCount = 0;
    private long lastReadTime = -1L;
    private long lastReadPos = -1L;
    private long bytesWritten = 0L;
    private int messagesWritten = 0;
    private long headerTime = -1L;
    private char openMode = (char)32;
    private long timeBase = -1L;
    private ArrayList<SessionEntry> sessions = null;
    private final HashMap<String, String> annotations = new HashMap();
    private volatile long lastAvailable = -1L;
    private long lastAnnotation = -1L;
    private long msgEnd = 28L;
    private boolean empty = true;
    private int bufSkip = 0;
    private byte bufLookFor = 1;
    private long bufHeader = 0L;
    private int bufMagic = 0;
    private long bufMagicPos = -1L;
    private long bufTS = 0L;
    private int bufLN = 0;
    private int bufDataIdx = 0;
    private byte[] bufData = null;
    private int bufHashCount = 0;
    private QuickHash bufHash = new QuickHash();
    private short bufChecksum = 0;
    private long msgCount = 0L;
    private long msgIndex = 0L;
    private long bufReceived = 0L;
    private boolean parseCompleted = false;
    private CRC32 bufCRC = null;
    private ListenerRegistry<VCRBufferListener> bufListeners = new ListenerRegistry((ThrowableListener)new BufFillThrowableListener());
    private Random rnd = null;
    private Object writeLock = new Object();
    private long outTS = 0L;
    private ByteArrayOutputStream outBuf = null;
    private DataOutputStream outStr = null;
    private CopyStream copyStr = null;
    private LightweightTimer flushTimer = null;
    private volatile boolean fileTooLong = false;
    private ArrayList<IndexEntry> indexMarks = null;
    private long lastIndexTime = -1L;
    private IndexProvider indexProvider = new IndexProvider();
    private IndexEntry placeHolder = null;
    private int historyIdx = 0;
    private final ReaderInfoRec[] history = new ReaderInfoRec[32];
    private static final int IO_OP_NONE = 0;
    private static final int IO_OP_OPEN = 1;
    private static final int IO_OP_SEEK = 2;
    private static final int IO_OP_READ = 3;
    private static final int IO_OP_WRITE = 4;
    private static final int IO_OP_CLOSE = 5;
    private static final int IO_OP_LENGTH = 6;
    private static final int IO_OP_DONE = 7;
    private static final String[] IO_OP_NAME = new String[]{"None", "Open", "Seek", "Read", "Write", "Close", "Length", "Done"};
    private FileLock flock = null;

    public static String getExpectedVersion() {
        return "1.2";
    }

    public VCRFile(File f) {
        this.file = f;
    }

    public VCRFile(URL url) {
        this.url = url;
    }

    public long getLastTime() {
        return this.lastTime;
    }

    public long getHeaderTime() {
        return this.headerTime;
    }

    public long getBytesWritten() {
        return this.bytesWritten;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getBytesBuffered() {
        long result = 0L;
        Debug.lockEnter((Object)this, (String)"getBytesBuffered", (String)"writeLock", (Object)this.writeLock);
        Object object = this.writeLock;
        synchronized (object) {
            result = this.outBuf.size();
        }
        Debug.lockLeave((Object)this, (String)"getBytesBuffered", (String)"writeLock", (Object)this.writeLock);
        return result;
    }

    public boolean isFileTooLong() {
        return this.fileTooLong;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearHistory() {
        ReaderInfoRec[] readerInfoRecArray = this.history;
        synchronized (this.history) {
            this.historyIdx = 0;
            for (int ix = 0; ix < this.history.length; ++ix) {
                this.history[ix] = null;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToHistory(String method, int action, long where) {
        ReaderInfoRec[] readerInfoRecArray = this.history;
        synchronized (this.history) {
            this.historyIdx = (this.historyIdx + 1) % this.history.length;
            if (this.history[this.historyIdx] == null) {
                this.history[this.historyIdx] = new ReaderInfoRec();
            }
            this.history[this.historyIdx].setOperation(method, action, where);
            // ** MonitorExit[var5_4] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getReaderHistory() {
        if (this.reader == null || this.history == null) {
            return "";
        }
        StringBuffer result = new StringBuffer(4096);
        ReaderInfoRec[] readerInfoRecArray = this.history;
        synchronized (this.history) {
            for (int i = 0; i < this.history.length; ++i) {
                int idx = (this.historyIdx + i + 1) % this.history.length;
                if (this.history[idx] == null) continue;
                if (result.length() > 0) {
                    result.append('\n');
                }
                result.append(this.history[idx]);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return result.toString();
        }
    }

    public String getReaderStatus() {
        long pos = -1L;
        long len = -1L;
        long expected = -1L;
        boolean fillCompleted = true;
        Throwable ioErr = null;
        if (this.reader != null) {
            try {
                pos = this.reader.getFilePointer();
                if (this.reader instanceof RandomAccessURL) {
                    len = this.reader.length();
                    expected = this.reader.getExpectedLength();
                    fillCompleted = ((RandomAccessURL)this.reader).isFillComplete();
                    ioErr = ((RandomAccessURL)this.reader).getFillError();
                }
            }
            catch (Throwable ignored) {
                // empty catch block
            }
        }
        return this + " mode=" + this.openMode + " pos=" + pos + "=" + Long.toHexString(pos) + (this.bufCRC != null ? " received=" + this.bufReceived + "/" + len + "/" + expected + " crc=" + this.bufCRC.getValue() : "") + " filling=" + !fillCompleted + " parsing=" + !this.parseCompleted + " lastTime=" + this.lastTime + "=" + StringUtils.formatTimeStamp((long)this.lastTime) + " lastAvail=" + this.lastAvailable + "=" + StringUtils.formatTimeStamp((long)this.lastAvailable) + " lastAnno=" + this.lastAnnotation + " annotations=" + this.annotations + " lastReadTime=" + this.lastReadTime + "=" + StringUtils.formatTimeStamp((long)this.lastReadTime) + " lastReadPos=" + this.lastReadPos + "=0x" + Long.toHexString(this.lastReadPos) + (ioErr == null ? "" : " ioErr=" + ioErr);
    }

    public Throwable getReaderError() {
        if (this.reader == null) {
            return null;
        }
        if (this.reader instanceof RandomAccessURL) {
            return ((RandomAccessURL)this.reader).getFillError();
        }
        return null;
    }

    public String dumpReadRegion(int prevBytes, int nBytes) {
        long startPos = this.lastReadPos;
        long off = Math.max(0L, startPos - (long)prevBytes) & 0x7FFFFFFFFFFFFFF0L;
        return this.dumpFileData(off, nBytes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public String dumpFileData(long startPos, int nBytes) {
        byte[] data;
        block21: {
            RandomAccessFile raf;
            block20: {
                if (this.reader == null) {
                    return null;
                }
                File f = null;
                f = this.reader instanceof RandomAccessURL ? ((RandomAccessURL)this.reader).getBackingFile() : this.file;
                if (f == null) {
                    return null;
                }
                raf = null;
                data = null;
                long fileLen = f.length();
                raf = new RandomAccessFile(f, "r");
                if ((long)nBytes + startPos > fileLen) {
                    startPos = Math.max(0L, fileLen - (long)nBytes);
                }
                if ((nBytes = Math.min(nBytes, (int)(fileLen - startPos))) > 0 && startPos < fileLen) break block20;
                String string = "Invalid dump position/size: " + startPos + " for " + nBytes;
                try {
                    if (raf != null) {
                        raf.close();
                    }
                }
                catch (Throwable ignored) {
                    // empty catch block
                }
                return string;
            }
            data = new byte[nBytes];
            raf.seek(startPos);
            raf.readFully(data);
            try {
                if (raf != null) {
                    raf.close();
                }
                break block21;
            }
            catch (Throwable ignored) {}
            break block21;
            catch (Throwable t) {
                try {
                    String string = "Exception processing dump: " + Debug.getStackTrace((Throwable)t);
                    return string;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    try {
                        if (raf != null) {
                            raf.close();
                        }
                    }
                    catch (Throwable ignored) {}
                }
            }
        }
        return "Dump " + nBytes + " bytes (0x" + Integer.toHexString(nBytes) + ") from " + startPos + " 0x" + Long.toHexString(startPos) + "\n" + StringUtils.dumpBytes((byte[])data, (int)0, (int)nBytes, (long)startPos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getWriterStatus() {
        StringBuffer result = new StringBuffer(1024);
        long modTime = -1L;
        Debug.lockEnter((Object)this, (String)"getWriterStatus", (String)"writeLock", (Object)this.writeLock);
        Object object = this.writeLock;
        synchronized (object) {
            result.append(this.toString());
            result.append(" mode=" + this.openMode);
            result.append(" flock=" + this.flock);
            result.append(" messagesWritten=" + this.messagesWritten);
            result.append(" bytesWritten=");
            result.append(this.bytesWritten);
            result.append(" bytesBuffered=");
            result.append(this.outBuf != null ? this.outBuf.size() : 0);
            result.append(" fileTooLong=" + this.fileTooLong);
            result.append(" lastTime=" + this.lastTime + "=" + StringUtils.formatTimeStamp((long)this.lastTime));
            result.append(" FSlength=");
            if (this.file != null && this.file.isFile()) {
                result.append(this.file.length());
                modTime = this.file.lastModified();
            } else {
                result.append("N/A");
            }
        }
        Debug.lockLeave((Object)this, (String)"getWriterStatus", (String)"writeLock", (Object)this.writeLock);
        if (modTime > 0L) {
            result.append(" FSmodTime=");
            result.append(modTime);
            result.append("=");
            result.append(new Date(modTime));
        }
        return result.toString();
    }

    public void addURLFillErrorListener(URLFillErrorListener l) {
        if (this.reader instanceof RandomAccessURL) {
            ((RandomAccessURL)this.reader).addURLFillErrorListener(l);
        } else {
            this.pendingFillListener = l;
        }
    }

    public void removeURLFillErrorListener(URLFillErrorListener l) {
        if (this.reader instanceof RandomAccessURL) {
            ((RandomAccessURL)this.reader).removeURLFillErrorListener(l);
        }
        if (this.pendingFillListener == l) {
            this.pendingFillListener = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void open(char mode) throws IOException, VCRException {
        disc = false;
        if (this.isOpen()) {
            throw new IllegalStateException(this + " is already open.");
        }
        if (DebugFlags.VCR_FILE.show()) {
            LogSupport.message((Object)this, (String)"open", (String)("Opening " + this + " for " + mode));
        }
        this.clearHistory();
        this.fileTooLong = false;
        if (this.url != null) {
            if (mode != 'r') {
                throw new IllegalArgumentException("Unable to open URL '" + this.url + "' for writing.");
            }
            this.addToHistory("open", 1, 0L);
            this.parseCompleted = false;
            this.reader = new RandomAccessURL(this.url, false, false, (BufferFillListener)this, this.pendingFillListener);
            this.pendingFillListener = null;
        } else {
            if (mode == 'w' || mode == 'a') {
                path = null;
                try {
                    path = this.file.getCanonicalPath();
                }
                catch (Throwable t) {
                    path = this.file.getAbsolutePath();
                    LogSupport.message((Object)this, (String)"open", (String)("Getting canonical path of " + (String)path + ": " + t));
                }
                Debug.lockEnter((Object)this, (String)"open", (String)"OPEN_FILES", VCRFile.OPEN_FILES);
                var4_7 = VCRFile.OPEN_FILES;
                synchronized (var4_7) {
                    vf = VCRFile.OPEN_FILES.get(path);
                    if (vf != null) {
                        throw new IllegalStateException(this + " is in use in another context: " + vf);
                    }
                    VCRFile.OPEN_FILES.put((String)path, this);
                }
                Debug.lockLeave((Object)this, (String)"open", (String)"OPEN_FILES", VCRFile.OPEN_FILES);
            }
            switch (mode) {
                case 'r': {
                    this.addToHistory("open", 1, 0L);
                    this.reader = new RandomInputFile(this.file, "r");
                    this.parseCompleted = true;
                    break;
                }
                case 'w': {
                    if (this.file.exists()) {
                        this.file.delete();
                    }
                    this.writer = new RandomInputFile(this.file, "rw");
                    this.empty = true;
                    break;
                }
                case 'a': {
                    if (!this.file.exists()) {
                        mode = (char)119;
                        this.empty = true;
                        this.writer = new RandomInputFile(this.file, "rw");
                        break;
                    }
                    this.writer = new RandomInputFile(this.file, "rw");
                }
            }
        }
        this.openMode = mode;
        if (this.openMode == 'w' || this.openMode == 'a') {
            this.outBuf = new ByteArrayOutputStream(65536);
            this.outStr = new DataOutputStream(this.outBuf);
            this.copyStr = new CopyStream();
            this.flushTimer = new LightweightTimer(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Debug.lockEnter((Object)this, (String)"run(flushTimer)", (String)"writeLock", (Object)VCRFile.this.writeLock);
                    Object object = VCRFile.this.writeLock;
                    synchronized (object) {
                        try {
                            VCRFile.this.flush();
                        }
                        catch (IOException iox) {
                            LogSupport.error((Object)this, (String)"run", (String)("Error flushing recording: " + iox));
                        }
                    }
                    Debug.lockLeave((Object)this, (String)"run", (String)"writeLock", (Object)VCRFile.this.writeLock);
                }
            });
        }
        switch (mode) {
            case 'w': {
                Debug.lockEnter((Object)this, (String)"open", (String)"writeLock", (Object)this.writeLock);
                path = this.writeLock;
                synchronized (path) {
                    this.writer.seek(0L);
                    this.writer.writeInt(1447252480);
                    this.writer.writeInt(825111552);
                    this.writer.writeLong(-1L);
                    this.writer.writeLong(0L);
                    this.writer.writeInt(0);
                    this.lastAnnotation = 16L;
                    this.messagesWritten = 0;
                    this.indexCount = 0;
                    this.bytesWritten = this.writer.length();
                }
                Debug.lockLeave((Object)this, (String)"open", (String)"writeLock", (Object)this.writeLock);
                break;
            }
            case 'a': {
                Debug.lockEnter((Object)this, (String)"open", (String)"writeLock", (Object)this.writeLock);
                path = this.writeLock;
                synchronized (path) {
                    this.writer.seek(0L);
                    if (this.writer.readInt() != 1447252480 || this.writer.readInt() != 825111552) {
                        throw new VCRException(this + " does not appear to be a VCR file.");
                    }
                    this.writer.seek(8L);
                    this.lastTime = this.writer.readLong();
                    this.timeBase = System.currentTimeMillis() - (this.lastTime + 1L);
                    this.writer.seek(24L);
                    this.indexCount = this.writer.readInt();
                    this.readAnnotations((RandomDataInput)this.writer);
                    this.writer.seek(this.msgEnd - 13L);
                    if (this.lastTime == -1L) {
                        disc = false;
                    } else if (this.writer.readInt() != 785386626) {
                        disc = true;
                    } else if (this.writer.readLong() != this.lastTime) {
                        disc = true;
                    } else if (this.writer.readByte() != 1) {
                        disc = true;
                    }
                    if (disc) {
                        this.writeMarker((byte)1);
                        this.flush();
                    }
                    this.messagesWritten = 0;
                    this.bytesWritten = this.writer.length();
                }
                Debug.lockLeave((Object)this, (String)"open", (String)"writeLock", (Object)this.writeLock);
                break;
            }
            case 'r': {
                this.addToHistory("open", 2, 0L);
                this.reader.seek(0L);
                this.addToHistory("open", 3, 0L);
                this.reader.readInt();
                this.addToHistory("open", 3, 4L);
                this.reader.readInt();
                this.addToHistory("open", 3, 8L);
                this.lastTime = this.reader.readLong();
                this.addToHistory("open", 2, 24L);
                this.reader.seek(24L);
                this.addToHistory("open", 3, 24L);
                this.indexCount = this.reader.readInt();
                try {
                    this.readAnnotations(this.reader);
                }
                catch (IOException iox) {
                    LogSupport.message((Object)this, (String)"open", (String)("I/O exception while reading annotations:\n" + Debug.getStackTrace((Throwable)iox)));
                    if (iox instanceof EOFException) ** GOTO lbl142
                    throw iox;
                }
lbl142:
                // 2 sources

                this.empty = false;
                this.sessions = new ArrayList<E>();
                this.createSessionEntry(0L, 28L, 0L);
                if (this.url != null) break;
                this.lastAvailable = this.lastTime;
                this.addToHistory("open", 6, 16L);
                fileLen = this.reader.length();
                this.fireBufferStatus(fileLen, fileLen, this.lastAvailable, this.lastTime, -1L);
            }
        }
        if (DebugFlags.VCR_FILE.show()) {
            LogSupport.message((Object)this, (String)"open", (String)(this.toString() + " for " + this.openMode));
        }
    }

    public void close() {
        this.close(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(boolean showMessages) {
        block41: {
            try {
                if (this.reader != null && this.writer != null && showMessages) {
                    LogSupport.message((Object)this, (String)"close", (String)("Warning: reader and writer were open simultaneously, " + this.file + " may be corrupt."));
                }
                if (this.reader != null) {
                    this.reader.close();
                    this.reader = null;
                    this.addToHistory("close", 5, 0L);
                }
                if (this.writer == null) break block41;
                Debug.lockEnter((Object)this, (String)"close", (String)"writeLock", (Object)this.writeLock);
                Object object = this.writeLock;
                synchronized (object) {
                    try {
                        this.flush();
                        this.writer.getFD().sync();
                    }
                    catch (Throwable t2) {
                        LogSupport.message((Object)this, (String)"close", (String)("Exception during flush/sync: " + Debug.getStackTrace((Throwable)t2)));
                    }
                    if (!(this.empty || this.file.exists() && this.bytesWritten == this.file.length())) {
                        this.emergencyBackup();
                    }
                    if (this.isLocked()) {
                        this.unlock();
                    }
                    this.writer.close();
                }
                Debug.lockLeave((Object)this, (String)"close", (String)"writeLock", (Object)this.writeLock);
                this.writer = null;
                if (this.empty) {
                    this.file.delete();
                }
            }
            catch (IOException ex) {
                LogSupport.message((Object)this, (String)"close", (String)Debug.getStackTrace((Throwable)ex));
            }
            finally {
                if (this.file != null) {
                    String path = null;
                    try {
                        path = this.file.getCanonicalPath();
                    }
                    catch (Throwable t) {
                        path = this.file.getAbsolutePath();
                        LogSupport.message((Object)this, (String)"close", (String)("Getting canonical path of " + path + ": " + t));
                    }
                    Debug.lockEnter((Object)this, (String)"close", (String)"OPEN_FILES", OPEN_FILES);
                    HashMap<String, VCRFile> hashMap = OPEN_FILES;
                    synchronized (hashMap) {
                        try {
                            VCRFile vf = OPEN_FILES.get(path);
                            if (vf == this) {
                                OPEN_FILES.remove(path);
                            } else if (vf != null) {
                                LogSupport.error((Object)this, (String)"close", (String)("WARNING: recording file collision for: " + path));
                            }
                        }
                        catch (Throwable ignored) {}
                    }
                    Debug.lockLeave((Object)this, (String)"close", (String)"OPEN_FILES", OPEN_FILES);
                }
            }
        }
        if (DebugFlags.VCR_FILE.show() && showMessages) {
            LogSupport.message((Object)this, (String)"close", (String)this.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void emergencyBackup() {
        long bytesCopied = 0L;
        File bkupFile = null;
        try {
            File tmpDir = null;
            String tmpDirName = System.getProperty("com.elluminate.live.vcrBackupDir");
            if (tmpDirName != null && !(tmpDir = new File(tmpDirName)).isDirectory()) {
                LogSupport.message((Object)this, (String)"emergencyBackup", (String)("Ignoring invalid backup directory: " + tmpDir));
                tmpDir = null;
            }
            bkupFile = File.createTempFile("elive", ".vcr", tmpDir);
            LogSupport.message((Object)this, (String)"emergencyBackup", (String)("Detected asynchronous delete of VCR file " + this.file + "\n  creating backup copy as " + bkupFile));
            RandomAccessFile bkup = null;
            try {
                bkup = this.createEmergencyBackupFile(bkupFile, "rw");
                byte[] buf = new byte[32768];
                this.writer.seek(0L);
                try {
                    int nRead;
                    while ((nRead = this.writer.read(buf, 0, buf.length)) >= 0) {
                        if (nRead <= 0) continue;
                        bkup.write(buf, 0, nRead);
                        bytesCopied += (long)nRead;
                    }
                }
                catch (EOFException eofx) {
                    // empty catch block
                }
            }
            finally {
                if (bkup != null) {
                    try {
                        bkup.close();
                    }
                    catch (Throwable t) {
                        LogSupport.exception((Object)this, (String)"emergencyBackup", (Throwable)t, (boolean)true, (String)("Error closing backup file " + bkupFile));
                    }
                }
            }
        }
        catch (Throwable t) {
            LogSupport.exception((Object)this, (String)"emergencyBackup", (Throwable)t, (boolean)true, (String)("Attempting to recover VCR file " + this.file));
        }
        LogSupport.message((Object)this, (String)"emergencyBackup", (String)("Copied " + bytesCopied + " bytes to " + bkupFile));
    }

    protected RandomAccessFile createEmergencyBackupFile(File f, String mode) throws IOException {
        return new RandomAccessFile(f, mode);
    }

    public boolean isOpen() {
        return this.reader != null || this.writer != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lock() throws IOException, LockedByOtherException, IllegalStateException {
        this.checkMode('w');
        Object object = this.writeLock;
        synchronized (object) {
            if (this.isLocked()) {
                return;
            }
            this.flock = this.writer.getChannel().tryLock();
            if (this.flock == null) {
                throw new LockedByOtherException();
            }
            if (DebugFlags.VCR_FILE.show()) {
                LogSupport.message((Object)this, (String)"lock", (String)(this.toString() + " flock=" + this.flock));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlock() throws IOException {
        Object object = this.writeLock;
        synchronized (object) {
            if (this.isLocked()) {
                this.flock.release();
            }
            this.flock = null;
            if (DebugFlags.VCR_FILE.show()) {
                LogSupport.message((Object)this, (String)"unlock", (String)this.toString());
            }
        }
    }

    public boolean isLocked() {
        FileLock fl = this.flock;
        if (fl == null) {
            return false;
        }
        return fl.isValid();
    }

    public boolean isEmpty() {
        return this.empty;
    }

    public DataProvider getRecordingIndexProvider() {
        return this.indexProvider;
    }

    public IndexEntry[] getRecordingIndex() {
        if (this.placeHolder == null) {
            this.placeHolder = new IndexEntry(this.i18n.getMessage((PropertiesEnum)StringsProperties.VCRFILE_UNKNOWNMODULEINDEXICON), this.i18n.getMessage((PropertiesEnum)StringsProperties.VCRFILE_UNKNOWNKINDINDEXTEXT), this.i18n.getMessage((PropertiesEnum)StringsProperties.VCRFILE_PLACEHOLDERINDEXTEXT));
        }
        if (this.indexMarks != null) {
            int ix;
            if (this.indexMarks.size() >= this.indexCount) {
                return this.indexMarks.toArray(new IndexEntry[this.indexMarks.size()]);
            }
            IndexEntry[] result = new IndexEntry[this.indexCount];
            for (ix = 0; ix < this.indexMarks.size(); ++ix) {
                result[ix] = this.indexMarks.get(ix);
            }
            for (ix = this.indexMarks.size(); ix < result.length; ++ix) {
                result[ix] = this.placeHolder;
            }
            return result;
        }
        return new IndexEntry[]{this.placeHolder};
    }

    public void scanRecordingFile() throws IOException {
        if (this.reader == null) {
            return;
        }
        if (this.url != null) {
            return;
        }
        this.lastIndexTime = -1L;
        this.lastAvailable = -1L;
        if (this.indexMarks != null) {
            this.indexMarks.clear();
        }
        long pos = 0L;
        this.addToHistory("scanRecordingFile", 2, pos);
        this.reader.seek(pos);
        this.addToHistory("scanRecordingFile", 6, 0L);
        long fileLen = this.reader.length();
        byte[] data = new byte[262144];
        while (true) {
            int nRead = 0;
            try {
                this.addToHistory("scanRecordingFile", 3, pos);
                for (int ix = 0; ix < data.length; ++ix) {
                    data[ix] = this.reader.readByte();
                    ++nRead;
                }
            }
            catch (EOFException eof) {
                // empty catch block
            }
            if (nRead <= 0) break;
            this.onBufferWrite(new BufferFillEvent((Object)this, 1, pos += (long)nRead, fileLen, data, nRead));
        }
        this.onBufferDone(new BufferFillEvent((Object)this, 3, fileLen, fileLen, null, -1));
    }

    public int getRecordingIndexCount() {
        return this.indexCount;
    }

    public String getAnnotation(String name) {
        return this.annotations.get(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAnnotation(String name, String value) throws DuplicateAnnotationException, IOException {
        this.checkMode('w');
        if (this.lastAnnotation < 0L) {
            LogSupport.error((Object)this, (String)"addAnnotation", (String)("No annotation tail offset: " + name));
            return;
        }
        long end = 0L;
        Debug.lockEnter((Object)this, (String)"addAnnotation", (String)"writeLock", (Object)this.writeLock);
        Object object = this.writeLock;
        synchronized (object) {
            if (this.annotations.containsKey(name)) {
                String oldValue = this.annotations.get(name);
                Debug.lockLeave((Object)this, (String)"addAnnotation", (String)"writeLock", (Object)this.writeLock);
                if (value.equals(oldValue)) {
                    return;
                }
                throw new DuplicateAnnotationException(name);
            }
            byte[] data = this.encodeAnnotation(name, value);
            if (data.length < 1) {
                throw new IllegalArgumentException("Invalid annotation: " + name + "='" + value + "' len=" + data.length);
            }
            this.annotations.put(name, value);
            short hash = (short)QuickHash.hash((byte[])data);
            this.flush();
            end = this.writer.length();
            this.writer.seek(this.lastAnnotation);
            this.writer.writeLong(end);
            this.writer.seek(end);
            this.writer.writeInt(785386627);
            this.writer.writeInt(data.length);
            this.writer.writeShort((int)hash);
            this.writer.write(data);
            this.lastAnnotation = this.writer.getFilePointer();
            this.writer.writeLong(0L);
            this.bytesWritten = this.writer.length();
        }
        Debug.lockLeave((Object)this, (String)"addAnnotation", (String)"writeLock", (Object)this.writeLock);
        if (DebugFlags.VCR_FILE.show()) {
            LogSupport.message((Object)this, (String)"addAnnotation", (String)("added '" + name + "' at " + end));
        }
    }

    public Set<String> annotations() {
        return Collections.unmodifiableSet(this.annotations.keySet());
    }

    private void readAnnotations(RandomDataInput str) throws IOException {
        this.empty = true;
        this.addToHistory("readAnnotations", 2, 16L);
        str.seek(16L);
        this.addToHistory("readAnnotations", 3, 16L);
        long next = str.readLong();
        if (next == 0L) {
            this.lastAnnotation = 16L;
            this.empty = str.length() > 28L;
            this.msgEnd = str.length();
            return;
        }
        if (next != str.getFilePointer()) {
            this.addToHistory("readAnnotations", 2, next);
            str.seek(next);
            this.msgEnd = next;
        }
        while (next >= 28L) {
            this.addToHistory("readAnnotations(magic)", 3, next);
            int magic = str.readInt();
            if (magic != 785386627) {
                LogSupport.error((Object)this, (String)"readAnnotations", (String)("Malformed recording file " + this + ": invalid entry in annotation chain at " + next + ", expecting 0x" + Integer.toHexString(785386627) + ": 0x" + Integer.toHexString(magic) + ", remaining annotations discarded."));
                this.empty = false;
                this.msgEnd = str.length();
                break;
            }
            this.addToHistory("readAnnotations(length)", 3, next + 4L);
            int len = str.readInt();
            this.addToHistory("readAnnotations(checksum)", 3, next + 8L);
            str.readShort();
            if (len <= 0) {
                LogSupport.error((Object)this, (String)"readAnnotations", (String)("Malformed recording file " + this + ": invalid entry in annotation chain at " + (str.getFilePointer() - 4L) + ", negative length: " + len + ", remaining annotations discarded."));
                this.empty = false;
                this.msgEnd = str.length();
                break;
            }
            byte[] data = new byte[len];
            this.addToHistory("readAnnotations(data)", 3, next + 10L);
            str.readFully(data);
            this.decodeAnnotation(data);
            this.lastAnnotation = str.getFilePointer();
            this.addToHistory("readAnnotations(next)", 3, next + 10L + (long)len);
            next = str.readLong();
            if (next == 0L) {
                if (str.getFilePointer() == str.length()) break;
                this.msgEnd = str.length();
                this.empty = false;
                break;
            }
            if (next == str.getFilePointer()) continue;
            this.addToHistory("readAnnotations(skip)", 2, next);
            str.seek(next);
            this.msgEnd = next;
            this.empty = false;
        }
        if (DebugFlags.VCR_FILE.show()) {
            LogSupport.message((Object)this, (String)"readAnnotations", (String)("" + this.annotations));
        }
    }

    private byte[] encodeAnnotation(String name, String value) throws IOException {
        ByteArrayOutputStream byteStr = new ByteArrayOutputStream();
        DataOutputStream dataStr = new DataOutputStream(byteStr);
        DES des = new DES();
        if (this.rnd == null) {
            this.rnd = new SecureRandom();
        }
        dataStr.writeLong(this.rnd.nextLong());
        dataStr.writeInt(1315927141);
        dataStr.writeUTF(name);
        dataStr.writeUTF(value);
        while (byteStr.size() % 8 != 0) {
            dataStr.writeByte(0);
        }
        dataStr.close();
        byte[] data = byteStr.toByteArray();
        des.init(ANNOT_KEY, true);
        for (int i = 8; i < data.length; i += 8) {
            for (int j = 0; j < 8; ++j) {
                int n = i + j;
                data[n] = (byte)(data[n] ^ data[i + j - 8]);
            }
            des.processBlock(data, i, data, i);
        }
        return data;
    }

    private void decodeAnnotation(byte[] data) throws IOException {
        DES des = new DES();
        des.init(ANNOT_KEY, false);
        for (int i = data.length - 8; i > 0; i -= 8) {
            des.processBlock(data, i, data, i);
            for (int j = 0; j < 8; ++j) {
                int n = i + j;
                data[n] = (byte)(data[n] ^ data[i + j - 8]);
            }
        }
        ByteArrayInputStream byteStr = new ByteArrayInputStream(data);
        DataInputStream dataStr = new DataInputStream(byteStr);
        dataStr.skipBytes(8);
        int tag = dataStr.readInt();
        if (tag != 1315927141) {
            throw new IOException("Corrupted VCR file, annotation found with invalid annotation tag.");
        }
        String name = dataStr.readUTF();
        String value = dataStr.readUTF();
        this.annotations.put(name, value);
    }

    public void addVCRBufferListener(VCRBufferListener lst) {
        this.bufListeners.add((Object)lst);
    }

    public void removeVCRBufferListener(VCRBufferListener lst) {
        this.bufListeners.remove((Object)lst);
    }

    private void fireBufferStatus(final long nByte, final long tByte, final long nMilli, final long tMilli, final long nMsgs) {
        this.bufListeners.fire((FiringFunctor)new FiringFunctor<VCRBufferListener>(){
            VCRBufferEvent e = null;

            public void fire(VCRBufferListener lst) {
                if (this.e == null) {
                    this.e = new VCRBufferEvent(VCRFile.this, nByte, tByte, nMilli, tMilli, nMsgs);
                }
                lst.bufferStatus(this.e);
            }
        });
    }

    private void loadIndexMark(IndexEntry entry) {
        if (DebugFlags.VCR_INDEX.show()) {
            LogSupport.message((Object)this, (String)"loadIndexMark", (String)("Adding index entry: " + entry));
        }
        if (this.indexMarks == null) {
            this.indexMarks = new ArrayList(Math.max(256, this.indexCount));
        }
        boolean added = false;
        if (entry.getTime() < this.lastIndexTime) {
            for (int ix = 0; ix < this.indexMarks.size(); ++ix) {
                IndexEntry cur = this.indexMarks.get(ix);
                if (cur.equals(entry)) {
                    return;
                }
                if (cur.getTime() <= entry.getTime()) continue;
                this.indexMarks.add(ix, entry);
                added = true;
                break;
            }
        }
        if (!added) {
            this.indexMarks.add(entry);
            this.lastIndexTime = entry.getTime();
        }
        if (this.indexMarks.size() > this.indexCount) {
            this.indexCount = this.indexMarks.size();
        }
        this.indexProvider.fireDataChangeListeners();
    }

    private byte[] encodeIndexMark(I18nMessage modName, I18nMessage kind, I18nMessage detail) throws IOException {
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
        DataOutputStream dataStream = new DataOutputStream(byteStream);
        modName.write(dataStream);
        kind.write(dataStream);
        if (detail != null) {
            detail.write(dataStream);
        }
        dataStream.close();
        return byteStream.toByteArray();
    }

    private IndexEntry decodeIndexMark(byte[] data, long timestamp) throws IOException {
        ByteArrayInputStream byteStream = new ByteArrayInputStream(data);
        DataInputStream dataStream = new DataInputStream(byteStream);
        I18nMessage modName = I18nMessage.read((DataInputStream)dataStream);
        I18nMessage kind = I18nMessage.read((DataInputStream)dataStream);
        I18nMessage detail = null;
        if (dataStream.available() > 0) {
            detail = I18nMessage.read((DataInputStream)dataStream);
        }
        return new IndexEntry(modName, kind, detail, timestamp);
    }

    public void writeMessage(MessageEvent msg) throws IOException {
        this.writeMessageAt(msg, System.currentTimeMillis());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeMessageAt(MessageEvent msg, long at) throws IOException {
        if (this.fileTooLong) {
            return;
        }
        ProtocolBuffer buffer = msg.getContent();
        short hash = (short)buffer.getCRC((Checksum)new QuickHash());
        int msgLen = 26 + buffer.getSize();
        Debug.lockEnter((Object)this, (String)"writeMessage", (String)"writeLock", (Object)this.writeLock);
        Object object = this.writeLock;
        synchronized (object) {
            this.checkFlush(msgLen);
            this.outStr.writeInt(785386625);
            this.writeTimestamp(at);
            this.outStr.writeShort(msg.getSourceAddress());
            this.outStr.writeShort(msg.getDestinationAddress());
            this.outStr.writeShort(msg.getGroupID());
            this.outStr.writeByte(msg.getChannel());
            this.outStr.writeByte(msg.getCommand());
            this.outStr.writeInt(buffer.getSize());
            this.outStr.writeShort(hash);
            buffer.writeTo(this.outStr);
            if (!this.flushTimer.isScheduled()) {
                this.flushTimer.scheduleIn(60000L);
            }
            this.empty = false;
            ++this.messagesWritten;
        }
        Debug.lockLeave((Object)this, (String)"writeMessage", (String)"writeLock", (Object)this.writeLock);
    }

    public void writeMarker(byte marker) throws IOException {
        this.writeMarkerAt(marker, System.currentTimeMillis());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeMarkerAt(byte marker, long at) throws IOException {
        Debug.lockEnter((Object)this, (String)"writeMarkerAt", (String)"writeLock", (Object)this.writeLock);
        Object object = this.writeLock;
        synchronized (object) {
            this.checkFlush(13);
            this.outStr.writeInt(785386626);
            this.writeTimestamp(at);
            this.outStr.writeByte(marker);
            if (!this.flushTimer.isScheduled()) {
                this.flushTimer.scheduleIn(60000L);
            }
            this.empty = false;
        }
        Debug.lockLeave((Object)this, (String)"writeMarkerAt", (String)"writeLock", (Object)this.writeLock);
    }

    public void writeIndexMark(I18nMessage modName, I18nMessage kind, I18nMessage detail) throws IOException {
        long at = this.lastTime + this.timeBase;
        if (at < System.currentTimeMillis() - 36000000L) {
            at = System.currentTimeMillis();
        }
        this.writeIndexMarkAt(modName, kind, detail, at);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeIndexMarkAt(I18nMessage modName, I18nMessage kind, I18nMessage detail, long at) throws IOException {
        byte[] data = this.encodeIndexMark(modName, kind, detail);
        short hash = (short)QuickHash.hash((byte[])data);
        Debug.lockEnter((Object)this, (String)"writeIndexMark", (String)"writeLock", (Object)this.writeLock);
        Object object = this.writeLock;
        synchronized (object) {
            this.checkFlush(18 + data.length);
            this.outStr.writeInt(785386628);
            this.writeTimestamp(at);
            this.outStr.writeInt(data.length);
            this.outStr.writeShort(hash);
            this.outStr.write(data, 0, data.length);
            ++this.indexCount;
            if (!this.flushTimer.isScheduled()) {
                this.flushTimer.scheduleIn(60000L);
            }
            this.empty = false;
        }
        Debug.lockLeave((Object)this, (String)"writeIndexMark", (String)"writeLock", (Object)this.writeLock);
        if (DebugFlags.VCR_INDEX.show()) {
            LogSupport.message((Object)this, (String)"writeIndexMarkAt", (String)("wrote index mark " + modName.getUnformattedString() + " " + kind.getUnformattedString() + " " + detail.getUnformattedString() + " @ " + StringUtils.formatTimeStamp((long)this.outTS) + " (" + data.length + " data bytes) to " + this));
        }
    }

    private void writeTimestamp(long now) throws IOException {
        this.checkMode('w');
        long prev = this.lastTime;
        if (this.timeBase < 0L) {
            this.timeBase = now - 1L;
        }
        this.lastTime = now - this.timeBase;
        if (this.lastTime < prev) {
            this.timeBase = now - prev;
            this.lastTime = prev;
        }
        this.outTS = this.lastTime;
        this.outStr.writeLong(this.lastTime);
    }

    private void checkFlush(int len) throws IOException {
        if (this.outBuf.size() + len >= 65536) {
            this.flush();
        }
    }

    private void flush() throws IOException {
        if (this.flushTimer != null) {
            this.flushTimer.cancel();
        }
        if (this.writer != null) {
            long curPos;
            this.writer.seek(8L);
            this.writer.writeLong(this.outTS);
            this.writer.seek(24L);
            this.writer.writeInt(this.indexCount);
            long endPos = this.writer.length();
            this.writer.seek(endPos);
            this.outStr.flush();
            int nBytes = this.outBuf.size();
            this.outBuf.writeTo(this.copyStr);
            this.outBuf.reset();
            if (nBytes > 0) {
                this.bytesWritten += (long)nBytes;
            }
            if (!this.fileTooLong && endPos + (long)nBytes > JinxTuning.MaxRecordingSize.getLongValue()) {
                this.fileTooLong = true;
                LogSupport.message((Object)this, (String)"flush", (String)("Recording file " + this + " has exceeded maximum length at " + (endPos + (long)nBytes)));
            }
            if (DebugFlags.VCR_FILE.show() && (curPos = this.writer.getFilePointer()) != endPos + (long)nBytes) {
                LogSupport.message((Object)this, (String)"flush", (String)("Positioning failure: clobbered " + nBytes + " bytes at " + (curPos - (long)nBytes) + " .. " + curPos + " of file " + this));
            }
        }
    }

    public void reset() throws IOException {
        this.checkMode('r');
        this.addToHistory("reset", 2, 28L);
        this.reader.seek(28L);
        this.msgIndex = 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long resetNearest(long target) throws IOException {
        this.checkMode('r');
        long sessionOffset = 28L;
        long sessionTimestamp = 0L;
        long sessionIndex = 0L;
        if (this.sessions != null) {
            ArrayList<SessionEntry> arrayList = this.sessions;
            synchronized (arrayList) {
                for (SessionEntry cur : this.sessions) {
                    if (cur.timestamp > target) break;
                    sessionOffset = cur.offset;
                    sessionTimestamp = cur.timestamp;
                    sessionIndex = cur.index;
                }
            }
        }
        this.addToHistory("resetNearest", 2, sessionOffset);
        this.reader.seek(sessionOffset);
        this.msgIndex = sessionIndex;
        if (DebugFlags.VCR_FILE.show()) {
            LogSupport.message((Object)this, (String)"resetNearest", (String)("Reset to " + sessionOffset + " for time " + target));
        }
        return sessionTimestamp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createSessionEntry(long ts, long off, long idx) {
        if (this.sessions == null) {
            return;
        }
        ArrayList<SessionEntry> arrayList = this.sessions;
        synchronized (arrayList) {
            for (int i = 0; i < this.sessions.size(); ++i) {
                SessionEntry curSession = this.sessions.get(i);
                if (curSession.timestamp < ts) continue;
                if (curSession.timestamp == ts) {
                    if (curSession.offset <= off) break;
                    curSession.offset = off;
                    curSession.index = idx;
                    if (!DebugFlags.VCR_FILE.show()) break;
                    LogSupport.message((Object)this, (String)"createSessionEntry", (String)("Updated session [" + i + "] " + ts + " @" + off + " #" + idx));
                    break;
                }
                SessionEntry startEntry = new SessionEntry(ts, off, idx);
                this.sessions.add(i, startEntry);
                if (!DebugFlags.VCR_FILE.show()) break;
                LogSupport.message((Object)this, (String)"createSessionEntry", (String)("New session [" + i + "] " + ts + " @" + off + " #" + idx));
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VCREntry read() throws IOException {
        RandomDataInput rdr = this.reader;
        Object object = rdr.getReadLock();
        synchronized (object) {
            return this.readEntry(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VCREntry readEach() throws IOException {
        RandomDataInput rdr = this.reader;
        Object object = rdr.getReadLock();
        synchronized (object) {
            return this.readEntry(false);
        }
    }

    private int readMagic(RandomDataInput rdr, long off) throws IOException {
        int magic = 0;
        if (off >= rdr.getExpectedLength()) {
            throw new EOFException();
        }
        if (rdr.length() <= 0L) {
            throw new EOFException();
        }
        if (off + 4L > rdr.getExpectedLength()) {
            LogSupport.error((Object)this, (String)"read", (String)("Magic number at offset " + off + " 0x" + Long.toHexString(off) + " exceeds logical file length (" + rdr.getExpectedLength() + ")\n" + this));
            throw new StreamCorruptedException("Corrupted VCR file, message header incomplete");
        }
        if (off + 4L > rdr.length()) {
            LogSupport.error((Object)this, (String)"read", (String)("Magic number at offset " + off + " 0x" + Long.toHexString(off) + " exceeds file length (" + rdr.length() + ")\n" + this));
            throw new UnexpectedEOFException("Incomplete VCR file");
        }
        try {
            this.addToHistory("read(magic)", 3, off);
            magic = rdr.readInt();
        }
        catch (EOFException eof) {
            LogSupport.error((Object)this, (String)"read", (String)("EOF part way through magic number at offset " + off + " 0x" + Long.toHexString(off) + "\n" + this));
            throw new StreamCorruptedException("Corrupted VCR file, EOF in magic number");
        }
        return magic;
    }

    private int skipAnnotation(RandomDataInput rdr, long off) throws IOException {
        if (this.lastAnnotation < 0L) {
            LogSupport.error((Object)this, (String)"read", (String)("Annotation found with no annotation chain header at " + off + " 0x" + Long.toHexString(off) + "\n" + this));
            throw new StreamCorruptedException("Corrupted VCR file, annotation without chain");
        }
        if (off + 10L > rdr.getExpectedLength()) {
            LogSupport.error((Object)this, (String)"read", (String)("Annotation header at offset " + off + " 0x" + Long.toHexString(off) + " exceeds logical file length (" + rdr.getExpectedLength() + ")\n" + this));
            throw new StreamCorruptedException("Corrupted VCR file, message header incomplete");
        }
        if (off + 10L > rdr.length()) {
            LogSupport.error((Object)this, (String)"read", (String)("Annotation header at offset " + off + " 0x" + Long.toHexString(off) + " exceeds file length\n" + this));
            throw new UnexpectedEOFException("Incomplete VCR file");
        }
        int len = -1;
        try {
            this.addToHistory("read(anno-len)", 3, off + 4L);
            len = rdr.readInt();
        }
        catch (EOFException eof) {
            LogSupport.error((Object)this, (String)"read", (String)("EOF part way through annotation length at offset " + off + " 0x" + Long.toHexString(off) + "\n" + this));
            throw new StreamCorruptedException("Corrupted VCR file, EOF in annotation header");
        }
        if (off + (long)len + 18L > rdr.getExpectedLength()) {
            LogSupport.error((Object)this, (String)"read", (String)("Annotation at offset " + off + " 0x" + Long.toHexString(off) + " has length(" + len + ") exceeding logical file length (" + rdr.getExpectedLength() + ")\n" + this));
            throw new StreamCorruptedException("Corrupted VCR file, bad annotation length");
        }
        if (off + (long)len + 18L > rdr.length()) {
            LogSupport.error((Object)this, (String)"read", (String)("Annotation at offset " + off + " 0x" + Long.toHexString(off) + " has length(" + len + ") exceeding file length\n" + this));
            throw new UnexpectedEOFException("Incomplete VCR file");
        }
        try {
            this.addToHistory("read(skip-anno)", 2, off + (long)len + 18L);
            rdr.seek(off + (long)len + 18L);
        }
        catch (EOFException eof) {
            LogSupport.error((Object)this, (String)"read", (String)("EOF part way through annotation at offset " + off + " 0x" + Long.toHexString(off) + "\n" + this));
            throw new StreamCorruptedException("Corrupted VCR file, EOF in annotation");
        }
        return len + 18;
    }

    private VCREntry readMarker(RandomDataInput rdr, long off) throws IOException {
        byte marker;
        long ts;
        if (off + 13L > rdr.getExpectedLength()) {
            LogSupport.error((Object)this, (String)"read", (String)("Message header at offset " + off + " 0x" + Long.toHexString(off) + " exceeds logical file length (" + rdr.getExpectedLength() + ")\n" + this));
            throw new StreamCorruptedException("Corrupted VCR file, message header incomplete");
        }
        if (off + 13L > rdr.length()) {
            LogSupport.error((Object)this, (String)"read", (String)("Message header at offset " + off + " 0x" + Long.toHexString(off) + " exceeds file length\n" + this));
            throw new UnexpectedEOFException("Incomplete VCR file");
        }
        try {
            this.addToHistory("read(marker)", 3, off + 4L);
            ts = rdr.readLong();
            marker = rdr.readByte();
        }
        catch (EOFException eof) {
            LogSupport.error((Object)this, (String)"read", (String)("EOF part way through marker header at offset " + off + " 0x" + Long.toHexString(off) + "\n" + this));
            throw new StreamCorruptedException("Corrupted VCR file, EOF in message");
        }
        if (marker == 1) {
            this.createSessionEntry(ts, off + 13L, this.msgIndex);
        }
        return new VCREntry(ts, this.msgIndex++, off, 13, marker);
    }

    private VCREntry readMessage(RandomDataInput rdr, long off) throws IOException {
        byte[] content;
        byte cmd;
        byte chnl;
        short grp;
        short dst;
        short src;
        long ts;
        int len = -1;
        short hash = 0;
        if (off + 26L > rdr.getExpectedLength()) {
            LogSupport.error((Object)this, (String)"read", (String)("Message header at offset " + off + " 0x" + Long.toHexString(off) + " exceeds logical file length (" + rdr.getExpectedLength() + ")\n" + this));
            throw new StreamCorruptedException("Corrupted VCR file, message header incomplete");
        }
        if (off + 26L > rdr.length()) {
            LogSupport.error((Object)this, (String)"read", (String)("Message header at offset " + off + " 0x" + Long.toHexString(off) + " exceeds file length\n" + this));
            throw new UnexpectedEOFException("Incomplete VCR file");
        }
        try {
            this.addToHistory("read(message-header)", 3, off + 4L);
            ts = rdr.readLong();
            src = rdr.readShort();
            dst = rdr.readShort();
            grp = rdr.readShort();
            chnl = rdr.readByte();
            cmd = rdr.readByte();
            len = rdr.readInt();
            hash = rdr.readShort();
        }
        catch (EOFException eof) {
            LogSupport.error((Object)this, (String)"read", (String)("EOF part way through message header at offset " + off + " 0x" + Long.toHexString(off) + "\n" + this));
            throw new StreamCorruptedException("Corrupted VCR file, EOF in message");
        }
        if (len < 0 || len > 4000000) {
            LogSupport.error((Object)this, (String)"read", (String)("Invalid message at offset " + off + " 0x" + Long.toHexString(off) + " (" + "src=" + src + ",dst=" + dst + ",grp=" + grp + "chnl=" + chnl + ",cmd=" + cmd + ",len=" + len + "hash=" + Integer.toHexString(hash & 0xFF) + ")" + "\n" + this));
            throw new StreamCorruptedException("Corrupted VCR file, bad message length");
        }
        if (off + (long)len + 26L > rdr.getExpectedLength()) {
            LogSupport.error((Object)this, (String)"read", (String)("Message at offset " + off + " 0x" + Long.toHexString(off) + " has length(" + len + ") exceeding logical file length (" + rdr.getExpectedLength() + ")\n" + this));
            throw new StreamCorruptedException("Corrupted VCR file, message too long");
        }
        if (off + (long)len + 26L > rdr.length()) {
            LogSupport.error((Object)this, (String)"read", (String)("Message at offset " + off + " 0x" + Long.toHexString(off) + " has length(" + len + ") exceeding file length\n" + this));
            throw new UnexpectedEOFException("Incomplete VCR file");
        }
        try {
            content = new byte[len];
            this.addToHistory("read(message-body)", 3, off + 26L);
            rdr.readFully(content);
        }
        catch (EOFException eof) {
            LogSupport.error((Object)this, (String)"read", (String)("EOF part way through message body at offset " + off + " 0x" + Long.toHexString(off) + (len >= 0 ? " body at " + (off + 26L) + " len=" + len : "") + "\n" + this));
            throw new StreamCorruptedException("Corrupted VCR file, EOF in message");
        }
        short hash2 = (short)QuickHash.hash((byte[])content);
        if (hash != hash2) {
            LogSupport.error((Object)this, (String)"read", (String)("Message checksum mismatch at " + off + " 0x" + Long.toHexString(off) + " (" + "src=" + src + ",dst=" + dst + ",grp=" + grp + ",chnl=" + chnl + ",cmd=" + cmd + ",len=" + len + ") expected=" + Integer.toHexString(hash & 0xFFFF) + " actual=" + Integer.toHexString(hash2 & 0xFFFF)));
            String dump = StringUtils.dumpBytes((byte[])content, (int)0, (int)Math.min(len, 1024), (long)(off + 26L));
            LogSupport.error((Object)this, (String)"read", (String)("Checksum failed for data:\n" + dump));
            throw new StreamCorruptedException("Message checksum mismatch");
        }
        MessageEvent msg = MessageEvent.getInstance((Object)this, src, dst, grp, (byte)2, chnl, cmd, content);
        return new VCREntry(ts, this.msgIndex++, off, len + 26, msg);
    }

    private VCREntry skipIndex(RandomDataInput rdr, long off) throws IOException {
        long ts;
        int len = -1;
        short hash = 0;
        if (off + 18L > rdr.getExpectedLength()) {
            LogSupport.error((Object)this, (String)"read", (String)("Index mark at offset " + off + " 0x" + Long.toHexString(off) + " exceeds logical file length (" + rdr.getExpectedLength() + ")\n" + this));
            throw new StreamCorruptedException("Corrupted VCR file, bad index length");
        }
        if (off + 18L > rdr.length()) {
            LogSupport.error((Object)this, (String)"read", (String)("Index mark at offset " + off + " 0x" + Long.toHexString(off) + " exceeds file length\n" + this));
            throw new UnexpectedEOFException("Incomplete VCR file");
        }
        try {
            this.addToHistory("read(index-time)", 3, off + 4L);
            ts = rdr.readLong();
            this.addToHistory("read(index-len)", 3, off + 12L);
            len = rdr.readInt();
            this.addToHistory("read(index-checksum)", 3, off + 16L);
            hash = rdr.readShort();
        }
        catch (EOFException eof) {
            LogSupport.error((Object)this, (String)"read", (String)("EOF part way through index mark header at offset " + off + " 0x" + Long.toHexString(off) + "\n" + this));
            throw new StreamCorruptedException("Corrupted VCR file, EOF in message");
        }
        byte[] indexData = new byte[len];
        this.addToHistory("read(index-data)", 3, off + 18L);
        try {
            rdr.readFully(indexData);
        }
        catch (EOFException eof) {
            LogSupport.error((Object)this, (String)"read", (String)("EOF part way through index mark data at " + off + " 0x" + Long.toHexString(off) + " reading " + len + " bytes\n" + this));
            throw new StreamCorruptedException("Corrupted VCR file, EOF in index mark");
        }
        short hash2 = (short)QuickHash.hash((byte[])indexData);
        if (hash != hash2) {
            LogSupport.error((Object)this, (String)"read", (String)("Index entry checksum mismatch at " + off + " 0x" + Long.toHexString(off) + " (" + "len=" + len + ") expected=" + Integer.toHexString(hash & 0xFF) + " actual=" + Integer.toHexString(hash2 & 0xFF)));
            String dump = StringUtils.dumpBytes((byte[])indexData, (int)0, (int)Math.min(len, 1024), (long)(off + 18L));
            LogSupport.error((Object)this, (String)"read", (String)("Checksum failed for data:\n" + dump));
            throw new StreamCorruptedException("Index entry checksum mismatch");
        }
        return new VCREntry(ts, this.msgIndex++, off, len + 18, this.decodeIndexMark(indexData, ts));
    }

    private VCREntry readEntry(boolean skipAnnotations) throws IOException {
        long off;
        RandomDataInput rdr = this.reader;
        VCREntry entry = null;
        this.checkMode('r');
        long readOffset = off = rdr.getFilePointer();
        long readTimestamp = -1L;
        int magic = this.readMagic(rdr, off);
        while (magic == 785386627) {
            int len = this.skipAnnotation(rdr, off);
            if (!skipAnnotations) {
                entry = new VCREntry(off, len);
                this.lastReadPos = readOffset;
                return entry;
            }
            magic = this.readMagic(rdr, off += (long)len);
        }
        readOffset = off;
        if (magic == 785386626) {
            entry = this.readMarker(rdr, off);
            readTimestamp = entry.getTime();
        } else if (magic == 785386625) {
            entry = this.readMessage(rdr, off);
            readTimestamp = entry.getTime();
        } else if (magic == 785386628) {
            entry = this.skipIndex(rdr, off);
            readTimestamp = entry.getTime();
        } else {
            LogSupport.error((Object)this, (String)"read", (String)("Invalid magic number " + Integer.toHexString(magic) + " at " + off + " 0x" + Long.toHexString(off) + "\n" + this));
            throw new StreamCorruptedException("Corrupted VCR file, invalid magic number");
        }
        this.lastReadPos = readOffset;
        if (readTimestamp >= 0L) {
            this.lastReadTime = readTimestamp;
        }
        return entry;
    }

    public void write(VCREntry entry) throws IOException {
        this.checkMode('w');
        byte mark = entry.getMarker();
        switch (mark) {
            case 0: {
                this.writeMessageAt(entry.getMessage(), entry.getTime());
                break;
            }
            case 3: {
                I18nMessage mod = entry.getIndexEntry().getModuleIntl();
                I18nMessage kind = entry.getIndexEntry().getKindIntl();
                I18nMessage details = entry.getIndexEntry().getDetailIntl();
                this.writeIndexMarkAt(mod, kind, details, entry.getTime());
                break;
            }
            default: {
                this.writeMarkerAt(mark, entry.getTime());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getNextTime() throws IOException {
        long ts;
        this.checkMode('r');
        long mark = this.reader.getFilePointer();
        try {
            this.addToHistory("getNextTime", 3, mark);
            int magic = this.reader.readInt();
            long pos = mark + 4L;
            while (magic == 785386627) {
                int dataLen = this.reader.readInt();
                this.addToHistory("getNextTime", 2, pos += (long)(2 + dataLen + 8));
                this.reader.seek(pos);
                this.addToHistory("getNextTime", 3, pos);
                magic = this.reader.readInt();
                pos += 4L;
            }
            ts = this.reader.readLong();
        }
        finally {
            this.addToHistory("getNextTime", 2, mark);
            this.reader.seek(mark);
        }
        return ts;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("VCRFile '");
        if (this.url != null) {
            buf.append(this.url);
            buf.append('(');
            buf.append(this.file);
            buf.append(')');
        } else {
            buf.append(this.file);
        }
        buf.append('\'');
        return buf.toString();
    }

    private void checkMode(char reqd) {
        switch (reqd) {
            case 'r': {
                if (this.openMode == 'r') {
                    return;
                }
                LogSupport.error((Object)this, (String)"checkMode", (String)("VCR is not open for reading: " + this));
                throw new IllegalStateException("VCR is not open for reading");
            }
            case 'w': {
                if (this.openMode == 'w' || this.openMode == 'a') {
                    return;
                }
                LogSupport.error((Object)this, (String)"checkMode", (String)("VCR is not open for writing: " + this));
                throw new IllegalStateException("VCR is not open for writing");
            }
        }
    }

    public void onBufferReset(BufferFillEvent e) {
        if (e.getCurrentLength() > 0L) {
            throw new UnsupportedOperationException("Reset position is not at BOF");
        }
        this.bufReceived = 0L;
        this.bufLookFor = 1;
        this.bufSkip = 0;
        this.bufCRC = null;
        this.bufHeader = 0L;
        this.bufMagic = 0;
        this.bufTS = 0L;
        this.bufLN = 0;
        this.bufDataIdx = 0;
        this.bufData = null;
        this.msgCount = 0L;
        this.lastAvailable = -1L;
    }

    public void onBufferDone(BufferFillEvent e) {
        this.bufReceived = e.getCurrentLength();
        if (this.bufReceived < 28L) {
            LogSupport.error((Object)this, (String)"onBufferDone", (String)"VCR header incomplete.");
            RuntimeException ex = new RuntimeException("VCR header incomplete.");
            String msg = this.i18n.getString((PropertiesEnum)StringsProperties.VCRFILE_SHORTFILEHEADERMSG);
            e.fireParseError(3, (Throwable)ex, msg, 1);
        } else if (this.lastTime > this.lastAvailable) {
            long missing = this.lastTime - this.lastAvailable;
            LogSupport.error((Object)this, (String)"onBufferDone", (String)("Data read did not reach timestamp from header, read to " + this.lastAvailable + " " + StringUtils.formatTimeStamp((long)this.lastAvailable) + ", expected " + this.lastTime + " " + StringUtils.formatTimeStamp((long)this.lastTime) + ", final " + missing + " millisecs are missing."));
            if (missing >= 1000L) {
                RuntimeException ex = new RuntimeException("Recording incomplete by timestamps.");
                String msg = this.i18n.getString((PropertiesEnum)StringsProperties.VCRFILE_MISSINGTIMEMSG, new Object[]{"" + (missing + 500L) / 1000L});
                e.fireParseError(3, (Throwable)ex, msg, 10);
            }
        } else if (this.bufSkip != 0 || this.bufLookFor != 3) {
            LogSupport.error((Object)this, (String)"onBufferDone", (String)"Parser out-of-sync, more data expected.");
            String msg = this.i18n.getString((PropertiesEnum)StringsProperties.VCRFILE_UNEXPECTEDEOFMSG);
            e.fireParseError(3, msg, 10);
        }
        if (this.lastAvailable < 0L) {
            LogSupport.message((Object)this, (String)"onBufferDone", (String)("No content in VCR file: timestamp=" + this.lastAvailable + ", expected " + this.lastTime));
        }
        this.lastTime = this.lastAvailable;
        this.parseCompleted = true;
        this.addToHistory("onBufferWrite", 7, e.getCurrentLength());
        if (DebugFlags.VCR_PARSER.show()) {
            LogSupport.message((Object)this, (String)"onBufferWrite", (String)("Parser finished at " + this.bufReceived + " 0x" + Long.toHexString(this.bufReceived) + " lastTime=" + this.lastTime + " " + StringUtils.formatTimeStamp((long)this.lastTime)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onBufferWrite(BufferFillEvent e) {
        byte[] data = e.getLastBuffer();
        this.bufReceived = e.getCurrentLength();
        try {
            long bufStartPos = e.getCurrentLength() - (long)e.getLastLength();
            this.addToHistory("onBufferWrite", 2, bufStartPos);
            this.addToHistory("onBufferWrite", 4, bufStartPos);
            if (this.bufCRC == null) {
                this.bufCRC = new CRC32();
            }
            this.bufCRC.update(data, 0, e.getLastLength());
            int remaining = e.getLastLength();
            int offset = 0;
            block15: while (remaining > 0) {
                if (this.bufSkip > 0) {
                    if (this.bufSkip > remaining) {
                        if (DebugFlags.VCR_PARSER.show()) {
                            LogSupport.message((Object)this, (String)"onBufferWrite", (String)("Skipping " + remaining + " / " + this.bufSkip));
                        }
                        this.bufSkip -= remaining;
                        offset += remaining;
                        remaining = 0;
                        continue;
                    }
                    if (DebugFlags.VCR_PARSER.show()) {
                        LogSupport.message((Object)this, (String)"onBufferWrite", (String)("Skipping " + this.bufSkip));
                    }
                    remaining -= this.bufSkip;
                    offset += this.bufSkip;
                    this.bufSkip = 0;
                    continue;
                }
                if (DebugFlags.VCR_PARSER.show()) {
                    LogSupport.message((Object)this, (String)"onBufferWrite", (String)("Parser mode: " + this.bufLookFor + " " + LOOK_NAME[this.bufLookFor] + " at " + offset + ": " + ((data[offset] & 0xFF) < 16 ? "0" : "") + Integer.toHexString(data[offset] & 0xFF) + (data[offset] >= 32 && data[offset] <= 126 ? " " + (char)data[offset] : "")));
                }
                switch (this.bufLookFor) {
                    case 1: {
                        String msg;
                        this.bufHeader = (this.bufHeader << 8) + (long)(data[offset++] & 0xFF);
                        --remaining;
                        --this.bufSkip;
                        if (this.bufSkip != -8) break;
                        if (this.bufHeader != 6215902071480005632L) {
                            LogSupport.error((Object)this, (String)"onBufferWrite", (String)("Invalid header 0x" + Long.toHexString(this.bufHeader) + " at " + (offset - 8) + " in buffer at file position " + bufStartPos + "\n" + StringUtils.dumpBytes((byte[])data, (int)(offset - 128), (int)256, (long)bufStartPos)));
                            RuntimeException ex = new RuntimeException("Invalid magic number in VCR header.");
                            msg = this.i18n.getString((PropertiesEnum)StringsProperties.VCRFILE_BADFILEHEADERMSG);
                            e.fireParseError(3, (Throwable)ex, msg, 1);
                        }
                        this.bufSkip = 16;
                        this.bufLookFor = (byte)2;
                        this.bufLN = 0;
                        break;
                    }
                    case 2: {
                        this.bufLN = (this.bufLN << 8) + (data[offset++] & 0xFF);
                        --remaining;
                        --this.bufSkip;
                        if (this.bufSkip != -4) break;
                        this.indexCount = this.bufLN;
                        this.bufSkip = 0;
                        this.bufLookFor = (byte)3;
                        this.bufMagic = 0;
                        this.bufMagicPos = -1L;
                        break;
                    }
                    case 3: 
                    case 9: {
                        String msg;
                        this.bufMagic = (this.bufMagic << 8) + (data[offset++] & 0xFF);
                        --remaining;
                        --this.bufSkip;
                        if (this.bufLookFor == 9 && this.bufSkip > -4) {
                            int prefix = 785386625 >> (4 + this.bufSkip) * 8;
                            if (this.bufMagic == prefix) continue block15;
                            this.bufSkip = 0;
                            this.bufMagic = 0;
                            break;
                        }
                        if (this.bufSkip != -4) break;
                        this.bufSkip = 0;
                        this.bufMagicPos = bufStartPos + (long)offset;
                        if (this.bufMagic == 785386625) {
                            this.bufLookFor = (byte)4;
                            break;
                        }
                        if (this.bufMagic == 785386626) {
                            this.bufLookFor = (byte)4;
                            break;
                        }
                        if (this.bufMagic == 785386627) {
                            this.bufLookFor = (byte)5;
                            break;
                        }
                        if (this.bufMagic == 785386628) {
                            this.bufLookFor = (byte)4;
                            break;
                        }
                        if (this.bufLookFor != 9) {
                            LogSupport.error((Object)this, (String)"onBufferWrite", (String)("Invalid magic number 0x" + Integer.toHexString(this.bufMagic) + " at " + (offset - 4) + " in buffer at file position " + bufStartPos + "\n" + StringUtils.dumpBytes((byte[])data, (int)(offset - 128), (int)256, (long)bufStartPos)));
                            RuntimeException ex = new RuntimeException("Invalid magic number in message.");
                            msg = this.i18n.getString((PropertiesEnum)StringsProperties.VCRFILE_BADJUJUMSG);
                            e.fireParseError(3, (Throwable)ex, msg, 9);
                            this.bufLookFor = (byte)9;
                        }
                        this.bufMagic = 0;
                        this.bufMagicPos = -1L;
                        break;
                    }
                    case 4: {
                        this.bufTS = (this.bufTS << 8) + ((long)data[offset++] & 0xFFL);
                        --remaining;
                        --this.bufSkip;
                        if (this.bufSkip != -8) break;
                        if (this.bufTS < this.lastAvailable) {
                            LogSupport.error((Object)this, (String)"onBufferWrite", (String)("Timestamp reversion " + this.bufTS + " read after " + this.lastAvailable + " at " + (offset - 8) + " in buffer at file position " + bufStartPos + "\n" + StringUtils.dumpBytes((byte[])data, (int)(offset - 128), (int)256, (long)bufStartPos)));
                        }
                        if (this.bufTS > this.lastTime && this.lastTime > 0L) {
                            LogSupport.error((Object)this, (String)"onBufferWrite", (String)("Timestamp " + this.bufTS + " is after end time " + this.lastTime + " at " + (offset - 8) + " in buffer at file position " + bufStartPos + "\n" + StringUtils.dumpBytes((byte[])data, (int)(offset - 128), (int)256, (long)bufStartPos)));
                        }
                        if (this.bufMagic == 785386625) {
                            this.bufSkip = 8;
                            this.bufLookFor = (byte)5;
                            this.lastAvailable = this.bufTS;
                            ++this.msgCount;
                        } else if (this.bufMagic == 785386626) {
                            this.bufSkip = 1;
                            this.bufLookFor = (byte)3;
                            this.bufMagic = 0;
                            this.bufMagicPos = -1L;
                            this.lastAvailable = this.bufTS;
                            ++this.msgCount;
                        } else if (this.bufMagic == 785386628) {
                            this.bufSkip = 0;
                            this.bufLookFor = (byte)5;
                            this.lastAvailable = this.bufTS;
                            ++this.msgCount;
                        } else {
                            LogSupport.error((Object)this, (String)"onBufferWrite", (String)("Unexpected timestamp 0x" + Long.toHexString(this.bufTS) + " after magic 0x" + Integer.toHexString(this.bufMagic) + " at " + (offset - 8) + " in buffer at file position " + bufStartPos + "\n" + StringUtils.dumpBytes((byte[])data, (int)(offset - 128), (int)256, (long)bufStartPos)));
                            this.bufSkip = 0;
                            this.bufLookFor = (byte)9;
                            this.bufMagic = 0;
                        }
                        this.bufTS = 0L;
                        break;
                    }
                    case 5: {
                        this.bufLN = (this.bufLN << 8) + (data[offset++] & 0xFF);
                        --remaining;
                        --this.bufSkip;
                        if (this.bufSkip != -4) break;
                        if (this.bufMagic == 785386625) {
                            this.bufHashCount = this.bufLN;
                            this.bufSkip = 0;
                            this.bufLookFor = (byte)6;
                        } else if (this.bufMagic == 785386627) {
                            this.bufHashCount = this.bufLN;
                            this.bufSkip = 0;
                            this.bufLookFor = (byte)6;
                            if (this.lastAvailable < 0L) {
                                this.lastAvailable = 0L;
                            }
                        } else if (this.bufMagic == 785386628) {
                            if (bufStartPos + (long)offset + (long)this.bufLN > e.getTotalLength()) {
                                LogSupport.error((Object)this, (String)"onBufferWrite", (String)("Index mark data length exceeds EOF: " + this.bufLN + " at " + (offset - 4) + " in buffer at file position " + bufStartPos + "\n" + StringUtils.dumpBytes((byte[])data, (int)(offset - 128), (int)256, (long)bufStartPos)));
                                this.bufSkip = 0;
                                this.bufLookFor = (byte)9;
                                this.bufMagic = 0;
                            } else {
                                if (this.bufLN > 4096) {
                                    LogSupport.message((Object)this, (String)"onBufferWrite", (String)("Warning: excessive index data length " + this.bufLN + " at " + (offset - 4) + " in buffer at file position " + bufStartPos + "\n" + StringUtils.dumpBytes((byte[])data, (int)(offset - 128), (int)256, (long)bufStartPos)));
                                }
                                this.bufDataIdx = 0;
                                this.bufData = new byte[this.bufLN];
                                this.bufHashCount = this.bufLN;
                                this.bufSkip = 0;
                                this.bufLookFor = (byte)6;
                            }
                        } else {
                            LogSupport.error((Object)this, (String)"onBufferWrite", (String)("Unexpected message length " + this.bufLN + " after magic 0x" + Integer.toHexString(this.bufMagic) + " at " + (offset - 4) + " in buffer at file position " + bufStartPos + "\n" + StringUtils.dumpBytes((byte[])data, (int)(offset - 128), (int)256, (long)bufStartPos)));
                            this.bufSkip = 0;
                            this.bufLookFor = (byte)9;
                            this.bufMagic = 0;
                        }
                        this.bufLN = 0;
                        break;
                    }
                    case 6: {
                        this.bufChecksum = (short)((this.bufChecksum << 8) + (data[offset++] & 0xFF));
                        --remaining;
                        --this.bufSkip;
                        if (this.bufSkip != -2) break;
                        this.bufSkip = 0;
                        if (this.bufMagic == 785386625) {
                            this.bufLookFor = (byte)8;
                            this.bufHash.reset();
                            break;
                        }
                        if (this.bufMagic == 785386627) {
                            this.bufLookFor = (byte)8;
                            this.bufHash.reset();
                            break;
                        }
                        if (this.bufMagic == 785386628) {
                            this.bufLookFor = (byte)7;
                            this.bufHash.reset();
                            break;
                        }
                        LogSupport.error((Object)this, (String)"onBufferWrite", (String)("Unexpected checksum length " + this.bufLN + " after magic 0x" + Integer.toHexString(this.bufMagic) + " at " + this.bufMagicPos + "\n" + StringUtils.dumpBytes((byte[])data, (int)(offset - 128), (int)256, (long)bufStartPos)));
                        this.bufLookFor = (byte)9;
                        this.bufMagic = 0;
                        break;
                    }
                    case 8: {
                        RuntimeException t;
                        String msg;
                        String posStr;
                        int nToHash = this.bufHashCount + this.bufSkip;
                        if (nToHash > remaining) {
                            nToHash = remaining;
                        }
                        if (nToHash > 0) {
                            this.bufHash.update(data, offset, nToHash);
                            offset += nToHash;
                            remaining -= nToHash;
                            this.bufSkip -= nToHash;
                        }
                        if (this.bufSkip != -this.bufHashCount) break;
                        this.bufSkip = 0;
                        short hash = (short)this.bufHash.getValue();
                        if (hash != this.bufChecksum) {
                            LogSupport.error((Object)this, (String)"onBufferWrite", (String)("Checksum failure in entry at " + this.bufMagicPos + " after " + this.bufHashCount + " data bytes, " + " expected=" + Integer.toHexString(this.bufChecksum & 0xFFFF) + " actual=" + Integer.toHexString(hash & 0xFFFF)));
                            posStr = this.bufMagicPos >= 0L ? "" + this.bufMagicPos : "" + (bufStartPos + (long)offset);
                            msg = this.i18n.getString((PropertiesEnum)StringsProperties.VCRFILE_BADCKSUMMSG, new Object[]{posStr});
                            t = new RuntimeException("Message checksum failed during parse");
                            e.fireParseError(3, (Throwable)t, msg, 9);
                        }
                        if (this.bufMagic == 785386625) {
                            this.bufLookFor = (byte)3;
                            this.bufHashCount = 0;
                            this.bufMagic = 0;
                        } else if (this.bufMagic == 785386627) {
                            this.bufSkip = 8;
                            this.bufLookFor = (byte)3;
                            this.bufHashCount = 0;
                            this.bufMagic = 0;
                        } else {
                            LogSupport.error((Object)this, (String)"onBufferWrite", (String)("Unexpected checksum data " + this.bufLN + " after magic 0x" + Integer.toHexString(this.bufMagic) + " at " + this.bufMagicPos + "\n" + StringUtils.dumpBytes((byte[])data, (int)(offset - 128), (int)256, (long)bufStartPos)));
                            this.bufLookFor = (byte)9;
                            this.bufMagic = 0;
                        }
                        this.bufMagicPos = -1L;
                        break;
                    }
                    case 7: {
                        RuntimeException t;
                        String msg;
                        String posStr;
                        if (this.bufMagic != 785386628) {
                            LogSupport.error((Object)this, (String)"onBufferWrite", (String)("Unexpected state " + this.bufLookFor + " for magic 0x" + Integer.toHexString(this.bufMagic) + " at " + offset + " in buffer at file position " + bufStartPos + "\n" + StringUtils.dumpBytes((byte[])data, (int)(offset - 128), (int)256, (long)bufStartPos)));
                        }
                        int nToCopy = 0;
                        if (this.bufData != null) {
                            nToCopy = this.bufData.length - this.bufDataIdx;
                        }
                        if (nToCopy > remaining) {
                            nToCopy = remaining;
                        }
                        if (nToCopy > 0) {
                            System.arraycopy(data, offset, this.bufData, this.bufDataIdx, nToCopy);
                            offset += nToCopy;
                            this.bufDataIdx += nToCopy;
                            remaining -= nToCopy;
                        }
                        if (this.bufDataIdx < this.bufData.length) break;
                        short hash = (short)QuickHash.hash((byte[])this.bufData);
                        if (hash != this.bufChecksum) {
                            LogSupport.error((Object)this, (String)"onBufferWrite", (String)("Checksum failure in entry at " + this.bufMagicPos + " after " + this.bufDataIdx + " data bytes, " + " expected=" + Integer.toHexString(this.bufChecksum & 0xFFFF) + " actual=" + Integer.toHexString(hash & 0xFFFF)));
                            posStr = this.bufMagicPos >= 0L ? "" + this.bufMagicPos : "" + (bufStartPos + (long)offset);
                            msg = this.i18n.getString((PropertiesEnum)StringsProperties.VCRFILE_BADCKSUMMSG, new Object[]{posStr});
                            t = new RuntimeException("Index checksum failed during parse");
                            e.fireParseError(3, (Throwable)t, msg, 11);
                        }
                        this.bufSkip = 0;
                        this.bufLookFor = (byte)3;
                        this.bufMagic = 0;
                        this.bufMagicPos = -1L;
                        try {
                            IndexEntry entry = this.decodeIndexMark(this.bufData, this.lastAvailable);
                            this.loadIndexMark(entry);
                            break;
                        }
                        catch (Throwable t2) {
                            LogSupport.error((Object)this, (String)"onBufferWrite", (String)("Failed to decode recording index at file position " + (bufStartPos + (long)offset - (long)this.bufDataIdx - 16L) + "\n" + StringUtils.dumpBytes((byte[])this.bufData, (int)0, (int)this.bufData.length, (long)0L) + "\n" + Debug.getStackTrace((Throwable)t2)));
                            msg = this.i18n.getString((PropertiesEnum)StringsProperties.VCRFILE_BADINDEXDATAMSG);
                            e.fireParseError(3, t2, msg, 11);
                        }
                    }
                }
            }
        }
        finally {
            this.fireBufferStatus(e.getCurrentLength(), e.getTotalLength(), this.lastAvailable, this.lastTime, this.msgCount);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dumpOpenFiles() {
        StringBuffer data = new StringBuffer(4096);
        HashMap<String, VCRFile> hashMap = OPEN_FILES;
        synchronized (hashMap) {
            for (String key : OPEN_FILES.keySet()) {
                VCRFile vf = OPEN_FILES.get(key);
                if (data.length() > 0) {
                    data.append('\n');
                }
                data.append(vf + " " + vf.isOpen());
            }
        }
        LogSupport.message(VCRFile.class, (String)"dumpOpenFiles", (String)data.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void closeOpenFiles() {
        HashMap<String, VCRFile> hashMap = OPEN_FILES;
        synchronized (hashMap) {
            for (String key : OPEN_FILES.keySet()) {
                VCRFile vf = OPEN_FILES.get(key);
                try {
                    vf.close();
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
        }
    }

    private class BufFillThrowableListener
    implements ThrowableListener {
        private BufFillThrowableListener() {
        }

        public void exceptionThrown(Exception e) {
            this.report(e);
        }

        public void errorThrown(Error e) {
            this.report(e);
        }

        private void report(Throwable t) {
            LogSupport.exception((Object)VCRFile.this, (String)"fireBufferStatus", (Throwable)t, (boolean)true);
        }
    }

    private class CopyStream
    extends OutputStream {
        private CopyStream() {
        }

        @Override
        public void write(byte[] buf) throws IOException {
            VCRFile.this.writer.write(buf);
        }

        @Override
        public void write(byte[] buf, int off, int len) throws IOException {
            VCRFile.this.writer.write(buf, off, len);
        }

        @Override
        public void write(int b) throws IOException {
            VCRFile.this.writer.write(b);
        }
    }

    public static class IndexEntry {
        private I18nMessage module;
        private I18nMessage kind;
        private I18nMessage detail;
        private long when;
        private String stringForm;

        public IndexEntry() {
            this(new I18nMessage(), new I18nMessage(), null, -1L);
        }

        public IndexEntry(I18nMessage module, I18nMessage kind, I18nMessage detail) {
            this(module, kind, detail, -1L);
        }

        public IndexEntry(I18nMessage module, I18nMessage kind, I18nMessage detail, long when) {
            this.module = module;
            this.kind = kind;
            this.detail = detail;
            this.when = when;
            this.stringForm = null;
        }

        public long getTime() {
            return this.when;
        }

        public String getModule() {
            return this.module.toString();
        }

        public String getKind() {
            return this.kind.toString();
        }

        public String getDetail() {
            if (this.detail == null) {
                return "";
            }
            return this.detail.toString();
        }

        public I18nMessage getModuleIntl() {
            return this.module;
        }

        public I18nMessage getKindIntl() {
            return this.kind;
        }

        public I18nMessage getDetailIntl() {
            return this.detail;
        }

        public boolean hasDetail() {
            return this.detail != null;
        }

        public String toString() {
            if (this.stringForm == null) {
                StringBuffer buf = new StringBuffer();
                if (this.detail != null) {
                    buf.append(" ");
                    buf.append(this.detail);
                }
                buf.append(" @ ");
                buf.append(StringUtils.formatTimeStamp((long)this.when));
                this.stringForm = buf.toString();
            }
            return this.stringForm;
        }

        public String getInfoString() {
            return this.module.getUnformattedString() + " " + this.kind.getUnformattedString() + " " + (this.detail == null ? "N/A" : this.detail.getUnformattedString()) + " @ " + StringUtils.formatTimeStamp((long)this.when);
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof IndexEntry)) {
                return false;
            }
            return this.toString().equals(obj.toString());
        }

        public int hashCode() {
            return this.toString().hashCode();
        }
    }

    private class IndexProvider
    implements DataProvider {
        private final ListenerRegistry<DataChangeListener> listeners = new ListenerRegistry((ThrowableListener)new IndexProviderThrowListener());

        private IndexProvider() {
        }

        public Object getData() {
            return VCRFile.this.getRecordingIndex();
        }

        public Class<?> getType() {
            return IndexEntry[].class;
        }

        public void addDataChangeListener(DataChangeListener l) {
            this.listeners.add((Object)l);
        }

        public void removeDataChangeListener(DataChangeListener l) {
            this.listeners.remove((Object)l);
        }

        void fireDataChangeListeners() {
            this.listeners.fire((FiringFunctor)new FiringFunctor<DataChangeListener>(){
                private DataChangeEvent ev = null;

                public void fire(DataChangeListener l) {
                    if (this.ev == null) {
                        this.ev = new DataChangeEvent((DataProvider)IndexProvider.this);
                    }
                    l.dataChanged(this.ev);
                }
            });
        }

        private class IndexProviderThrowListener
        implements ThrowableListener {
            private IndexProviderThrowListener() {
            }

            public void exceptionThrown(Exception e) {
                this.report(e);
            }

            public void errorThrown(Error e) {
                this.report(e);
            }

            private void report(Throwable t) {
                LogSupport.exception((Object)IndexProvider.this, (String)"fireDataChangeListeners", (Throwable)t, (boolean)true);
            }
        }
    }

    public class LockedByOtherException
    extends IOException {
        private LockedByOtherException() {
            super("File locked by another process.: " + VCRFile.this.toString());
        }
    }

    static class ReaderInfoRec {
        WeakReference<Thread> lastThreadRef = null;
        String method = null;
        int action = 0;
        long where = -1L;
        long time = 0L;
        String thread = null;
        String trace = null;

        ReaderInfoRec() {
        }

        void clear() {
            this.method = null;
            this.action = 0;
            this.where = -1L;
            this.time = 0L;
            this.thread = null;
            this.trace = null;
        }

        void setOperation(String method, int action, long where) {
            Thread lastThread;
            if (this.lastThreadRef == null) {
                lastThread = Thread.currentThread();
                this.lastThreadRef = new WeakReference<Thread>(lastThread);
            } else {
                lastThread = (Thread)this.lastThreadRef.get();
            }
            this.method = method;
            this.action = action;
            this.where = where;
            this.time = System.currentTimeMillis();
            Thread currentThread = Thread.currentThread();
            if (this.thread == null || currentThread != lastThread) {
                this.thread = Thread.currentThread().toString();
                this.lastThreadRef = new WeakReference<Thread>(currentThread);
            }
            this.trace = null;
            if (DebugFlags.VCR_TRACE.show()) {
                this.trace = Debug.getStackTrace((Throwable)new Exception());
            }
        }

        public String toString() {
            StringBuffer result = new StringBuffer();
            result.append(this.method);
            result.append(" ");
            if (this.action >= 0 && this.action < IO_OP_NAME.length) {
                result.append(IO_OP_NAME[this.action]);
            } else {
                result.append("" + this.action);
            }
            result.append(" ");
            result.append(this.where);
            result.append(" ");
            result.append(StringUtils.formatTimeStamp((long)this.time));
            result.append(" ");
            result.append(this.thread);
            if (this.trace != null) {
                result.append(" ");
                result.append(this.trace);
            }
            return result.toString();
        }
    }

    private static class SessionEntry {
        long timestamp;
        long offset;
        long index;

        SessionEntry(long ts, long off, long idx) {
            this.timestamp = ts;
            this.offset = off;
            this.index = idx;
        }
    }

    public class UnexpectedEOFException
    extends IOException {
        public UnexpectedEOFException(String msg) {
            super(msg);
        }
    }
}

