/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.jinx;

import com.elluminate.jinx.Transceiver;
import java.util.EventObject;

public class TransceiverEvent
extends EventObject {
    public static final byte ESTABLISHED = 1;
    public static final byte ENABLED = 2;
    public static final byte DISCONNECTED = 3;
    public static final byte REASON_NONE = 0;
    public static final byte REASON_COMMAND = 1;
    public static final byte REASON_REMOTE = 2;
    public static final byte REASON_ERROR = 3;
    public static final byte REASON_WATCHDOG = 4;
    public static final String[] REASONS = new String[]{"none", "command", "remote", "error", "watchdog"};
    private Transceiver transceiver = null;
    private byte action = 1;
    private byte previous = (byte)3;
    private byte reason = 0;

    public TransceiverEvent(Object src, Transceiver who, byte what, byte prev) {
        this(src, who, what, prev, 0);
    }

    public TransceiverEvent(Object src, Transceiver who, byte what, byte prev, byte why) {
        super(src);
        this.action = what;
        this.previous = prev;
        this.reason = why;
        this.transceiver = who;
    }

    public Transceiver getTransceiver() {
        return this.transceiver;
    }

    public byte getAction() {
        return this.action;
    }

    public byte getPreviousState() {
        return this.previous;
    }

    public byte getReason() {
        return this.reason;
    }

    @Override
    public String toString() {
        String str = this.getClass().getName() + " - ";
        switch (this.action) {
            case 1: {
                str = str + "Established ";
                break;
            }
            case 2: {
                str = str + "Enabled ";
                break;
            }
            case 3: {
                str = str + "Disconnect ";
                break;
            }
            default: {
                str = str + "??? ";
            }
        }
        str = str + this.transceiver.getName() + "(" + this.transceiver.getAddress() + ")";
        return str;
    }
}

