/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.jinx;

import com.elluminate.jinx.ClientStats;
import com.elluminate.jinx.JinxConnectionException;
import com.elluminate.jinx.PacketEvent;
import com.elluminate.jinx.PacketListener;
import com.elluminate.jinx.Transceiver;
import com.elluminate.jinx.TransceiverEvent;
import com.elluminate.jinx.TransceiverListener;
import com.elluminate.jinx.TransmitStatusEvent;
import com.elluminate.util.Debug;
import com.elluminate.util.log.LogSupport;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.TooManyListenersException;

public abstract class TransceiverAdapter
implements Transceiver {
    private short address = (short)-32767;
    private short group = 0;
    private String name = null;
    private String conf = null;
    private PacketListener pListener = null;
    private ArrayList<TransceiverListener> tListener = new ArrayList();
    private Object listenerLock = new Object();
    private volatile byte state = (byte)3;
    private Object license = null;
    protected ClientStats stats = new ClientStats();
    private static Object statsLock = new Object();
    private static HashSet<Transceiver> transceivers = new HashSet();
    private static ClientStats cumulativeStats = new ClientStats();

    public void setAddress(short addr) {
        this.address = addr;
    }

    @Override
    public short getAddress() {
        return this.address;
    }

    public void setLicense(Object lic) {
        this.license = lic;
    }

    public Object getLicense() {
        return this.license;
    }

    @Override
    public void setGroup(short grp) {
        this.group = grp;
    }

    @Override
    public short getGroup() {
        return this.group;
    }

    public void setName(String who) {
        this.name = who;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setConferenceName(String nm) {
        this.conf = nm;
    }

    public String getConferenceName() {
        return this.conf;
    }

    @Override
    public byte getState() {
        return this.state;
    }

    protected byte setState(byte newState) {
        byte prev = this.state;
        this.state = newState;
        switch (this.state) {
            case 2: {
                if (this.isNetwork()) {
                    this.txListAdd();
                }
                this.stats.connect();
                break;
            }
            case 3: {
                if (this.isNetwork()) {
                    this.txListDel();
                }
                this.stats.disconnect();
            }
        }
        return prev;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void txListAdd() {
        Object object = statsLock;
        synchronized (object) {
            transceivers.add(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void txListDel() {
        Object object = statsLock;
        synchronized (object) {
            transceivers.remove(this);
        }
    }

    @Override
    public boolean isEnabled() {
        return this.getState() == 2;
    }

    public boolean isConnected() {
        return this.getState() != 3;
    }

    @Override
    public boolean isNetwork() {
        return true;
    }

    @Override
    public boolean isSecure() {
        return false;
    }

    @Override
    public String getCipher() {
        return null;
    }

    @Override
    public ClientStats getStatistics() {
        return this.stats;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addPacketListener(PacketListener lst) throws TooManyListenersException {
        Debug.lockEnter((Object)this, (String)"addPacketListener", (String)"listenerLock", (Object)this.listenerLock);
        Object object = this.listenerLock;
        synchronized (object) {
            if (this.pListener != null) {
                throw new TooManyListenersException(this.getClass().getName() + ": only 1 PacketListener allowed.");
            }
            this.pListener = lst;
        }
        Debug.lockLeave((Object)this, (String)"addPacketListener", (String)"listenerLock", (Object)this.listenerLock);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removePacketListener(PacketListener lst) {
        Debug.lockEnter((Object)this, (String)"removePacketListener", (String)"listenerLock", (Object)this.listenerLock);
        Object object = this.listenerLock;
        synchronized (object) {
            if (this.pListener == lst) {
                this.pListener = null;
            }
        }
        Debug.lockLeave((Object)this, (String)"removePacketListener", (String)"listenerLock", (Object)this.listenerLock);
    }

    protected void fireOnPacket(PacketEvent event) {
        try {
            PacketListener l = this.pListener;
            if (l != null) {
                l.onPacket(event);
            }
            event.dispose();
        }
        catch (Throwable t) {
            LogSupport.exception((Object)this, (String)"fireOnPacket", (Throwable)t, (boolean)true, (String)("processing " + event.toString(true)));
        }
    }

    protected void fireTransmitComplete(TransmitStatusEvent event) {
        try {
            PacketListener l = this.pListener;
            if (l != null) {
                l.onTransmitStatus(event);
            }
        }
        catch (Exception ex) {
            LogSupport.exception((Object)this, (String)"fireTransmitComplete", (Throwable)ex, (boolean)true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addTransceiverListener(TransceiverListener lst) {
        Debug.lockEnter((Object)this, (String)"addTransceiverListener", (String)"listenerLock", (Object)this.listenerLock);
        Object object = this.listenerLock;
        synchronized (object) {
            if (!this.tListener.contains(lst)) {
                ArrayList<TransceiverListener> copy = new ArrayList<TransceiverListener>(this.tListener);
                copy.add(lst);
                this.tListener = copy;
            }
        }
        Debug.lockLeave((Object)this, (String)"addTransceiverListener", (String)"listenerLock", (Object)this.listenerLock);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeTransceiverListener(TransceiverListener lst) {
        Debug.lockEnter((Object)this, (String)"removeTransceiverListener", (String)"listenerLock", (Object)this.listenerLock);
        Object object = this.listenerLock;
        synchronized (object) {
            if (this.tListener.contains(lst)) {
                ArrayList<TransceiverListener> copy = new ArrayList<TransceiverListener>(this.tListener);
                copy.remove(lst);
                this.tListener = copy;
            }
        }
        Debug.lockLeave((Object)this, (String)"removeTransceiverListener", (String)"listenerLock", (Object)this.listenerLock);
    }

    protected void fireTransceiverStatusChanged(byte action, byte previous, byte reason) throws JinxConnectionException {
        TransceiverEvent e = new TransceiverEvent(this, this, action, previous, reason);
        for (TransceiverListener lst : this.tListener) {
            try {
                lst.transceiverStatusChanged(e);
            }
            catch (JinxConnectionException ex) {
                throw ex;
            }
            catch (Exception ex) {
                LogSupport.exception((Object)this, (String)"fireTransceiverStatusChanged", (Throwable)ex, (boolean)true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ClientStats getCumulativeStats() {
        Object object = statsLock;
        synchronized (object) {
            for (Transceiver tx : transceivers) {
                cumulativeStats.accumulate(tx.getStatistics());
            }
        }
        return cumulativeStats;
    }

    public static int getTransceiverCount() {
        return transceivers.size();
    }
}

