/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.jinx;

import com.elluminate.jinx.RecvWindowListener;
import com.elluminate.util.LightweightTimer;

public class RecvWindow {
    private long msec;
    private int min;
    private int max;
    private int size;
    private int recv;
    private long last = -1L;
    private RecvWindowListener listener = null;
    private Object context = null;
    private LightweightTimer ackTimer;

    public RecvWindow(long msec, int min, int max, RecvWindowListener lst, Object ctx) {
        this.msec = msec;
        this.min = min;
        this.max = max;
        this.listener = lst;
        this.context = ctx;
        this.size = (min + min + max) / 3;
        this.recv = 0;
        this.ackTimer = new LightweightTimer(1, new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                boolean send = false;
                RecvWindow recvWindow = RecvWindow.this;
                synchronized (recvWindow) {
                    send = RecvWindow.this.recv > 0;
                }
                if (send) {
                    RecvWindow.this.listener.sendAck(RecvWindow.this, RecvWindow.this.context);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int ack() {
        int nAck;
        RecvWindow recvWindow = this;
        synchronized (recvWindow) {
            long now = System.currentTimeMillis();
            long interval = Math.max(1L, Math.min(this.msec, now - this.last));
            nAck = this.recv;
            this.recv = 0;
            this.ackTimer.cancel();
            if (nAck > 0) {
                int computed = (int)((long)nAck * this.msec / interval);
                computed = Math.min(this.max, Math.max(computed, this.min));
                this.size = (computed + this.size) / 2;
                this.last = now;
            }
        }
        return nAck;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recv(int nBytes) {
        boolean send = false;
        RecvWindow recvWindow = this;
        synchronized (recvWindow) {
            this.recv += nBytes;
            if (this.recv > this.size / 2) {
                send = true;
            } else if (nBytes == this.recv) {
                this.ackTimer.scheduleIn(this.msec / 2L);
            }
        }
        if (send) {
            this.listener.sendAck(this, this.context);
        }
    }

    public int getWindowSize() {
        return this.size;
    }

    public void reset() {
        this.recv = 0;
        this.last = -1L;
    }
}

