/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.jinx;

import com.elluminate.jinx.JinxProtocolException;
import com.elluminate.jinx.MessageEvent;
import com.elluminate.jinx.PacketEvent;
import com.elluminate.jinx.ProtocolBuffer;

class ReassemblyData {
    private byte messageID = 0;
    private short remaining = 0;
    private MessageEvent msg;
    private ProtocolBuffer buffer;

    public ReassemblyData(PacketEvent packet, byte id, short left, byte chnl, byte cmd) {
        this.messageID = -id;
        this.remaining = left;
        this.buffer = (ProtocolBuffer)packet.getContent().clone();
        this.msg = MessageEvent.getInstance((Object)this, packet.getSourceAddress(), packet.getDestinationAddress(), packet.getGroupID(), packet.getPriority(), chnl, cmd, this.buffer);
    }

    public void merge(PacketEvent packet, byte id, short left) throws JinxProtocolException {
        if (id != this.messageID) {
            throw new JinxProtocolException("Incomplete packet from " + this.msg.getSourceAddress() + "(id " + this.messageID + ", priority " + packet.getPriority() + ") discarded - " + this.remaining + " fragments missing.\n  Received id " + id + ", " + left + " fragments");
        }
        if (left != this.remaining - 1) {
            throw new JinxProtocolException("Incomplete packet from " + this.msg.getSourceAddress() + " discarded - expected part " + (this.remaining - 1) + ", got " + left);
        }
        this.buffer.addPayload(packet.getContent());
        this.remaining = left;
    }

    public boolean isDone() {
        return this.remaining == 0;
    }

    public MessageEvent getMessage() {
        return this.msg;
    }
}

