/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.jinx;

import com.elluminate.jinx.PropertyAccessController;
import com.elluminate.jinx.PropertyStore;
import com.elluminate.jinx.PropertyValue;
import com.elluminate.util.log.LogSupport;
import java.beans.PropertyChangeEvent;

class Property
implements Cloneable {
    public static final short NullID = -1;
    private short id = (short)-1;
    private String name = null;
    private PropertyAccessController access = null;
    private PropertyValue value = null;

    Property(String name, PropertyValue value, short id) {
        this.name = name;
        this.value = value;
        this.id = id;
    }

    public Property(String name, PropertyValue value) {
        this(name, value, -1);
    }

    public boolean set(PropertyStore store, short who, PropertyValue newValue) {
        PropertyValue old = this.value;
        PropertyAccessController effectiveAccess = this.access;
        PropertyChangeEvent event = new PropertyChangeEvent(store, this.name, old.rawValue(), newValue.rawValue());
        if (effectiveAccess == null) {
            effectiveAccess = store.getDefaultAccess();
        }
        if (effectiveAccess != null && !effectiveAccess.propertyChangeAllowed(who, event)) {
            return false;
        }
        if (this.id > 0) {
            this.value = newValue;
            store.firePropertyChange(event);
        } else {
            this.value = newValue;
            store.firePropertyChange(event);
        }
        return true;
    }

    public boolean isShared() {
        return this.id != -1;
    }

    public String getName() {
        return this.name;
    }

    public short getID() {
        return this.id;
    }

    public PropertyValue getValue() {
        return this.value;
    }

    public void setAccessController(PropertyAccessController ctl) {
        this.access = ctl;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (Exception ex) {
            LogSupport.exception((Object)this, (String)"clone", (Throwable)ex, (boolean)true);
            return null;
        }
    }
}

