/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.jinx;

import com.elluminate.jinx.ProtocolBuffer;
import com.elluminate.util.ObjectPool;
import com.elluminate.util.PooledObject;
import com.elluminate.util.log.LogSupport;
import java.io.DataInputStream;

public class PacketEvent
extends PooledObject
implements Cloneable {
    private static Object packetPoolLock = new Object();
    private static ObjectPool packetPool = null;
    private Object source = null;
    private short from = (short)-32767;
    private short to = (short)-32767;
    private short group = (short)-32767;
    private byte priority = (byte)2;
    private ProtocolBuffer buffer = null;

    public void poInit() {
        super.poInit();
    }

    public void poCleanup() {
        this.source = null;
        this.buffer = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static PacketEvent alloc() {
        if (packetPool == null) {
            Object object = packetPoolLock;
            synchronized (object) {
                if (packetPool == null) {
                    ObjectPool pool;
                    packetPool = pool = ObjectPool.getInstance(PacketEvent.class);
                }
            }
        }
        return (PacketEvent)packetPool.alloc();
    }

    public static PacketEvent newInstance(Object source, short src, short dst, short grp, byte pri, byte[] payload) {
        PacketEvent e = PacketEvent.alloc();
        e.packetInitInstance(source, src, dst, grp, pri, payload);
        return e;
    }

    protected void packetInitInstance(Object source, short src, short dst, short grp, byte pri, byte[] payload) {
        this.source = source;
        this.from = src;
        this.to = dst;
        this.group = grp;
        this.priority = pri;
        this.buffer = ProtocolBuffer.getInstance(payload);
    }

    public static PacketEvent newInstance(Object source, short src, short dst, short grp, byte pri, byte[] payload, int off, int len) {
        PacketEvent e = PacketEvent.alloc();
        e.packetInitInstance(source, src, dst, grp, pri, payload, off, len);
        return e;
    }

    protected void packetInitInstance(Object source, short src, short dst, short grp, byte pri, byte[] payload, int off, int len) {
        this.source = source;
        this.from = src;
        this.to = dst;
        this.group = grp;
        this.priority = pri;
        this.buffer = ProtocolBuffer.getInstance(payload, off, len);
    }

    public static PacketEvent newInstance(Object source, short src, short dst, short grp, byte pri, ProtocolBuffer payload) {
        PacketEvent e = PacketEvent.alloc();
        e.packetInitInstance(source, src, dst, grp, pri, payload);
        return e;
    }

    protected void packetInitInstance(Object source, short src, short dst, short grp, byte pri, ProtocolBuffer payload) {
        this.source = source;
        this.from = src;
        this.to = dst;
        this.group = grp;
        this.priority = pri;
        this.buffer = payload;
    }

    public Object getSource() {
        return this.source;
    }

    public void setSource(Object obj) {
        this.source = obj;
    }

    public short getSourceAddress() {
        return this.from;
    }

    public short getDestinationAddress() {
        return this.to;
    }

    public short getGroupID() {
        return this.group;
    }

    public byte getPriority() {
        return this.priority;
    }

    public ProtocolBuffer getContent() {
        return this.buffer;
    }

    public ProtocolBuffer removeContent() {
        ProtocolBuffer buf = this.buffer;
        this.buffer = null;
        return buf;
    }

    public DataInputStream read() {
        return this.buffer.readPayload();
    }

    public Object clone() {
        try {
            PacketEvent copy = (PacketEvent)packetPool.alloc();
            this.cloneInto(copy);
            return copy;
        }
        catch (Exception ex) {
            LogSupport.exception((Object)this, (String)"clone", (Throwable)ex, (boolean)true);
            return null;
        }
    }

    protected void cloneInto(PacketEvent copy) {
        copy.source = this.source;
        copy.from = this.from;
        copy.to = this.to;
        copy.group = this.group;
        copy.priority = this.priority;
        copy.buffer = (ProtocolBuffer)this.buffer.clone();
    }

    public void dispose() {
        if (this.buffer != null) {
            this.buffer.dispose();
            this.buffer = null;
        }
        super.dispose();
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean verbose) {
        String str = "PacketEvent, source: " + this.source + ", from: " + this.from + ", to: " + this.to + ", group: " + this.group + ", priority: " + this.priority;
        if (verbose) {
            try {
                DataInputStream istr = this.buffer.readPayload();
                byte msgID = istr.readByte();
                short left = istr.readShort();
                byte chnl = istr.readByte();
                byte cmd = istr.readByte();
                int len = this.buffer.getSize() - 5;
                istr.close();
                str = str + "[id=" + msgID + ",left=" + left + ",chnl=" + chnl + ",cmd=" + cmd + ",len=" + len + "]";
            }
            catch (Throwable ex) {
                str = str + "[Exception reading header - " + ex + "]";
            }
        }
        return str;
    }
}

