/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.jinx;

import com.elluminate.jinx.BandwidthLimit;
import com.elluminate.jinx.ControlPacket;
import com.elluminate.jinx.DebugFlags;
import com.elluminate.jinx.JinxConnectionException;
import com.elluminate.jinx.JinxException;
import com.elluminate.jinx.JinxTuning;
import com.elluminate.jinx.LogFlags;
import com.elluminate.jinx.PacketEvent;
import com.elluminate.jinx.PacketScheduler;
import com.elluminate.jinx.ProtocolBuffer;
import com.elluminate.jinx.TransceiverAdapter;
import com.elluminate.jinx.TransceiverEvent;
import com.elluminate.jinx.TransmitStatusEvent;
import com.elluminate.jinx.core.metrics.MetricsInstance;
import com.elluminate.jinx.core.metrics.MetricsLoggerFactory;
import com.elluminate.net.Endpoint;
import com.elluminate.net.EndpointSecurity;
import com.elluminate.util.Debug;
import com.elluminate.util.MTPriorityQueue;
import com.elluminate.util.PriorityScheduler;
import com.elluminate.util.QueuedProcessor;
import com.elluminate.util.log.LogSupport;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetAddress;

public class NetworkTransceiver
extends TransceiverAdapter
implements Runnable {
    public static final int HEADER_LENGTH = 10;
    public static final byte OP_USER_DATA = 0;
    public static final byte OP_RECEIVE_BANDWIDTH = 1;
    public static final byte OP_PING = 2;
    public static final byte OP_ECHO = 3;
    public static final byte OP_HANGUP = 4;
    public static final int WAIT_TIME = 1000;
    public static final int PING_TIMEOUT = 20000;
    public static final int PING_RETRY_INTERVAL = 5000;
    public static final int DISCONNECT_TIMEOUT = 45000;
    private static final float HALF_DUPLEX_MOD = 0.5f;
    private static final int MAX_BUFFER_SIZE = 1600;
    private static final int MIN_BUFFER_SIZE = 500;
    private static final long PRIORITY_INTERVAL = 2000L;
    private final MetricsInstance metricsSessionLogger = MetricsLoggerFactory.getInstance().getMetricsLogger("session");
    private Endpoint endpoint = null;
    private DataInputStream in = null;
    private OutputStream out = null;
    private Thread reader = null;
    private PacketScheduler scheduler = null;
    private MTPriorityQueue queue = null;
    private int myRecvSpeed = 1000000;
    private int myXmitSpeed = 1000000;
    private int hisRecvSpeed = 1000000;
    private Object disconnectLock = new Object();
    private volatile boolean disconnecting = false;
    private byte[] transmitBuffer = new byte[2048];
    private int bufferSize = 1600;
    private int bufferOffset = 0;
    private int stackSize = 0;
    private volatile long lastMsg;
    private long lastPing = this.lastMsg = System.currentTimeMillis();

    public NetworkTransceiver(BandwidthLimit[] limits) {
        this.scheduler = new PacketScheduler(limits);
    }

    public void connect(Endpoint ep, short addr, String name, int recvBandwidth, int xmitBandwidth) throws JinxConnectionException {
        this.setAddress(addr);
        this.setName(name);
        this.endpoint = ep;
        if (this.endpoint.isFullDuplex()) {
            this.myXmitSpeed = xmitBandwidth;
            this.myRecvSpeed = recvBandwidth;
        } else {
            this.myXmitSpeed = (int)((float)xmitBandwidth * 0.5f);
            this.myRecvSpeed = (int)((float)recvBandwidth * 0.5f);
        }
        this.disconnecting = false;
        this.scheduler.setBandwidth(this.myXmitSpeed);
        this.updateBufferSize();
        if (DebugFlags.BANDWIDTH.show()) {
            LogSupport.message((Object)this, (String)"connect", (String)("TX connect - myXmit=" + this.myXmitSpeed + ", myRecv=" + this.myRecvSpeed));
        }
        byte prev = this.setState((byte)1);
        this.fireTransceiverStatusChanged((byte)1, prev, (byte)0);
    }

    @Override
    public void enable() {
        this.enable(null);
    }

    public void enable(ThreadGroup grp) {
        QueuedProcessor proc = new QueuedProcessor(){

            public void process(Object o, Object context) {
                NetworkTransceiver.this.processOutgoing(o);
            }

            public void idle() {
                NetworkTransceiver.this.transmit();
            }

            public void discard(Object o) {
                try {
                    PacketEvent p = (PacketEvent)o;
                    p.dispose();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        };
        byte prev = this.getState();
        this.queue = new MTPriorityQueue("netXmit('" + this.getName() + "'," + this.getAddress() + ")", proc, (PriorityScheduler)this.scheduler);
        this.queue.setThreadStackSize(this.stackSize);
        this.queue.setPriorityRange((byte)4);
        this.queue.setDefaultPriority((byte)2);
        this.queue.setPriorityIncrementInterval(2000L);
        this.queue.setThreadGroup(grp);
        try {
            this.endpoint.setSoLinger(true, 10);
            this.endpoint.setTcpNoDelay(true);
            this.endpoint.setSoTimeout(45000);
            this.in = new DataInputStream(this.endpoint.getInputStream());
            this.out = this.endpoint.getOutputStream();
        }
        catch (IOException ex) {
            try {
                this.fireTransceiverStatusChanged((byte)3, prev, (byte)3);
            }
            catch (Exception ex2) {
                LogSupport.exception((Object)this, (String)"enable", (Throwable)ex, (boolean)true);
            }
            return;
        }
        this.reader = new Thread(grp, this, "netRecv('" + this.getName() + "'," + this.getAddress() + ")", this.stackSize);
        this.reader.setPriority(5);
        this.queue.setIdleWhenDelayed(true);
        this.queue.setIdleTask(new Runnable(){

            @Override
            public void run() {
                NetworkTransceiver.this.pingCheck();
            }
        });
        if (DebugFlags.BANDWIDTH.show()) {
            LogSupport.message((Object)this, (String)"enable", (String)("Scheduler xmit speed=" + this.myXmitSpeed));
        }
        this.scheduler.setBandwidth(this.myXmitSpeed);
        this.scheduler.setBufferSize(this.bufferSize);
        if (DebugFlags.BANDWIDTH.show()) {
            LogSupport.message((Object)this, (String)"enable", (String)("Send recv speed=" + this.myRecvSpeed));
        }
        this.onControlPacket(new ControlPacket(1, this.myRecvSpeed));
        this.setState((byte)2);
        this.reader.start();
        try {
            this.fireTransceiverStatusChanged((byte)2, prev, (byte)0);
        }
        catch (JinxConnectionException ex) {
            LogSupport.exception((Object)this, (String)"enable", (Throwable)ex, (boolean)true);
        }
        if (DebugFlags.CIPHER.show()) {
            String cipher = EndpointSecurity.getCipher((Endpoint)this.endpoint);
            if (cipher == null) {
                LogSupport.message((String)"Channel not enciphered.");
            } else {
                LogSupport.message((String)("Channel enciphered using " + cipher));
            }
        }
    }

    @Override
    public void disconnect(byte reason) {
        if (DebugFlags.HANGUP.show()) {
            this.logHangup("disconnect", "locally(" + TransceiverEvent.REASONS[reason] + ")");
        }
        this.hangup(reason);
    }

    public int getThreadStackSize() {
        return this.stackSize;
    }

    public void setThreadStackSize(int size) {
        this.stackSize = size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void hangup(byte reason) {
        boolean inProgress = false;
        boolean notify = false;
        Endpoint closeEndpoint = null;
        byte prev = 3;
        Debug.lockEnter((Object)this, (String)"hangup", (String)"disconnectLock", (Object)this.disconnectLock);
        Object object = this.disconnectLock;
        synchronized (object) {
            inProgress = this.disconnecting;
            this.disconnecting = true;
        }
        Debug.lockLeave((Object)this, (String)"hangup", (String)"disconnectLock", (Object)this.disconnectLock);
        if (inProgress && reason != 4) {
            return;
        }
        Debug.lockEnter((Object)this, (String)"hangup", null, (Object)this);
        object = this;
        synchronized (object) {
            if (this.endpoint != null) {
                notify = true;
                this.reader = null;
                if (reason == 1) {
                    this.queue.clear();
                    this.onControlPacket(new ControlPacket(4));
                    this.queue.stop((byte)0, 1000L);
                } else if (this.queue != null) {
                    this.queue.stop(false);
                }
                closeEndpoint = this.endpoint;
                this.endpoint = null;
                this.in = null;
                this.out = null;
                prev = this.setState((byte)3);
            }
        }
        Debug.lockLeave((Object)this, (String)"hangup", null, (Object)this);
        if (notify) {
            Thread.interrupted();
            try {
                this.fireTransceiverStatusChanged((byte)3, prev, reason);
            }
            catch (JinxException ex) {
            }
            catch (Exception ex) {
                LogSupport.exception((Object)this, (String)"hangup", (Throwable)ex, (boolean)true);
            }
            Debug.lockEnter((Object)this, (String)"hangup", null, (Object)this);
            object = this;
            synchronized (object) {
                this.setName(null);
                this.setAddress((short)-32767);
            }
            Debug.lockLeave((Object)this, (String)"hangup", null, (Object)this);
        }
        if (closeEndpoint != null) {
            closeEndpoint.closeForce();
        }
    }

    public void setConnectionSpeed(int xmit, int recv) {
        Endpoint ep;
        if (DebugFlags.BANDWIDTH.show()) {
            LogSupport.message((Object)this, (String)"setConnectionSpeed", (String)("Setting speed to " + xmit + "bps xmit, " + recv + "bps recv"));
        }
        if ((ep = this.endpoint) == null) {
            return;
        }
        if (ep.isFullDuplex()) {
            this.myXmitSpeed = xmit;
            this.myRecvSpeed = recv;
        } else {
            this.myXmitSpeed = (int)((float)xmit * 0.5f);
            this.myRecvSpeed = (int)((float)recv * 0.5f);
        }
        int xmitActual = Math.min(this.myXmitSpeed, this.hisRecvSpeed);
        if (DebugFlags.BANDWIDTH.show()) {
            LogSupport.message((Object)this, (String)"setConnectionSpeed", (String)("Scheduler xmit speed=" + xmitActual));
        }
        this.scheduler.setBandwidth(xmitActual);
        this.updateBufferSize();
        if (DebugFlags.BANDWIDTH.show()) {
            LogSupport.message((Object)this, (String)"setConnectionSpeed", (String)("Send recv speed=" + recv));
        }
        this.onControlPacket(new ControlPacket(1, recv));
    }

    public long getLastMessageInterval() {
        return System.currentTimeMillis() - this.lastMsg;
    }

    @Override
    public boolean isSecure() {
        Endpoint ep = this.endpoint;
        if (ep == null) {
            return false;
        }
        return ep.isSecure();
    }

    @Override
    public String getCipher() {
        Endpoint ep = this.endpoint;
        if (ep == null) {
            return null;
        }
        return ep.getCipher();
    }

    private void pingCheck() {
        if (DebugFlags.TX_NO_PING.isEnabled()) {
            return;
        }
        long now = System.currentTimeMillis();
        if (now - this.lastMsg > 20000L && now - this.lastPing > 5000L) {
            this.onControlPacket(new ControlPacket(2));
            this.lastPing = now;
        }
    }

    private void processOutgoing(Object o) {
        if (o instanceof PacketEvent) {
            PacketEvent e = (PacketEvent)o;
            this.processPacket(e);
        } else if (o instanceof ControlPacket) {
            ControlPacket p = (ControlPacket)o;
            this.processControl(p);
        } else if (o instanceof TransmitStatusEvent) {
            TransmitStatusEvent c = (TransmitStatusEvent)o;
            c.setTransmitComplete();
            this.fireTransmitComplete(c);
        } else {
            LogSupport.error((Object)this, (String)"processOutgoing", (String)("Unknown object type '" + o.getClass().getName() + "' found in transmit queue."));
        }
    }

    private void processPacket(PacketEvent event) {
        ProtocolBuffer buffer = event.getContent();
        short len = (short)buffer.getSize();
        DataOutputStream str = buffer.addHeader();
        try {
            str.writeShort(event.getSourceAddress());
            str.writeShort(event.getDestinationAddress());
            str.writeShort(event.getGroupID());
            str.writeByte(event.getPriority());
            str.writeByte(0);
            str.writeShort(len);
            str.close();
            str = buffer.addPayload();
            str.close();
        }
        catch (Exception ex) {
            LogSupport.exception((Object)this, (String)"onPacket", (Throwable)ex, (boolean)true);
            return;
        }
        str = null;
        this.send(buffer);
        event.dispose();
    }

    private void processControl(ControlPacket p) {
        ProtocolBuffer buf = p.getBuffer(this.getAddress());
        this.send(buf);
        this.transmit();
        buf.dispose();
    }

    private void send(ProtocolBuffer buf) {
        int len = buf.getSize();
        if (this.bufferOffset + len > this.bufferSize) {
            this.transmit();
        }
        buf.writeTo(this.transmitBuffer, this.bufferOffset, len);
        this.bufferOffset += len;
        this.stats.write(len);
    }

    private void transmit() {
        if (this.bufferOffset == 0) {
            return;
        }
        if (this.out != null) {
            try {
                this.out.write(this.transmitBuffer, 0, this.bufferOffset);
                this.stats.send();
            }
            catch (IOException ex) {
                this.logDisconnect("transmit", ex, "output exception");
                this.hangup((byte)3);
            }
            catch (Exception ex) {
                LogSupport.exception((Object)this, (String)"transmit", (Throwable)ex, (boolean)true);
            }
        } else if (DebugFlags.PACKETS.show()) {
            LogSupport.message((Object)this, (String)"transmit", (String)"no output stream.");
        }
        this.scheduler.flush();
        this.bufferOffset = 0;
    }

    @Override
    public void onPacket(PacketEvent event) {
        if (this.queue != null) {
            event.setSource(this);
            this.queue.process((Object)event, event.getPriority());
        }
    }

    @Override
    public void onTransmitStatus(TransmitStatusEvent event) {
        if (this.queue != null) {
            this.queue.process((Object)event, event.getPriority());
        }
    }

    void onControlPacket(ControlPacket p) {
        if (this.queue != null) {
            this.queue.process((Object)p, (byte)0);
        }
    }

    @Override
    public void run() {
        ProtocolBuffer buf = null;
        DataInputStream str = this.in;
        while (!Thread.interrupted() && this.isEnabled()) {
            short len;
            byte op;
            byte pri;
            short grp;
            short dst;
            short src;
            int nRead;
            block18: {
                nRead = 0;
                try {
                    src = str.readShort();
                    dst = str.readShort();
                    grp = str.readShort();
                    pri = str.readByte();
                    op = str.readByte();
                    len = str.readShort();
                    nRead += 10;
                    if (len <= 0) break block18;
                    buf = ProtocolBuffer.getInstance();
                    if (len > 5) {
                        buf.readFrom(str, 5, len - 5);
                    } else {
                        buf.readFrom(str, 0, len);
                    }
                    nRead += len;
                }
                catch (Throwable ex) {
                    this.logDisconnect("run", ex, "input exception (header)");
                    this.hangup((byte)3);
                    break;
                }
            }
            this.lastMsg = System.currentTimeMillis();
            switch (op) {
                case 0: {
                    if (len <= 0) break;
                    try {
                        PacketEvent event = PacketEvent.newInstance((Object)this, src, dst, grp, pri, buf);
                        this.fireOnPacket(event);
                        buf = null;
                    }
                    catch (Exception ex) {
                        LogSupport.exception((Object)this, (String)"run", (Throwable)ex, (boolean)false);
                    }
                    break;
                }
                case 2: {
                    this.onControlPacket(new ControlPacket(3));
                    break;
                }
                case 3: {
                    break;
                }
                case 1: {
                    int recv;
                    try {
                        DataInputStream rstr = buf.readPayload();
                        recv = rstr.readInt();
                        rstr.close();
                    }
                    catch (Throwable ex) {
                        this.logDisconnect("run", ex, "input exception (bandwidth)");
                        this.hangup((byte)3);
                        break;
                    }
                    if (DebugFlags.BANDWIDTH.show()) {
                        LogSupport.message((Object)this, (String)"run", (String)("Remote recv speed=" + recv));
                    }
                    this.hisRecvSpeed = recv;
                    this.scheduler.setBandwidth(Math.min(this.hisRecvSpeed, this.myXmitSpeed));
                    this.updateBufferSize();
                    break;
                }
                case 4: {
                    this.logHangup("run", "remotely");
                    this.hangup((byte)2);
                    break;
                }
                default: {
                    LogSupport.error((Object)this, (String)"run", (String)("Unknown opcode (" + op + ") in received packet. src: " + src + ", dst: " + dst + ", grp: " + grp + ", pri: " + pri + ", len: " + len));
                }
            }
            if (buf != null) {
                buf.dispose();
                buf = null;
            }
            this.stats.read(nRead);
        }
        this.hangup((byte)0);
        str = null;
    }

    @Override
    public int getMaxXmitSpeed() {
        return this.scheduler.getBandwidth();
    }

    public int getNegotiatedXmitSpeed() {
        return Math.min(this.myXmitSpeed, this.hisRecvSpeed);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isTimedOut() {
        boolean timedOut = false;
        Object object = this.disconnectLock;
        synchronized (object) {
            if (this.disconnecting) {
                timedOut = false;
            } else if (System.currentTimeMillis() - this.lastMsg > 45000L) {
                timedOut = true;
                this.disconnecting = true;
            }
        }
        return timedOut;
    }

    private void logDisconnect(String from, Throwable t, String desc) {
        if (this.disconnecting) {
            return;
        }
        if (DebugFlags.DISCONNECTION.show()) {
            InetAddress addr;
            String ip = "unknown";
            String statistics = "";
            String details = "";
            String trace = "";
            if (this.endpoint != null && (addr = this.endpoint.getInetAddress()) != null) {
                ip = addr.toString();
            }
            if (LogFlags.STATS.show()) {
                statistics = " [" + this.stats + "]";
            }
            if (t != null) {
                if (LogFlags.TRACE_DISCON.show()) {
                    trace = "\n" + Debug.getStackTrace((Throwable)t);
                }
                details = " - " + t;
            }
            LogSupport.message((Object)this, (String)from, (String)("Disconnecting " + this.getName() + "(" + ip + ") on " + desc + details + statistics + trace));
        }
        if (this.getAddress() != -32767) {
            this.metricsSessionLogger.log(this.getConferenceName(), "hangup", Short.toString(this.getAddress()), desc, this.stats.toString());
        }
    }

    private void logHangup(String from, String side) {
        if (DebugFlags.HANGUP.show()) {
            InetAddress addr;
            String ip = "unknown";
            String statistics = "";
            if (this.endpoint != null && (addr = this.endpoint.getInetAddress()) != null) {
                ip = addr.toString();
            }
            if (LogFlags.STATS.show()) {
                statistics = " [" + this.stats + "]";
            }
            LogSupport.message((Object)this, (String)from, (String)("User " + this.getName() + "(" + ip + ") has been disconnected " + side + statistics));
        }
        if (this.getAddress() != -32767) {
            this.metricsSessionLogger.log(this.getConferenceName(), "disconnect", Short.toString(this.getAddress()), "hangup", this.stats.toString());
        }
    }

    private void updateBufferSize() {
        int divisor = JinxTuning.BundlingSizeFraction.getIntValue() * 8;
        int bSize = this.scheduler.getBandwidth() / divisor;
        bSize = Math.min(bSize, 1600);
        bSize = Math.max(bSize, 500);
        if (DebugFlags.BANDWIDTH.show()) {
            LogSupport.message((Object)this, (String)"updateBufferSize", (String)("Buffer size for " + this.getName() + " set to " + bSize + " bytes."));
        }
        this.bufferSize = bSize;
        this.scheduler.setBufferSize(bSize);
    }
}

