/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.jinx;

import com.elluminate.jinx.DefaultProtocolResponder;
import com.elluminate.jinx.JinxProtocol;
import com.elluminate.jinx.JinxProtocolChnl;
import com.elluminate.jinx.JinxProtocolProp;
import com.elluminate.jinx.PropertyAccessController;
import com.elluminate.jinx.PropertyValue;
import com.elluminate.jinx.ProtocolResponder;
import java.beans.PropertyChangeEvent;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class JinxProtocolAdapter
implements JinxProtocol {
    private static Map<String, Properties> propMap = new HashMap<String, Properties>();
    private List<JinxProtocolChnl> channels = new LinkedList<JinxProtocolChnl>();
    private List<JinxProtocolProp> properties = new LinkedList<JinxProtocolProp>();
    private String versionProperty = null;
    private String versionString = null;

    protected JinxProtocolAdapter() {
        this.lookupProtocolProperty();
    }

    protected void defineChannel(String chnl, byte pri) {
        this.channels.add(new JinxProtocolChnl(chnl, pri));
    }

    protected void defineProperty(String prop, byte scope, PropertyValue dft) {
        this.defineProperty(prop, scope, dft, null);
    }

    protected void defineProperty(String prop, byte scope, boolean dft) {
        this.defineProperty(prop, scope, new PropertyValue(dft), null);
    }

    protected void defineProperty(String prop, byte scope, byte dft) {
        this.defineProperty(prop, scope, new PropertyValue(dft), null);
    }

    protected void defineProperty(String prop, byte scope, char dft) {
        this.defineProperty(prop, scope, new PropertyValue(Character.valueOf(dft)), null);
    }

    protected void defineProperty(String prop, byte scope, short dft) {
        this.defineProperty(prop, scope, new PropertyValue(dft), null);
    }

    protected void defineProperty(String prop, byte scope, int dft) {
        this.defineProperty(prop, scope, new PropertyValue(dft), null);
    }

    protected void defineProperty(String prop, byte scope, float dft) {
        this.defineProperty(prop, scope, new PropertyValue(Float.valueOf(dft)), null);
    }

    protected void defineProperty(String prop, byte scope, double dft) {
        this.defineProperty(prop, scope, new PropertyValue(dft), null);
    }

    protected void defineProperty(String prop, byte scope, String dft) {
        this.defineProperty(prop, scope, new PropertyValue(dft), null);
    }

    protected void defineProperty(String prop, byte scope, PropertyValue dft, PropertyAccessController ctl) {
        this.properties.add(new JinxProtocolProp(prop, scope, dft, ctl));
    }

    protected void defineProperty(String prop, byte scope, boolean dft, PropertyAccessController ctl) {
        this.properties.add(new JinxProtocolProp(prop, scope, new PropertyValue(dft), ctl));
    }

    protected void defineProperty(String prop, byte scope, byte dft, PropertyAccessController ctl) {
        this.properties.add(new JinxProtocolProp(prop, scope, new PropertyValue(dft), ctl));
    }

    protected void defineProperty(String prop, byte scope, char dft, PropertyAccessController ctl) {
        this.properties.add(new JinxProtocolProp(prop, scope, new PropertyValue(Character.valueOf(dft)), ctl));
    }

    protected void defineProperty(String prop, byte scope, short dft, PropertyAccessController ctl) {
        this.properties.add(new JinxProtocolProp(prop, scope, new PropertyValue(dft), ctl));
    }

    protected void defineProperty(String prop, byte scope, int dft, PropertyAccessController ctl) {
        this.properties.add(new JinxProtocolProp(prop, scope, new PropertyValue(dft), ctl));
    }

    protected void defineProperty(String prop, byte scope, long dft, PropertyAccessController ctl) {
        this.properties.add(new JinxProtocolProp(prop, scope, new PropertyValue(dft), ctl));
    }

    protected void defineProperty(String prop, byte scope, float dft, PropertyAccessController ctl) {
        this.properties.add(new JinxProtocolProp(prop, scope, new PropertyValue(Float.valueOf(dft)), ctl));
    }

    protected void defineProperty(String prop, byte scope, double dft, PropertyAccessController ctl) {
        this.properties.add(new JinxProtocolProp(prop, scope, new PropertyValue(dft), ctl));
    }

    protected void defineProperty(String prop, byte scope, String dft, PropertyAccessController ctl) {
        this.properties.add(new JinxProtocolProp(prop, scope, new PropertyValue(dft), ctl));
    }

    @Override
    public List<JinxProtocolChnl> getChannels() {
        return new LinkedList<JinxProtocolChnl>(this.channels);
    }

    @Override
    public JinxProtocolChnl getChannel(String name) {
        for (JinxProtocolChnl c : this.channels) {
            if (!c.getName().equals(name)) continue;
            return c;
        }
        return null;
    }

    @Override
    public List<JinxProtocolProp> getProperties() {
        return new LinkedList<JinxProtocolProp>(this.properties);
    }

    @Override
    public JinxProtocolProp getProperty(String name) {
        for (JinxProtocolProp p : this.properties) {
            if (!p.getName().equals(name)) continue;
            return p;
        }
        return null;
    }

    @Override
    public String commandToString(byte cmd) {
        return Byte.toString(cmd);
    }

    @Override
    public String messageToString(byte cmd, DataInputStream str) {
        try {
            return "cmd=" + this.commandToString(cmd) + ", " + str.available() + " bytes of data.";
        }
        catch (IOException ex) {
            return "cmd=" + this.commandToString(cmd) + ", unable to read contents...";
        }
    }

    @Override
    public ProtocolResponder getResponder() {
        return new DefaultProtocolResponder(this);
    }

    public String getVersionProperty() {
        return this.versionProperty;
    }

    public String getProtocolVersion() {
        return this.versionString;
    }

    protected void lookupProtocolProperty() {
        Class<?> cls = this.getClass();
        while (!cls.getName().startsWith("java")) {
            Properties props = JinxProtocolAdapter.getPropertiesFor(cls);
            if (props != null) {
                String prop = "_protocol." + cls.getName() + "Ver";
                String ver = props.getProperty("protocolVersion");
                if (ver != null) {
                    this.versionProperty = prop;
                    this.versionString = ver;
                    this.defineProperty(prop, (byte)1, new PropertyValue(ver), new PropertyAccessController(){

                        @Override
                        public boolean propertyChangeAllowed(short by, PropertyChangeEvent chg) {
                            return false;
                        }
                    });
                    return;
                }
            }
            cls = cls.getSuperclass();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties getPropertiesFor(Class<?> cls) {
        Properties props;
        block21: {
            ClassLoader loader = null;
            String nm = cls.getName().replace('.', '/');
            Map<String, Properties> map = propMap;
            synchronized (map) {
                if (propMap.containsKey(nm)) {
                    return propMap.get(nm);
                }
            }
            if (cls != null) {
                loader = cls.getClassLoader();
            }
            if (loader == null) {
                loader = ClassLoader.getSystemClassLoader();
            }
            props = null;
            InputStream istr = null;
            try {
                istr = loader.getResourceAsStream(nm + "Ver.properties");
                if (istr == null) break block21;
                props = new Properties();
                props.load(istr);
                Map<String, Properties> map2 = propMap;
                synchronized (map2) {
                    propMap.put(nm, props);
                }
            }
            catch (IOException iox) {
                props = null;
            }
            finally {
                try {
                    if (istr != null) {
                        istr.close();
                    }
                }
                catch (IOException iox) {}
            }
        }
        return props;
    }
}

