/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.jinx;

public class ConferenceName {
    public static final String PART_CHARACTERS = "-_=+.,";
    public static final String NAME_CHARACTERS = "-_=+.,|#";
    private String original = null;
    private String canonical = null;

    public ConferenceName(String nm) {
        String[] parts = ConferenceName.split(nm);
        StringBuffer buf = new StringBuffer();
        this.original = nm;
        if (parts[0] != null) {
            buf.append(ConferenceName.canonicalize(parts[0]));
            buf.append('|');
        }
        buf.append(ConferenceName.canonicalize(parts[1]));
        if (parts[2] != null) {
            buf.append('#');
            buf.append(ConferenceName.canonicalize(parts[2]));
        }
        this.canonical = buf.toString();
    }

    public String getOriginalName() {
        return this.original;
    }

    public String getCanonicalName() {
        return this.canonical;
    }

    public String getDisplayName() {
        return ConferenceName.split(this.original)[1];
    }

    public String getNameWithinGroup() {
        String[] parts = ConferenceName.split(this.canonical);
        if (parts[2] == null) {
            return parts[1];
        }
        return parts[1] + "#" + parts[2];
    }

    public String getGroupPart() {
        return ConferenceName.split(this.canonical)[0];
    }

    public String getDisplayPart() {
        return ConferenceName.split(this.canonical)[1];
    }

    public String getUniquePart() {
        return ConferenceName.split(this.canonical)[2];
    }

    public boolean equals(Object o) {
        if (o instanceof ConferenceName) {
            ConferenceName other = (ConferenceName)o;
            return this.canonical.equals(other.canonical);
        }
        if (o instanceof String) {
            ConferenceName other = new ConferenceName((String)o);
            return this.canonical.equals(other.canonical);
        }
        return false;
    }

    public int hashCode() {
        return this.canonical.hashCode();
    }

    public static String canonicalize(String nm) {
        return ConferenceName.canonicalize(nm, PART_CHARACTERS);
    }

    public static String canonicalize(String nm, String extras) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < nm.length(); ++i) {
            char c = nm.charAt(i);
            if (Character.isLetterOrDigit(c)) {
                buf.append(c);
                continue;
            }
            if (extras.indexOf(c) < 0) continue;
            buf.append(c);
        }
        return buf.toString();
    }

    public static String[] split(String nm) {
        int uIdx;
        int gIdx = nm.indexOf("|");
        String[] parts = new String[3];
        if (gIdx >= 0) {
            parts[0] = nm.substring(0, gIdx);
            uIdx = nm.indexOf("#", gIdx + 1);
        } else {
            parts[0] = null;
            uIdx = nm.indexOf("#");
        }
        if (uIdx >= 0) {
            parts[1] = nm.substring(gIdx + 1, uIdx);
            parts[2] = nm.substring(uIdx + 1);
        } else {
            parts[1] = nm.substring(gIdx + 1);
            parts[2] = null;
        }
        return parts;
    }

    public String toString() {
        if (this.canonical.equals(this.original)) {
            return this.canonical;
        }
        return this.canonical + "(" + this.original + ")";
    }
}

