/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.jinx;

import com.elluminate.jinx.ByteBlock;
import com.elluminate.jinx.ByteListInputStream;
import com.elluminate.jinx.ByteListOutputStream;
import com.elluminate.jinx.DebugFlags;
import com.elluminate.jinx.ProtocolIOListener;
import com.elluminate.net.AsyncEndpoint;
import com.elluminate.net.AsyncIOListener;
import com.elluminate.net.AsyncIORequest;
import com.elluminate.util.ObjectPool;
import com.elluminate.util.PooledObject;
import com.elluminate.util.log.LogSupport;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.EOFException;
import java.io.IOException;
import java.util.zip.Checksum;

public final class ByteList
extends PooledObject
implements Cloneable,
AsyncIOListener {
    private static Object listPoolLock = new Object();
    private static ObjectPool listPool = null;
    private static boolean unpooled = false;
    ObjectPool pool = null;
    ByteBlock head = null;
    ByteBlock tail = null;
    int length = 0;
    boolean doValidate = false;
    boolean doTrace = false;
    long headGeneration = -1L;
    Throwable lastDispose = null;
    long disposeGeneration = -1L;
    ByteBlock lastBlock = null;
    int lastIndex = 0;
    ProtocolIOListener readListener = null;
    int readLen;
    ProtocolIOListener writeListener = null;
    ByteBlock writing = null;

    public void poInit() {
        this.doValidate = DebugFlags.BYTELIST_CHECK.show();
        this.doTrace = DebugFlags.BYTELIST_INST.show();
    }

    public void poCleanup() {
        this.pool = null;
        this.head = null;
        this.tail = null;
        this.lastBlock = null;
        this.writing = null;
        this.readListener = null;
        this.writeListener = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ByteList alloc() {
        if (unpooled) {
            return new ByteList();
        }
        if (listPool == null) {
            Object object = listPoolLock;
            synchronized (object) {
                if (!ObjectPool.isEnabled()) {
                    unpooled = true;
                    return new ByteList();
                }
                if (listPool == null) {
                    ObjectPool op;
                    listPool = op = ObjectPool.getInstance(ByteList.class);
                }
            }
        }
        return (ByteList)listPool.alloc();
    }

    static ByteList getInstance(ObjectPool pool) {
        ByteList list = ByteList.alloc();
        list.length = 0;
        list.pool = pool;
        list.head = list.tail = (ByteBlock)pool.alloc();
        list.headGeneration = list.head.poGetGeneration();
        list.lastBlock = null;
        list.lastIndex = 0;
        if (list.doTrace) {
            ByteList.logInstance(list, "getInstance");
        }
        return list;
    }

    static ByteList getInstance(ByteBlock first, ByteBlock last) {
        ByteList list = ByteList.alloc();
        list.pool = last.poGetObjectPool();
        list.head = first;
        list.headGeneration = first.poGetGeneration();
        list.tail = last;
        last.setNext(null);
        list.length = 0;
        for (ByteBlock blk = first; blk != null; blk = blk.getNext()) {
            list.length += blk.length - blk.start;
        }
        list.lastBlock = null;
        list.lastIndex = 0;
        if (list.doTrace) {
            ByteList.logInstance(list, "getInstance");
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void append(ByteList list) {
        long ll;
        ByteBlock lt;
        ByteBlock lh;
        if (this.doValidate) {
            if (!this.isValid() || !list.isValid()) {
                throw new IllegalStateException("append on invalid byte lists.");
            }
            if (list == this) {
                throw new IllegalArgumentException("Cannot append a list to itself");
            }
        }
        this.copyOnWrite();
        if (list.doTrace) {
            ByteList.logRelation(list, this, "append");
        }
        ByteList byteList = list;
        synchronized (byteList) {
            lh = list.head;
            lt = list.tail;
            ll = list.length;
            list.head = null;
            list.tail = null;
            list.headGeneration = -1L;
            list.length = 0;
            list.dispose();
        }
        byteList = this;
        synchronized (byteList) {
            this.tail.setNext(lh);
            this.tail = lt;
            this.length = (int)((long)this.length + ll);
            this.lastBlock = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prepend(ByteList list) {
        long ll;
        ByteBlock lt;
        ByteBlock lh;
        if (this.doValidate) {
            if (!this.isValid() || !list.isValid()) {
                throw new IllegalStateException("prepend on invalid byte lists.");
            }
            if (list == this) {
                throw new IllegalArgumentException("Cannot prepend a list to itself");
            }
        }
        list.copyOnWrite();
        if (list.doTrace) {
            ByteList.logRelation(list, this, "prepend");
        }
        ByteList byteList = list;
        synchronized (byteList) {
            lh = list.head;
            lt = list.tail;
            ll = list.length;
            list.head = null;
            list.tail = null;
            list.headGeneration = -1L;
            list.length = 0;
            list.dispose();
        }
        byteList = this;
        synchronized (byteList) {
            lt.setNext(this.head);
            this.head = lh;
            this.headGeneration = this.head.poGetGeneration();
            this.length = (int)((long)this.length + ll);
            this.lastBlock = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object clone() {
        ByteList list = ByteList.alloc();
        ByteList byteList = this;
        synchronized (byteList) {
            if (this.tail != null) {
                ByteBlock byteBlock = this.tail;
                synchronized (byteBlock) {
                    for (ByteBlock scan = this.head; scan != null; scan = scan.getNext()) {
                        scan.incRefCount();
                    }
                }
            }
            list.pool = this.pool;
            list.head = this.head;
            if (list.head != null) {
                list.headGeneration = list.head.poGetGeneration();
            }
            list.tail = this.tail;
            list.length = this.length;
            list.lastBlock = this.lastBlock;
            list.lastIndex = this.lastIndex;
            if (list.doTrace) {
                ByteList.logInstance(list, "clone");
                ByteList.logRelation(this, list, "clone");
            }
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getCRC(Checksum crc) {
        ByteList byteList = this;
        synchronized (byteList) {
            for (ByteBlock scan = this.head; scan != null; scan = scan.getNext()) {
                crc.update(scan.data, scan.start, scan.length);
            }
        }
        return (int)crc.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyOnWrite() {
        if (this.tail.ref == 1) {
            return;
        }
        ByteBlock newHead = null;
        ByteBlock newTail = null;
        ByteBlock next = null;
        ByteList byteList = this;
        synchronized (byteList) {
            if (this.tail != null) {
                ByteBlock byteBlock = this.tail;
                synchronized (byteBlock) {
                    ByteBlock scan = this.head;
                    while (scan != null) {
                        ByteBlock copy;
                        next = scan.getNext();
                        if (scan.ref == 1) {
                            copy = scan;
                        } else {
                            copy = scan.copy();
                            scan.decRefCount();
                        }
                        if (newTail == null) {
                            newHead = copy;
                            newTail = copy;
                        } else {
                            newTail.setNext(copy);
                            newTail = copy;
                        }
                        scan = next;
                    }
                }
            }
            this.head = newHead;
            this.tail = newTail;
            if (this.head != null) {
                this.headGeneration = this.head.poGetGeneration();
            }
        }
    }

    public ByteListInputStream getInputStream(int maxLen) {
        if (maxLen > this.length) {
            throw new ArrayIndexOutOfBoundsException(maxLen);
        }
        return ByteListInputStream.getInstance(this, maxLen, true);
    }

    public ByteListInputStream getInputStream() {
        return ByteListInputStream.getInstance(this, this.length, false);
    }

    public ByteListOutputStream getOutputStream() {
        this.copyOnWrite();
        return ByteListOutputStream.getInstance(this);
    }

    public int getLength() {
        return this.length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getBlockCount(int max) {
        int c = 0;
        int n = 0;
        ByteList byteList = this;
        synchronized (byteList) {
            if (this.tail != null) {
                ByteBlock byteBlock = this.tail;
                synchronized (byteBlock) {
                    for (ByteBlock scan = this.head; scan != null; scan = scan.getNext()) {
                        int sz = scan.length - scan.start;
                        if (n == 0) {
                            if ((n += sz) <= max) continue;
                            ++c;
                            n = 0;
                            continue;
                        }
                        if (n + sz > max) {
                            ++c;
                            n = sz;
                            continue;
                        }
                        n += sz;
                    }
                }
            }
        }
        if (n > 0) {
            ++c;
        }
        return c;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ByteList extractBlock(int max) {
        ByteList list = null;
        this.copyOnWrite();
        ByteList byteList = this;
        synchronized (byteList) {
            ByteBlock first = this.head;
            ByteBlock last = null;
            ByteBlock blk = this.head.getNext();
            ByteBlock prev = this.head;
            int size = first.length - first.start;
            if (this.tail != null) {
                ByteBlock byteBlock = this.tail;
                synchronized (byteBlock) {
                    while (last == null) {
                        if (blk == null) {
                            last = prev;
                            continue;
                        }
                        if (size + blk.length - blk.start > max) {
                            last = prev;
                            blk = blk.getNext();
                            continue;
                        }
                        size += blk.length - blk.start;
                        prev = blk;
                        blk = blk.getNext();
                    }
                }
            }
            this.head = last.getNext();
            last.setNext(null);
            this.length -= size;
            list = ByteList.getInstance(first, last);
            if (this.doTrace) {
                ByteList.logRelation(this, list, "extractBlock");
            }
            if (this.head == null) {
                this.tail = null;
            } else {
                this.headGeneration = this.head.poGetGeneration();
            }
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isValid() {
        boolean valid;
        ByteList byteList = this;
        synchronized (byteList) {
            valid = this.head != null;
        }
        return valid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isShared() {
        boolean shared;
        ByteList byteList = this;
        synchronized (byteList) {
            shared = this.head != null && this.tail.ref > 1;
        }
        return shared;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        if (this.doValidate) {
            this.validate(this.poGeneration);
        }
        ByteList byteList = this;
        synchronized (byteList) {
            if (this.tail != null) {
                ByteBlock byteBlock = this.tail;
                synchronized (byteBlock) {
                    while (this.head != null) {
                        ByteBlock curr = this.head;
                        this.head = curr.getNext();
                        curr.decRefCount();
                    }
                }
            }
            this.tail = null;
        }
        if (this.doValidate) {
            this.lastDispose = new RuntimeException("Last dispose of ByteList");
            this.disposeGeneration = this.poGeneration;
        }
        if (this.doTrace) {
            ByteList.logInstance(this, "dispose");
        }
        super.dispose();
    }

    int read(int at) throws IOException {
        int blkOff = this.setLast(at);
        int value = 0;
        return value |= this.lastBlock.data[blkOff + this.lastBlock.start] & 0xFF;
    }

    int read(int at, byte[] buf, int off, int len) throws IOException {
        int nBytes = 0;
        int blkOff = this.setLast(at);
        int avail = this.length - at;
        if (avail == 0) {
            return -1;
        }
        if (len == 0) {
            return 0;
        }
        while (len > 0 && avail > 0) {
            int n = Math.min(avail, len);
            int blkLen = this.lastBlock.length - this.lastBlock.start;
            int blkLeft = blkLen - blkOff;
            n = Math.min(n, blkLeft);
            System.arraycopy(this.lastBlock.data, this.lastBlock.start + blkOff, buf, off, n);
            avail -= n;
            off += n;
            len -= n;
            nBytes += n;
            if ((blkOff += n) != blkLen) continue;
            this.lastIndex += blkLen;
            this.lastBlock = this.lastBlock.getNext();
            blkOff = 0;
            if (this.lastBlock != null || len <= 0) continue;
            return nBytes;
        }
        if (nBytes == 0) {
            return -1;
        }
        return nBytes;
    }

    private int setLast(int at) throws IOException {
        int size;
        if (this.doValidate && !this.isValid()) {
            throw new IOException("Read from invalid ByteList");
        }
        int blkOff = 0;
        ByteBlock scan = this.head;
        if (this.lastBlock != null) {
            size = this.lastBlock.length - this.lastBlock.start;
            blkOff = at - this.lastIndex;
            if (blkOff < 0) {
                this.lastBlock = null;
                this.lastIndex = 0;
                blkOff = at;
            } else if (blkOff >= size) {
                scan = this.lastBlock.getNext();
                this.lastIndex += size;
                blkOff -= size;
                this.lastBlock = null;
            }
        } else {
            this.lastIndex = 0;
        }
        if (this.lastBlock == null) {
            while (scan != null) {
                size = scan.length - scan.start;
                if (blkOff < size) {
                    this.lastBlock = scan;
                    break;
                }
                this.lastIndex += size;
                blkOff -= size;
                scan = scan.getNext();
            }
            if (this.lastBlock == null) {
                throw new EOFException();
            }
        }
        return blkOff;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void write(int v) throws IOException {
        ByteList byteList = this;
        synchronized (byteList) {
            int avail;
            if (this.doValidate) {
                if (!this.isValid()) {
                    throw new IOException("Write to invalid ByteList");
                }
                if (this.pool == null) {
                    throw new IOException("Write to read-only ByteList");
                }
                if (this.isShared()) {
                    throw new IOException("Write to shared ByteList");
                }
            }
            if ((avail = this.tail.data.length - this.tail.length) == 0) {
                ByteBlock blk = this.pool != null ? (ByteBlock)this.pool.alloc() : (ByteBlock)this.tail.dup();
                avail = blk.data.length;
                this.tail.setNext(blk);
                this.tail = blk;
            }
            short s = this.tail.length;
            this.tail.length = (short)(s + 1);
            this.tail.data[s] = (byte)v;
            ++this.length;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void write(byte[] buf, int off, int len) throws IOException {
        ByteList byteList = this;
        synchronized (byteList) {
            if (this.doValidate) {
                if (!this.isValid()) {
                    throw new IOException("Write to invalid ByteList");
                }
                if (this.pool == null) {
                    throw new IOException("Write to read-only ByteList");
                }
                if (this.isShared()) {
                    throw new IOException("Write to shared ByteList");
                }
            }
            while (len > 0) {
                int avail = this.tail.data.length - this.tail.length;
                if (avail == 0) {
                    ByteBlock blk = (ByteBlock)this.pool.alloc();
                    avail = blk.data.length;
                    this.tail.setNext(blk);
                    this.tail = blk;
                }
                avail = Math.min(avail, len);
                System.arraycopy(buf, off, this.tail.data, this.tail.length, avail);
                this.tail.length = (short)(this.tail.length + avail);
                off += avail;
                len -= avail;
                this.length += avail;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void consume(int len) {
        ByteList byteList = this;
        synchronized (byteList) {
            if (len > this.length) {
                throw new ArrayIndexOutOfBoundsException(len);
            }
            while (len > 0) {
                int size = this.head.length - this.head.start;
                ByteBlock byteBlock = this.tail;
                synchronized (byteBlock) {
                    if (size <= len) {
                        ByteBlock blk = this.head;
                        this.head = blk.getNext();
                        this.headGeneration = this.head == null ? -1L : this.head.poGetGeneration();
                        len -= size;
                        this.length -= size;
                        blk.decRefCount();
                        if (this.head == null) {
                            this.tail = null;
                        }
                    } else {
                        if (this.head.ref > 1) {
                            ByteBlock newHead = this.head.copy();
                            newHead.setNext(this.head.getNext());
                            this.head.decRefCount();
                            this.head = newHead;
                            this.headGeneration = this.head == null ? -1L : this.head.poGetGeneration();
                        }
                        this.head.start = (short)(this.head.start + len);
                        this.length -= len;
                        len = 0;
                    }
                }
            }
            this.lastBlock = null;
        }
    }

    public void writeTo(DataOutput str) throws IOException {
        for (ByteBlock scan = this.head; scan != null; scan = scan.getNext()) {
            str.write(scan.data, scan.start, scan.length - scan.start);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean writeTo(AsyncEndpoint ep, ProtocolIOListener lst) throws IOException {
        boolean wouldBlock = false;
        ByteList byteList = this;
        synchronized (byteList) {
            this.writing = this.head;
            this.writeListener = lst;
            while (this.writing != null) {
                if (ep.beginWriteFully(this.writing.data, (int)this.writing.start, (int)this.writing.length, (AsyncIOListener)this)) {
                    this.writing = this.writing.getNext();
                    continue;
                }
                wouldBlock = true;
                break;
            }
            if (!wouldBlock) {
                this.writeListener = null;
            }
        }
        return !wouldBlock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readFrom(DataInput str, int len) throws IOException {
        this.copyOnWrite();
        ByteList byteList = this;
        synchronized (byteList) {
            while (len > 0) {
                int avail = this.tail.data.length - this.tail.length;
                if (avail == 0) {
                    ByteBlock blk = (ByteBlock)this.pool.alloc();
                    this.tail.setNext(blk);
                    this.tail = blk;
                    avail = blk.data.length;
                }
                int nRead = Math.min(avail, len);
                str.readFully(this.tail.data, this.tail.length, nRead);
                this.tail.length = (short)(this.tail.length + nRead);
                this.length += nRead;
                len -= nRead;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean readFrom(AsyncEndpoint ep, int len, ProtocolIOListener lst) throws IOException {
        this.copyOnWrite();
        ByteList byteList = this;
        synchronized (byteList) {
            this.readLen = len;
            this.readListener = lst;
            while (this.readLen > 0) {
                int n;
                int avail = this.tail.data.length - this.tail.length;
                if (avail == 0) {
                    ByteBlock blk = (ByteBlock)this.pool.alloc();
                    this.tail.setNext(blk);
                    this.tail = blk;
                    avail = blk.data.length;
                }
                if (ep.beginReadFully(this.tail.data, (int)this.tail.length, n = Math.min(avail, this.readLen), (AsyncIOListener)this)) {
                    this.tail.length = (short)(this.tail.length + n);
                    this.length += n;
                    this.readLen -= n;
                    continue;
                }
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readComplete(AsyncIORequest req) {
        ProtocolIOListener l = null;
        AsyncEndpoint ep = null;
        try {
            ByteList byteList = this;
            synchronized (byteList) {
                l = this.readListener;
                ep = req.getOwner();
                int n = req.finishRequest();
                do {
                    this.tail.length = (short)(this.tail.length + n);
                    this.length += n;
                    this.readLen -= n;
                    int avail = this.tail.data.length - this.tail.length;
                    if (this.readLen > 0 && avail == 0) {
                        ByteBlock blk = (ByteBlock)this.pool.alloc();
                        this.tail.setNext(blk);
                        this.tail = blk;
                        avail = blk.data.length;
                    }
                    if (ep.beginReadFully(this.tail.data, (int)this.tail.length, n = Math.min(avail, this.readLen), (AsyncIOListener)this)) {
                        this.tail.length = (short)(this.tail.length + n);
                        this.length += n;
                        this.readLen -= n;
                        continue;
                    }
                    return;
                } while (this.readLen > 0);
                this.readListener = null;
            }
            l.protocolReadComplete(null);
        }
        catch (IOException iox) {
            ByteList byteList = this;
            synchronized (byteList) {
                this.readListener = null;
            }
            l.protocolReadComplete(iox);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeComplete(AsyncIORequest req) {
        ProtocolIOListener l = null;
        AsyncEndpoint ep = null;
        try {
            ByteList byteList = this;
            synchronized (byteList) {
                l = this.writeListener;
                ep = req.getOwner();
                req.finishRequest();
                do {
                    this.writing = this.writing.getNext();
                } while (this.writing != null && ep.beginWriteFully(this.writing.data, (int)this.writing.start, (int)this.writing.length, (AsyncIOListener)this));
                if (this.writing == null) {
                    this.writeListener = null;
                }
            }
            if (this.writing == null) {
                l.protocolWriteComplete(null);
            }
        }
        catch (IOException iox) {
            ByteList byteList = this;
            synchronized (byteList) {
                this.writeListener = null;
            }
            l.protocolWriteComplete(iox);
        }
    }

    public void connectComplete(AsyncIORequest req) {
        throw new UnsupportedOperationException();
    }

    public void closeComplete(AsyncIORequest req) {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("ByteList[");
        buf.append(this.length);
        buf.append(" bytes(");
        for (ByteBlock blk = this.head; blk != null; blk = blk.getNext()) {
            buf.append("<");
            if (blk.start != 0) {
                buf.append(blk.start);
                buf.append(":");
            }
            buf.append(blk.length);
            buf.append("/");
            buf.append(blk.data.length);
            buf.append(">");
        }
        buf.append(")]");
        return buf.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void logInstance(ByteList inst, String method) {
        Class<ByteList> clazz = ByteList.class;
        synchronized (ByteList.class) {
            LogSupport.exception((Object)inst, (String)method, (Throwable)new RuntimeException("(" + System.identityHashCode(inst) + "," + inst.poGeneration + ")"), (boolean)true);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void logRelation(ByteList src, ByteList dst, String method) {
        Class<ByteList> clazz = ByteList.class;
        synchronized (ByteList.class) {
            LogSupport.message((Object)src, (String)method, (String)("(" + System.identityHashCode(src) + "," + src.poGeneration + ") ==> (" + System.identityHashCode(dst) + "," + dst.poGeneration + ")"));
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validate(long count) {
        if (!this.doValidate) {
            return;
        }
        if (this.poDisposed || count != this.poGeneration) {
            RuntimeException reusedEx = new RuntimeException("ByteList used after dispose.");
            Class<ByteList> clazz = ByteList.class;
            synchronized (ByteList.class) {
                String pfx = "(" + System.identityHashCode(this) + ",";
                String sfx = this.poDisposed ? ",disposed)" : ")";
                LogSupport.exception((Object)this, (String)"validate", (Throwable)reusedEx, (boolean)true, (String)(pfx + this.poGeneration + sfx));
                if (this.lastDispose != null) {
                    LogSupport.exception((Object)this, (String)"validate", (Throwable)this.lastDispose, (boolean)true, (String)(pfx + this.disposeGeneration + ")"));
                } else {
                    LogSupport.error((Object)this, (String)"validate", (String)(pfx + this.disposeGeneration + ")"));
                }
                // ** MonitorExit[var4_4] (shouldn't be in output)
                throw reusedEx;
            }
        }
        ByteList byteList = this;
        synchronized (byteList) {
            if (this.tail != null) {
                ByteBlock byteBlock = this.tail;
                synchronized (byteBlock) {
                    this.head.validate(this.headGeneration, 1, 1);
                }
            }
        }
    }
}

