/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.jinx;

import com.elluminate.jinx.PooledRunnable;
import com.elluminate.util.ObjectPool;
import com.elluminate.util.log.LogSupport;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public class Appointment
extends PooledRunnable {
    private static ObjectPool pool = ObjectPool.getInstance(Appointment.class);
    static AtomicLong delta = new AtomicLong(0L);
    static AtomicInteger count = new AtomicInteger(0);
    static volatile long min = 0L;
    static volatile long max = 0L;
    private Runnable r = null;
    private long t = -1L;

    public void poCleanup() {
        this.r = null;
        this.t = -1L;
    }

    private void init(Runnable run, long time) {
        this.r = run;
        this.t = time;
        count.getAndIncrement();
    }

    public long getSchedule() {
        return this.t;
    }

    @Override
    public void run() {
        long now = System.currentTimeMillis();
        long d = now - this.t;
        delta.getAndAdd(d);
        if (d > max) {
            max = d;
        }
        if (d < min) {
            min = d;
        }
        try {
            this.r.run();
        }
        catch (Throwable t) {
            LogSupport.exception((Object)this, (String)"run", (Throwable)t, (boolean)true);
        }
        this.dispose();
    }

    public static Appointment getInstance(Runnable r, long t) {
        Appointment a = (Appointment)pool.alloc();
        a.init(r, t);
        return a;
    }

    public static long getDelta() {
        return delta.get();
    }

    public static int getCount() {
        return count.get();
    }

    public static long getMin() {
        return min;
    }

    public static long getMax() {
        return max;
    }

    public static void clearStats() {
        delta.set(0L);
        count.set(0);
        min = 0L;
        max = 0L;
    }
}

