/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.framework.session.listener;

import com.elluminate.framework.session.CRParticipant;
import com.elluminate.framework.session.CRRoom;
import com.elluminate.framework.session.CRSessionDebug;
import com.elluminate.framework.session.listener.CRParticipantListener;
import com.elluminate.framework.session.listener.event.CRParticipantEvent;
import com.elluminate.util.log.LogSupport;
import java.util.Iterator;

public class CRParticipantDebug
implements CRParticipantListener {
    @Override
    public void onParticipantAdded(CRParticipantEvent event) {
        if (CRSessionDebug.INFO.isEnabled()) {
            LogSupport.message((Object)this, (String)"onParticipantAdded", (String)("participant added: " + event));
        }
    }

    @Override
    public void onParticipantRemoved(CRParticipantEvent event) {
        if (CRSessionDebug.INFO.isEnabled()) {
            LogSupport.message((Object)this, (String)"onParticipantRemoved", (String)("participant removed: " + event));
        }
    }

    @Override
    public void onParticipantRenamed(CRParticipantEvent event) {
        if (CRSessionDebug.INFO.isEnabled()) {
            LogSupport.message((Object)this, (String)"onParticipantRenamed", (String)("participant renamed: " + event));
        }
    }

    @Override
    public void onParticipantJoinedRoom(CRParticipantEvent event) {
        if (CRSessionDebug.INFO.isEnabled()) {
            LogSupport.message((Object)this, (String)"onParticipantJoined", (String)("participant joined: " + event));
            this.showParticipantList(event);
        }
    }

    @Override
    public void onParticipantLeftRoom(CRParticipantEvent event) {
        if (CRSessionDebug.INFO.isEnabled()) {
            LogSupport.message((Object)this, (String)"onParticipantLeft", (String)("participant left: " + event));
            this.showParticipantList(event);
        }
    }

    @Override
    public void onMeAdded(CRParticipantEvent event) {
        if (CRSessionDebug.INFO.isEnabled()) {
            LogSupport.message((Object)this, (String)"onMeAdded", (String)("me added: " + event));
            this.showParticipantList(event);
        }
    }

    @Override
    public void onMeRemoved(CRParticipantEvent event) {
        if (CRSessionDebug.INFO.isEnabled()) {
            LogSupport.message((Object)this, (String)"onMeRemoved", (String)("me removed: " + event));
            this.showParticipantList(event);
        }
    }

    private void showParticipantList(CRParticipantEvent event) {
        CRRoom room = event.getRoom();
        Iterator<CRParticipant> itr = room.getParticipantIterator();
        while (itr.hasNext()) {
            LogSupport.message((String)itr.next().toString());
        }
    }
}

