/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.framework.session;

import com.elluminate.framework.session.CRPermissionDelegate;
import com.elluminate.framework.session.CRPermissionFactory;
import com.elluminate.framework.session.CRPermissionScope;
import java.util.List;

public class CRPermission {
    CRPermissionFactory factory = null;
    CRPermissionDelegate delegate = null;
    public static final short UNDEFINED_ID = -1;
    short id = (short)-1;

    public CRPermission(short id, CRPermissionFactory factory, CRPermissionDelegate delegate) {
        this.id = id;
        this.factory = factory;
        this.delegate = delegate;
    }

    public short getID() {
        return this.id;
    }

    public String getGroup() {
        if (this.factory != null) {
            return this.factory.getGroup();
        }
        return null;
    }

    public String getName() {
        if (this.factory != null) {
            return this.factory.getName();
        }
        return null;
    }

    public CRPermissionScope getScope() {
        if (this.factory != null) {
            return this.factory.getScope();
        }
        return null;
    }

    public boolean getValue() {
        if (this.delegate != null) {
            return this.delegate.getValue(this.id);
        }
        return false;
    }

    public void setValue(boolean value) {
        if (this.delegate != null) {
            this.delegate.setValue(this, value);
        }
    }

    public void setValue(List<CRPermission> permissions, boolean value) {
        if (this.delegate != null && permissions != null && permissions.size() > 0) {
            this.delegate.setValue(permissions, value);
        }
    }

    public boolean getDefault() {
        if (this.delegate != null) {
            return this.delegate.getDefault();
        }
        return false;
    }

    public void setDefault(boolean value) {
        if (this.delegate != null) {
            this.delegate.setDefault(this, value);
        }
    }

    public boolean canSet() {
        if (this.delegate != null) {
            return this.delegate.canSet(this.id);
        }
        return false;
    }

    public boolean canSetDefault() {
        if (this.delegate != null) {
            return this.delegate.canSetDefault(this.id);
        }
        return false;
    }

    public String getPropertyName() {
        if (this.delegate != null) {
            return this.delegate.getPropertyName();
        }
        return null;
    }

    public boolean globalPermissionSupported() {
        if (this.delegate != null) {
            return this.delegate.globalPermissionSupported();
        }
        return Boolean.FALSE;
    }

    public String toString() {
        String descStr = "[CRPermission: ";
        if (this.getID() == -1) {
            descStr = descStr + "UNDEFINED]";
            return descStr;
        }
        descStr = descStr + "ID=" + this.getID();
        if (this.factory == null) {
            descStr = descStr + ", NO FACTORY DEFINED]";
            return descStr;
        }
        descStr = descStr + ", group=" + this.getGroup() + ", name=" + this.getName() + ", scope=" + (Object)((Object)this.getScope());
        if (this.delegate == null) {
            descStr = descStr + ", NO DELEGATE DEFINED]";
            return descStr;
        }
        descStr = descStr + ", value=" + this.getValue() + ", default=" + this.getDefault() + ", canSet=" + this.canSet() + ", canSetDefault=" + this.canSetDefault() + "]";
        return descStr;
    }
}

