/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.framework.session;

import com.elluminate.framework.session.CRAnnotation;
import com.elluminate.framework.session.listener.CRAnnotationChangeListener;
import com.elluminate.framework.session.listener.event.CRAnnotationChangeEvent;
import com.elluminate.util.event.FiringFunctor;
import com.elluminate.util.event.ListenerRegistry;
import com.google.inject.Inject;

public class CRAnnotationFactory {
    private String name = null;
    private Object defaultValue = null;
    private ListenerRegistry<CRAnnotationChangeListener> annotationListenerRegistry = null;

    @Inject
    protected void initAnnotationListenerRegistry(ListenerRegistry<CRAnnotationChangeListener> registry) {
        this.annotationListenerRegistry = registry;
    }

    void init(String name, Object defaultValue) {
        this.name = name;
        this.defaultValue = defaultValue;
    }

    synchronized void addListener(CRAnnotationChangeListener listener) {
        if (listener != null) {
            this.annotationListenerRegistry.add((Object)listener);
        }
    }

    synchronized void removeListener(CRAnnotationChangeListener listener) {
        if (listener != null) {
            this.annotationListenerRegistry.remove((Object)listener);
        }
    }

    void fireAnnotationEvent(final CRAnnotationChangeEvent event) {
        FiringFunctor<CRAnnotationChangeListener> ff = null;
        ff = new FiringFunctor<CRAnnotationChangeListener>(){

            public void fire(CRAnnotationChangeListener listener) {
                listener.onAnnotationValueChange(event);
            }
        };
        if (ff != null) {
            this.annotationListenerRegistry.fire((FiringFunctor)ff);
        }
    }

    public CRAnnotation getAnnotationInstance(short id) {
        return new CRAnnotation(id, this);
    }

    public String getName() {
        return this.name;
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }
}

