/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.framework.session;

import com.elluminate.framework.session.CRParticipant;
import com.elluminate.framework.session.CRPermission;
import com.elluminate.framework.session.CRPermissionDelegate;
import com.elluminate.framework.session.CRSession;
import com.elluminate.framework.session.CRSessionDebug;
import com.elluminate.framework.session.listener.CRPermissionChangeListener;
import com.elluminate.framework.session.listener.event.CRPermissionChangeEvent;
import com.elluminate.framework.session.listener.event.CRPermissionChangeEventType;
import com.elluminate.jinx.Client;
import com.elluminate.jinx.ClientInfo;
import com.elluminate.jinx.PropertyValue;
import com.elluminate.jinx.provider.ClientProvider;
import com.elluminate.util.event.FiringFunctor;
import com.elluminate.util.event.ListenerRegistry;
import com.elluminate.util.log.LogSupport;
import com.google.inject.Inject;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;

public abstract class CRAbstractPermissionDelegate
implements CRPermissionDelegate,
PropertyChangeListener {
    private ListenerRegistry<CRPermissionChangeListener> listenerRegistry;
    private ClientProvider clientProvider;
    private CRSession session;

    protected abstract String getPermissionName();

    @Inject
    protected void initListenerRegistry(ListenerRegistry<CRPermissionChangeListener> listenerRegistry) {
        this.listenerRegistry = listenerRegistry;
    }

    public ClientProvider getClientProvider() {
        return this.clientProvider;
    }

    public void setClientProvider(ClientProvider clientProvider) {
        this.clientProvider = clientProvider;
    }

    public CRSession getSession() {
        return this.session;
    }

    public void setSession(CRSession session) {
        this.session = session;
    }

    private Client getClient() {
        return this.clientProvider != null ? this.clientProvider.get() : null;
    }

    private CRParticipant getMe() {
        return this.session != null ? this.session.getMe() : null;
    }

    @Override
    public void addListener(CRPermissionChangeListener listener) {
        this.listenerRegistry.add((Object)listener);
    }

    @Override
    public void removeListener(CRPermissionChangeListener listener) {
        this.listenerRegistry.remove((Object)listener);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.propertyChange(evt, this.getPropertyName());
    }

    private void propertyChange(PropertyChangeEvent evt, String propName) {
        boolean isDefaultPermissionChanged;
        String propertyName = evt.getPropertyName();
        Object source = evt.getSource();
        boolean bl = isDefaultPermissionChanged = this.getClient() != null ? this.getClient().getClientList().isDefaultPropertyValue(source) : false;
        if (CRSessionDebug.PERMISSION_DELEGATE.show()) {
            LogSupport.message((Object)this, (String)"propertyChange", (String)("propName = " + propName + " isDefaultPermissionChanged = " + isDefaultPermissionChanged));
        }
        if (propertyName.equals(propName)) {
            Boolean oldValue = (Boolean)evt.getOldValue();
            Boolean newValue = (Boolean)evt.getNewValue();
            if (CRSessionDebug.PERMISSION_DELEGATE.show()) {
                LogSupport.message((Object)this, (String)"propertyChange", (String)("source = " + source + "\noldValue = " + oldValue + "\nnewValue = " + newValue));
            }
            if (newValue == null) {
                return;
            }
            CRPermission permission = null;
            if (source instanceof ClientInfo) {
                permission = this.session.getPermission(this.getPermissionName(), ((ClientInfo)source).getAddress());
            } else if (isDefaultPermissionChanged) {
                permission = this.session.getPermission(this.getPermissionName(), (short)0);
            }
            if (CRSessionDebug.PERMISSION_DELEGATE.show()) {
                LogSupport.message((Object)this, (String)"propertyChange", (String)("permission = " + permission));
            }
            if ((oldValue == null || oldValue.booleanValue()) && !newValue.booleanValue() && permission != null) {
                this.firePermissionChanged(permission, Boolean.TRUE, Boolean.FALSE, isDefaultPermissionChanged);
            }
            if ((oldValue == null || !oldValue.booleanValue()) && newValue.booleanValue() && permission != null) {
                this.firePermissionChanged(permission, Boolean.FALSE, Boolean.TRUE, isDefaultPermissionChanged);
            }
        }
    }

    private void firePermissionChanged(CRPermission permission, boolean oldValue, boolean value, boolean isDefaultPermissionChanged) {
        CRPermissionChangeEvent event = null;
        if (!oldValue && value) {
            event = new CRPermissionChangeEvent(permission, CRPermissionChangeEventType.FALSE_TO_TRUE);
        } else if (oldValue && !value) {
            event = new CRPermissionChangeEvent(permission, CRPermissionChangeEventType.TRUE_TO_FALSE);
        } else {
            return;
        }
        this.firePermissionChanged(event, isDefaultPermissionChanged);
    }

    private void firePermissionChanged(final CRPermissionChangeEvent event, final boolean isDefaultPermissionChanged) {
        FiringFunctor<CRPermissionChangeListener> ff = null;
        ff = new FiringFunctor<CRPermissionChangeListener>(){

            public void fire(CRPermissionChangeListener listener) {
                if (CRSessionDebug.PERMISSION_DELEGATE.show()) {
                    LogSupport.message((Object)this, (String)"firePermissionChanged", (String)("listener = " + listener));
                }
                if (isDefaultPermissionChanged) {
                    listener.onPermissionDefaultChange(event);
                } else {
                    listener.onPermissionValueChange(event);
                }
            }
        };
        this.listenerRegistry.fire((FiringFunctor)ff);
    }

    @Override
    public boolean getValue(short id) {
        boolean currValue = false;
        if (this.isInitialized()) {
            ClientInfo who = this.getClient().getClientList().get(id);
            if (CRSessionDebug.PERMISSION_DELEGATE.show()) {
                LogSupport.message((Object)this, (String)"getValue", (String)("who = " + who));
            }
            if (who != null) {
                Boolean value = (Boolean)who.getProperty(this.getPropertyName());
                boolean bl = currValue = value != null ? value.booleanValue() : this.getDefault();
            }
        }
        if (CRSessionDebug.PERMISSION_DELEGATE.show()) {
            LogSupport.message((Object)this, (String)"getValue", (String)("return[" + this.getPropertyName() + "] = " + currValue));
        }
        return currValue;
    }

    @Override
    public void setValue(CRPermission permission, boolean newValue) {
        ClientInfo who;
        if (CRSessionDebug.PERMISSION_DELEGATE.show()) {
            LogSupport.message((Object)this, (String)"setValue", (String)(permission + "=" + newValue));
        }
        if (permission != null && this.canMeSet() && (who = this.getClient().getClientList().get(permission.getID())) != null) {
            Boolean oldValue = (Boolean)who.getProperty(this.getPropertyName());
            if (CRSessionDebug.PERMISSION_DELEGATE.show()) {
                LogSupport.message((Object)this, (String)"setValue", (String)(oldValue + "->" + newValue));
            }
            if (oldValue == null || oldValue != newValue) {
                who.setProperty(this.getPropertyName(), newValue);
            }
        }
    }

    @Override
    public void setValue(List<CRPermission> permissions, boolean newValue) {
        if (CRSessionDebug.PERMISSION_DELEGATE.show()) {
            LogSupport.message((Object)this, (String)"setValue", (String)("permissions.size = " + (permissions != null ? permissions.size() : 0) + " " + newValue));
        }
        if (this.canMeSet() && permissions != null) {
            for (CRPermission p : permissions) {
                this.setValue(p, newValue);
            }
        }
    }

    @Override
    public boolean getDefault() {
        boolean currValue = Boolean.FALSE;
        if (this.isInitialized()) {
            Boolean value = currValue;
            try {
                value = (Boolean)this.getClient().getClientList().getClientPropertyDefault(this.getPropertyName());
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (value == null && this.canMeSet()) {
                this.getClient().getClientList().setClientPropertyDefault(this.getPropertyName(), new PropertyValue(Boolean.valueOf(currValue)));
                if (CRSessionDebug.PERMISSION_DELEGATE.show()) {
                    LogSupport.message((Object)this, (String)"getDefault", (String)("set[" + this.getPropertyName() + "] = " + currValue));
                }
            }
            boolean bl = currValue = value != null ? value : currValue;
        }
        if (CRSessionDebug.PERMISSION_DELEGATE.show()) {
            LogSupport.message((Object)this, (String)"getDefault", (String)("return[" + this.getPropertyName() + "] = " + currValue));
        }
        return currValue;
    }

    @Override
    public void setDefault(CRPermission permission, boolean newValue) {
        if (CRSessionDebug.PERMISSION_DELEGATE.show()) {
            LogSupport.message((Object)this, (String)"setDefault", (String)(permission + "=" + newValue));
        }
        if (permission != null && this.canMeSet()) {
            Boolean oldValue = (Boolean)this.getClient().getClientList().getClientPropertyDefault(this.getPropertyName());
            if (CRSessionDebug.PERMISSION_DELEGATE.show()) {
                LogSupport.message((Object)this, (String)"setDefault", (String)(oldValue + "->" + newValue));
            }
            if (oldValue == null || oldValue != newValue) {
                this.getClient().getClientList().setClientPropertyDefault(this.getPropertyName(), new PropertyValue(Boolean.valueOf(newValue)));
            }
        }
    }

    @Override
    public boolean canSet(short id) {
        return this.canMeSet();
    }

    @Override
    public boolean canSetDefault(short id) {
        return this.canMeSet();
    }

    private boolean canMeSet() {
        CRParticipant me = this.getMe();
        boolean canSet = this.isInitialized();
        canSet = me != null ? me.isChair() : true;
        return canSet;
    }

    protected boolean isInitialized() {
        return this.getClient() != null && this.getClient().isConnected();
    }

    @Override
    public boolean globalPermissionSupported() {
        return Boolean.TRUE;
    }
}

