/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.chair.module;

import com.elluminate.groupware.chair.ChairDebug;
import com.elluminate.groupware.module.JinxTerminal;
import com.elluminate.gui.swing.DialogParentProvider;
import com.elluminate.jinx.ChannelDataEvent;
import com.elluminate.jinx.ChannelDataListener;
import com.elluminate.jinx.ChannelListener;
import com.elluminate.jinx.Client;
import com.elluminate.jinx.ClientEvent;
import com.elluminate.jinx.ClientList;
import com.elluminate.jinx.ClientListener;
import com.elluminate.jinx.JinxProtocol;
import com.elluminate.jinx.provider.ClientProvider;
import com.elluminate.util.log.Logger;
import com.google.inject.Inject;
import java.awt.Frame;
import java.beans.PropertyChangeListener;

public abstract class BasicBean
implements ClientListener {
    protected ClientProvider clientProvider;
    protected JinxTerminal terminal;
    private DialogParentProvider parentProvider;
    protected Client client;
    protected ClientList clients;
    protected Logger logger;

    @Inject
    protected BasicBean(Logger logger) {
        this.logger = logger;
    }

    @Inject
    protected void initClientProvider(ClientProvider clientProvider) {
        this.clientProvider = clientProvider;
    }

    @Inject
    protected void initJinxTerminal(JinxTerminal terminal) {
        if (ChairDebug.TRACE.show()) {
            this.logger.message((Object)this, "initJinxTerminal", "jinx terminal: " + terminal);
        }
        this.terminal = terminal;
    }

    @Inject
    protected void initModularAppProvider(DialogParentProvider dpp) {
        this.parentProvider = dpp;
    }

    protected final Frame getAppFrame() {
        return this.parentProvider.getDialogParent();
    }

    protected void setClient(Client theClient, JinxProtocol proto, ChannelListener cLst, ChannelDataListener dLst, PropertyChangeListener pLst) {
        this.changeClient(theClient);
        this.terminal.setProtocolAndListeners(proto, cLst, dLst, pLst);
    }

    private void changeClient(Client theClient) {
        if (this.client == theClient) {
            return;
        }
        if (this.clients != null) {
            this.clients.removeClientListener((ClientListener)this);
        }
        this.client = theClient;
        this.clients = this.client == null ? null : this.client.getClientList();
        this.terminal.setClient(theClient);
        if (this.clients != null) {
            this.clients.addClientListener((ClientListener)this);
        }
    }

    public void onAddClient(ClientEvent event) {
    }

    public void onRemoveClient(ClientEvent event) {
    }

    public void fireChannelData(ChannelDataEvent anEvent) {
        this.fireChannelData(0, anEvent, true, (byte)0);
    }

    public void fireChannelData(int which, ChannelDataEvent anEvent) {
        this.fireChannelData(which, anEvent, true, (byte)0);
    }

    public void fireChannelData(ChannelDataEvent e, boolean catchExceptions) {
        this.fireChannelData(0, e, catchExceptions, (byte)0);
    }

    public void fireChannelData(int which, ChannelDataEvent e, boolean catchExceptions) {
        this.fireChannelData(which, e, catchExceptions, (byte)0);
    }

    public void fireChannelData(int which, ChannelDataEvent e, boolean catchExceptions, byte urgency) {
        this.terminal.fireChannelData(which, e, catchExceptions, urgency);
    }
}

