/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.transfer;

import com.elluminate.groupware.transfer.ResponderTransferLibrary;
import com.elluminate.groupware.transfer.TransferProtocol;
import com.elluminate.jinx.Channel;
import com.elluminate.jinx.ChannelDataListener;
import com.elluminate.jinx.ChannelEvent;
import com.elluminate.jinx.ChannelListener;
import com.elluminate.jinx.Connection;
import com.elluminate.jinx.JinxChannelException;
import com.elluminate.jinx.JinxProtocol;
import com.elluminate.jinx.NotableEventListener;
import com.elluminate.jinx.ProtocolResponder;
import com.elluminate.util.log.LogSupport;
import com.google.inject.Inject;
import java.util.HashMap;

public class TransferResponder
implements ProtocolResponder {
    private Connection client = null;
    private HashMap contexts = new HashMap();
    private ResponderTransferLibrary lib;
    private TransferProtocol transferProtocol;

    @Inject
    public void initTransferProtocol(TransferProtocol transferProtocol) {
        this.transferProtocol = transferProtocol;
    }

    @Inject
    public void initResponderTransferLibrary(ResponderTransferLibrary lib) {
        this.lib = lib;
    }

    public void join(Connection connection, String channel) {
        if (this.contexts.containsKey(channel)) {
            return;
        }
        this.contexts.put(channel, new Context(connection, channel));
    }

    public void leave(String channel) {
        Context c = (Context)this.contexts.remove(channel);
        if (c != null) {
            c.shutdown();
        }
    }

    public void addNotableEventListener(NotableEventListener l) {
    }

    public void removeNotableEventListener(NotableEventListener l) {
    }

    class Context
    implements ChannelListener {
        Connection client;
        Channel chnl;

        public Context(Connection connection, String channel) {
            this.client = connection;
            try {
                this.chnl = connection.acquireChannel(channel, (byte)2, (ChannelListener)this, (ChannelDataListener)TransferResponder.this.lib);
            }
            catch (JinxChannelException ex) {
                LogSupport.exception((Object)this, (String)"<init>", (Throwable)ex, (boolean)true);
                return;
            }
            this.chnl.setProtocol((JinxProtocol)TransferResponder.this.transferProtocol);
            TransferResponder.this.lib.setChannel(this.chnl);
        }

        public void channelStateChanged(ChannelEvent e) {
            switch (e.getState()) {
                case 1: {
                    TransferResponder.this.lib.addProxy((short)0);
                    break;
                }
                case 2: {
                    TransferResponder.this.lib.removeProxy((short)0);
                    break;
                }
            }
        }

        public void shutdown() {
            TransferResponder.this.lib.setChannel(null);
            this.client.releaseChannel(this.chnl);
            this.chnl = null;
        }
    }
}

