/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.transfer;

import com.elluminate.groupware.imps.filetransfer.FileTransferException;
import com.elluminate.groupware.imps.filetransfer.FileTransferItem;
import com.elluminate.groupware.imps.filetransfer.FileTransferListener;
import com.elluminate.groupware.imps.filetransfer.FileTransferRequestListener;
import com.elluminate.groupware.transfer.StreamProxy;
import com.elluminate.groupware.transfer.TransferLibraryEntry;
import com.elluminate.groupware.transfer.Urgency;
import com.elluminate.jinx.Channel;
import com.elluminate.jinx.ChannelDataEvent;
import com.elluminate.jinx.ChannelDataListener;
import com.elluminate.jinx.Connection;
import com.elluminate.jinx.RecvWindow;
import com.elluminate.jinx.RecvWindowListener;
import com.elluminate.jinx.TransmitStatusEvent;
import com.elluminate.jinx.TransmitStatusListener;
import com.elluminate.util.DebugFlag;
import com.elluminate.util.I18n;
import com.elluminate.util.I18nMessage;
import com.elluminate.util.log.LogSupport;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;

public abstract class TransferLibrary
implements ChannelDataListener,
TransmitStatusListener,
Urgency {
    protected static final int WINDOW_SIZE = 32000;
    public static final int NULL_REQUEST = -1;
    protected I18n i18n = I18n.create((Object)this);
    protected Channel channel = null;
    private HashMap entries = new HashMap();
    private int requestID = 1;
    private Object requestLock = new Object();
    private LinkedList listeners = new LinkedList();
    private Object listenerLock = new Object();
    private HashMap requests = new HashMap();
    private DebugFlag logFlag = null;
    protected RecvWindowListener windowListener = new RecvWindowListener(){

        public void sendAck(Object src, Object context) {
            TransferLibrary.this.doSendAck((RecvWindow)src, (TransferLibraryEntry)context);
        }
    };

    public TransferLibrary(Channel chnl) {
        this.channel = chnl;
        this.logFlag = chnl == null ? DebugFlag.get((String)"log.transfer") : DebugFlag.get((String)("log." + chnl.getName()));
    }

    public void setChannel(Channel chnl) {
        this.channel = chnl;
        this.logFlag = chnl == null ? DebugFlag.get((String)"log.transfer") : DebugFlag.get((String)("log." + chnl.getName()));
    }

    public Iterator iterator() {
        return Collections.unmodifiableCollection(this.entries.values()).iterator();
    }

    public Set keys() {
        return new HashSet(this.entries.keySet());
    }

    public TransferLibraryEntry get(int id) {
        return (TransferLibraryEntry)this.entries.get(new Integer(id));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFileTransferListener(FileTransferListener ftl) {
        Object object = this.listenerLock;
        synchronized (object) {
            if (!this.listeners.contains(ftl)) {
                LinkedList nl = (LinkedList)this.listeners.clone();
                nl.add(ftl);
                this.listeners = nl;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFileTransferListener(FileTransferListener ftl) {
        Object object = this.listenerLock;
        synchronized (object) {
            LinkedList nl = (LinkedList)this.listeners.clone();
            nl.remove(ftl);
            this.listeners = nl;
        }
    }

    protected void fireFileAdded(FileTransferItem item) {
        for (FileTransferListener ftl : this.listeners) {
            try {
                ftl.fileAdded(item);
            }
            catch (Throwable t) {
                LogSupport.exception((Object)this, (String)"fireFileAdded", (Throwable)t, (boolean)true);
            }
            if (!this.logFlag.show()) continue;
            String chnl = this.channel != null ? this.channel.getName() : "transfer";
            String owner = item.getOwner();
            owner = owner.equals(" ---") ? "preload" : "\"" + owner + "\"";
            LogSupport.log((String)(item.getName() + "(" + item.getMimeType() + "," + item.getLength() + "b) added to the " + chnl + " library by " + owner));
        }
    }

    protected void fireFileRemoved(FileTransferItem item) {
        for (FileTransferListener ftl : this.listeners) {
            try {
                ftl.fileRemoved(item);
            }
            catch (Throwable t) {
                LogSupport.exception((Object)this, (String)"fireRemoveFile", (Throwable)t, (boolean)true);
            }
        }
    }

    protected void fireFileAttributeChanged(FileTransferItem item, String attr) {
        for (FileTransferListener ftl : this.listeners) {
            try {
                ftl.fileAttributeChanged(item, attr);
            }
            catch (Throwable t) {
                LogSupport.exception((Object)this, (String)"fireFileAttributeChanged", (Throwable)t, (boolean)true);
            }
        }
    }

    protected void fireFileChanged(FileTransferItem item) {
        for (FileTransferListener ftl : this.listeners) {
            try {
                ftl.fileChanged(item);
            }
            catch (Throwable t) {
                LogSupport.exception((Object)this, (String)"fireFileChanged", (Throwable)t, (boolean)true);
            }
        }
    }

    protected void fireTransferError(FileTransferException ex) {
        for (FileTransferListener ftl : this.listeners) {
            try {
                ftl.transferError(ex);
            }
            catch (Throwable t) {
                LogSupport.exception((Object)this, (String)"fireTransferError", (Throwable)t, (boolean)true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void insert(int id, TransferLibraryEntry entry) {
        TransferLibrary transferLibrary = this;
        synchronized (transferLibrary) {
            HashMap newEntries = (HashMap)this.entries.clone();
            newEntries.put(new Integer(id), entry);
            this.entries = newEntries;
        }
        this.fireFileAdded(entry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected TransferLibraryEntry delete(int id) {
        TransferLibraryEntry ent = null;
        TransferLibrary transferLibrary = this;
        synchronized (transferLibrary) {
            HashMap newEntries = (HashMap)this.entries.clone();
            ent = (TransferLibraryEntry)newEntries.remove(new Integer(id));
            this.entries = newEntries;
        }
        this.fireFileRemoved(ent);
        return ent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected TransferLibraryEntry setAttributes(int id, Map attrs) {
        TransferLibraryEntry ent = null;
        TransferLibrary transferLibrary = this;
        synchronized (transferLibrary) {
            ent = (TransferLibraryEntry)this.entries.get(new Integer(id));
            for (String attr : attrs.keySet()) {
                String val = (String)attrs.get(attr);
                ent.setAttribute(attr, val);
                this.fireFileAttributeChanged(ent, attr);
            }
        }
        return ent;
    }

    public boolean contains(int id) {
        return this.entries.containsKey(new Integer(id));
    }

    public boolean isEmpty() {
        return this.entries.isEmpty();
    }

    public int size() {
        return this.entries.size();
    }

    public abstract int load(File var1, Map var2, FileTransferRequestListener var3);

    public abstract int load(URL var1, Map var2, FileTransferRequestListener var3);

    public abstract int remove(int var1, FileTransferRequestListener var2);

    public abstract int setAttributes(int var1, Map var2, FileTransferRequestListener var3);

    @Override
    public abstract void setUrgent(int var1, boolean var2);

    protected abstract void doSendAck(RecvWindow var1, TransferLibraryEntry var2);

    public abstract void onChannelData(ChannelDataEvent var1);

    public abstract void transmitStatusChange(TransmitStatusEvent var1);

    public abstract void addProxy(short var1);

    public abstract void removeProxy(short var1);

    protected Connection getConnection() {
        if (this.channel == null) {
            return null;
        }
        return this.channel.getConnection();
    }

    public Object getLock() {
        if (this.channel == null) {
            return this;
        }
        return this.getConnection().getMessageLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        ArrayList<TransferLibraryEntry> disposal = new ArrayList<TransferLibraryEntry>();
        TransferLibrary transferLibrary = this;
        synchronized (transferLibrary) {
            Iterator i = this.entries.values().iterator();
            while (i.hasNext()) {
                TransferLibraryEntry entry = (TransferLibraryEntry)i.next();
                i.remove();
                disposal.add(entry);
            }
        }
        Iterator i = disposal.iterator();
        while (i.hasNext()) {
            TransferLibraryEntry entry = (TransferLibraryEntry)i.next();
            i.remove();
            entry.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void disconnectProxy(StreamProxy proxy) {
        short addr = proxy.getAddress();
        TransferLibrary transferLibrary = this;
        synchronized (transferLibrary) {
            for (TransferLibraryEntry entry : this.entries.values()) {
                proxy.disconnect(entry);
                if (entry.getSource() != addr) continue;
                entry.setSource((short)-32767);
            }
        }
    }

    protected void sendOK(short addr, int seq, int id) {
        if (addr == -32767 || addr == 0) {
            this.completeRequest(seq, id);
            return;
        }
        try {
            ChannelDataEvent e = ChannelDataEvent.getInstance((Object)this, (short)addr, (byte)11);
            DataOutputStream str = e.write();
            str.writeInt(seq);
            str.writeInt(id);
            str.close();
            this.channel.onChannelData(e);
        }
        catch (IOException iox) {
            LogSupport.exception((Object)this, (String)"sendOK", (Throwable)iox, (boolean)true);
        }
    }

    protected void sendError(short addr, int seq, I18nMessage msg) {
        if (addr == -32767 || addr == 0) {
            if (seq >= 0) {
                this.completeRequest(seq, new FileTransferException(seq, msg));
            } else {
                this.fireTransferError(new FileTransferException(seq, msg));
            }
            return;
        }
        try {
            ChannelDataEvent e = ChannelDataEvent.getInstance((Object)this, (short)addr, (byte)15);
            DataOutputStream str = e.write();
            str.writeInt(seq);
            msg.write(str);
            str.close();
            this.channel.onChannelData(e);
        }
        catch (IOException ex) {
            LogSupport.exception((Object)this, (String)"sendError", (Throwable)ex, (boolean)true);
        }
    }

    protected void sendError(short addr, int seq, String msg, String context, String details) {
        this.sendError(addr, seq, new I18nMessage(TransferLibrary.class, msg, new String[]{context, details}));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void beginRequest(int id, FileTransferRequestListener lst) {
        if (id < 0) {
            throw new IllegalArgumentException("Invalid Request id: " + id);
        }
        HashMap hashMap = this.requests;
        synchronized (hashMap) {
            this.requests.put(new Integer(id), lst);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void completeRequest(int id, int uid) {
        FileTransferRequestListener lst;
        if (id < 0) {
            return;
        }
        HashMap hashMap = this.requests;
        synchronized (hashMap) {
            lst = (FileTransferRequestListener)this.requests.remove(new Integer(id));
        }
        if (lst != null) {
            try {
                lst.notifyComplete(id, uid);
            }
            catch (Throwable t) {
                LogSupport.exception((Object)this, (String)"completeRequest", (Throwable)t, (boolean)true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected FileTransferRequestListener getRequest(int id) {
        FileTransferRequestListener req = null;
        HashMap hashMap = this.requests;
        synchronized (hashMap) {
            req = (FileTransferRequestListener)this.requests.get(new Integer(id));
        }
        return req;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void completeRequest(int id, FileTransferException ex) {
        FileTransferRequestListener lst;
        if (id < 0) {
            return;
        }
        HashMap hashMap = this.requests;
        synchronized (hashMap) {
            lst = (FileTransferRequestListener)this.requests.remove(new Integer(id));
        }
        if (lst != null) {
            try {
                lst.notifyException(id, ex);
            }
            catch (Throwable t) {
                LogSupport.exception((Object)this, (String)"completeRequest", (Throwable)t, (boolean)true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getNextRequestID() {
        int id;
        Object object = this.requestLock;
        synchronized (object) {
            id = this.requestID++;
        }
        return id;
    }
}

