/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.transfer;

import com.elluminate.groupware.transfer.AbstractLoader;
import com.elluminate.groupware.transfer.LoaderListener;
import com.elluminate.groupware.transfer.TransferLibrary;
import com.elluminate.jinx.ProtocolBuffer;
import com.elluminate.platform.Platform;
import java.io.BufferedInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Map;

public class FileLoader
extends AbstractLoader {
    private File file;
    private DataInputStream istr;

    public FileLoader(int seq, File f, int id, Map attrs, Object lock, LoaderListener lst, TransferLibrary lib) {
        super(seq, f.getName(), id, attrs, lock, lst, lib);
        this.file = f;
    }

    @Override
    protected boolean open() throws IOException {
        this.istr = new DataInputStream(new BufferedInputStream(new FileInputStream(this.file)));
        this.setLength(this.file.length());
        this.setMimeType(Platform.getMimeType((File)this.file));
        return true;
    }

    @Override
    protected void close() {
        if (this.istr != null) {
            try {
                this.istr.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.istr = null;
        }
    }

    @Override
    protected boolean read(ProtocolBuffer buf, int nBytes) {
        try {
            buf.readFrom((DataInput)this.istr, 0, nBytes);
            return true;
        }
        catch (EOFException eof) {
            return false;
        }
        catch (IOException ex) {
            this.reportError("FileLoader.readError", ex.toString());
            return false;
        }
    }
}

