/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.cluster;

import com.elluminate.cluster.AsteriskServer;
import com.elluminate.cluster.ClusterMsg;
import java.util.List;

public class TelephonyAllocatorResourceReq
extends ClusterMsg {
    private static final long serialVersionUID = 1L;
    public static final short F_REQUEST = 1;
    public static final short F_SUCCESS = 2;
    public static final short F_RESOURCE_NAME = 3;
    public static final short F_SERVER = 4;
    public static final short F_SERVERS = 5;
    public static final byte REQ_ADD = 1;
    public static final byte REQ_REMOVE = 2;
    public static final byte REQ_START = 3;
    public static final byte REQ_QUIESCE = 4;
    public static final byte REQ_STOP = 5;
    public static final byte REQ_STATUS = 6;
    public static final short VERSION = 1;

    public TelephonyAllocatorResourceReq() {
    }

    public TelephonyAllocatorResourceReq(byte req, String name) {
        super((short)1, (short)1, req);
        if (req == 1) {
            throw new IllegalArgumentException("Wrong constructor for add request.");
        }
        if (req == 6) {
            if (name != null) {
                this.setField((short)3, name);
            }
        } else {
            if (name == null) {
                throw new NullPointerException("name argument may not be null");
            }
            this.setField((short)3, name);
        }
    }

    public TelephonyAllocatorResourceReq(AsteriskServer toAdd) {
        super((short)1, (short)1, (byte)1, (short)4, toAdd);
    }

    public byte getRequestType() {
        return (byte)this.getFieldAsLong((short)1);
    }

    public boolean succeeded() {
        return this.getFieldAsBoolean((short)2);
    }

    public String getResourceName() {
        return this.getFieldAsString((short)3, null);
    }

    public AsteriskServer getServerInfo() {
        return this.getFieldAsMsg((short)4, AsteriskServer.class, null);
    }

    public List<AsteriskServer> getStatus() {
        return this.getFieldAsMsgArray((short)5, AsteriskServer.class);
    }

    public void setResults(AsteriskServer server) {
        if (this.getRequestType() == 6) {
            throw new IllegalStateException("Incorrect result set for a status requerst.");
        }
        this.setField((short)4, server);
        this.setField((short)2, true);
    }

    public void setResults(AsteriskServer[] servers) {
        if (this.getRequestType() != 6) {
            throw new IllegalStateException("Incorrect result set for a non-status request");
        }
        this.setField((short)5, servers);
        this.setField((short)2, true);
    }

    public void setFail() {
        this.setField((short)2, false);
    }

    @Override
    public String toString() {
        StringBuilder bld = new StringBuilder();
        byte req = (byte)this.getFieldAsLong((short)1);
        String name = this.getFieldAsString((short)3);
        switch (req) {
            case 1: {
                bld.append("TAResourceRequestAdd(v");
                break;
            }
            case 2: {
                bld.append("TAResourceRequestRemove(v");
                break;
            }
            case 3: {
                bld.append("TAResourceRequestStart(v");
                break;
            }
            case 4: {
                bld.append("TAResourceRequestQuiesce(v");
                break;
            }
            case 5: {
                bld.append("TAResourceRequestStop(v");
                break;
            }
            case 6: {
                bld.append("TAResourceRequestStatus(v");
                break;
            }
            default: {
                return super.toString();
            }
        }
        bld.append(this.getVersion());
        if (this.hasField((short)3)) {
            bld.append(",resourceName=");
            bld.append(name);
        }
        if (this.hasField((short)4)) {
            bld.append(",server=");
            bld.append(this.getFieldAsMsg((short)4, AsteriskServer.class).toString());
        }
        bld.append(")");
        if (this.hasField((short)2)) {
            bld.append("=[");
            boolean success = this.getFieldAsBoolean((short)2);
            bld.append(success ? "succeeded" : "failed");
            if (this.hasField((short)4)) {
                bld.append(",server=");
                bld.append(this.getFieldAsMsg((short)4, AsteriskServer.class).toString());
            } else if (this.hasField((short)5)) {
                List<AsteriskServer> servers = this.getFieldAsMsgArray((short)5, AsteriskServer.class);
                boolean first = true;
                bld.append(",servers=[");
                for (AsteriskServer svr : servers) {
                    if (first) {
                        first = false;
                    } else {
                        bld.append(",");
                    }
                    bld.append(svr.toString());
                }
                bld.append("]");
            }
            bld.append("]");
        }
        return bld.toString();
    }
}

