/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.cluster;

import com.elluminate.cluster.CQueue;
import com.elluminate.cluster.CTopic;
import com.elluminate.cluster.ClusterMsg;
import com.elluminate.cluster.GeminiEvent;
import com.elluminate.cluster.HazelcastWrappedObject;
import com.elluminate.cluster.ReloadEvent;
import com.hazelcast.config.Config;
import com.hazelcast.config.XmlConfigBuilder;
import com.hazelcast.core.Cluster;
import com.hazelcast.core.Hazelcast;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.ItemEvent;
import com.hazelcast.core.ItemListener;
import com.hazelcast.core.LifecycleEvent;
import com.hazelcast.core.LifecycleListener;
import com.hazelcast.core.Member;
import com.hazelcast.core.MessageListener;
import com.hazelcast.logging.ILogger;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;

public class Clustering {
    private final long CONFIG_RELOAD_TIMEOUT_MILLIS = 60000L;
    private HazelcastInstance instance = null;
    private CQueue<ClusterMsg> waitQ = null;
    private String waitQName = null;
    private Object waitLock = new Object();
    private Map<Long, SyncWait<?>> pending = new HashMap();
    private ItemListener<ClusterMsg> respListener;
    private String myNode;
    private ILogger logger;
    private long requestid;
    private ConfigReloadManager reloadManager = null;
    private LifecycleListener hzListener = null;

    public void configure(String clusterName, String clusterPass, String nodeName, LogSystem logsys) {
        if (this.instance != null) {
            throw new IllegalStateException("Clustering is already configured.");
        }
        SecureRandom rnd = new SecureRandom();
        this.configLogsys(logsys);
        Config config = new Config();
        config.setInstanceName(clusterName);
        config.getGroupConfig().setName(clusterName);
        config.getGroupConfig().setPassword(clusterPass);
        this.myNode = nodeName;
        this.waitQName = "Wait." + nodeName;
        this.requestid = rnd.nextLong();
        this.instance = Hazelcast.newHazelcastInstance((Config)config);
        this.logger = this.instance.getLoggingService().getLogger("com.elluminate.clustering.Cluster");
        if (this.reloadManager == null) {
            this.reloadManager = new ConfigReloadManager(clusterName, clusterPass, nodeName, logsys);
        }
    }

    public void configure(URL configURL, String nodeName, LogSystem logsys) {
        try {
            this.configure(configURL.openStream(), nodeName, logsys);
        }
        catch (IOException iox) {
            throw new IllegalArgumentException("Unable to read config file: " + configURL);
        }
        if (this.reloadManager == null) {
            this.reloadManager = new ConfigReloadManager(configURL, nodeName, logsys);
        }
    }

    public void configure(File configFile, String nodeName, LogSystem logsys) {
        try {
            this.configure(new FileInputStream(configFile), nodeName, logsys);
        }
        catch (IOException iox) {
            throw new IllegalArgumentException("Unable to read config file: " + configFile);
        }
        if (this.reloadManager == null) {
            this.reloadManager = new ConfigReloadManager(configFile, nodeName, logsys);
        }
    }

    public void configure(InputStream str, String nodeName, LogSystem logsys) {
        if (this.instance != null) {
            throw new IllegalStateException("Clustering is already configured.");
        }
        SecureRandom rnd = new SecureRandom();
        this.configLogsys(logsys);
        XmlConfigBuilder builder = new XmlConfigBuilder(str);
        Config config = builder.build();
        this.myNode = nodeName;
        this.waitQName = "Wait." + nodeName;
        this.requestid = rnd.nextLong();
        this.instance = Hazelcast.newHazelcastInstance((Config)config);
        this.logger = this.instance.getLoggingService().getLogger("com.elluminate.clustering.Cluster");
    }

    public void addMergeListener() {
        this.logger.log(Level.INFO, "(Clustering) lifecycle event LISTENER ADDED ");
        this.hzListener = new LifecycleListener(){

            public void stateChanged(LifecycleEvent lifecycleEvent) {
                if (LifecycleEvent.LifecycleState.MERGING.equals((Object)lifecycleEvent.getState())) {
                    Clustering.this.logger.log(Level.WARNING, "(Clustering) lifecycle event is MERGING");
                } else if (LifecycleEvent.LifecycleState.RESTARTED.equals((Object)lifecycleEvent.getState())) {
                    Clustering.this.logger.log(Level.WARNING, "(Clustering) lifecycle event is RESTARTED ");
                }
            }
        };
        this.instance.getLifecycleService().addLifecycleListener(this.hzListener);
    }

    public String[] configure(String[] args, LogSystem logsys) {
        if (this.instance != null) {
            throw new IllegalStateException("Clustering is already configured.");
        }
        ArgState state = ArgState.ARG;
        URL url = null;
        File file = null;
        String cName = null;
        String cPass = null;
        String node = null;
        ArrayList<String> unused = new ArrayList<String>();
        block10: for (String arg : args) {
            switch (state) {
                case ARG: {
                    if ("-node".equals(arg)) {
                        state = ArgState.NODE;
                        continue block10;
                    }
                    if ("-cluster".equals(arg)) {
                        state = ArgState.CNAME;
                        continue block10;
                    }
                    if ("-configUrl".equals(arg)) {
                        state = ArgState.URL;
                        continue block10;
                    }
                    if ("-configFile".equals(arg)) {
                        state = ArgState.FILE;
                        continue block10;
                    }
                    unused.add(arg);
                    continue block10;
                }
                case NODE: {
                    node = arg;
                    state = ArgState.ARG;
                    continue block10;
                }
                case CNAME: {
                    if (cName != null) {
                        throw new IllegalArgumentException("Cannot have multiple -cluster args");
                    }
                    if (file != null) {
                        throw new IllegalArgumentException("Cannot have both -configFile and -cluster");
                    }
                    if (url != null) {
                        throw new IllegalArgumentException("Cannot have both -configUrl and -cluster");
                    }
                    cName = arg;
                    state = ArgState.CPASS;
                    continue block10;
                }
                case CPASS: {
                    cPass = arg;
                    state = ArgState.ARG;
                    continue block10;
                }
                case URL: {
                    if (url != null) {
                        throw new IllegalArgumentException("Cannot have multiple -configUrl args");
                    }
                    if (file != null) {
                        throw new IllegalArgumentException("Cannot have both -configFile and -configUrl");
                    }
                    if (cName != null) {
                        throw new IllegalArgumentException("Cannot have both -configFile and -cluster");
                    }
                    try {
                        url = new URL(arg);
                    }
                    catch (MalformedURLException mux) {
                        throw new IllegalArgumentException("Invalid config file URL: '" + arg + "'");
                    }
                    state = ArgState.ARG;
                    continue block10;
                }
                case FILE: {
                    if (file != null) {
                        throw new IllegalArgumentException("Cannot have multiple -configFile args");
                    }
                    if (url != null) {
                        throw new IllegalArgumentException("Cannot have both -configFile and -configUrl");
                    }
                    if (cName != null) {
                        throw new IllegalArgumentException("Cannot have both -configFile and -cluster");
                    }
                    file = new File(arg);
                    if (!file.exists()) {
                        throw new IllegalArgumentException("Config file '" + arg + "' does not exist.");
                    }
                    state = ArgState.ARG;
                }
            }
        }
        if (state != ArgState.ARG) {
            throw new IllegalArgumentException("Missing argument.");
        }
        if (node == null) {
            throw new IllegalArgumentException("No node name supplied.");
        }
        if (file != null) {
            this.configure(file, node, logsys);
        } else if (url != null) {
            this.configure(url, node, logsys);
        } else if (cName != null) {
            this.configure(cName, cPass, node, logsys);
        } else {
            throw new IllegalArgumentException("One of -cluster, -configUrl, or -configFile is required");
        }
        return unused.toArray(args);
    }

    public void requestConfigReloads() {
        if (this.instance != null) {
            int timeOutCount = 0;
            int failureCount = 0;
            Cluster cl = this.instance.getCluster();
            Set memberSet = cl.getMembers();
            int memberCount = memberSet.size();
            this.logger.log(Level.WARNING, ">>> config reload request: " + memberCount + " cluster members.");
            int nodeNum = 0;
            for (Member member : memberSet) {
                String memberReloadQueueName = this.reloadManager.getMemberConfigReloadQueueName(member);
                if (member.localMember()) continue;
                this.logger.log(Level.WARNING, ">>> config reload request " + ++nodeNum + " of " + memberCount + " to " + memberReloadQueueName + "...");
                ReloadEvent resp = this.sendToQueueAndWait(memberReloadQueueName, new ReloadEvent(), 60000L);
                if (resp == null) {
                    this.logger.log(Level.SEVERE, ">>> " + memberReloadQueueName + " config reload response: TIMED-OUT <<<<<<<");
                    ++timeOutCount;
                    continue;
                }
                if (resp.isAck()) {
                    this.logger.log(Level.WARNING, ">>> " + memberReloadQueueName + " config reload response: SUCCESS <<<<<<<");
                    continue;
                }
                this.logger.log(Level.SEVERE, ">>> " + memberReloadQueueName + " config reload response: FAILURE <<<<<<<");
                ++failureCount;
            }
            if (this.reloadManager.selfReload()) {
                this.logger.log(Level.WARNING, ">>> SELF config reload response: SUCCESS <<<<<<<");
            } else {
                this.logger.log(Level.SEVERE, ">>> SELF config reload response: FAILURE <<<<<<<");
                ++failureCount;
            }
            this.logger.log(Level.WARNING, ">>> Config reload results: of " + memberCount + " members, " + timeOutCount + " requests timed-out, " + failureCount + " returned FAIL, so " + (memberCount - timeOutCount - failureCount) + " SUCCEEDED <<<<<<<");
        }
    }

    public boolean requestLocalRestart() {
        boolean ret = this.reloadManager.selfReload();
        if (ret) {
            this.logger.log(Level.WARNING, ">>> SELF config reload response: SUCCESS <<<<<<<");
        } else {
            this.logger.log(Level.SEVERE, ">>> SELF config reload response: FAILURE <<<<<<<");
        }
        return ret;
    }

    public String[] requestMembers() {
        ArrayList<String> members = new ArrayList<String>();
        if (this.instance != null) {
            Cluster cl = this.instance.getCluster();
            if (cl == null) {
                return new String[0];
            }
            Set memberSet = cl.getMembers();
            for (Member member : memberSet) {
                if (!member.localMember()) {
                    members.add(member.getInetSocketAddress().toString());
                    continue;
                }
                members.add(member.getInetSocketAddress().toString() + "  (self)");
            }
        }
        return members.toArray(new String[0]);
    }

    private void configLogsys(LogSystem logsys) {
        switch (logsys) {
            case NONE: {
                System.setProperty("hazelcast.logging.type", "none");
                break;
            }
            case JDK: {
                System.setProperty("hazelcast.logging.type", "jdk");
                break;
            }
            case LOG4J: {
                System.setProperty("hazelcast.logging.type", "log4j");
                break;
            }
            case GEMINI: {
                System.setProperty("hazelcast.logging.class", "com.elluminate.cluster.GeminiLoggerFactory");
            }
        }
    }

    public boolean isConfigured() {
        return this.instance != null;
    }

    public void detach() {
        if (this.reloadManager != null) {
            this.reloadManager.shutdown();
            this.reloadManager = null;
        }
        if (this.instance != null) {
            this.instance.getLifecycleService().shutdown();
            this.instance = null;
        }
    }

    public String getMyNodeName() {
        return this.myNode;
    }

    public <T extends ClusterMsg> CQueue<T> getQueue(String name) {
        return this.reloadManager.getQueue(name, this.instance);
    }

    public <T extends ClusterMsg> CTopic<T> getTopic(String name) {
        return this.reloadManager.getTopic(name, this.instance);
    }

    public <T extends ClusterMsg> boolean sendToQueue(String name, T msg, String replyQueue) {
        if (this.instance != null) {
            CQueue queue = this.reloadManager.getQueue(name, this.instance);
            return this.sendToQueue(queue, msg, replyQueue);
        }
        return false;
    }

    public <T extends ClusterMsg> boolean sendToQueue(CQueue<T> queue, T msg, String replyQueue) {
        if (this.instance != null) {
            if (replyQueue != null) {
                msg.setReturnQueue(replyQueue);
            }
            queue.add(msg);
            return true;
        }
        return false;
    }

    public <T extends ClusterMsg> T sendToQueueAndWait(String name, T msg, long timeoutMillis) {
        if (this.instance == null) {
            return null;
        }
        CQueue<T> queue = this.getQueue(name);
        return this.sendToQueueAndWait(queue, msg, timeoutMillis);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends ClusterMsg> T sendToQueueAndWait(CQueue<T> queue, T msg, long timeoutMillis) {
        if (this.instance == null) {
            return null;
        }
        SyncWait sync = null;
        Object object = this.waitLock;
        synchronized (object) {
            if (this.waitQ == null) {
                this.waitQ = this.getQueue(this.waitQName);
                this.respListener = new ItemListener<ClusterMsg>(){

                    public void itemAdded(ItemEvent<ClusterMsg> item) {
                        ClusterMsg resp = null;
                        while ((resp = (ClusterMsg)Clustering.this.waitQ.poll()) != null) {
                            long id = resp.getRequestID();
                            SyncWait sync = (SyncWait)Clustering.this.pending.get(id);
                            if (sync != null) {
                                sync.setResponse(resp);
                                continue;
                            }
                            Clustering.this.logger.log(Level.FINE, "Dropped stale response message " + resp);
                        }
                    }

                    public void itemRemoved(ItemEvent<ClusterMsg> item) {
                    }
                };
                this.waitQ.addItemListener(this.respListener, false);
            }
            long id = this.requestid++;
            msg.setRequestID(id);
            msg.setReturnQueue(this.waitQName);
            sync = new SyncWait(id, timeoutMillis);
            this.pending.put(id, sync);
        }
        queue.add(msg);
        Object response = sync.waitFor();
        Object object2 = this.waitLock;
        synchronized (object2) {
            this.pending.remove(sync.getRequestID());
        }
        return response;
    }

    public HazelcastWrappedObject<ClusterMsg> getNodeQueue() {
        return this.getQueue("Node." + this.myNode);
    }

    public boolean sendToNode(String name, ClusterMsg msg, boolean reply) {
        if (this.instance != null) {
            CQueue<ClusterMsg> queue = this.getQueue("Node." + name);
            if (reply) {
                msg.setReturnQueue("Node." + this.myNode);
            }
            queue.add(msg);
            return true;
        }
        return false;
    }

    public <T extends GeminiEvent> boolean sendGeminiEvent(String name, T event) {
        if (this.instance != null) {
            CTopic<T> topic = this.getGeminiEventTopic(name);
            topic.publish(event);
            return true;
        }
        return false;
    }

    public <T extends GeminiEvent> boolean addGeminiEventListener(String name, MessageListener<T> lst) {
        if (this.instance != null) {
            CTopic<T> topic = this.getGeminiEventTopic(name);
            topic.addMessageListener(lst);
            return true;
        }
        return false;
    }

    public <T extends GeminiEvent> boolean removeGeminiEventListener(String name, MessageListener<T> lst) {
        if (this.instance != null) {
            CTopic<T> topic = this.getGeminiEventTopic(name);
            topic.removeMessageListener(lst);
            return true;
        }
        return false;
    }

    public <T extends GeminiEvent> CTopic<T> getGeminiEventTopic(String name) {
        this.logger.log(Level.INFO, "Getting topic Gemini." + name);
        return this.getTopic("Gemini." + name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        if (this.instance == null) {
            return "Clustering is not configured.";
        }
        StringBuffer buf = new StringBuffer();
        buf.append("Cluster ");
        buf.append(this.instance.getName());
        buf.append("\n\n");
        buf.append(this.instance.getCluster().toString());
        buf.append("\n  ");
        Object object = this.waitLock;
        synchronized (object) {
            buf.append(this.pending.size());
        }
        buf.append(" synchronous requests pending.");
        return buf.toString();
    }

    private static enum ArgState {
        URL,
        FILE,
        NODE,
        CNAME,
        CPASS,
        ARG;

    }

    private class ConfigReloadManager
    extends Thread {
        private final long MONITOR_THREAD_SLEEP_MILLIS = 4000L;
        private final long MONITOR_RELOAD_SLEEP_MILLIS = 1000L;
        private final long SHUTDOWN_SLEEP_MILLIS = 50L;
        private URL configURL;
        private File configFile;
        private String configClusterName;
        private String configClusterPass;
        private String configNodeName;
        private LogSystem configLogsys;
        private ConfigType configType;
        private volatile boolean keepMonitoring;
        private volatile boolean reloadConfig;
        private volatile ItemListener<ReloadEvent> reloadListener = null;
        private volatile CQueue<ReloadEvent> reloadQueue = null;
        private volatile ReloadEvent reloadResponse = null;
        private volatile boolean selfReloadComplete;
        private volatile Object reloadLock = new Object();
        private Map<String, HazelcastWrappedObject<?>> wrappedObjectsMap = new HashMap();

        public ConfigReloadManager(File file, String nodeName, LogSystem logsys) {
            this.configFile = file;
            this.configNodeName = nodeName;
            this.configLogsys = logsys;
            this.configType = ConfigType.FILE;
            this.startup();
        }

        public ConfigReloadManager(URL url, String nodeName, LogSystem logsys) {
            this.configURL = url;
            this.configNodeName = nodeName;
            this.configLogsys = logsys;
            this.configType = ConfigType.URL;
            this.startup();
        }

        public ConfigReloadManager(String clusterName, String clusterPass, String nodeName, LogSystem logsys) {
            this.configClusterName = clusterName;
            this.configClusterPass = clusterPass;
            this.configNodeName = nodeName;
            this.configLogsys = logsys;
            this.configType = ConfigType.CNAME;
            this.startup();
        }

        private void startup() {
            this.keepMonitoring = true;
            this.reloadConfig = false;
            this.setDaemon(true);
            this.start();
            this.setupReloadRequestListener();
        }

        public void shutdown() {
            this.keepMonitoring = false;
            while (this.isAlive()) {
                try {
                    Thread.sleep(50L);
                }
                catch (Exception exception) {}
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public <T extends ClusterMsg> CQueue<T> getQueue(String name, HazelcastInstance instance) {
            CQueue queue = null;
            if (instance != null) {
                Object object = this.reloadLock;
                synchronized (object) {
                    queue = (CQueue)this.wrappedObjectsMap.get(name);
                    if (queue == null) {
                        queue = new CQueue(name, instance);
                        this.wrappedObjectsMap.put(name, queue);
                    }
                }
            }
            return queue;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public <T extends ClusterMsg> CTopic<T> getTopic(String name, HazelcastInstance instance) {
            CTopic topic = null;
            if (instance != null) {
                Object object = this.reloadLock;
                synchronized (object) {
                    topic = (CTopic)this.wrappedObjectsMap.get(name);
                    if (topic == null) {
                        topic = new CTopic(name, instance);
                        this.wrappedObjectsMap.put(name, topic);
                    }
                }
            }
            return topic;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean selfReload() {
            Clustering.this.logger.log(Level.WARNING, "ConfigReloadManager: config reload request - TO SELF...");
            Object object = this.reloadLock;
            synchronized (object) {
                this.reloadResponse = null;
                this.selfReloadComplete = false;
                this.reloadConfig = true;
                while (!this.selfReloadComplete) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (Exception exception) {}
                }
            }
            return true;
        }

        private void pauseForReload() {
            for (HazelcastWrappedObject<?> hwo : this.wrappedObjectsMap.values()) {
                hwo.pauseForReload();
            }
            Clustering.this.instance.getLifecycleService().shutdown();
            Clustering.this.instance = null;
        }

        private void resumeAfterReload() {
            for (HazelcastWrappedObject<?> hwo : this.wrappedObjectsMap.values()) {
                hwo.resumeAfterReload(Clustering.this.instance);
            }
        }

        @Override
        public void run() {
            while (this.keepMonitoring) {
                try {
                    Thread.sleep(4000L);
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (!this.reloadConfig) continue;
                this.reloadConfig = false;
                Clustering.this.logger.log(Level.WARNING, "ConfigReloadManager: pausing queues and topics, for reload...");
                this.pauseForReload();
                Clustering.this.logger.log(Level.WARNING, "ConfigReloadManager: re-loading configuration...");
                if (this.configType == ConfigType.FILE) {
                    Clustering.this.configure(this.configFile, this.configNodeName, this.configLogsys);
                } else if (this.configType == ConfigType.URL) {
                    Clustering.this.configure(this.configURL, this.configNodeName, this.configLogsys);
                } else {
                    Clustering.this.configure(this.configClusterName, this.configClusterPass, this.configNodeName, this.configLogsys);
                }
                Clustering.this.logger.log(Level.WARNING, "ConfigReloadManager: Hazelcast restarted. queues and topics resumed. Sending response (SUCCESS)");
                this.resumeAfterReload();
                if (this.reloadResponse == null) {
                    this.selfReloadComplete = true;
                    continue;
                }
                this.reloadResponse.ack();
                try {
                    String returnQueueName = this.reloadResponse.getReturnQueue();
                    CQueue<ReloadEvent> returnQueue = this.getQueue(returnQueueName, Clustering.this.instance);
                    Clustering.this.logger.log(Level.WARNING, "ConfigReloadManager: sending response (SUCCESS) to " + returnQueueName);
                    returnQueue.add(this.reloadResponse);
                }
                catch (Exception e) {
                    Clustering.this.logger.log(Level.SEVERE, "ConfigReloadManager: caught while responding: " + e);
                }
            }
            Clustering.this.logger.log(Level.WARNING, "ConfigReloadManager: exiting");
        }

        private void setupReloadRequestListener() {
            this.reloadQueue = this.getQueue(this.getMyConfigReloadQueueName(), Clustering.this.instance);
            this.reloadListener = new ItemListener<ReloadEvent>(){

                public void itemAdded(ItemEvent<ReloadEvent> item) {
                    ReloadEvent event = null;
                    while ((event = (ReloadEvent)ConfigReloadManager.this.reloadQueue.poll()) != null) {
                        Clustering.this.logger.log(Level.WARNING, "ReloadEvent: received");
                        ConfigReloadManager.this.reloadResponse = event;
                        ConfigReloadManager.this.reloadConfig = true;
                    }
                }

                public void itemRemoved(ItemEvent<ReloadEvent> item) {
                }
            };
            this.reloadQueue.addItemListener(this.reloadListener, false);
        }

        private String getMyConfigReloadQueueName() {
            Cluster cl = Clustering.this.instance.getCluster();
            Member me = cl.getLocalMember();
            return this.getMemberConfigReloadQueueName(me);
        }

        private String getMemberConfigReloadQueueName(Member m) {
            return "ConfigReload." + m.getInetSocketAddress().toString();
        }
    }

    private static enum ConfigType {
        URL,
        FILE,
        CNAME;

    }

    public static enum LogSystem {
        NONE,
        JDK,
        LOG4J,
        GEMINI;

    }

    private class SyncWait<T extends ClusterMsg> {
        long requestid;
        long timeout;
        T response = null;

        public SyncWait(long id, long millis) {
            this.requestid = id;
            this.timeout = System.currentTimeMillis() + millis;
        }

        public long getRequestID() {
            return this.requestid;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public T waitFor() {
            long now = System.currentTimeMillis();
            while (this.response == null && now < this.timeout) {
                try {
                    SyncWait syncWait = this;
                    synchronized (syncWait) {
                        this.wait(this.timeout - now);
                    }
                }
                catch (InterruptedException ix) {
                    break;
                }
                now = System.currentTimeMillis();
            }
            return this.response;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setResponse(ClusterMsg rsp) {
            SyncWait syncWait = this;
            synchronized (syncWait) {
                try {
                    this.response = rsp;
                }
                catch (ClassCastException ccx) {
                    Clustering.this.logger.log(Level.SEVERE, "Response message is not the same class as the originating request! - " + rsp.getClass().getName());
                }
                this.notifyAll();
            }
        }
    }
}

