/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.cluster;

import com.elluminate.util.TuningParam;
import java.util.logging.Level;

public class ClusterTuning {
    public static final String[] VALUES = new String[]{"OFF", "SEVERE", "WARNING", "INFO", "CONFIG", "FINE", "FINER", "FINEST", "ALL"};
    public static LevelTuningParam DefaultLogLevel = new LevelTuningParam("cluster.DefaultLogLevel", Level.WARNING);

    public static class LevelTuningParam
    extends TuningParam.EnumTuningParam {
        Level level;

        private LevelTuningParam(String name, Level dft) {
            super(name, dft.getName(), VALUES);
            this.level = dft;
        }

        public void setValue(String value) {
            super.setValue(value);
            this.level = Level.parse(value);
        }

        public void setValue(int value) {
            super.setValue(value);
            this.level = Level.parse(this.getValue());
        }

        public Level getLevel() {
            return this.level;
        }
    }
}

