/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.polling.module;

import com.elluminate.framework.feature.AbstractFeature;
import com.elluminate.framework.feature.EnumeratedFeature;
import com.elluminate.framework.feature.Feature;
import com.elluminate.framework.feature.MetaDataEvent;
import com.elluminate.framework.feature.MetaDataListener;
import com.elluminate.groupware.polling.module.PollingTypeAdapter;
import com.elluminate.groupware.polling.module.StringsProperties;
import com.elluminate.util.PropertiesEnum;
import java.awt.Image;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

public class YesNoPolling
extends PollingTypeAdapter {
    private static final String FEATURE_PATH = "/polling/yesno";
    private EnumeratedFeature<Character> yesNoResponseFeature = null;
    private Map<Character, Image> yesNoImages = new LinkedHashMap<Character, Image>();
    private Map<Character, String> yesNoStrings = new LinkedHashMap<Character, String>();
    private MetaDataListener changeListener = null;

    @Override
    public void setupFeatures() {
        this.changeListener = new MetaDataListener(){

            public void metaDataChanged(MetaDataEvent ev) {
                YesNoPolling.this.yesNoResponseChanged(ev);
            }
        };
        this.initializeMap();
        this.setupYesNoFeature();
    }

    private void initializeMap() {
        this.yesNoImages.put(Character.valueOf('y'), this.i18n.getImage((PropertiesEnum)StringsProperties.POLLINGMODULE_YESICON));
        this.yesNoImages.put(Character.valueOf('n'), this.i18n.getImage((PropertiesEnum)StringsProperties.POLLINGMODULE_NOICON));
        this.yesNoImages.put(Character.valueOf(' '), this.i18n.getImage((PropertiesEnum)StringsProperties.POLLINGMODULE_NONEICON));
        this.yesNoStrings.put(Character.valueOf('y'), this.i18n.getString((PropertiesEnum)StringsProperties.POLLINGMODULE_YESMENU));
        this.yesNoStrings.put(Character.valueOf('n'), this.i18n.getString((PropertiesEnum)StringsProperties.POLLINGMODULE_NOMENU));
        this.yesNoStrings.put(Character.valueOf(' '), this.i18n.getString((PropertiesEnum)StringsProperties.POLLINGMODULE_NONEMENU));
    }

    private void setupYesNoFeature() {
        Object[] supported = new Character[]{Character.valueOf('y'), Character.valueOf('n'), Character.valueOf(' ')};
        this.yesNoResponseFeature = this.broker.createEnumeratedFeature((Object)this, FEATURE_PATH, Character.class, true, (Object)Character.valueOf(' '), supported, this.i18n.getString((PropertiesEnum)StringsProperties.POLLINGMODULE_RESPONSE), this.i18n.getString((PropertiesEnum)StringsProperties.POLLINGMODULE_RESPONSE));
        this.yesNoResponseFeature.setValueText((Object)Character.valueOf('y'), this.i18n.getString((PropertiesEnum)StringsProperties.POLLINGMODULE_YESMENU));
        this.yesNoResponseFeature.setValueIconImage((Object)Character.valueOf('y'), this.i18n.getImage((PropertiesEnum)StringsProperties.POLLINGMODULE_YESICON));
        this.yesNoResponseFeature.setValueText((Object)Character.valueOf('n'), this.i18n.getString((PropertiesEnum)StringsProperties.POLLINGMODULE_NOMENU));
        this.yesNoResponseFeature.setValueIconImage((Object)Character.valueOf('n'), this.i18n.getImage((PropertiesEnum)StringsProperties.POLLINGMODULE_NOICON));
        this.yesNoResponseFeature.setValueText((Object)Character.valueOf(' '), this.i18n.getString((PropertiesEnum)StringsProperties.POLLINGMODULE_NORESPONSEMENU));
        this.yesNoResponseFeature.setValueIconImage((Object)Character.valueOf(' '), this.i18n.getImage((PropertiesEnum)StringsProperties.POLLINGMODULE_NONEICON));
        this.yesNoResponseFeature.setDefaultIcon(this.i18n.getImage((PropertiesEnum)StringsProperties.POLLINGMODULE_YESNOPOLLICONINACTIVE));
        this.yesNoResponseFeature.addValueChangeListener(this.changeListener);
    }

    private void yesNoResponseChanged(MetaDataEvent ev) {
        Character response = Character.valueOf(' ');
        Image icon = this.i18n.getImage((PropertiesEnum)StringsProperties.POLLINGMODULE_YESNOPOLLICONINACTIVE);
        if (ev != null && ev.getNewValue() != null && (response = (Character)ev.getNewValue()).charValue() != ' ') {
            icon = this.yesNoImages.get(response);
        }
        this.model.setPollResponse(response.charValue());
        this.yesNoResponseFeature.setDefaultIcon(icon);
    }

    @Override
    public void clearResponse() {
        this.model.setPollResponse(' ');
        this.yesNoResponseFeature.setValue((Object)Character.valueOf(' '));
    }

    @Override
    public void updateFeature() {
        Feature current = this.broker.getFeature(FEATURE_PATH);
        if (current != null) {
            ((AbstractFeature)current).setEnabled(false);
            this.broker.setFeaturePublished(current, false);
        }
        if (this.model.getPollingMode() == 1) {
            this.yesNoResponseFeature.setEnabled(!this.model.isPollingLocked());
            this.broker.setFeaturePublished(this.yesNoResponseFeature, true);
        }
    }

    @Override
    public void lockFeature(Boolean locked) {
        if (locked != null) {
            this.yesNoResponseFeature.setEnabled(locked == false);
        }
    }

    @Override
    public void cleanupFeatures() {
        this.broker.removeFeature(this.yesNoResponseFeature);
        this.yesNoResponseFeature.removeMetaDataListener(this.changeListener);
    }

    @Override
    public Image getImageFor(Character c) {
        return this.yesNoImages.get(c);
    }

    @Override
    public String getTextFor(Character c) {
        return this.yesNoStrings.get(c);
    }

    @Override
    public Map<Character, Image> getResponseOptions() {
        if (this.model.getPollingMode() == 1) {
            return Collections.unmodifiableMap(this.yesNoImages);
        }
        return null;
    }
}

