/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.polling.module;

import com.elluminate.framework.feature.FeatureBroker;
import com.elluminate.framework.session.CRSession;
import com.elluminate.groupware.polling.module.PollingModel;
import com.elluminate.groupware.polling.module.PollingType;
import com.elluminate.groupware.polling.module.PollingUtils;
import com.elluminate.jinx.ClientGroup;
import com.elluminate.jinx.ClientGroupEvent;
import com.elluminate.jinx.ClientGroupListener;
import com.elluminate.jinx.ClientList;
import com.elluminate.jinx.provider.ClientProvider;
import com.elluminate.util.I18n;
import com.elluminate.util.log.Logger;
import com.google.inject.Inject;
import java.awt.Image;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Map;

public abstract class PollingTypeAdapter
implements PollingType {
    protected I18n i18n = I18n.create((Object)this);
    protected Logger log = null;
    protected PollingUtils utils = null;
    protected PollingModel model = null;
    protected ClientProvider clientProvider = null;
    protected FeatureBroker broker = null;
    protected CRSession session = null;
    private PropertyChangeListener modeChangeListener = null;
    private PropertyChangeListener lockedChangeListener = null;
    private PropertyChangeListener responseChangeListener = null;
    private ClientGroupListener clientGroupListener = null;

    @Inject
    public void initLogger(Logger l) {
        this.log = l;
    }

    @Inject
    public void initFeatureBroker(FeatureBroker fb) {
        this.broker = fb;
    }

    @Inject
    public void initClientProvider(ClientProvider cp) {
        this.clientProvider = cp;
    }

    @Inject
    public void initModel(PollingModel theModel) {
        this.model = theModel;
    }

    @Inject
    public void initPollingUtils(PollingUtils u) {
        this.utils = u;
    }

    @Inject
    public void initCRSession(CRSession s) {
        this.session = s;
    }

    public abstract void setupFeatures();

    public abstract void cleanupFeatures();

    public abstract void clearResponse();

    public abstract void updateFeature();

    public abstract void lockFeature(Boolean var1);

    public abstract Image getImageFor(Character var1);

    public abstract String getTextFor(Character var1);

    public abstract Map<Character, Image> getResponseOptions();

    @Override
    public void setup() {
        this.setupFeatures();
        this.registerModeListener();
        this.registerLockedListener();
        this.registerResponseListener();
        this.registerClientListener();
    }

    @Override
    public void cleanup() {
        this.clientProvider.get().getClientList().removeGroupPropertyChangeListener(this.modeChangeListener);
        this.clientProvider.get().getClientList().removeGroupPropertyChangeListener(this.lockedChangeListener);
        this.clientProvider.get().getClientList().removeClientPropertyChangeListener(this.responseChangeListener);
        this.clientProvider.get().removeClientGroupListener(this.clientGroupListener);
        this.cleanupFeatures();
    }

    private void registerModeListener() {
        this.modeChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                PollingTypeAdapter.this.handleModeChange(evt);
            }
        };
        this.clientProvider.get().getClientList().addGroupPropertyChangeListener("pollingMode", this.modeChangeListener);
    }

    private void handleModeChange(PropertyChangeEvent evt) {
        if (this.utils.isMyGroup(this.clientProvider.get(), (ClientGroup)evt.getSource())) {
            Short mode = (Short)evt.getNewValue();
            mode = mode == null ? (short)0 : mode;
            this.model.setPollingMode(mode);
            this.clearResponse();
            this.updateFeature();
        }
    }

    private void registerLockedListener() {
        this.lockedChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (PollingTypeAdapter.this.utils.isMyGroup(PollingTypeAdapter.this.clientProvider.get(), (ClientGroup)evt.getSource())) {
                    PollingTypeAdapter.this.lockFeature((Boolean)evt.getNewValue());
                }
            }
        };
        this.clientProvider.get().getClientList().addGroupPropertyChangeListener("pollingLocked", this.lockedChangeListener);
    }

    private void registerResponseListener() {
        this.responseChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                PollingTypeAdapter.this.handleClearResponseChange(evt);
            }
        };
        this.clientProvider.get().getClientList().addClientPropertyChangeListener("pollingValue", this.responseChangeListener);
    }

    private void registerClientListener() {
        this.clientGroupListener = new ClientGroupListener(){

            public void clientGroupRenamed(ClientGroupEvent event) {
            }

            public void clientGroupDeleted(ClientGroupEvent event) {
            }

            public void clientGroupCreated(ClientGroupEvent event) {
            }

            public void clientGroupChanged(ClientGroupEvent event) {
                if (event.getClient().isMe()) {
                    PollingTypeAdapter.this.utils.matchToGroup(event.getGroup());
                    PollingTypeAdapter.this.handleClientGroupChange(event.getGroup());
                }
            }
        };
        this.clientProvider.get().addClientGroupListener(this.clientGroupListener);
    }

    private void handleClientGroupChange(ClientGroup grp) {
        this.clearResponse();
        this.updateFeature();
    }

    private void handleClearResponseChange(PropertyChangeEvent evt) {
        ClientList clients = this.clientProvider.get().getClientList();
        if (clients.getPropertyOwner(evt.getSource()) == clients.getMyAddress() && ((Character)evt.getNewValue() == null || ((Character)evt.getNewValue()).charValue() == ' ')) {
            this.clearResponse();
        }
    }
}

