/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.polling.module;

import com.elluminate.groupware.polling.module.LetterPolling;
import com.elluminate.groupware.polling.module.PollingModel;
import com.elluminate.groupware.polling.module.PollingTypeAdapter;
import com.elluminate.groupware.polling.module.YesNoPolling;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.List;

public class PollTypeFactory {
    private LetterPolling letterPolling = null;
    private YesNoPolling yesNoPolling = null;
    private PollingModel model = null;
    private List<PollingTypeAdapter> allTypes = new ArrayList<PollingTypeAdapter>();

    @Inject
    public void initLetterPolling(LetterPolling lp) {
        this.letterPolling = lp;
        this.allTypes.add(this.letterPolling);
    }

    @Inject
    public void initYesNoPolling(YesNoPolling ynp) {
        this.yesNoPolling = ynp;
        this.allTypes.add(this.yesNoPolling);
    }

    @Inject
    public void initPollingModel(PollingModel m) {
        this.model = m;
    }

    public PollingTypeAdapter getCurrentPollingType() {
        short mode = this.model.getPollingMode();
        switch (mode) {
            case 2: 
            case 3: 
            case 4: {
                return this.letterPolling;
            }
            case 1: {
                return this.yesNoPolling;
            }
        }
        return null;
    }

    public List<PollingTypeAdapter> getAllTypes() {
        return this.allTypes;
    }
}

