/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.calculator;

import com.elluminate.groupware.calculator.DyadicOperatorTerm;
import com.elluminate.util.Rational;

public class PowerOperator
extends DyadicOperatorTerm {
    double lastDouble = 0.0;
    Rational lastRational = null;

    public PowerOperator() {
        super(4);
    }

    @Override
    public double eval(double l, double r) {
        double result = Math.pow(l, r);
        if (Double.isNaN(result) && l < 0.0) {
            if (this.lastRational == null || this.lastDouble != r) {
                this.lastRational = new Rational(r);
                this.lastDouble = r;
            }
            if (this.lastRational.isRational() && (this.lastRational.getDenominator() & 1L) == 1L) {
                result = Math.pow(Math.abs(l), r);
                if ((this.lastRational.getNumerator() & 1L) == 1L) {
                    result = -result;
                }
            }
        }
        return result;
    }
}

