/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.appshare.module.x11;

import com.elluminate.groupware.appshare.AppShareDebug;
import com.elluminate.groupware.appshare.module.AppSharingHost;
import com.elluminate.groupware.appshare.module.ApplicationInformation;
import com.elluminate.groupware.appshare.module.ButtonInputEvent;
import com.elluminate.groupware.appshare.module.KeyInputEvent;
import com.elluminate.groupware.appshare.module.MouseMoveEvent;
import com.elluminate.groupware.appshare.module.ScrollWheelEvent;
import com.elluminate.groupware.appshare.module.common.ASKeyUtils;
import com.elluminate.platform.Platform;
import com.elluminate.util.Debug;
import com.elluminate.util.DebugFlag;
import com.elluminate.util.LightweightTimer;
import com.elluminate.util.SwingRunnerSupport;
import com.elluminate.util.WorkerThread;
import com.elluminate.util.log.LogSupport;
import java.awt.Color;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.Window;
import java.io.File;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class X11AppSharingHost
extends AppSharingHost {
    private static final String EXTENSION_SEARCH_PATH_PROP = "com.elluminate.appShare.x11ExtensionPath";
    private static final String SOLARIS_SEARCH_PATH = "/usr/openwin/lib:/usr/X11/lib:/usr/openwin/sfw/lib:/usr/sfw/lib:/usr/lib";
    private static final String LINUX_SEARCH_PATH = "/usr/X11/lib:/usr/X11R6/lib:/usr/lib";
    private static boolean loadedLib;
    private short bkgCol = 0;
    private int colReduceMode = 2;
    private int cacheLen = Short.MAX_VALUE;
    private int frameID = 0;
    private Thread tileScanner = null;
    private boolean sharing = false;
    private boolean hostingByApps = false;
    public static final DebugFlag FRAME;
    public static final DebugFlag COLOURMAP;
    public static final DebugFlag CURSOR;
    public static final DebugFlag X11AOI;

    protected static String[] getSearchPath() {
        String searchPath = System.getProperty(EXTENSION_SEARCH_PATH_PROP);
        if (searchPath == null) {
            switch (Platform.getOS()) {
                case 250: {
                    searchPath = SOLARIS_SEARCH_PATH;
                    break;
                }
                default: {
                    searchPath = LINUX_SEARCH_PATH;
                }
            }
        }
        StringTokenizer parser = new StringTokenizer(searchPath, ":", false);
        ArrayList<String> dirList = new ArrayList<String>(parser.countTokens());
        while (parser.hasMoreTokens()) {
            String dir = parser.nextToken();
            File f = new File(dir);
            if (!f.isDirectory()) continue;
            dirList.add(dir);
        }
        return dirList.toArray(new String[dirList.size()]);
    }

    protected static native int nativeGetLibraryVersion();

    protected static native void nativeInitializeLibrary(String[] var0);

    protected static native void nativeSetClientMask(int var0);

    protected static native void nativeCheckDisplay();

    protected native Rectangle[] nativeGetWindowRects();

    protected native ApplicationInformation[] nativeGetAppList(ApplicationInformation[] var1, String var2, int var3);

    protected native void nativeGetAppBounds(Object[] var1, Rectangle var2);

    protected native int nativeGetWindowID(Window var1);

    protected native void nativeSetIgnoredWindow(int var1);

    protected native void nativeInitialize(short var1, int var2, int var3);

    protected native void nativeTerminate();

    protected native void nativeStartRegion(int var1, int var2, int var3, int var4);

    protected native void nativeStartApp(Object[] var1, boolean var2);

    protected native void nativeChangeRegion(int var1, int var2, int var3, int var4);

    protected native void nativeStop();

    protected native void nativePause();

    protected native void nativeResume();

    protected native void nativeResend(int var1, int var2, int var3, int var4);

    protected native void nativeFlushCache();

    protected native void nativeMovePointer(int var1, int var2);

    protected native void nativeSetButton(int var1, boolean var2);

    protected native void nativeKeyInput(int var1, char var2, boolean var3);

    protected native void nativeScrollWheel(int var1);

    public X11AppSharingHost() {
        if (!loadedLib) {
            throw new RuntimeException("AppSharing not available, failed to load native library.");
        }
        Integer val = Integer.getInteger("com.elluminate.appShare.x11ClientMask");
        if (val != null) {
            X11AppSharingHost.nativeSetClientMask(val);
        }
    }

    @Override
    public void setAppFrame(Frame frame) {
        super.setAppFrame(frame);
        Runnable runner = new Runnable(){
            LightweightTimer timer = null;

            @Override
            public void run() {
                if (!X11AppSharingHost.this.appFrame.isVisible()) {
                    if (this.timer == null) {
                        this.timer = new LightweightTimer(2, (Runnable)this);
                    }
                    this.timer.scheduleIn(100L);
                    return;
                }
                X11AppSharingHost.this.frameID = X11AppSharingHost.this.nativeGetWindowID(X11AppSharingHost.this.appFrame);
            }
        };
        SwingRunnerSupport.invokeLater((Runnable)runner);
    }

    @Override
    public boolean setIgnoredWindow(final Window win) {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                int id = X11AppSharingHost.this.nativeGetWindowID(win);
                X11AppSharingHost.this.nativeSetIgnoredWindow(id);
            }
        };
        SwingRunnerSupport.invokeLater((Runnable)r);
        return true;
    }

    @Override
    public int getBaseCapabilities() {
        return 3;
    }

    @Override
    public Rectangle[] getWindowRects() {
        return this.nativeGetWindowRects();
    }

    @Override
    public ApplicationInformation[] getApplicationList(ApplicationInformation[] prevList, String me) {
        ApplicationInformation[] result = this.nativeGetAppList(prevList, me, this.frameID);
        if (result != null) {
            return result;
        }
        if (prevList != null && prevList.length == 0) {
            return prevList;
        }
        return new ApplicationInformation[0];
    }

    @Override
    public Rectangle getAppDisplayBounds(Object[] appList) {
        Rectangle bounds = new Rectangle();
        this.nativeGetAppBounds(appList, bounds);
        return bounds;
    }

    @Override
    public void keyInput(KeyInputEvent e) {
        if (!this.sharing) {
            return;
        }
        int code = e.getKeyCode();
        if (code == 0) {
            code = ASKeyUtils.remapGlyph(e.getUnicode());
        }
        this.nativeKeyInput(code, e.getUnicode(), e.getPressed());
    }

    @Override
    public void buttonInput(ButtonInputEvent e) {
        if (this.sharing) {
            this.nativeSetButton(e.getButton(), e.getPressed());
        }
    }

    @Override
    public void mouseMoved(MouseMoveEvent e) {
        if (this.sharing) {
            this.nativeMovePointer(e.getX(), e.getY());
        }
    }

    @Override
    public void scrollWheelMoved(ScrollWheelEvent ev) {
        if (this.sharing) {
            this.nativeScrollWheel(ev.getAmount());
        }
    }

    @Override
    public void pauseSending() {
        this.nativePause();
    }

    @Override
    public void resumeSending() {
        this.nativeResume();
    }

    @Override
    public void setBackgroundColor(Color colour) {
        int blue5 = colour.getBlue() >> 3;
        int green5 = colour.getGreen() >> 3;
        int red5 = colour.getRed() >> 3;
        this.bkgCol = (short)(red5 << 10 | green5 << 5 | blue5);
    }

    @Override
    public void setHistoryCount(int historyCnt) {
        this.cacheLen = historyCnt;
    }

    @Override
    public void setColorReduction(int reduceMode) {
        this.colReduceMode = reduceMode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void showRegion(final Rectangle rgn) {
        if (rgn.isEmpty()) {
            LogSupport.message((Object)this, (String)"showRegion", (String)"Empty AppSharing region.");
            throw new RuntimeException("Empty AppSharing region.");
        }
        this.areaOfInterest.setBounds(rgn);
        Debug.lockEnter((Object)this, (String)"showRegion", (String)"Start/Stop Lock", (Object)this);
        try {
            X11AppSharingHost x11AppSharingHost = this;
            synchronized (x11AppSharingHost) {
                Thread tmp = this.tileScanner;
                if (tmp != null) {
                    if (tmp.isAlive()) {
                        LogSupport.message((Object)this, (String)"showRegion", (String)"AppSharing already running.");
                        throw new RuntimeException("AppSharing already running.");
                    }
                    this.tileScanner = null;
                }
                try {
                    this.nativeInitialize(this.bkgCol, this.cacheLen, this.colReduceMode);
                    tmp = new WorkerThread(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                X11AppSharingHost.this.nativeStartRegion(rgn.x, rgn.y, rgn.width, rgn.height);
                            }
                            catch (Throwable t) {
                                LogSupport.exception((Object)this, (String)"run", (Throwable)t, (boolean)true);
                                X11AppSharingHost.this.fireShutDown(4);
                            }
                        }
                    }, "X11TileScanner-Region");
                    tmp.setDaemon(true);
                    tmp.start();
                    this.tileScanner = tmp;
                    this.hostingByApps = false;
                }
                catch (RuntimeException rex) {
                    LogSupport.exception((Object)this, (String)"showRegion", (Throwable)rex, (boolean)true);
                    throw rex;
                }
                catch (Throwable t) {
                    LogSupport.exception((Object)this, (String)"showRegion", (Throwable)t, (boolean)true);
                    throw new RuntimeException("Failed to start AppSharing: " + t);
                }
            }
        }
        finally {
            Debug.lockLeave((Object)this, (String)"showRegion", (String)"Start/Stop Lock", (Object)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void showApplications(final Object[] appList, final boolean raise) {
        if (appList == null || appList.length == 0) {
            LogSupport.message((Object)this, (String)"showApplications", (String)"Empty AppSharing application list.");
            throw new RuntimeException("Empty AppSharing application list.");
        }
        this.areaOfInterest.setBounds(0, 0, 0, 0);
        Debug.lockEnter((Object)this, (String)"showApplications", (String)"Start/Stop Lock", (Object)this);
        try {
            X11AppSharingHost x11AppSharingHost = this;
            synchronized (x11AppSharingHost) {
                Thread tmp = this.tileScanner;
                if (tmp != null) {
                    if (tmp.isAlive()) {
                        LogSupport.message((Object)this, (String)"showApplications", (String)"AppSharing already running.");
                        throw new RuntimeException("AppSharing already running.");
                    }
                    this.tileScanner = null;
                }
                try {
                    this.nativeInitialize(this.bkgCol, this.cacheLen, this.colReduceMode);
                    tmp = new WorkerThread(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                X11AppSharingHost.this.nativeStartApp(appList, raise);
                            }
                            catch (Throwable t) {
                                LogSupport.exception((Object)this, (String)"run", (Throwable)t, (boolean)true);
                                X11AppSharingHost.this.fireShutDown(4);
                            }
                        }
                    }, "X11TileScanner-Apps");
                    tmp.setDaemon(true);
                    tmp.start();
                    this.tileScanner = tmp;
                    this.hostingByApps = true;
                }
                catch (RuntimeException rex) {
                    LogSupport.exception((Object)this, (String)"showApplications", (Throwable)rex, (boolean)true);
                    throw rex;
                }
                catch (Throwable t) {
                    LogSupport.exception((Object)this, (String)"showApplications", (Throwable)t, (boolean)true);
                    throw new RuntimeException("Failed to start AppSharing: " + t);
                }
            }
        }
        finally {
            Debug.lockLeave((Object)this, (String)"showApplications", (String)"Start/Stop Lock", (Object)this);
        }
    }

    @Override
    public boolean isLiveRegionResizeAvailable() {
        return true;
    }

    @Override
    public void changeRegion(Rectangle region) {
        this.nativeChangeRegion(region.x, region.y, region.width, region.height);
    }

    @Override
    public boolean isShowing() {
        Thread tmp = this.tileScanner;
        if (tmp == null) {
            return false;
        }
        return tmp.isAlive();
    }

    public boolean isSharing() {
        return this.sharing;
    }

    @Override
    public boolean isShowingRegion() {
        return this.isShowing() && !this.hostingByApps;
    }

    @Override
    public boolean isShowingApplications() {
        return this.isShowing() && this.hostingByApps;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setSharing(boolean on) {
        Debug.lockEnter((Object)this, (String)"setSharing", (String)"Start/Stop Lock", (Object)this);
        try {
            X11AppSharingHost x11AppSharingHost = this;
            synchronized (x11AppSharingHost) {
                block9: {
                    if (this.sharing != on) break block9;
                    return;
                }
                if (on && this.tileScanner == null) {
                    throw new IllegalStateException("App show not enabled before sharing turned on.");
                }
                this.sharing = on;
            }
        }
        finally {
            Debug.lockLeave((Object)this, (String)"setSharing", (String)"Start/Stop Lock", (Object)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        this.hideAperture();
        this.areaOfInterest.setBounds(0, 0, 0, 0);
        this.hostingByApps = false;
        Debug.lockEnter((Object)this, (String)"stop", (String)"Start/Stop Lock", (Object)this);
        try {
            X11AppSharingHost x11AppSharingHost = this;
            synchronized (x11AppSharingHost) {
                Thread tmp = this.tileScanner;
                this.tileScanner = null;
                long waitStart = System.currentTimeMillis();
                long waitUntil = waitStart + 5000L;
                long dt = 5001L;
                do {
                    try {
                        this.setSharing(false);
                        this.nativeStop();
                        if (tmp == Thread.currentThread()) {
                            LogSupport.message((Object)this, (String)"stop", (String)("WARNING: called from TileScanner thread!\n" + Debug.getStackTrace((Throwable)new RuntimeException())));
                            break;
                        }
                        if (tmp == null) continue;
                        tmp.join(1000L);
                    }
                    catch (Throwable ex) {
                        long elapsed;
                        if (AppShareDebug.HOST.show()) {
                            LogSupport.message((Object)this, (String)"stop", (String)("Thread.join failed: " + Debug.getStackTrace((Throwable)ex)));
                        }
                        if ((elapsed = System.currentTimeMillis() - waitStart) >= 200L) continue;
                        try {
                            Thread.sleep(250L - elapsed);
                        }
                        catch (Throwable ignored) {
                            // empty catch block
                        }
                    }
                } while ((dt = waitUntil - (waitStart = System.currentTimeMillis())) > 1L && tmp != null && tmp.isAlive());
                if (tmp != null && tmp.isAlive()) {
                    LogSupport.exception((Object)this, (String)"stop", (Throwable)new RuntimeException("TileScanner ignored STOP"), (boolean)true, (String)tmp.toString());
                }
                this.nativeTerminate();
            }
        }
        finally {
            Debug.lockLeave((Object)this, (String)"stop", (String)"Start/Stop Lock", (Object)this);
        }
    }

    @Override
    public void flush() {
        this.nativeFlushCache();
    }

    @Override
    public void resend(Rectangle rgn) {
        this.nativeResend(rgn.x, rgn.y, rgn.width, rgn.height);
    }

    @Override
    public void resend() {
        this.nativeResend(0, 0, 65535, 65535);
    }

    static {
        block6: {
            loadedLib = false;
            try {
                System.loadLibrary("X11AppSharing");
                int libVers = 65536;
                try {
                    libVers = X11AppSharingHost.nativeGetLibraryVersion();
                }
                catch (Throwable ignored) {
                    // empty catch block
                }
                LogSupport.message((String)("Loaded X11AppSharing native lib, version " + (libVers >> 16) + "." + (libVers >> 8 & 0xFF) + "." + (libVers & 0xFF)));
                try {
                    String[] searchDirs = X11AppSharingHost.getSearchPath();
                    X11AppSharingHost.nativeInitializeLibrary(searchDirs);
                    X11AppSharingHost.nativeCheckDisplay();
                    loadedLib = true;
                }
                catch (Throwable t) {
                    loadedLib = false;
                    LogSupport.message(X11AppSharingHost.class, (String)"<clinit>", (String)("X display cannot host AppSharing: " + Debug.getStackTrace((Throwable)t)));
                }
            }
            catch (Throwable t) {
                loadedLib = false;
                if (!AppShareDebug.HOST.show()) break block6;
                LogSupport.message(X11AppSharingHost.class, (String)"<clinit>", (String)("Failed to load library: " + Debug.getStackTrace((Throwable)t)));
            }
        }
        FRAME = DebugFlag.get((String)"appShare.x11.frame");
        COLOURMAP = DebugFlag.get((String)"appShare.x11.colourmap");
        CURSOR = DebugFlag.get((String)"appShare.x11.cursor");
        X11AOI = DebugFlag.get((String)"appShare.x11.aoi");
    }
}

