/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.appshare.module.windows;

import com.elluminate.groupware.appshare.module.ApplicationInformation;
import com.elluminate.groupware.appshare.module.windows.StringsProperties;
import com.elluminate.gui.GuiUtils;
import com.elluminate.util.I18n;
import com.elluminate.util.PropertiesEnum;
import java.io.File;
import java.util.ArrayList;
import java.util.Locale;
import javax.swing.Icon;

public final class WinProcessInfo
implements ApplicationInformation {
    static I18n i18n = I18n.create(WinProcessInfo.class);
    static final String JAVA_APP_DESC = i18n.getString((PropertiesEnum)StringsProperties.WINPROCESSINFO_JAVAAPPDESCRIPTION);
    int pid;
    Integer key;
    String path;
    String desc;
    String name;
    Icon icon;
    ArrayList titles = new ArrayList(16);

    public WinProcessInfo(int pid, String path, String desc) {
        this.pid = pid;
        this.key = new Integer(pid);
        this.path = path;
        if (path != null) {
            this.name = new File(path).getName().toLowerCase(Locale.ENGLISH);
            this.icon = WinProcessInfo.getFileIcon(path);
        } else {
            this.name = null;
            this.icon = null;
        }
        this.desc = ("java.exe".equalsIgnoreCase(this.name) || "javaw.exe".equalsIgnoreCase(this.name)) && desc != null && desc.startsWith("Java(TM)") ? JAVA_APP_DESC : desc;
    }

    @Override
    public String getAppName() {
        if (this.desc != null) {
            return this.desc;
        }
        if (this.name != null) {
            return this.name;
        }
        return "Process " + this.pid;
    }

    @Override
    public String getAppPath() {
        return this.path;
    }

    @Override
    public int getWindowCount() {
        return this.titles.size();
    }

    @Override
    public String getWindowTitle(int which) {
        return (String)this.titles.get(which);
    }

    @Override
    public Icon getWindowIcon(int which) {
        return null;
    }

    @Override
    public String[] getWindowTitles() {
        return this.titles.toArray(new String[this.titles.size()]);
    }

    @Override
    public Object getKey() {
        return this.key;
    }

    @Override
    public Icon getAppIcon() {
        return this.icon;
    }

    public int getProcessID() {
        return this.pid;
    }

    void addWindow(String title) {
        this.titles.add(title);
    }

    public String toString() {
        String promoted = this.titles.size() == 1 ? " '" + this.getWindowTitle(0) + "'" : "";
        if (this.desc != null && this.name != null) {
            return this.desc + " (" + this.name + ")" + promoted;
        }
        if (this.path != null) {
            return this.path + promoted;
        }
        if (this.desc != null) {
            return this.desc + promoted;
        }
        if (!this.titles.isEmpty()) {
            return this.getWindowTitle(0);
        }
        return "Process " + this.pid;
    }

    public boolean equals(Object o) {
        try {
            WinProcessInfo other = (WinProcessInfo)o;
            if (other.pid != this.pid) {
                return false;
            }
            if (this.path != null || other.path != null) {
                if (this.path == null) {
                    return false;
                }
                if (!this.path.equals(other.path)) {
                    return false;
                }
            } else if (this.desc != null || other.desc != null) {
                if (this.desc == null) {
                    return false;
                }
                if (!this.desc.equals(other.desc)) {
                    return false;
                }
            }
            return this.titles.equals(other.titles);
        }
        catch (Exception ex) {
            return false;
        }
    }

    public int hashCode() {
        return this.pid;
    }

    private static Icon getFileIcon(String file) {
        if (file == null) {
            return null;
        }
        return GuiUtils.getFileIcon((File)new File(file));
    }
}

