/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.appshare.module.windows;

import com.elluminate.groupware.appshare.AppShareDebug;
import com.elluminate.groupware.appshare.module.AppSharingHost;
import com.elluminate.groupware.appshare.module.ApplicationInformation;
import com.elluminate.groupware.appshare.module.ButtonInputEvent;
import com.elluminate.groupware.appshare.module.KeyInputEvent;
import com.elluminate.groupware.appshare.module.MouseMoveEvent;
import com.elluminate.groupware.appshare.module.ScrollWheelEvent;
import com.elluminate.groupware.appshare.module.windows.WinProcessInfo;
import com.elluminate.gui.GuiUtils;
import com.elluminate.platform.Platform;
import com.elluminate.util.Resource;
import com.elluminate.util.ThreadUtils;
import com.elluminate.util.WorkerThread;
import com.elluminate.util.log.LogSupport;
import java.awt.Color;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.Window;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;

public final class WinASHost
extends AppSharingHost
implements Runnable {
    private static final int STOP_NO_REASON = 0;
    private static final int STOP_BY_SERVER = 1;
    private static final int STOP_APP_EXIT = 2;
    private static final int STOP_SCREEN_SIZE = 3;
    private static final String BROKER32_APP = "eLiveASBroker32.exe";
    private static final String BROKER64_APP = "eLiveASBroker64.exe";
    private static final String HOOK32_DLL = "eLiveASHooks32.dll";
    private static final String HOOK64_DLL = "eLiveASHooks64.dll";
    private static final String HOST32_DLL = "eLiveASHost32.dll";
    private static final String HOST64_DLL = "eLiveASHost64.dll";
    private static final String SUBDIR32 = "x86/";
    private static final String SUBDIR64 = "x86_64/";
    private static int[] bounds = new int[64];
    private static Rectangle[] windows = null;
    protected short bkgndColor;
    protected int escapeKeyCode;
    protected int escapeKeyMask;
    protected int historyCnt;
    protected int sendWinSize;
    protected Thread writerThread;
    protected volatile boolean writerThreadRunning;
    protected Object[] runningApps;
    private static boolean librariesLoaded = false;

    static native boolean nativeExtraPrivilegesAvailable();

    static native String nativeGetVersion();

    static native void nativeSetDebug(boolean var0);

    protected native void nativeButtonInput(int var1, boolean var2);

    protected native void nativeColorReduction(int var1);

    protected native void nativeFlushCache();

    protected native int nativeGetAppWindows(int[] var1, Object var2);

    protected native Object[] nativeGetApplicationList(Object[] var1, String var2);

    protected native String nativeGetThreadState();

    protected native void nativeKeyInput(char var1, int var2, boolean var3);

    protected native void nativeMouseMoved(int var1, int var2);

    protected native void nativeMouseWheel(int var1);

    protected native void nativePauseSending();

    protected native void nativeReleaseExtraPrivileges();

    protected native boolean nativeRequestExtraPrivileges();

    protected native void nativeResend(int var1, int var2, int var3, int var4);

    protected native void nativeResendAll();

    protected native void nativeResumeSending();

    protected native boolean nativeSetIgnoredWindow(long var1);

    protected native void nativeSetSharing(boolean var1);

    protected native void nativeShowApplications(Object[] var1, boolean var2);

    protected native void nativeShowRegion(int var1, int var2, int var3, int var4);

    protected native void nativeChangeRegion(int var1, int var2, int var3, int var4);

    protected native void nativeStop();

    protected native void nativeWriter();

    protected native boolean nativeWriterReady();

    public WinASHost() {
        if (!librariesLoaded) {
            throw new RuntimeException("DLLs not available.");
        }
        this.escapeKeyCode = 0;
        this.escapeKeyMask = 0;
        this.writerThreadRunning = false;
        this.runningApps = null;
        WinASHost.nativeSetDebug(AppShareDebug.NATIVE.isEnabled());
        AppShareDebug.NATIVE.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent pce) {
                WinASHost.nativeSetDebug(AppShareDebug.NATIVE.isEnabled());
            }
        });
    }

    @Override
    public void buttonInput(ButtonInputEvent e) {
        try {
            this.nativeButtonInput(e.getButton(), e.getPressed());
        }
        catch (Throwable t) {
            LogSupport.message((Object)this, (String)"buttonInput", (String)("nativeButtonInput failed: " + t));
            this.fireShutDown(4);
        }
    }

    @Override
    public boolean extraPrivilegesAvailable() {
        return WinASHost.nativeExtraPrivilegesAvailable();
    }

    @Override
    public void flush() {
        this.nativeFlushCache();
    }

    @Override
    public Rectangle getAppDisplayBounds(Object[] appList) {
        Rectangle boundingRect = null;
        int count = -1;
        for (int a = 0; a < appList.length; ++a) {
            while ((count = this.nativeGetAppWindows(bounds, appList[a])) < 0) {
                bounds = new int[bounds.length * 2];
            }
            int i = 0;
            int j = 0;
            while (i < count) {
                Rectangle window = new Rectangle(bounds[j], bounds[j + 1], bounds[j + 2], bounds[j + 3]);
                if (!window.isEmpty()) {
                    boundingRect = boundingRect == null ? window : boundingRect.union(window);
                }
                ++i;
                j += 4;
            }
        }
        if (boundingRect == null) {
            return new Rectangle();
        }
        return boundingRect;
    }

    @Override
    public ApplicationInformation[] getApplicationList(ApplicationInformation[] prevList, String me) {
        return (ApplicationInformation[])this.nativeGetApplicationList(prevList, me);
    }

    @Override
    public int getBaseCapabilities() {
        return 3;
    }

    private String getThreadInfo(Thread t, boolean isRunning) {
        StackTraceElement[] trace;
        StringBuffer status = new StringBuffer();
        boolean isAlive = t.isAlive();
        status.append(isAlive ? (isRunning ? "Running" : "Zombie") : (isRunning ? "Failed" : "Stopped"));
        status.append(" state=" + (Object)((Object)t.getState()));
        String blockInfo = ThreadUtils.getThreadBlockingInfo((Thread)t);
        if (blockInfo != null && blockInfo.length() > 0) {
            status.append("\nblocking: " + blockInfo);
        }
        if ((trace = t.getStackTrace()) != null) {
            for (int ix = 0; ix < trace.length; ++ix) {
                status.append("\n  " + trace[ix]);
            }
        }
        return status.toString();
    }

    @Override
    public Rectangle[] getWindowRects() {
        int count = -1;
        while ((count = this.nativeGetAppWindows(bounds, null)) < 0) {
            bounds = new int[bounds.length * 2];
        }
        if (windows != null && windows.length == count) {
            boolean unchanged = true;
            int j = 0;
            for (int i = 0; unchanged && i < count; ++i) {
                Rectangle w = windows[i];
                if (w.x != bounds[j++]) {
                    unchanged = false;
                    continue;
                }
                if (w.y != bounds[j++]) {
                    unchanged = false;
                    continue;
                }
                if (w.width != bounds[j++]) {
                    unchanged = false;
                    continue;
                }
                if (w.height == bounds[j++]) continue;
                unchanged = false;
            }
            if (unchanged) {
                return windows;
            }
        }
        windows = new Rectangle[count];
        int i = 0;
        int j = 0;
        while (i < count) {
            WinASHost.windows[i] = new Rectangle(bounds[j], bounds[j + 1], bounds[j + 2], bounds[j + 3]);
            ++i;
            j += 4;
        }
        return windows;
    }

    @Override
    public void keyInput(KeyInputEvent e) {
        try {
            this.nativeKeyInput(e.getUnicode(), e.getKeyCode(), e.getPressed());
        }
        catch (Throwable t) {
            LogSupport.message((Object)this, (String)"keyInput", (String)("nativeKeyInput failed: " + t));
            this.fireShutDown(4);
        }
    }

    @Override
    public void mouseMoved(MouseMoveEvent e) {
        try {
            this.nativeMouseMoved(e.getX(), e.getY());
        }
        catch (Throwable t) {
            LogSupport.message((Object)this, (String)"mouseMoved", (String)("nativeMouseMoved failed: " + t));
            this.fireShutDown(4);
        }
    }

    @Override
    public void pauseSending() {
        this.nativePauseSending();
    }

    @Override
    public void releaseExtraPrivileges() {
        this.nativeReleaseExtraPrivileges();
    }

    @Override
    public boolean requestExtraPrivileges() {
        return this.nativeRequestExtraPrivileges();
    }

    @Override
    public void resend() {
        this.nativeResendAll();
    }

    @Override
    public void resend(Rectangle rgn) {
        int col = rgn.x / 16;
        int row = rgn.y / 16;
        int w = (rgn.x + rgn.width - 1) / 16 - col + 1;
        int h = (rgn.y + rgn.height - 1) / 16 - row + 1;
        this.nativeResend(col, row, w, h);
    }

    @Override
    public void resumeSending() {
        this.nativeResumeSending();
    }

    @Override
    public void run() {
        this.writerThreadRunning = true;
        try {
            this.nativeWriter();
            this.writerThreadRunning = false;
        }
        catch (Throwable t) {
            this.writerThreadRunning = false;
            LogSupport.message((Object)this, (String)"run", (String)("writerThread failed: " + t));
            this.fireShutDown(4);
        }
    }

    @Override
    public void scrollWheelMoved(ScrollWheelEvent ev) {
        try {
            this.nativeMouseWheel(ev.getAmount());
        }
        catch (Throwable t) {
            LogSupport.message((Object)this, (String)"scrollWheelMoved", (String)("nativeMouseWheel failed: " + t));
            this.fireShutDown(4);
        }
    }

    @Override
    public void setBackgroundColor(Color color) {
        int blue5 = color.getBlue() >> 3;
        int green5 = color.getGreen() >> 3;
        int red5 = color.getRed() >> 3;
        this.bkgndColor = (short)(red5 << 10 | green5 << 5 | blue5);
    }

    @Override
    public void setColorReduction(int reduceMode) {
        this.nativeColorReduction(reduceMode);
    }

    @Override
    public void setHistoryCount(int historyCnt) {
        this.historyCnt = historyCnt;
    }

    @Override
    public boolean setIgnoredWindow(Window w) {
        Number h;
        long hwnd = 0L;
        if (w != null && (h = (Number)GuiUtils.getWindowHandle((Component)w)) != null) {
            hwnd = h.longValue();
        }
        return this.nativeSetIgnoredWindow(hwnd);
    }

    @Override
    public void setSharing(boolean share) {
        this.nativeSetSharing(share);
    }

    @Override
    public void showApplications(Object[] apps, boolean raiseWindows) {
        this.areaOfInterest.setBounds(0, 0, 0, 0);
        this.runningApps = apps;
        this.startShowing();
        try {
            this.nativeShowApplications(apps, raiseWindows);
        }
        catch (Throwable t) {
            LogSupport.message((Object)this, (String)"showApplications", (String)("nativeShowApplications failed: " + t));
            this.fireShutDown(4);
        }
    }

    @Override
    public void showRegion(Rectangle rgn) {
        this.areaOfInterest.setBounds(rgn);
        this.runningApps = null;
        this.startShowing();
        try {
            this.nativeShowRegion(rgn.x, rgn.y, rgn.width, rgn.height);
        }
        catch (Throwable t) {
            LogSupport.message((Object)this, (String)"showRegion", (String)("nativeShowRegion failed: " + t));
            this.fireShutDown(4);
        }
    }

    @Override
    public boolean isLiveRegionResizeAvailable() {
        return true;
    }

    @Override
    public void changeRegion(Rectangle region) {
        if (!this.isShowingRegion()) {
            throw new IllegalStateException("Not showing a region");
        }
        this.nativeChangeRegion(region.x, region.y, region.width, region.height);
    }

    private boolean startShowing() {
        StringBuffer status;
        if (!this.writerThreadRunning) {
            this.writerThreadRunning = true;
            this.writerThread = new WorkerThread((Runnable)this, "WinASHostWriter");
            this.writerThread.setDaemon(true);
            this.writerThread.start();
        } else {
            status = new StringBuffer();
            status.append(this.writerThread);
            if (this.writerThread != null) {
                status.append(" " + this.getThreadInfo(this.writerThread, this.writerThreadRunning));
                status.append("\nNative state: " + this.nativeGetThreadState());
            }
            LogSupport.message((Object)this, (String)"startShowing", (String)("writerThread already running: " + status));
        }
        while (this.writerThreadRunning && !this.nativeWriterReady()) {
            try {
                Thread.sleep(20L);
            }
            catch (InterruptedException ex) {}
        }
        if (this.nativeWriterReady()) {
            return true;
        }
        if (!this.nativeWriterReady()) {
            status = new StringBuffer();
            status.append(this.writerThread);
            if (this.writerThread != null) {
                status.append(" " + this.getThreadInfo(this.writerThread, this.writerThreadRunning));
            }
            LogSupport.message((Object)this, (String)"startShowing", (String)("writerThread failed to start " + status));
        }
        LogSupport.message((Object)this, (String)"startShowing", (String)("Native state: " + this.nativeGetThreadState()));
        try {
            this.nativeStop();
        }
        catch (Throwable t) {
            this.writerThreadRunning = false;
        }
        throw new RuntimeException("Unable to start application sharing.");
    }

    @Override
    public boolean isShowing() {
        return this.writerThreadRunning;
    }

    @Override
    public boolean isShowingRegion() {
        return this.isShowing() && this.runningApps == null;
    }

    @Override
    public boolean isShowingApplications() {
        return this.isShowing() && this.runningApps != null;
    }

    @Override
    public void stop() {
        this.runningApps = null;
        this.hideAperture();
        this.areaOfInterest.setBounds(0, 0, 0, 0);
        try {
            this.nativeStop();
        }
        catch (Throwable t) {
            StringBuffer status = new StringBuffer();
            status.append("\nwriterThread=" + this.writerThread);
            if (this.writerThread != null) {
                status.append(" " + this.getThreadInfo(this.writerThread, this.writerThreadRunning));
            }
            status.append("\nNative state: " + this.nativeGetThreadState());
            this.writerThreadRunning = false;
            LogSupport.exception((Object)this, (String)"stop", (Throwable)t, (boolean)true, (String)status.toString());
        }
    }

    public void updateRunningApps(int[] apps) {
        if (apps == null || apps.length == 0) {
            return;
        }
        if (this.runningApps == null) {
            return;
        }
        if (this.runningApps.length == 0) {
            return;
        }
        ArrayList<WinProcessInfo> list = new ArrayList<WinProcessInfo>();
        for (int ix = 0; ix < this.runningApps.length; ++ix) {
            if (this.runningApps[ix] == null || !(this.runningApps[ix] instanceof WinProcessInfo)) continue;
            boolean running = false;
            WinProcessInfo pInfo = (WinProcessInfo)this.runningApps[ix];
            int pid = pInfo.getProcessID();
            for (int px = 0; px < apps.length; ++px) {
                if (pid != apps[px]) continue;
                running = true;
                list.add(pInfo);
                break;
            }
            if (running) continue;
            this.runningApps[ix] = null;
            if (!AppShareDebug.HOST.show()) continue;
            LogSupport.message((Object)this, (String)"updateRunningApps", (String)("Application has terminated: " + pInfo));
        }
        this.fireRunningApplicationsChanged(list.toArray());
    }

    static {
        try {
            File host64Dll;
            File host32Dll;
            File hook64Dll;
            File hook32Dll;
            File dllDir;
            File broker64App;
            File broker32App;
            Resource broker64;
            Resource broker32;
            block20: {
                Resource host64;
                block19: {
                    Resource host32;
                    block18: {
                        Resource hook64;
                        block17: {
                            Object context = new Object(){};
                            broker32 = new Resource(context, "x86/eLiveASBroker32.exe");
                            broker64 = new Resource(context, "x86_64/eLiveASBroker64.exe");
                            Resource hook32 = new Resource(context, "x86/eLiveASHooks32.dll");
                            hook64 = new Resource(context, "x86_64/eLiveASHooks64.dll");
                            host32 = new Resource(context, "x86/eLiveASHost32.dll");
                            host64 = new Resource(context, "x86_64/eLiveASHost64.dll");
                            broker32App = null;
                            broker64App = null;
                            dllDir = null;
                            hook32Dll = null;
                            hook64Dll = null;
                            host32Dll = null;
                            host64Dll = null;
                            File tmpDir = Platform.getTempDir();
                            for (int i = 0; i < 9; ++i) {
                                File subdir = new File(tmpDir, "eLiveAS" + i + ".tmp");
                                if (subdir.exists() && subdir.isDirectory() && ((host32Dll = new File(subdir, HOST32_DLL)).exists() && !host32Dll.delete() || (host64Dll = new File(subdir, HOST64_DLL)).exists() && !host64Dll.delete() || (hook32Dll = new File(subdir, HOOK32_DLL)).exists() && !hook32Dll.delete() || (hook64Dll = new File(subdir, HOOK64_DLL)).exists() && !hook64Dll.delete() || (broker32App = new File(subdir, BROKER32_APP)).exists() && !broker32App.delete() || (broker64App = new File(subdir, BROKER64_APP)).exists() && !broker64App.delete())) continue;
                                subdir.delete();
                                if (dllDir != null || subdir.exists()) continue;
                                dllDir = subdir;
                            }
                            dllDir.mkdir();
                            hook32Dll = new File(dllDir, HOOK32_DLL);
                            hook64Dll = new File(dllDir, HOOK64_DLL);
                            host32Dll = new File(dllDir, HOST32_DLL);
                            host64Dll = new File(dllDir, HOST64_DLL);
                            try {
                                hook32.save(hook32Dll.getPath());
                            }
                            catch (IOException ex) {
                                if (hook32Dll.length() == (long)hook32.length()) break block17;
                                throw ex;
                            }
                        }
                        try {
                            hook64.save(hook64Dll.getPath());
                        }
                        catch (IOException ex) {
                            if (hook64Dll.length() == (long)hook64.length()) break block18;
                            throw ex;
                        }
                    }
                    try {
                        host32.save(host32Dll.getPath());
                    }
                    catch (IOException ex) {
                        if (host32Dll.length() == (long)host32.length()) break block19;
                        throw ex;
                    }
                }
                try {
                    host64.save(host64Dll.getPath());
                }
                catch (IOException ex) {
                    if (host64Dll.length() == (long)host64.length()) break block20;
                    throw ex;
                }
            }
            if (Platform.is64BitAddressable()) {
                System.load(hook64Dll.getPath());
                System.load(host64Dll.getPath());
                LogSupport.message((String)("Loaded native library eLiveASHost64.dll, version " + WinASHost.nativeGetVersion()));
            } else {
                System.load(hook32Dll.getPath());
                System.load(host32Dll.getPath());
                LogSupport.message((String)("Loaded native library eLiveASHost32.dll, version " + WinASHost.nativeGetVersion()));
            }
            librariesLoaded = true;
            try {
                broker32App = new File(dllDir, BROKER32_APP);
                broker32.save(broker32App.getPath());
            }
            catch (IOException ex) {
                LogSupport.message((String)("Cannot save eLiveASBroker32.exe: " + ex));
            }
            try {
                broker64App = new File(dllDir, BROKER64_APP);
                broker64.save(broker64App.getPath());
            }
            catch (IOException ex) {
                LogSupport.message((String)("Cannot save eLiveASBroker64.exe: " + ex));
            }
        }
        catch (Throwable ex) {
            LogSupport.message((String)("Cannot load app-sharing native code: " + ex));
        }
    }

    final class AppInfo {
        int pid;
        String title;

        public AppInfo(int pid, String title) {
            this.pid = pid;
            this.title = title;
        }

        public boolean equals(Object o) {
            try {
                AppInfo other = (AppInfo)o;
                return other.pid == this.pid;
            }
            catch (Exception ex) {
                return false;
            }
        }

        public int hashCode() {
            return this.pid;
        }

        public String toString() {
            return this.title;
        }
    }
}

