/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.appshare.module;

import com.elluminate.groupware.appshare.module.AppShareBean;
import com.elluminate.groupware.appshare.module.StringsProperties;
import com.elluminate.gui.component.AbstractPreferencesPanel;
import com.elluminate.gui.component.CColorPicker;
import com.elluminate.gui.component.PreferencesPanelOwner;
import com.elluminate.util.I18n;
import com.elluminate.util.Preferences;
import com.elluminate.util.PropertiesEnum;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

@Singleton
public class ViewingPrefsPanel
extends AbstractPreferencesPanel {
    private I18n i18n;
    private JCheckBox presentedSharingBox;
    private CColorPicker presentedSharingColor;
    private JCheckBox controlledSharingBox;
    private CColorPicker controlledSharingColor;

    @Inject
    public ViewingPrefsPanel(PreferencesPanelOwner owner, I18n i18n) {
        super(owner, i18n.getString((PropertiesEnum)StringsProperties.VIEWINGPREFSPANEL_TITLE));
        this.i18n = i18n;
    }

    protected void createContent() {
        JPanel content = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        this.setLayout(new BorderLayout());
        this.add(content, "Center");
        gbc.gridx = 0;
        gbc.fill = 2;
        gbc.anchor = 17;
        gbc.weightx = 1.0;
        gbc.insets.top = 0;
        gbc.insets.left = 0;
        gbc.insets.bottom = 6;
        gbc.insets.right = 0;
        JLabel label = new JLabel(this.i18n.getString((PropertiesEnum)StringsProperties.VIEWINGPREFSPANEL_BORDERSLABEL));
        content.add((Component)label, gbc);
        gbc.insets.bottom = 0;
        gbc.insets.left = 20;
        Box presentedPane = Box.createHorizontalBox();
        this.presentedSharingBox = new JCheckBox(this.i18n.getString((PropertiesEnum)StringsProperties.VIEWINGPREFSPANEL_PRESENTEDBTN));
        this.presentedSharingBox.setToolTipText(this.i18n.getString((PropertiesEnum)StringsProperties.VIEWINGPREFSPANEL_PRESENTEDTIP));
        this.presentedSharingColor = new CColorPicker(AppShareBean.DFT_PRESENTED_SHARING_COLOR);
        presentedPane.add(this.presentedSharingBox);
        presentedPane.add(Box.createHorizontalStrut(12));
        presentedPane.add((Component)this.presentedSharingColor);
        presentedPane.add(Box.createHorizontalGlue());
        content.add((Component)presentedPane, gbc);
        Box controlledPane = Box.createHorizontalBox();
        this.controlledSharingBox = new JCheckBox(this.i18n.getString((PropertiesEnum)StringsProperties.VIEWINGPREFSPANEL_CONTROLLEDBTN));
        this.controlledSharingBox.setToolTipText(this.i18n.getString((PropertiesEnum)StringsProperties.VIEWINGPREFSPANEL_CONTROLLEDTIP));
        this.controlledSharingColor = new CColorPicker(AppShareBean.DFT_CONTROLLED_SHARING_COLOR);
        controlledPane.add(this.controlledSharingBox);
        controlledPane.add(Box.createHorizontalStrut(12));
        controlledPane.add((Component)this.controlledSharingColor);
        controlledPane.add(Box.createHorizontalGlue());
        content.add((Component)controlledPane, gbc);
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ViewingPrefsPanel.this.setModified(true);
            }
        };
        PropertyChangeListener propListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent ev) {
                ViewingPrefsPanel.this.setModified(true);
            }
        };
        this.presentedSharingBox.addActionListener(actionListener);
        this.controlledSharingBox.addActionListener(actionListener);
        this.presentedSharingColor.addPropertyChangeListener("color", propListener);
        this.controlledSharingColor.addPropertyChangeListener("color", propListener);
    }

    protected void populate(Preferences preferences) {
        String prefix = this.getOwnerPrefix();
        boolean selected = preferences.getBooleanSetting(prefix + ".presentedSharingEnabled", true);
        Color color = preferences.getColorSetting(prefix + ".presentedSharingColor", AppShareBean.DFT_PRESENTED_SHARING_COLOR);
        this.presentedSharingBox.setSelected(selected);
        this.presentedSharingColor.setColor(color);
        selected = preferences.getBooleanSetting(prefix + ".controlledSharingEnabled", true);
        color = preferences.getColorSetting(prefix + ".controlledSharingColor", AppShareBean.DFT_CONTROLLED_SHARING_COLOR);
        this.controlledSharingBox.setSelected(selected);
        this.controlledSharingColor.setColor(color);
    }

    protected void apply(Preferences preferences) {
        String prefix = this.getOwnerPrefix();
        boolean selected = this.presentedSharingBox.isSelected();
        Color color = this.presentedSharingColor.getColor();
        preferences.setSetting(prefix + ".presentedSharingEnabled", selected);
        preferences.setSetting(prefix + ".presentedSharingColor", color);
        selected = this.controlledSharingBox.isSelected();
        color = this.controlledSharingColor.getColor();
        preferences.setSetting(prefix + ".controlledSharingEnabled", selected);
        preferences.setSetting(prefix + ".controlledSharingColor", color);
    }

    protected void reset(Preferences preferences) {
        String prefix = this.getOwnerPrefix();
        preferences.setSetting(prefix + ".presentedSharingEnabled", true);
        preferences.setSetting(prefix + ".presentedSharingColor", AppShareBean.DFT_PRESENTED_SHARING_COLOR);
        preferences.setSetting(prefix + ".controlledSharingEnabled", true);
        preferences.setSetting(prefix + ".controlledSharingColor", AppShareBean.DFT_CONTROLLED_SHARING_COLOR);
    }
}

