/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.appshare.module;

import com.elluminate.groupware.appshare.AppShareMessage;
import com.elluminate.groupware.appshare.AppShareMessageHandler;
import com.elluminate.groupware.appshare.AppShareProtocol;
import com.elluminate.jinx.ClientInfo;
import com.elluminate.jinx.ClientList;
import com.elluminate.jinx.PropertyValue;
import com.elluminate.util.Debug;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

public final class SubscriptionManager {
    public static final short UP_TO_DATE_OK = 256;
    public static final short UP_TO_DATE_BEHIND = 2048;
    private ClientList clients = null;
    private ArrayList subscribed = new ArrayList();

    public SubscriptionManager(ClientList cList) {
        this.clients = cList;
    }

    public void forget(int varCode) {
        String prop = AppShareProtocol.getStatusProperty((int)varCode);
        if (prop == null) {
            return;
        }
        if (AppShareProtocol.isPluralStatus((int)varCode)) {
            for (ClientInfo ci : this.clients) {
                ci.deleteProperty(prop);
            }
        } else {
            this.clients.deleteProperty(prop);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown(AppShareMessageHandler handler) {
        Debug.lockEnter((Object)this, (String)"shutdown", null, (Object)this);
        SubscriptionManager subscriptionManager = this;
        synchronized (subscriptionManager) {
            Iterator i = this.subscribed.iterator();
            while (i.hasNext()) {
                AppShareMessage.Subscribe.Request req = (AppShareMessage.Subscribe.Request)i.next();
                i.remove();
                this.forget(req.getCode());
            }
        }
        Debug.lockLeave((Object)this, (String)"shutdown", null, (Object)this);
        this.sendSubscribe(handler);
    }

    public void update(AppShareMessage.Status msg) {
        AppShareMessage.Status.Element elem = new AppShareMessage.Status.Element();
        AppShareMessage.Status.ValueIterator valit = msg.getValues();
        while (valit.hasMoreValues()) {
            String prop;
            valit.getNext(elem);
            if (!this.isSubscribed(elem.code) || (prop = AppShareProtocol.getStatusProperty((int)elem.code)) == null) continue;
            if (AppShareProtocol.isPluralStatus((int)elem.code)) {
                ClientInfo ci = this.clients.get(elem.client);
                if (ci == null) continue;
                ci.setProperty(prop, new PropertyValue(elem.value));
                continue;
            }
            this.clients.setProperty(prop, new PropertyValue(elem.value));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void subscribe(int varCode, AppShareMessageHandler handler) {
        AppShareMessage.Subscribe.Request req = null;
        if (this.isSubscribed(varCode)) {
            return;
        }
        switch (varCode) {
            case 1: {
                req = new AppShareProtocol.UpToDateRequest(256, 2048);
                break;
            }
            default: {
                req = new AppShareMessage.Subscribe.Request(varCode);
            }
        }
        Debug.lockEnter((Object)this, (String)"subscribe", null, (Object)this);
        SubscriptionManager subscriptionManager = this;
        synchronized (subscriptionManager) {
            this.subscribed.add(req);
        }
        Debug.lockLeave((Object)this, (String)"subscribe", null, (Object)this);
        this.sendSubscribe(handler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unsubscribe(int varCode, AppShareMessageHandler handler) {
        Debug.lockEnter((Object)this, (String)"unsubscribe", null, (Object)this);
        SubscriptionManager subscriptionManager = this;
        synchronized (subscriptionManager) {
            Iterator i = this.subscribed.iterator();
            while (i.hasNext()) {
                AppShareMessage.Subscribe.Request req = (AppShareMessage.Subscribe.Request)i.next();
                if (req.getCode() != varCode) continue;
                i.remove();
                break;
            }
        }
        Debug.lockLeave((Object)this, (String)"unsubscribe", null, (Object)this);
        this.sendSubscribe(handler);
        this.forget(varCode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSubscribed(int varCode) {
        boolean sub = false;
        Debug.lockEnter((Object)this, (String)"isSubscribed", null, (Object)this);
        SubscriptionManager subscriptionManager = this;
        synchronized (subscriptionManager) {
            for (AppShareMessage.Subscribe.Request req : this.subscribed) {
                if (req.getCode() != varCode) continue;
                sub = true;
                break;
            }
        }
        Debug.lockLeave((Object)this, (String)"isSubscribed", null, (Object)this);
        return sub;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendSubscribe(AppShareMessageHandler handler) {
        Debug.lockEnter((Object)this, (String)"sendSubscribe", null, (Object)this);
        SubscriptionManager subscriptionManager = this;
        synchronized (subscriptionManager) {
            AppShareMessage.Subscribe msg = new AppShareMessage.Subscribe((Collection)this.subscribed);
            msg.send((short)0, handler);
        }
        Debug.lockLeave((Object)this, (String)"sendSubscribe", null, (Object)this);
    }
}

