/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.appshare.module;

import com.elluminate.groupware.appshare.module.StringsProperties;
import com.elluminate.gui.GuiUtils;
import com.elluminate.gui.component.EasyDialog;
import com.elluminate.gui.component.KeyConfigPanel;
import com.elluminate.platform.Platform;
import com.elluminate.util.I18n;
import com.elluminate.util.PropertiesEnum;
import com.elluminate.util.SwingRunnerSupport;
import com.elluminate.util.log.LogSupport;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;

public class SimulatedKeyStroke
implements Cloneable {
    public static final int HOST_ALL = 0;
    public static final int HOST_WIN = 1;
    public static final int HOST_MAC = 2;
    public static final int HOST_X11 = 3;
    private static I18n i18n = I18n.create(SimulatedKeyStroke.class);
    private static final String[] HOST_NAMES = new String[]{"All", "Win", "Mac", "X11"};
    private static final String[] HOST_LOCAL_NAMES = new String[]{null, i18n.getString((PropertiesEnum)StringsProperties.SIMULATEDKEYSTROKE_HOSTWINDOWS), i18n.getString((PropertiesEnum)StringsProperties.SIMULATEDKEYSTROKE_HOSTMAC), i18n.getString((PropertiesEnum)StringsProperties.SIMULATEDKEYSTROKE_HOSTX11)};
    private int sendCode = 0;
    private int sendMods = 0;
    private int triggerCode = 0;
    private int triggerMods = 0;
    private int hostType = 0;

    public SimulatedKeyStroke() {
    }

    public SimulatedKeyStroke(int code, int mods) {
        this.sendCode = code;
        this.sendMods = mods;
    }

    public SimulatedKeyStroke(int code, int mods, int host) {
        this(code, mods);
        this.hostType = host;
    }

    public SimulatedKeyStroke(int code, int mods, int triggerCode, int triggerMods, int host) {
        this(code, mods, host);
        this.triggerCode = triggerCode;
        this.triggerMods = triggerMods;
    }

    public Object clone() {
        return new SimulatedKeyStroke(this.sendCode, this.sendMods, this.triggerCode, this.triggerMods, this.hostType);
    }

    public boolean isValid() {
        return this.sendCode != 0;
    }

    public int getKeyCode() {
        return this.sendCode;
    }

    public int getKeyModifiers() {
        return this.sendMods;
    }

    public String getKeystroke() {
        return GuiUtils.getKeystrokeText((int)this.sendCode, (int)this.sendMods);
    }

    public void setTriggerKey(int code, int mods) {
        this.triggerCode = code;
        this.triggerMods = mods;
    }

    public void clearTriggerKey() {
        this.triggerCode = 0;
        this.triggerMods = 0;
    }

    public int getTriggerKeyCode() {
        return this.triggerCode;
    }

    public int getTriggerKeyModifiers() {
        return this.triggerMods;
    }

    public String getTriggerKeyText() {
        if (this.isTriggerKeyDefined()) {
            return GuiUtils.getKeystrokeText((int)this.triggerCode, (int)this.triggerMods);
        }
        return "";
    }

    public KeyStroke getTriggerKeyStroke() {
        if (this.isTriggerKeyDefined()) {
            return KeyStroke.getKeyStroke(this.triggerCode, this.triggerMods);
        }
        return null;
    }

    public boolean isTriggerKeyDefined() {
        return this.triggerCode != 0;
    }

    public int getHostType() {
        return this.hostType;
    }

    private String getHostName() {
        if (this.hostType < 0 || this.hostType >= HOST_NAMES.length) {
            return "";
        }
        return HOST_NAMES[this.hostType];
    }

    public String getLocalizedHostName() {
        if (this.hostType < 0 || this.hostType >= HOST_LOCAL_NAMES.length) {
            return null;
        }
        return HOST_LOCAL_NAMES[this.hostType];
    }

    public String encodeProperty() {
        String hostName = this.hostType >= 0 && this.hostType < HOST_NAMES.length ? HOST_NAMES[this.hostType] : "?";
        return this.sendCode + "|" + this.sendMods + "|" + this.triggerCode + "|" + this.triggerMods + "|" + hostName;
    }

    public void decodeProperty(String val) {
        this.triggerCode = 0;
        this.sendCode = 0;
        this.triggerMods = 0;
        this.sendMods = 0;
        this.hostType = 0;
        StringTokenizer parser = new StringTokenizer(val, "|");
        this.sendCode = Integer.parseInt(parser.nextToken());
        this.sendMods = Integer.parseInt(parser.nextToken());
        this.triggerCode = Integer.parseInt(parser.nextToken());
        this.triggerMods = Integer.parseInt(parser.nextToken());
        String hostName = parser.nextToken();
        for (int ix = 0; ix < HOST_NAMES.length; ++ix) {
            if (!hostName.equalsIgnoreCase(HOST_NAMES[ix])) continue;
            this.hostType = ix;
            break;
        }
    }

    public String toString() {
        StringBuffer result = new StringBuffer(32);
        result.append(this.getClass().getName() + " key=" + this.getKeySequence(this.sendCode, this.sendMods));
        if (this.isTriggerKeyDefined()) {
            result.append(" trigger=" + this.getKeySequence(this.triggerCode, this.triggerMods));
        }
        if (this.hostType != 0) {
            String hostName = this.hostType >= 0 && this.hostType < HOST_NAMES.length ? HOST_NAMES[this.hostType] : "?";
            result.append(" host=" + hostName);
        }
        return result.toString();
    }

    private String getKeySequence(int code, int mods) {
        StringBuffer result = new StringBuffer(16);
        if (mods != 0) {
            result.append(KeyEvent.getKeyModifiersText(mods) + "+");
        }
        result.append(KeyEvent.getKeyText(code));
        return result.toString();
    }

    public boolean showConfigureDialog(Component parent) {
        ConfigPane content = new ConfigPane(this.sendCode, this.sendMods);
        EasyDialog d = new EasyDialog(parent, i18n.getString((PropertiesEnum)StringsProperties.SIMULATEDKEYSTROKE_CONFIGTITLE));
        d.setContent((Component)content);
        d.addActionButton(d.makeButton(1), true);
        d.addCancelButton(d.makeButton(0));
        d.setInitialFocus(content.keystrokePanel.getPrimaryComponent());
        d.show();
        if (d.wasCanceled()) {
            return false;
        }
        this.sendCode = content.getKeyCode();
        this.sendMods = content.getKeyModifiers();
        if (content.triggerCheck.isSelected()) {
            this.setTriggerKey(content.triggerCode, content.triggerMods);
        } else {
            this.clearTriggerKey();
        }
        this.hostType = content.curHost;
        return true;
    }

    public static String formatSet(ArrayList keys) {
        StringBuffer b = new StringBuffer(256);
        for (SimulatedKeyStroke key : keys) {
            if (b.length() > 0) {
                b.append(",");
            }
            b.append(key.encodeProperty());
        }
        return b.toString();
    }

    public static ArrayList parseSet(String data) {
        ArrayList<SimulatedKeyStroke> keys = new ArrayList<SimulatedKeyStroke>();
        StringTokenizer parser = new StringTokenizer(data, ",");
        while (parser.hasMoreTokens()) {
            String encoded = parser.nextToken();
            try {
                SimulatedKeyStroke key = new SimulatedKeyStroke();
                key.decodeProperty(encoded);
                keys.add(key);
            }
            catch (Throwable t) {
                LogSupport.exception(SimulatedKeyStroke.class, (String)"parseSet", (Throwable)t, (boolean)true, (String)("KeyStroke=" + encoded));
            }
        }
        return keys;
    }

    public static ArrayList makeDefaultSet() {
        ArrayList<SimulatedKeyStroke> keys = new ArrayList<SimulatedKeyStroke>();
        switch (Platform.getPlatform()) {
            case 1: {
                keys.add(new SimulatedKeyStroke(27, 2));
                keys.add(new SimulatedKeyStroke(9, 2));
                keys.add(new SimulatedKeyStroke(9, 8));
                keys.add(new SimulatedKeyStroke(9, 9));
                keys.add(new SimulatedKeyStroke(67, 4, 67, 2, 2));
                keys.add(new SimulatedKeyStroke(88, 4, 88, 2, 2));
                keys.add(new SimulatedKeyStroke(86, 4, 86, 2, 2));
                break;
            }
            case 2: {
                keys.add(new SimulatedKeyStroke(32, 4));
                keys.add(new SimulatedKeyStroke(9, 4));
                keys.add(new SimulatedKeyStroke(9, 5));
                if (Platform.getOS() != 202) break;
                keys.add(new SimulatedKeyStroke(120, 0));
                keys.add(new SimulatedKeyStroke(121, 0));
                keys.add(new SimulatedKeyStroke(122, 0));
                keys.add(new SimulatedKeyStroke(123, 0));
                break;
            }
            case 3: {
                keys.add(new SimulatedKeyStroke(27, 2));
                keys.add(new SimulatedKeyStroke(9, 8));
                keys.add(new SimulatedKeyStroke(9, 9));
                keys.add(new SimulatedKeyStroke(27, 8));
                keys.add(new SimulatedKeyStroke(32, 8));
                keys.add(new SimulatedKeyStroke(67, 4, 67, 2, 2));
                keys.add(new SimulatedKeyStroke(88, 4, 88, 2, 2));
                keys.add(new SimulatedKeyStroke(86, 4, 86, 2, 2));
            }
        }
        return keys;
    }

    class ConfigPane
    extends Box {
        protected KeyConfigPanel keystrokePanel;
        protected JCheckBox triggerCheck;
        protected JTextField triggerField;
        protected JCheckBox hostCheck;
        protected JComboBox hostSelect;
        protected int triggerCode;
        protected int triggerMods;
        protected int curHost;

        public ConfigPane(int code, int mods) {
            super(1);
            this.triggerCheck = new JCheckBox(i18n.getString((PropertiesEnum)StringsProperties.SIMULATEDKEYSTROKE_TRIGGERCHECKBOX));
            this.triggerField = new JTextField();
            this.hostCheck = new JCheckBox(i18n.getString((PropertiesEnum)StringsProperties.SIMULATEDKEYSTROKE_HOSTCHECKBOX));
            this.hostSelect = new JComboBox();
            this.triggerCode = SimulatedKeyStroke.this.triggerCode;
            this.triggerMods = SimulatedKeyStroke.this.triggerMods;
            this.curHost = SimulatedKeyStroke.this.hostType;
            this.initConfigPane(code, mods);
        }

        public int getKeyCode() {
            return this.keystrokePanel.getKeyCode();
        }

        public int getKeyModifiers() {
            return this.keystrokePanel.getKeyModifiers();
        }

        private void initConfigPane(int code, int mods) {
            this.keystrokePanel = new KeyConfigPanel(code, mods, true);
            String title = i18n.getString((PropertiesEnum)StringsProperties.SIMULATEDKEYSTROKE_KEYBORDERTITLE);
            this.keystrokePanel.setBorder((Border)new TitledBorder(title));
            this.triggerCheck.setToolTipText(i18n.getString((PropertiesEnum)StringsProperties.SIMULATEDKEYSTROKE_TRIGGERCHECKBOXTIP));
            this.triggerField.setKeymap(null);
            this.triggerField.setColumns(24);
            this.triggerField.setToolTipText(i18n.getString((PropertiesEnum)StringsProperties.SIMULATEDKEYSTROKE_TRIGGERFIELDTIP));
            this.triggerField.setEnabled(SimulatedKeyStroke.this.isTriggerKeyDefined());
            this.triggerField.setText(SimulatedKeyStroke.this.getTriggerKeyText());
            this.triggerField.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    final int keycode = e.getKeyCode();
                    final int keymods = e.getModifiers();
                    if (!KeyConfigPanel.isModifierKey((int)keycode)) {
                        SwingRunnerSupport.invokeLater((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                ConfigPane.this.triggerCode = keycode;
                                ConfigPane.this.triggerMods = keymods;
                                String keyName = "";
                                if (keycode != 0) {
                                    keyName = GuiUtils.getKeystrokeText((int)keycode, (int)keymods);
                                }
                                ConfigPane.this.triggerField.setText(keyName);
                            }
                        });
                    }
                    e.consume();
                }
            });
            this.triggerCheck.setSelected(SimulatedKeyStroke.this.isTriggerKeyDefined());
            this.triggerCheck.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent ev) {
                    String strokeText = "";
                    if (ConfigPane.this.triggerCheck.isSelected()) {
                        ConfigPane.this.triggerField.setEnabled(true);
                        ConfigPane.this.triggerField.requestFocus();
                        if (ConfigPane.this.triggerCode != 0) {
                            strokeText = GuiUtils.getKeystrokeText((int)ConfigPane.this.triggerCode, (int)ConfigPane.this.triggerMods);
                        }
                    } else {
                        ConfigPane.this.triggerField.setEnabled(false);
                    }
                    ConfigPane.this.triggerField.setText(strokeText);
                }
            });
            this.hostCheck.setToolTipText(i18n.getString((PropertiesEnum)StringsProperties.SIMULATEDKEYSTROKE_HOSTCHECKBOXTIP));
            this.hostCheck.setSelected(this.curHost != 0);
            this.hostCheck.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent ev) {
                    if (ConfigPane.this.hostCheck.isSelected()) {
                        ConfigPane.this.hostSelect.setEnabled(true);
                        ConfigPane.this.curHost = ConfigPane.this.hostSelect.getSelectedIndex() + 1;
                    } else {
                        ConfigPane.this.hostSelect.setEnabled(false);
                        ConfigPane.this.curHost = 0;
                    }
                }
            });
            this.hostSelect.setToolTipText(i18n.getString((PropertiesEnum)StringsProperties.SIMULATEDKEYSTROKE_HOSTSELECTORTIP));
            this.hostSelect.addItem(i18n.getString((PropertiesEnum)StringsProperties.SIMULATEDKEYSTROKE_HOSTWINDOWS));
            this.hostSelect.addItem(i18n.getString((PropertiesEnum)StringsProperties.SIMULATEDKEYSTROKE_HOSTMAC));
            this.hostSelect.addItem(i18n.getString((PropertiesEnum)StringsProperties.SIMULATEDKEYSTROKE_HOSTX11));
            if (this.curHost != 0) {
                this.hostSelect.setEnabled(true);
                this.hostSelect.setSelectedIndex(this.curHost - 1);
            } else {
                this.hostSelect.setEnabled(false);
            }
            this.hostSelect.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent ev) {
                    ConfigPane.this.curHost = ConfigPane.this.hostSelect.getSelectedIndex() + 1;
                }
            });
            JPanel triggerPanel = new JPanel(new GridBagLayout());
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.anchor = 17;
            gbc.gridwidth = 1;
            gbc.weightx = 0.0;
            triggerPanel.add((Component)this.triggerCheck, gbc);
            gbc.gridwidth = 0;
            gbc.weightx = 1.0;
            gbc.insets.left += 8;
            gbc.insets.right += 8;
            triggerPanel.add((Component)this.triggerField, gbc);
            JPanel hostPanel = new JPanel(new GridBagLayout());
            gbc.gridwidth = 1;
            gbc.weightx = 0.0;
            gbc.insets.left -= 8;
            gbc.insets.right -= 8;
            hostPanel.add((Component)this.hostCheck, gbc);
            gbc.gridwidth = 0;
            gbc.weightx = 1.0;
            gbc.insets.left += 8;
            gbc.insets.right += 8;
            hostPanel.add((Component)this.hostSelect, gbc);
            this.add(Box.createVerticalStrut(8));
            this.add((Component)this.keystrokePanel);
            this.add(Box.createVerticalStrut(18));
            this.add(triggerPanel);
            this.add(Box.createVerticalStrut(18));
            this.add(hostPanel);
            this.add(Box.createVerticalStrut(12));
        }
    }
}

