/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.appshare.module;

import com.elluminate.framework.imps.Imps;
import com.elluminate.groupware.appshare.AppShareDebug;
import com.elluminate.groupware.appshare.module.AppShareController;
import com.elluminate.groupware.appshare.module.AppSharingHost;
import com.elluminate.groupware.appshare.module.ApplicationInformation;
import com.elluminate.groupware.appshare.module.RegionBrowser;
import com.elluminate.groupware.appshare.module.RegionEvent;
import com.elluminate.groupware.appshare.module.RegionListener;
import com.elluminate.groupware.appshare.module.StringsProperties;
import com.elluminate.groupware.imps.module.PresentationModeAPI;
import com.elluminate.gui.GuiUtils;
import com.elluminate.gui.component.DisabledIcon;
import com.elluminate.gui.component.EasyDialog;
import com.elluminate.gui.swing.CTabbedPane;
import com.elluminate.gui.swing.CTree;
import com.elluminate.util.I18n;
import com.elluminate.util.LightweightTimer;
import com.elluminate.util.PropertiesEnum;
import com.elluminate.util.SwingRunnerSupport;
import com.elluminate.util.log.LogSupport;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class ShareSelectDialog
extends EasyDialog
implements RegionListener {
    private static I18n i18n = I18n.create(ShareSelectDialog.class);
    private static final int APPS_TAB = 0;
    private static final int REGION_TAB = 1;
    private static final int SMALL_ZOOM_SIZE = 64;
    private static final int LARGE_ZOOM_SIZE = 128;
    private static boolean usingScreenShot = true;
    private static Rectangle prevBounds = null;
    private static int prevTab = -1;
    private static final String emptyListBkgText = i18n.getString((PropertiesEnum)StringsProperties.SHARESELECTDIALOG_EMPTYLISTTEXT);
    private static final String expandAllName = i18n.getString((PropertiesEnum)StringsProperties.SHARESELECTDIALOG_EXPANDALLBTN);
    private static final String expandAllTip = i18n.getString((PropertiesEnum)StringsProperties.SHARESELECTDIALOG_EXPANDALLTIP);
    private static final String collapseAllName = i18n.getString((PropertiesEnum)StringsProperties.SHARESELECTDIALOG_COLLAPSEALLBTN);
    private static final String collapseAllTip = i18n.getString((PropertiesEnum)StringsProperties.SHARESELECTDIALOG_COLLAPSEALLTIP);
    JButton okBtn = new JButton();
    JButton cancelBtn = new JButton();
    JButton optionsBtn = new JButton();
    JPanel regionPanel = new JPanel();
    BorderLayout regionLayout = new BorderLayout();
    JCheckBox desktop = new JCheckBox();
    JPanel regionBox = new JPanel();
    BorderLayout regionBoxLayout = new BorderLayout();
    RegionBrowser region = new RegionBrowser();
    JPanel browserPanel = new JPanel();
    BorderLayout browserLayout = new BorderLayout();
    JPanel coordPanel = new JPanel();
    JTextField rgnX = new JTextField();
    JTextField rgnY = new JTextField();
    JTextField rgnW = new JTextField();
    JTextField rgnH = new JTextField();
    GridBagLayout coordlayout = new GridBagLayout();
    Rectangle returnRegion = null;
    Object[] returnApps = null;
    JLabel positionLabel = new JLabel();
    JLabel sizeLabel = new JLabel();
    JLabel zoomLabel;
    ButtonGroup zoomGroup = new ButtonGroup();
    JRadioButton zoomOff = new JRadioButton();
    JRadioButton zoomSmall = new JRadioButton();
    JRadioButton zoomLarge = new JRadioButton();
    JCheckBox snapShotCheckBox = new JCheckBox();
    CTabbedPane tabs = new CTabbedPane();
    DefaultMutableTreeNode appRoot = new DefaultMutableTreeNode();
    DefaultTreeModel appTreeModel = new DefaultTreeModel(this.appRoot);
    AppTreeCellRenderer appRenderer = new AppTreeCellRenderer();
    AppTree appTree = new AppTree(this.appTreeModel);
    JScrollPane appScroller = new JScrollPane();
    JPanel appPanel = new JPanel();
    BorderLayout appLayout = new BorderLayout();
    JCheckBox excludeMenuBar = new JCheckBox();
    JButton appExpander = null;
    JCheckBox presentShare = new JCheckBox();
    AppSharingHost host = null;
    AppShareController ctl = null;
    Imps imps = null;
    ApplicationInformation[] prevApps = null;
    Frame top = null;
    String appName = null;
    Icon appIcon = null;
    UpdaterTask timerTask = new UpdaterTask();
    LightweightTimer timer = new LightweightTimer(this.timerTask){

        public boolean cancel() {
            ShareSelectDialog.this.timerTask.stop();
            return super.cancel();
        }
    };

    public ShareSelectDialog(Frame parent, String title, String appName, Icon appIcon, AppSharingHost host, AppShareController ctl, Imps imps) {
        super((Component)parent, title, false);
        Rectangle dt;
        Rectangle r;
        this.setResizable(true);
        this.top = parent;
        this.appName = appName;
        this.appIcon = appIcon;
        this.host = host;
        this.ctl = ctl;
        this.imps = imps;
        try {
            this.jbInit();
            this.excludeMenuBar.setVisible(host.isExcludeMenuBarSupported());
            this.excludeMenuBar.setSelected(host.getExcludeMenuBar());
            this.region.addRegionListener(this);
            this.region.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ShareSelectDialog.this.doOk();
                }
            });
            this.appTree.getSelectionModel().addTreeSelectionListener(new TreeSelectionListener(){

                @Override
                public void valueChanged(TreeSelectionEvent ev) {
                    ShareSelectDialog.this.normalizeAppSelection();
                    if (ShareSelectDialog.this.appTree.getSelectionCount() == 0) {
                        ShareSelectDialog.this.okBtn.setEnabled(false);
                    } else {
                        ShareSelectDialog.this.okBtn.setEnabled(true);
                    }
                }
            });
            this.appTree.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseReleased(MouseEvent me) {
                    if (!ShareSelectDialog.this.appTree.isEnabled()) {
                        return;
                    }
                    if (me.getClickCount() == 2) {
                        ShareSelectDialog.this.doOk();
                        me.consume();
                    }
                }
            });
            this.tabs.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent ev) {
                    ShareSelectDialog.this.okBtn.setEnabled(false);
                    ShareSelectDialog.this.desktop.setSelected(false);
                    ShareSelectDialog.this.region.setRegion(new Rectangle());
                    ShareSelectDialog.this.appTree.clearSelection();
                }
            });
            this.pack();
        }
        catch (Exception ex) {
            LogSupport.exception((Object)this, (String)"ShareSelectDialog", (Throwable)ex, (boolean)true);
        }
        if (prevBounds != null && !(r = (dt = GuiUtils.getDesktopBounds()).intersection(prevBounds)).isEmpty()) {
            this.setBounds(r);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        try {
            this.region.dispose();
            this.timer.cancel();
            if (this.ctl != null) {
                AppShareController tmp = this.ctl;
                this.ctl = null;
                tmp.cancel();
            }
        }
        finally {
            super.dispose();
        }
    }

    public void show() {
        int capabilities = this.host.getCapabilities();
        if (capabilities == 0) {
            if (this.ctl != null) {
                AppShareController tmp = this.ctl;
                this.ctl = null;
                tmp.cancel();
            }
            return;
        }
        if (capabilities == 1) {
            if (this.ctl != null) {
                AppShareController tmp = this.ctl;
                this.ctl = null;
                tmp.selectRegion(this.getScreenRect());
            }
            return;
        }
        this.tabs.setEnabledAt(1, capabilities >= 2);
        this.tabs.setEnabledAt(0, capabilities >= 3);
        switch (prevTab) {
            case 0: {
                if (capabilities < 3) break;
                this.tabs.setSelectedComponent((Component)this.appPanel);
                break;
            }
            case 1: {
                if (capabilities < 2) break;
                this.tabs.setSelectedComponent((Component)this.regionPanel);
                break;
            }
            default: {
                if (capabilities < 3) {
                    this.tabs.setSelectedComponent((Component)this.regionPanel);
                    break;
                }
                this.tabs.setSelectedComponent((Component)this.appPanel);
            }
        }
        super.show();
        this.prevApps = null;
        this.timer.scheduleIn(250L);
    }

    public void hide() {
        Rectangle bounds = this.getBounds();
        super.hide();
        if (prevBounds == null) {
            prevBounds = new Rectangle(bounds);
        } else {
            prevBounds.setBounds(bounds);
        }
        prevTab = this.tabs.getSelectedIndex();
        this.region.dispose();
        this.timer.cancel();
        AppShareController tmp = this.ctl;
        if (tmp != null) {
            this.ctl = null;
            tmp.cancel();
        }
    }

    protected void processWindowEvent(WindowEvent e) {
        super.processWindowEvent(e);
        if (e.getID() == 201) {
            this.doCancel();
        }
    }

    void jbInit() throws Exception {
        this.okBtn.setEnabled(false);
        this.okBtn.setText(i18n.getString((PropertiesEnum)StringsProperties.SHARESELECTDIALOG_OK));
        this.okBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ShareSelectDialog.this.okBtn_actionPerformed(e);
            }
        });
        if (this.ctl == null) {
            this.cancelBtn.setText(i18n.getString((PropertiesEnum)StringsProperties.SHARESELECTDIALOG_CLOSE));
        } else {
            this.cancelBtn.setText(i18n.getString((PropertiesEnum)StringsProperties.SHARESELECTDIALOG_CANCEL));
        }
        this.cancelBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ShareSelectDialog.this.cancelBtn_actionPerformed(e);
            }
        });
        this.optionsBtn.setText(i18n.getString((PropertiesEnum)StringsProperties.SHARESELECTDIALOG_OPTIONS));
        this.optionsBtn.setToolTipText(i18n.getString((PropertiesEnum)StringsProperties.SHARESELECTDIALOG_OPTIONSTIP));
        this.optionsBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                if (ShareSelectDialog.this.ctl != null) {
                    ShareSelectDialog.this.ctl.showOptions((Component)((Object)ShareSelectDialog.this));
                }
            }
        });
        this.optionsBtn.setVisible(false);
        this.desktop.setText(i18n.getString((PropertiesEnum)StringsProperties.SHARESELECTDIALOG_SHAREDESKTOP));
        this.desktop.setToolTipText(i18n.getString((PropertiesEnum)StringsProperties.SHARESELECTDIALOG_SHAREDESKTOPTIP));
        this.desktop.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                ShareSelectDialog.this.desktop_itemStateChanged(e);
            }
        });
        this.regionLayout.setVgap(6);
        this.regionPanel.setLayout(this.regionLayout);
        this.regionPanel.setBorder(BorderFactory.createEmptyBorder(4, 10, 10, 10));
        ActionMap aMap = this.regionPanel.getActionMap();
        InputMap iMap = this.regionPanel.getInputMap(1);
        AbstractAction selectAllAction = new AbstractAction("select-entire-desktop"){

            @Override
            public void actionPerformed(ActionEvent ev) {
                ShareSelectDialog.this.desktop.setSelected(true);
                ShareSelectDialog.this.desktop.requestFocus();
            }
        };
        aMap.put(selectAllAction.getValue("Name"), selectAllAction);
        int accelMask = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        iMap.put(KeyStroke.getKeyStroke(65, accelMask), selectAllAction.getValue("Name"));
        this.browserLayout.setVgap(6);
        this.browserPanel.setLayout(this.browserLayout);
        this.region.setEnabled(this.ctl != null);
        this.coordPanel.setLayout(this.coordlayout);
        this.positionLabel.setHorizontalAlignment(4);
        this.positionLabel.setText(i18n.getString((PropertiesEnum)StringsProperties.SHARESELECTDIALOG_POSITION));
        this.sizeLabel.setHorizontalAlignment(4);
        this.sizeLabel.setText(i18n.getString((PropertiesEnum)StringsProperties.SHARESELECTDIALOG_SIZE));
        JPanel zoomPanel = new JPanel(new GridBagLayout());
        this.zoomLabel = new JLabel(i18n.getString((PropertiesEnum)StringsProperties.SHARESELECTDIALOG_ZOOMLABEL));
        this.zoomOff.setText(i18n.getString((PropertiesEnum)StringsProperties.SHARESELECTDIALOG_ZOOMOFF));
        this.zoomSmall.setText(i18n.getString((PropertiesEnum)StringsProperties.SHARESELECTDIALOG_ZOOMSMALL));
        this.zoomLarge.setText(i18n.getString((PropertiesEnum)StringsProperties.SHARESELECTDIALOG_ZOOMLARGE));
        this.zoomGroup.add(this.zoomOff);
        this.zoomGroup.add(this.zoomSmall);
        this.zoomGroup.add(this.zoomLarge);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.gridx = 0;
        zoomPanel.add((Component)this.zoomLabel, gbc);
        JPanel zoomChoicesPanel = new JPanel(new GridLayout(1, 0, 6, 0));
        zoomChoicesPanel.add(this.zoomOff);
        zoomChoicesPanel.add(this.zoomSmall);
        zoomChoicesPanel.add(this.zoomLarge);
        gbc.gridx = 1;
        gbc.insets.left = 6;
        zoomPanel.add((Component)zoomChoicesPanel, gbc);
        gbc.gridx = 2;
        gbc.weightx = 1.0;
        zoomPanel.add(Box.createHorizontalGlue(), gbc);
        this.presentShare.setText(i18n.getString((PropertiesEnum)StringsProperties.SHARESELECTDIALOG_PRESENTSHARECHECKBOX));
        this.presentShare.setToolTipText(i18n.getString((PropertiesEnum)StringsProperties.SHARESELECTDIALOG_PRESENTSHARETIP));
        PresentationModeAPI presentMode = (PresentationModeAPI)this.imps.findBest(PresentationModeAPI.class);
        this.presentShare.setVisible(presentMode != null && presentMode.isAvailable() && presentMode.isPresentationPermitted());
        this.zoomOff.setSelected(true);
        this.region.setZoom(false);
        ChangeListener zoomChanged = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (ShareSelectDialog.this.zoomSmall.isSelected()) {
                    ShareSelectDialog.this.region.setZoomSize(64);
                } else if (ShareSelectDialog.this.zoomLarge.isSelected()) {
                    ShareSelectDialog.this.region.setZoomSize(128);
                } else {
                    ShareSelectDialog.this.region.setZoomSize(0);
                }
            }
        };
        this.zoomOff.addChangeListener(zoomChanged);
        this.zoomSmall.addChangeListener(zoomChanged);
        this.zoomLarge.addChangeListener(zoomChanged);
        this.zoomOff.setToolTipText(i18n.getString((PropertiesEnum)StringsProperties.SHARESELECTDIALOG_ZOOMOFFTIP));
        this.zoomSmall.setToolTipText(i18n.getString((PropertiesEnum)StringsProperties.SHARESELECTDIALOG_ZOOMSMALLTIP));
        this.zoomLarge.setToolTipText(i18n.getString((PropertiesEnum)StringsProperties.SHARESELECTDIALOG_ZOOMLARGETIP));
        JPanel snapShotPanel = new JPanel(new GridBagLayout());
        this.snapShotCheckBox.setText(i18n.getString((PropertiesEnum)StringsProperties.SHARESELECTDIALOG_SNAPSHOTBTN));
        this.snapShotCheckBox.setToolTipText(i18n.getString((PropertiesEnum)StringsProperties.SHARESELECTDIALOG_SNAPSHOTTIP));
        this.region.setUsingSnapShot(usingScreenShot);
        if (AppShareDebug.REGION_SNAP.show()) {
            this.snapShotCheckBox.setSelected(usingScreenShot);
            ActionListener snapShotCheckAction = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ev) {
                    usingScreenShot = ShareSelectDialog.this.snapShotCheckBox.isSelected();
                    if (!usingScreenShot) {
                        ShareSelectDialog.this.zoomOff.setSelected(true);
                    }
                    ShareSelectDialog.this.zoomSmall.setEnabled(usingScreenShot);
                    ShareSelectDialog.this.zoomLarge.setEnabled(usingScreenShot);
                    ShareSelectDialog.this.region.setUsingSnapShot(usingScreenShot);
                }
            };
            this.snapShotCheckBox.addActionListener(snapShotCheckAction);
            snapShotCheckAction.actionPerformed(null);
        } else {
            this.snapShotCheckBox.setEnabled(false);
            this.snapShotCheckBox.setVisible(false);
        }
        gbc = new GridBagConstraints();
        gbc.gridwidth = 0;
        gbc.fill = 0;
        gbc.anchor = 21;
        gbc.weightx = 1.0;
        snapShotPanel.add((Component)this.snapShotCheckBox, gbc);
        Box regionOptionsPanel = Box.createVerticalBox();
        regionOptionsPanel.add(zoomPanel);
        regionOptionsPanel.add(snapShotPanel);
        this.regionPanel.add((Component)regionOptionsPanel, "South");
        this.regionBox.setLayout(this.regionBoxLayout);
        this.regionBox.setBorder(BorderFactory.createLineBorder(Color.gray, 1));
        this.region.setToolTipText(i18n.getString((PropertiesEnum)StringsProperties.SHARESELECTDIALOG_REGIONBROWSERTIP));
        this.regionBox.add((Component)this.region, "Center");
        this.regionPanel.add((Component)this.browserPanel, "Center");
        this.browserPanel.add((Component)this.regionBox, "Center");
        this.browserPanel.add((Component)this.coordPanel, "South");
        gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.gridx = 0;
        gbc.weightx = 0.0;
        this.coordPanel.add((Component)this.positionLabel, gbc);
        gbc.gridx = 1;
        gbc.weightx = 1.0;
        gbc.insets.left = 6;
        this.coordPanel.add((Component)this.rgnX, gbc);
        gbc.gridx = 2;
        gbc.weightx = 1.0;
        gbc.insets.left = 6;
        this.coordPanel.add((Component)this.rgnY, gbc);
        gbc.gridx = 3;
        gbc.weightx = 0.0;
        gbc.insets.left = 10;
        this.coordPanel.add((Component)this.sizeLabel, gbc);
        gbc.gridx = 4;
        gbc.weightx = 1.0;
        gbc.insets.left = 6;
        this.coordPanel.add((Component)this.rgnW, gbc);
        gbc.gridx = 5;
        gbc.weightx = 1.0;
        gbc.insets.left = 6;
        this.coordPanel.add((Component)this.rgnH, gbc);
        this.rgnX.setToolTipText(i18n.getString((PropertiesEnum)StringsProperties.SHARESELECTDIALOG_XPOSITIONTIP));
        this.rgnX.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                if (!e.isTemporary()) {
                    ShareSelectDialog.this.rgnX.selectAll();
                }
            }

            @Override
            public void focusLost(FocusEvent e) {
                ShareSelectDialog.this.rgnXchanged();
            }
        });
        this.rgnX.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ShareSelectDialog.this.rgnXchanged();
            }
        });
        this.rgnY.setToolTipText(i18n.getString((PropertiesEnum)StringsProperties.SHARESELECTDIALOG_YPOSITIONTIP));
        this.rgnY.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                if (!e.isTemporary()) {
                    ShareSelectDialog.this.rgnY.selectAll();
                }
            }

            @Override
            public void focusLost(FocusEvent e) {
                ShareSelectDialog.this.rgnYchanged();
            }
        });
        this.rgnY.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ShareSelectDialog.this.rgnYchanged();
            }
        });
        this.rgnW.setToolTipText(i18n.getString((PropertiesEnum)StringsProperties.SHARESELECTDIALOG_WIDTHTIP));
        this.rgnW.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                if (!e.isTemporary()) {
                    ShareSelectDialog.this.rgnW.selectAll();
                }
            }

            @Override
            public void focusLost(FocusEvent e) {
                ShareSelectDialog.this.rgnWchanged();
            }
        });
        this.rgnW.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ShareSelectDialog.this.rgnWchanged();
            }
        });
        this.rgnH.setToolTipText(i18n.getString((PropertiesEnum)StringsProperties.SHARESELECTDIALOG_HEIGHTTIP));
        this.rgnH.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                if (!e.isTemporary()) {
                    ShareSelectDialog.this.rgnH.selectAll();
                }
            }

            @Override
            public void focusLost(FocusEvent e) {
                ShareSelectDialog.this.rgnHchanged();
            }
        });
        this.rgnH.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ShareSelectDialog.this.rgnHchanged();
            }
        });
        this.appLayout.setVgap(6);
        this.appPanel.setLayout(this.appLayout);
        this.appPanel.setBorder(BorderFactory.createEmptyBorder(4, 10, 10, 10));
        this.appTree.getSelectionModel().setSelectionMode(4);
        this.appTree.setRootVisible(false);
        this.appTree.setShowsRootHandles(true);
        this.appTree.emptyText = i18n.getString((PropertiesEnum)StringsProperties.SHARESELECTDIALOG_GETAPPLISTTEXT);
        this.appTree.setCellRenderer(this.appRenderer);
        this.appTree.setRenderersHaveToolTips(true);
        this.appTree.setToolTipText(i18n.getString((PropertiesEnum)StringsProperties.SHARESELECTDIALOG_APPSTREETIP));
        this.appTree.setRowHeight(18);
        this.appExpander = new JButton(expandAllName);
        this.appExpander.setToolTipText(expandAllTip);
        this.appExpander.addActionListener(new ActionListener(){
            boolean doExpand = true;

            @Override
            public void actionPerformed(ActionEvent ev) {
                if (this.doExpand) {
                    ShareSelectDialog.this.appExpander.setText(collapseAllName);
                    ShareSelectDialog.this.appExpander.setToolTipText(collapseAllTip);
                    this.doExpand = false;
                    ShareSelectDialog.this.appTree.expandAll();
                } else {
                    ShareSelectDialog.this.appExpander.setText(expandAllName);
                    ShareSelectDialog.this.appExpander.setToolTipText(expandAllTip);
                    this.doExpand = true;
                    ShareSelectDialog.this.appTree.collapseAll();
                }
            }
        });
        this.appScroller.setViewportView((Component)((Object)this.appTree));
        this.appScroller.setHorizontalScrollBarPolicy(30);
        this.appScroller.setVerticalScrollBarPolicy(22);
        this.appScroller.getViewport().setPreferredSize(new Dimension(100, 100));
        this.appScroller.getViewport().setBackground(this.appTree.getBackground());
        this.appScroller.getViewport().addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                ShareSelectDialog.this.appTree.clearSelection();
                ShareSelectDialog.this.appTree.requestFocus();
            }
        });
        this.appPanel.add((Component)this.appScroller, "Center");
        this.excludeMenuBar.setText(i18n.getString((PropertiesEnum)StringsProperties.SHARESELECTDIALOG_EXCLUDEMENUBAR));
        this.excludeMenuBar.setToolTipText(i18n.getString((PropertiesEnum)StringsProperties.SHARESELECTDIALOG_EXCLUDEMENUBARTIP));
        if (this.host.isExcludeMenuBarSupported()) {
            this.excludeMenuBar.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent ev) {
                    if (ShareSelectDialog.this.excludeMenuBar.isVisible()) {
                        ShareSelectDialog.this.host.setExcludeMenuBar(ShareSelectDialog.this.excludeMenuBar.isSelected());
                    }
                }
            });
        }
        JPanel appBtnPane = new JPanel(new BorderLayout());
        appBtnPane.add((Component)this.excludeMenuBar, "West");
        appBtnPane.add((Component)this.appExpander, "East");
        this.appPanel.add((Component)appBtnPane, "South");
        this.tabs.add((Component)this.appPanel, (Object)i18n.getString((PropertiesEnum)StringsProperties.SHARESELECTDIALOG_APPS));
        this.tabs.add((Component)this.regionPanel, (Object)i18n.getString((PropertiesEnum)StringsProperties.SHARESELECTDIALOG_REGION));
        this.tabs.setToolTipTextAt(0, i18n.getString((PropertiesEnum)StringsProperties.SHARESELECTDIALOG_APPSTIP));
        this.tabs.setToolTipTextAt(1, i18n.getString((PropertiesEnum)StringsProperties.SHARESELECTDIALOG_REGIONTIP));
        this.rgnX.setEnabled(this.ctl != null);
        this.rgnY.setEnabled(this.ctl != null);
        this.rgnW.setEnabled(this.ctl != null);
        this.rgnH.setEnabled(this.ctl != null);
        Dimension scr = Toolkit.getDefaultToolkit().getScreenSize();
        scr.width /= 4;
        scr.height /= 4;
        this.region.setPreferredSize(scr);
        this.region.setBackground(Color.lightGray);
        JPanel desktopPane = new JPanel(new FlowLayout(3));
        desktopPane.add(this.desktop);
        JPanel content = new JPanel(new BorderLayout(0, 6));
        content.add((Component)desktopPane, "North");
        content.add((Component)this.tabs, "Center");
        if (this.presentShare.isVisible()) {
            JPanel presentPane = new JPanel(new FlowLayout(3));
            presentPane.add(this.presentShare);
            content.add((Component)presentPane, "South");
        }
        this.setContent(content);
        if (this.ctl != null) {
            this.addPassiveComponent(this.optionsBtn);
            this.addActionButton(this.okBtn, true);
        }
        this.addCancelButton(this.cancelBtn);
        this.setInitialFocus((Component)((Object)this.appTree));
    }

    @Override
    public void regionChanged(RegionEvent e) {
        boolean zero;
        Rectangle region = e.getRegion();
        boolean bl = zero = region.x == 0 && region.y == 0 && region.width == 0 && region.height == 0;
        if (zero) {
            this.rgnX.setText("0");
            this.rgnY.setText("0");
            this.rgnW.setText("0");
            this.rgnH.setText("0");
            this.okBtn.setEnabled(false);
        } else {
            this.rgnX.setText(Integer.toString(region.x));
            this.rgnY.setText(Integer.toString(region.y));
            this.rgnW.setText(Integer.toString(region.width));
            this.rgnH.setText(Integer.toString(region.height));
            this.okBtn.setEnabled(!region.isEmpty());
        }
    }

    void setWindows(Rectangle[] windows) {
        this.region.setWindows(windows);
    }

    void setApplications(ApplicationInformation[] curApps) {
        if (this.appTree.emptyText != emptyListBkgText) {
            this.appTree.emptyText = emptyListBkgText;
        }
        if (curApps == this.prevApps) {
            return;
        }
        Object[] expanded = this.getExpandedApps();
        Object[] selected = this.getSelectedApps();
        this.repopulateAppTree(curApps);
        this.setSelectedApps(selected);
        this.expandApps(expanded);
        this.prevApps = curApps;
    }

    private void repopulateAppTree(ApplicationInformation[] curApps) {
        this.appRoot.removeAllChildren();
        for (int ix = 0; ix < curApps.length; ++ix) {
            this.appRoot.add(this.createAppNode(curApps[ix]));
        }
        this.appTreeModel.nodeStructureChanged(this.appRoot);
    }

    private MutableTreeNode createAppNode(ApplicationInformation app) {
        DefaultMutableTreeNode node = new DefaultMutableTreeNode(app, true);
        int nWins = app.getWindowCount();
        if (nWins > 1) {
            for (int ix = 0; ix < nWins; ++ix) {
                node.add(new WindowTreeNode(app.getWindowTitle(ix), app.getAppName(), app.getWindowIcon(ix)));
            }
        }
        return node;
    }

    private void normalizeAppSelection() {
        int[] indices = this.appTree.getSelectionRows();
        if (indices == null || indices.length == 0) {
            return;
        }
        ArrayList<TreePath> selectedPaths = new ArrayList<TreePath>(indices.length);
        for (int ix = 0; ix < indices.length; ++ix) {
            TreePath path = this.appTree.getPathForRow(indices[ix]);
            if (path.getPathCount() < 2) continue;
            while (path.getPathCount() > 2) {
                path = path.getParentPath();
            }
            if (selectedPaths.contains(path)) continue;
            selectedPaths.add(path);
        }
        if (selectedPaths.isEmpty()) {
            this.appTree.clearSelection();
        } else {
            TreePath[] paths = new TreePath[selectedPaths.size()];
            paths = selectedPaths.toArray(paths);
            this.appTree.setSelectionPaths(paths);
        }
    }

    private Object[] getSelectedApps() {
        int[] indices = this.appTree.getSelectionRows();
        if (indices == null || indices.length == 0) {
            return null;
        }
        ArrayList<Object> items = new ArrayList<Object>(indices.length);
        for (int i = 0; i < indices.length; ++i) {
            TreePath path = this.appTree.getPathForRow(indices[i]);
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
            if (!this.appRoot.isNodeChild(node)) continue;
            items.add(node.getUserObject());
        }
        if (items.size() == 0) {
            return null;
        }
        return items.toArray();
    }

    private void setSelectedApps(Object[] selected) {
        this.appTree.clearSelection();
        if (selected == null) {
            return;
        }
        if (selected.length == 0) {
            return;
        }
        ArrayList<TreePath> selectedPaths = new ArrayList<TreePath>(selected.length);
        for (int ix = 0; ix < selected.length; ++ix) {
            TreePath path = this.getPathToApp(selected[ix]);
            if (path == null) continue;
            selectedPaths.add(path);
        }
        if (selectedPaths.size() == 0) {
            return;
        }
        TreePath[] paths = new TreePath[selectedPaths.size()];
        paths = selectedPaths.toArray(paths);
        this.appTree.setSelectionPaths(paths);
    }

    private Object[] getExpandedApps() {
        ArrayList<Object> expandedApps = new ArrayList<Object>();
        TreePath path = new TreePath(new Object[]{this.appRoot});
        Enumeration e = this.appTree.getExpandedDescendants(path);
        if (e == null) {
            return null;
        }
        while (e.hasMoreElements()) {
            Object app;
            path = (TreePath)e.nextElement();
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
            if (!this.appRoot.isNodeChild(node) || (app = node.getUserObject()) == null || expandedApps.contains(app)) continue;
            expandedApps.add(app);
        }
        if (expandedApps.isEmpty()) {
            return null;
        }
        return expandedApps.toArray();
    }

    private void expandApps(Object[] toExpand) {
        if (toExpand == null) {
            return;
        }
        for (int ix = 0; ix < toExpand.length; ++ix) {
            TreePath path = this.getPathToApp(toExpand[ix]);
            if (path == null) continue;
            this.appTree.expandPath(path);
        }
    }

    private TreePath getPathToApp(Object app) {
        if (app == null) {
            return null;
        }
        Object appKey = null;
        if (app instanceof ApplicationInformation) {
            appKey = ((ApplicationInformation)app).getKey();
        }
        for (int ix = 0; ix < this.appRoot.getChildCount(); ++ix) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.appRoot.getChildAt(ix);
            Object user = node.getUserObject();
            if (user == null) continue;
            boolean mustAdd = false;
            if (appKey != null && user instanceof ApplicationInformation) {
                Object userKey = ((ApplicationInformation)user).getKey();
                mustAdd = appKey.equals(userKey);
            } else {
                mustAdd = app.equals(user);
            }
            if (!mustAdd) continue;
            return new TreePath(node.getPath());
        }
        return null;
    }

    Rectangle getRegion() {
        return this.returnRegion;
    }

    Rectangle getScreenRect() {
        Dimension size = Toolkit.getDefaultToolkit().getScreenSize();
        return new Rectangle(0, 0, size.width, size.height);
    }

    Object[] getApplications() {
        return this.returnApps;
    }

    boolean isToPresent() {
        return this.presentShare.isVisible() && this.presentShare.isEnabled() && this.presentShare.isSelected();
    }

    void okBtn_actionPerformed(ActionEvent e) {
        this.doOk();
    }

    void doOk() {
        if (this.doOkApply()) {
            this.setVisible(false);
        }
    }

    void cancelBtn_actionPerformed(ActionEvent e) {
        this.doCancel();
    }

    void doCancel() {
        this.returnRegion = null;
        if (this.ctl != null) {
            AppShareController tmp = this.ctl;
            this.ctl = null;
            tmp.cancel();
        }
        this.setVisible(false);
    }

    void desktop_itemStateChanged(ItemEvent e) {
        if (e.getStateChange() == 1) {
            this.appScroller.setEnabled(false);
            this.appTree.setEnabled(false);
            this.appExpander.setEnabled(false);
            this.excludeMenuBar.setEnabled(false);
            this.region.setEnabled(false);
            this.positionLabel.setEnabled(false);
            this.rgnX.setEnabled(false);
            this.rgnY.setEnabled(false);
            this.sizeLabel.setEnabled(false);
            this.rgnW.setEnabled(false);
            this.rgnH.setEnabled(false);
            this.region.setRegion(this.getScreenRect());
            this.zoomLabel.setEnabled(false);
            this.zoomOff.setEnabled(false);
            this.zoomSmall.setEnabled(false);
            this.zoomLarge.setEnabled(false);
            this.appTree.clearSelection();
            this.okBtn.setEnabled(true);
        } else {
            this.appScroller.setEnabled(true);
            this.appTree.setEnabled(true);
            this.appExpander.setEnabled(true);
            this.excludeMenuBar.setEnabled(true);
            this.region.setEnabled(true);
            this.positionLabel.setEnabled(true);
            this.rgnX.setEnabled(true);
            this.rgnY.setEnabled(true);
            this.sizeLabel.setEnabled(true);
            this.rgnW.setEnabled(true);
            this.rgnH.setEnabled(true);
            this.tabs.setEnabled(true);
            this.region.setRegion(new Rectangle());
            this.zoomLabel.setEnabled(true);
            this.zoomOff.setEnabled(true);
            this.zoomSmall.setEnabled(true);
            this.zoomLarge.setEnabled(true);
            this.appTree.clearSelection();
            this.okBtn.setEnabled(false);
        }
    }

    boolean doOkApply() {
        try {
            if (this.desktop.isSelected()) {
                Rectangle tmpRegion = this.getScreenRect();
                if (tmpRegion == null || tmpRegion.isEmpty()) {
                    return false;
                }
                this.returnRegion = tmpRegion;
                if (this.ctl != null) {
                    AppShareController tmp = this.ctl;
                    this.ctl = null;
                    tmp.selectRegion(this.returnRegion);
                }
                return true;
            }
            switch (this.tabs.getSelectedIndex()) {
                case 1: {
                    Rectangle tmpRegion = this.region.getRegion();
                    if (tmpRegion == null || tmpRegion.isEmpty()) {
                        return false;
                    }
                    this.returnRegion = tmpRegion;
                    if (this.ctl != null) {
                        AppShareController tmp = this.ctl;
                        this.ctl = null;
                        tmp.selectRegion(this.returnRegion);
                    }
                    return true;
                }
                case 0: {
                    this.normalizeAppSelection();
                    this.returnApps = this.getSelectedApps();
                    if (this.returnApps == null || this.returnApps.length == 0) {
                        return false;
                    }
                    if (this.ctl != null) {
                        AppShareController tmp = this.ctl;
                        this.ctl = null;
                        tmp.selectApps(this.returnApps);
                    }
                    return true;
                }
            }
        }
        catch (Throwable t) {
            LogSupport.exception((Object)this, (String)"doOkApply", (Throwable)t, (boolean)true);
        }
        return false;
    }

    void rgnXchanged() {
        int x;
        Rectangle rgn = this.region.getRegion();
        if (rgn == null) {
            rgn = new Rectangle(0, 0, 0, 0);
        }
        if ((x = this.getValue(this.rgnX, rgn.x)) >= 0) {
            Rectangle screen = this.getScreenRect();
            if (x >= screen.width) {
                x = screen.width - rgn.width;
            } else if (x > screen.width - rgn.width) {
                rgn.width = screen.width - x;
            }
            rgn.x = x;
            this.region.setRegion(rgn);
        }
    }

    void rgnYchanged() {
        int y;
        Rectangle rgn = this.region.getRegion();
        if (rgn == null) {
            rgn = new Rectangle(0, 0, 0, 0);
        }
        if ((y = this.getValue(this.rgnY, rgn.y)) >= 0) {
            Rectangle screen = this.getScreenRect();
            if (y >= screen.height) {
                y = screen.height - rgn.height;
            } else if (y > screen.height - rgn.height) {
                rgn.height = screen.height - y;
            }
            rgn.y = y;
            this.region.setRegion(rgn);
        }
    }

    void rgnHchanged() {
        int h;
        Rectangle rgn = this.region.getRegion();
        if (rgn == null) {
            rgn = new Rectangle(0, 0, 0, 0);
        }
        if ((h = this.getValue(this.rgnH, rgn.height)) >= 0) {
            Rectangle screen = this.getScreenRect();
            if (h > screen.height - rgn.y) {
                h = screen.height - rgn.y;
            }
            rgn.height = h;
            this.region.setRegion(rgn);
        }
    }

    void rgnWchanged() {
        int w;
        Rectangle rgn = this.region.getRegion();
        if (rgn == null) {
            rgn = new Rectangle(0, 0, 0, 0);
        }
        if ((w = this.getValue(this.rgnW, rgn.width)) >= 0) {
            Rectangle screen = this.getScreenRect();
            if (w > screen.width - rgn.x) {
                w = screen.width - rgn.x;
            }
            rgn.width = w;
            this.region.setRegion(rgn);
        }
    }

    int getValue(JTextField fld, int dft) {
        String text = fld.getText();
        int value = -1;
        if (text == null || text.equals("")) {
            return 0;
        }
        try {
            value = Integer.parseInt(text, 10);
        }
        catch (Exception ex) {
            value = -1;
        }
        if (value < 0) {
            fld.setText(Integer.toString(dft));
        }
        return value;
    }

    private class AppTree
    extends CTree {
        String emptyText;

        AppTree(TreeModel model) {
            super(model);
            this.emptyText = null;
        }

        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            if (this.emptyText != null && this.emptyText.length() > 0 && ShareSelectDialog.this.appRoot.getChildCount() == 0) {
                Insets insets = this.getInsets();
                Dimension dim = new Dimension(this.getWidth(), this.getHeight());
                dim.width -= insets.left + insets.right;
                dim.height -= insets.top + insets.bottom;
                Graphics gc = g.create();
                gc.setColor(Color.GRAY);
                Font f = this.getFont();
                gc.setFont(f);
                FontMetrics fm = gc.getFontMetrics();
                int w = fm.stringWidth(this.emptyText);
                int x = insets.left + (dim.width - w) / 2;
                int y = insets.top + fm.getLeading() + fm.getAscent();
                gc.drawString(this.emptyText, x, y);
            }
        }
    }

    private class AppTreeCellRenderer
    extends DefaultTreeCellRenderer {
        private AppTreeCellRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object val, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            Component comp;
            ApplicationInformation app = null;
            WindowTreeNode winInfo = null;
            String name = null;
            boolean isApp = false;
            if (val instanceof WindowTreeNode) {
                winInfo = (WindowTreeNode)val;
                name = winInfo.getAppName();
                if (name == null) {
                    name = val.toString();
                }
            } else if (val instanceof DefaultMutableTreeNode) {
                Object userObj = ((DefaultMutableTreeNode)val).getUserObject();
                if (userObj instanceof ApplicationInformation) {
                    isApp = true;
                    app = (ApplicationInformation)userObj;
                    name = app.getAppName();
                    if (name == null) {
                        name = app.getWindowCount() > 0 ? app.getWindowTitle(0) : app.toString();
                    }
                } else {
                    name = val.toString();
                }
            } else {
                name = val != null ? val.toString() : "???";
            }
            if ((comp = super.getTreeCellRendererComponent(tree, val, selected, expanded, leaf, row, hasFocus)) instanceof JLabel) {
                JLabel lbl = (JLabel)comp;
                Icon icon = null;
                Icon disabled = null;
                if (isApp) {
                    icon = name == ShareSelectDialog.this.appName ? ShareSelectDialog.this.appIcon : app.getAppIcon();
                } else if (winInfo != null) {
                    icon = winInfo.getWindowIcon();
                    comp.setForeground(Color.GRAY);
                }
                if (icon != null && comp instanceof JComponent) {
                    disabled = DisabledIcon.getDisabledIcon((Icon)icon, (JComponent)((JComponent)comp));
                }
                lbl.setIcon(icon);
                lbl.setDisabledIcon(disabled);
            }
            if (comp instanceof JComponent) {
                String tip = leaf ? i18n.getString((PropertiesEnum)StringsProperties.SHARESELECTDIALOG_APPSTREEAPPTIP, new Object[]{name}) : (expanded ? i18n.getString((PropertiesEnum)StringsProperties.SHARESELECTDIALOG_APPSTREEAPPOPENTIP, new Object[]{name}) : i18n.getString((PropertiesEnum)StringsProperties.SHARESELECTDIALOG_APPSTREEAPPCLOSEDTIP, new Object[]{name}));
                ((JComponent)comp).setToolTipText(tip);
            }
            return comp;
        }
    }

    private class UpdaterTask
    implements Runnable {
        private boolean failed = false;
        private volatile boolean running = true;

        private UpdaterTask() {
        }

        void stop() {
            this.running = false;
        }

        @Override
        public void run() {
            try {
                switch (ShareSelectDialog.this.tabs.getSelectedIndex()) {
                    case 1: {
                        this.updateRegion();
                        break;
                    }
                    case 0: {
                        this.updateApps();
                    }
                }
                this.failed = false;
            }
            catch (Throwable t) {
                LogSupport.exception((Object)this, (String)"run", (Throwable)t, (boolean)true);
                if (this.failed) {
                    ShareSelectDialog.this.timer.cancel();
                }
                this.failed = true;
            }
        }

        private void updateRegion() {
            final Rectangle[] rects = ShareSelectDialog.this.host.getWindowRects();
            SwingRunnerSupport.invokeLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    ShareSelectDialog.this.setWindows(rects);
                    if (UpdaterTask.this.running) {
                        ShareSelectDialog.this.timer.scheduleIn(1000L);
                    }
                }
            });
        }

        private void updateApps() {
            final ApplicationInformation[] curApps = ShareSelectDialog.this.host.getApplicationList(ShareSelectDialog.this.prevApps, ShareSelectDialog.this.appName);
            SwingRunnerSupport.invokeLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    ShareSelectDialog.this.setApplications(curApps);
                    if (UpdaterTask.this.running) {
                        ShareSelectDialog.this.timer.scheduleIn(1000L);
                    }
                }
            });
        }
    }

    private static class WindowTreeNode
    extends DefaultMutableTreeNode {
        String app = null;
        Icon icon = null;

        WindowTreeNode(String title, String appName, Icon winIcon) {
            super(title, false);
            this.app = appName;
            this.icon = winIcon;
        }

        String getAppName() {
            return this.app;
        }

        Icon getWindowIcon() {
            return this.icon;
        }
    }
}

