/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.appshare.module;

import com.elluminate.engine.CommandContextException;
import com.elluminate.engine.CommandExecutionException;
import com.elluminate.engine.CommandParameterException;
import com.elluminate.engine.command.AbstractCommand;
import com.elluminate.engine.command.ShareApplicationCommand;
import com.elluminate.engine.model.ShareableApplication;
import com.elluminate.framework.imps.Imps;
import com.elluminate.groupware.appshare.AppShareDebug;
import com.elluminate.groupware.appshare.module.AppShareBean;
import com.elluminate.groupware.appshare.module.AppShareController;
import com.elluminate.groupware.appshare.module.AppShareModule;
import com.elluminate.groupware.appshare.module.AppSharingHost;
import com.elluminate.groupware.appshare.module.ApplicationInformation;
import com.elluminate.groupware.appshare.module.StringsProperties;
import com.elluminate.groupware.imps.module.PresentationModeAPI;
import com.elluminate.groupware.imps.view.ViewAPI;
import com.elluminate.groupware.imps.view.ViewMode;
import com.elluminate.platform.Platform;
import com.elluminate.util.Debug;
import com.elluminate.util.I18n;
import com.elluminate.util.LightweightTimer;
import com.elluminate.util.PropertiesEnum;
import com.elluminate.util.StringUtils;
import com.elluminate.util.log.LogSupport;
import com.google.inject.Inject;
import java.awt.Component;
import java.awt.Rectangle;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Set;
import javax.swing.Icon;

public class ShareApplicationCmd
extends AbstractCommand
implements ShareApplicationCommand {
    private boolean includeScreenMenuBar = false;
    private boolean presentationMode = false;
    private String filePath = null;
    private String applicationPath = null;
    private Object key = null;
    private boolean appLaunchSuccess = false;
    private ApplicationInformation appToShare = null;
    private int timeout = 10000;
    @Inject
    private I18n i18n;
    @Inject
    private AppShareModule module;
    private Imps imps;

    @Inject
    void initImps(Imps imps) {
        this.imps = imps;
    }

    public void setLaunchTimeout(int timeout) {
        this.timeout = timeout;
    }

    public ShareableApplication[] getAvailableApplications() {
        ApplicationInformation[] arr = this.module.getAppBean().getApplicationList();
        if (arr == null) {
            return null;
        }
        ShareableApplication[] returnValue = new RunningApplication[arr.length];
        for (int i = 0; i < arr.length; ++i) {
            returnValue[i] = new RunningApplication(arr[i].getAppName(), arr[i].getAppIcon(), arr[i].getAppPath(), arr[i].getKey(), arr[i].getWindowTitles());
        }
        if (AppShareDebug.VERBOSE.show()) {
            LogSupport.message((Object)((Object)this), (String)"ShareApplicationCmd", (String)"Array returned from ShareApplicationCmd#getAvailableApplications");
            LogSupport.message((String)StringUtils.getStringValue((Object)returnValue));
        }
        return returnValue;
    }

    public ShareableApplication[] getMatchingApplications(String application) {
        ArrayList infos = this.getMatchingApplicationInfos(application);
        if (infos == null) {
            return null;
        }
        ShareableApplication[] apps = new RunningApplication[infos.size()];
        Iterator itr = infos.iterator();
        for (int i = 0; i < apps.length; ++i) {
            ApplicationInformation info = (ApplicationInformation)itr.next();
            apps[i] = new RunningApplication(info.getAppName(), info.getAppIcon(), info.getAppPath(), info.getKey(), info.getWindowTitles());
        }
        return apps;
    }

    private ArrayList getMatchingApplicationInfos(String application) {
        ApplicationInformation[] apps = this.module.getAppBean().getApplicationList();
        if (apps == null) {
            return null;
        }
        ArrayList<ApplicationInformation> matches = new ArrayList<ApplicationInformation>();
        String specPath = application.toLowerCase();
        String specName = ShareApplicationCmd.getLeafNameFromPath(specPath);
        if (specName != null) {
            for (int i = 0; i < apps.length; ++i) {
                ApplicationInformation app = apps[i];
                String name = app.getAppName();
                String path = app.getAppPath();
                if ((path == null || !path.toLowerCase(Locale.ENGLISH).equals(specPath)) && (name == null || name.toLowerCase(Locale.ENGLISH).indexOf(specName) == -1)) continue;
                matches.add(app);
            }
        }
        if (matches.size() == 0) {
            return null;
        }
        return matches;
    }

    private static String getLeafNameFromPath(String path) {
        String ext;
        if (path == null) {
            return null;
        }
        int pos = path.lastIndexOf("\\");
        if (pos == -1 && (pos = path.lastIndexOf("/")) == -1) {
            pos = path.lastIndexOf(":");
        }
        if (pos == path.length() - 1) {
            return null;
        }
        String name = path.substring(pos + 1);
        if ((pos = name.lastIndexOf(".")) != -1 && pos != path.length() - 1 && ((ext = name.substring(pos + 1)).equalsIgnoreCase("exe") || ext.equalsIgnoreCase("app"))) {
            name = name.substring(0, pos);
        }
        return name;
    }

    public void setApplication(String applicationPath, Object key) {
        this.applicationPath = applicationPath;
        this.key = key;
    }

    public void setFile(String filePath) {
        this.filePath = filePath;
    }

    public void setIncludeScreenMenuBar(boolean includeScreenMenuBar) {
        this.includeScreenMenuBar = includeScreenMenuBar;
    }

    public void setPresenting(boolean presenting) {
        this.presentationMode = presenting;
    }

    public void doexecute() throws CommandExecutionException {
        this.validateIsOnline();
        AppShareBean bean = this.module.getAppBean();
        if (bean.isViewing()) {
            throw new CommandContextException("Already sharing", this.i18n.getString((PropertiesEnum)StringsProperties.SHARECMD_BADCONTEXTALREADYSHARING));
        }
        if (bean.getState() != 1) {
            throw new CommandContextException("Already hosting", this.i18n.getString((PropertiesEnum)StringsProperties.SHARECMD_BADCONTEXTALREADYHOSTING));
        }
        AppSharingHost appShareHost = bean.getAppSharingHost();
        if (appShareHost == null) {
            throw new CommandContextException("No AppSharingHost implementation defined for this platform", this.i18n.getString((PropertiesEnum)StringsProperties.SHAREAPPLICATIONCMD_BADCONTEXTNOSHARINGHOST));
        }
        if ((this.applicationPath == null || this.applicationPath.length() < 1) && this.key == null) {
            throw new CommandParameterException("An application to share must be specified by application pathe or by key", this.i18n.getString((PropertiesEnum)StringsProperties.SHAREAPPLICATIONCMD_BADPARAMAPPLICATIONNOTSET));
        }
        ApplicationInformation[] possibles = null;
        File file = null;
        if (this.filePath != null && this.filePath.length() != 0) {
            file = new File(this.filePath);
            if (!file.exists()) {
                throw new CommandParameterException("The document specified to be opened does not exist", this.i18n.getString((PropertiesEnum)StringsProperties.SHAREAPPLICATIONCMD_BADPARAMDOCUMENTNOTFOUND, new Object[]{this.filePath}));
            }
        } else {
            possibles = bean.getApplicationList();
            if (this.key != null) {
                for (int i = 0; i < possibles.length; ++i) {
                    if (!this.key.equals(possibles[i].getKey())) continue;
                    this.appToShare = possibles[i];
                    break;
                }
            }
            if (this.appToShare == null && (this.applicationPath == null || this.applicationPath.length() < 1)) {
                throw new CommandParameterException("Cannot find requested process id to share and no application path was provided", this.i18n.getString((PropertiesEnum)StringsProperties.SHAREAPPLICATIONCMD_BADPARAMAPPLICATIONNOTFOUND, new Object[]{this.key}));
            }
            if (this.appToShare == null) {
                this.appToShare = this.searchForApplication(new HashSet<ApplicationInformation>(Arrays.asList(possibles)));
            }
        }
        if (this.appToShare == null) {
            File app = new File(this.applicationPath);
            if (!app.exists()) {
                throw new CommandParameterException("The requested application does not exist", this.i18n.getString((PropertiesEnum)StringsProperties.SHAREAPPLICATIONCMD_BADPARAMAPPLICATIONNOTFOUND, new Object[]{this.applicationPath}));
            }
            ApplicationInformation[] appsBeforeLaunch = bean.getApplicationList();
            this.appLaunchSuccess = Platform.launchApp((File)app, (File)file);
            if (!this.appLaunchSuccess) {
                throw new CommandExecutionException("Failed to launch the requested application", this.i18n.getString((PropertiesEnum)StringsProperties.SHAREAPPLICATIONCMD_BADRESULTLAUNCHINGFAILED));
            }
            this.waitForAppToLaunch(appsBeforeLaunch);
        }
        if (this.appToShare == null) {
            throw new CommandParameterException("Unable to launch and share the desired application", this.i18n.getString((PropertiesEnum)StringsProperties.SHAREAPPLICATIONCMD_BADPARAMAPPLICATIONNOTFOUND, new Object[]{this.applicationPath}));
        }
        if (appShareHost.isExcludeMenuBarSupported()) {
            appShareHost.setExcludeMenuBar(!this.includeScreenMenuBar);
        }
        AppShareController ctl = new AppShareController(){
            Rectangle initAOI = null;
            Object[] appList = null;
            AppShareModule appMod = ShareApplicationCmd.access$000(ShareApplicationCmd.this);
            AppShareBean appShareBean = ShareApplicationCmd.access$000(ShareApplicationCmd.this).getAppBean();

            @Override
            public void selectRegion(Rectangle rgn) {
                throw new UnsupportedOperationException("Invalid method. ShareApplicationCmd shares applications, not regions.");
            }

            @Override
            public void selectApps(Object[] appsToShare) {
                if (appsToShare == null || appsToShare.length != 1) {
                    throw new IllegalArgumentException("Apps to share array must be of length 1.");
                }
                this.appShareBean.changeState(4);
                this.appList = appsToShare;
                this.initAOI = this.appShareBean.getAppSharingHost().getAppDisplayBounds(this.appList);
                if (!this.startSharing()) {
                    throw new RuntimeException("Sharing application was unsuccessful");
                }
            }

            @Override
            public void cancel() {
                this.appShareBean.changeState(1);
            }

            @Override
            public void showOptions(Component parent) {
                throw new UnsupportedOperationException("Invalid method. Cannot show options.");
            }

            private boolean startSharing() {
                if (this.appShareBean.startHosting(this.appList, this.initAOI)) {
                    if (ShareApplicationCmd.this.presentationMode) {
                        Runnable presentAction = new Runnable(){

                            @Override
                            public void run() {
                                if (appShareBean.getState() == 5) {
                                    LightweightTimer timer = new LightweightTimer(2, (Runnable)this);
                                    timer.scheduleIn(100L);
                                    return;
                                }
                                if (appShareBean.getState() != 6) {
                                    return;
                                }
                                PresentationModeAPI presentationAPI = null;
                                if (appMod != null) {
                                    presentationAPI = appMod.getPresentationAPI();
                                }
                                if (presentationAPI == null) {
                                    return;
                                }
                                presentationAPI.setPresentable((Object)appMod, true);
                                if (presentationAPI.isPresentationPermitted()) {
                                    presentationAPI.present((Object)appMod, false);
                                }
                            }
                        };
                        LightweightTimer timer = new LightweightTimer(2, presentAction);
                        timer.scheduleIn(250L);
                    }
                    return true;
                }
                this.cancel();
                return false;
            }
        };
        ViewAPI viewApi = (ViewAPI)this.imps.findBest(ViewAPI.class);
        if (viewApi != null) {
            viewApi.requestMode(ViewMode.APPSHARE);
        }
        try {
            ctl.selectApps(new Object[]{this.appToShare});
        }
        catch (RuntimeException re) {
            if (AppShareDebug.VERBOSE.show()) {
                LogSupport.message((String)re.getMessage());
                LogSupport.message((String)Debug.getStackTrace((Throwable)re));
            }
            throw new CommandContextException(re.getMessage(), this.i18n.getString((PropertiesEnum)StringsProperties.SHARECMD_BADRESULTERROROCCURRED));
        }
    }

    private ApplicationInformation searchForApplication(Set possibles) {
        if (this.applicationPath == null || this.applicationPath.length() < 1) {
            return null;
        }
        ApplicationInformation info = null;
        Iterator i = possibles.iterator();
        while (i.hasNext()) {
            try {
                info = (ApplicationInformation)i.next();
            }
            catch (ClassCastException e) {
                return null;
            }
            if (!this.applicationPath.equals(info.getAppPath())) continue;
            return info;
        }
        return null;
    }

    private void waitForAppToLaunch(ApplicationInformation[] appsBeforeLaunch) {
        ArrayList<ApplicationInformation> oldList = new ArrayList<ApplicationInformation>();
        if (appsBeforeLaunch != null) {
            oldList.addAll(Arrays.asList(appsBeforeLaunch));
        }
        long now = System.currentTimeMillis();
        while (System.currentTimeMillis() - now < (long)this.timeout) {
            try {
                Thread.sleep(250L);
            }
            catch (InterruptedException ex) {
                // empty catch block
            }
            if (Platform.getPlatform() == 3) {
                ApplicationInformation[] appsNow = this.module.getAppBean().getApplicationList();
                ArrayList<ApplicationInformation> newList = new ArrayList<ApplicationInformation>(Arrays.asList(appsNow));
                newList.removeAll(oldList);
                if (newList.size() < 1) continue;
                this.appToShare = newList.get(0);
                break;
            }
            ArrayList infos = this.getMatchingApplicationInfos(this.applicationPath);
            if (infos == null || infos.size() == 0) continue;
            this.appToShare = (ApplicationInformation)infos.get(0);
            break;
        }
    }

    static /* synthetic */ AppShareModule access$000(ShareApplicationCmd x0) {
        return x0.module;
    }

    private static class RunningApplication
    implements ShareableApplication {
        private String displayName;
        private Icon smallIcon;
        private String path;
        private Object uid;
        private String[] windowTitles;

        public RunningApplication(String displayName, Icon smallIcon, String path, Object uid, String[] windowTitles) {
            this.displayName = displayName;
            this.smallIcon = smallIcon;
            this.path = path;
            this.uid = uid;
            this.windowTitles = windowTitles;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public Icon getSmallIcon() {
            return this.smallIcon;
        }

        public String getPath() {
            return this.path;
        }

        public Object getUID() {
            return this.uid;
        }

        public String[] getWindowTitles() {
            return this.windowTitles;
        }
    }
}

