/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.appshare.module;

import com.elluminate.groupware.appshare.AppShareDebug;
import com.elluminate.groupware.appshare.module.RegionEvent;
import com.elluminate.groupware.appshare.module.RegionListener;
import com.elluminate.gui.GuiUtils;
import com.elluminate.gui.ScreenSnapshot;
import com.elluminate.util.Debug;
import com.elluminate.util.SwingRunnerSupport;
import com.elluminate.util.WorkerThread;
import com.elluminate.util.log.LogSupport;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;

public class RegionBrowser
extends JComponent
implements MouseMotionListener,
MouseListener {
    public static final int DOUBLE_CLICK_ID = 1;
    public static final String DOUBLE_CLICK_CMD = "double-click";
    private static final int SLOP = 1;
    private static final int MODE_IN = 0;
    private static final int MODE_N = 1;
    private static final int MODE_E = 2;
    private static final int MODE_NE = 3;
    private static final int MODE_W = 4;
    private static final int MODE_NW = 5;
    private static final int MODE_S = 8;
    private static final int MODE_SE = 10;
    private static final int MODE_SW = 12;
    private static final int MODE_OUT = 16;
    private static final int MODE_DISABLED = 32;
    private static final int N_MODES = 33;
    private static final Point ORIGIN = new Point(0, 0);
    private static final int REFRESH_INTERVAL = 15000;
    private Cursor[] cursors = new Cursor[33];
    private Rectangle[] aWindow = new Rectangle[0];
    private Rectangle[] sWindow = new Rectangle[0];
    private Rectangle aRegion = null;
    private Rectangle sRegion = null;
    private Rectangle aScreen = null;
    private Rectangle sScreen = null;
    private float scale = 0.0f;
    private Color inBackground = Color.cyan;
    private Color outBackground = this.inBackground.darker();
    private Color inEdgeColor = Color.blue;
    private Color outEdgeColor = this.inEdgeColor.darker();
    private Color inFillColor = Color.white;
    private Color outFillColor = this.inFillColor.darker();
    private Color inSelectAlpha = new Color(192, 192, 255, 64);
    private Color outSelectAlpha = new Color(128, 128, 128, 92);
    private ArrayList listeners = new ArrayList();
    private int mode = 16;
    private int savedMode = 16;
    private boolean didDrag = false;
    private Point last = null;
    private Point anchor = null;
    private Toolkit toolkit = Toolkit.getDefaultToolkit();
    private ArrayList actionListeners = new ArrayList();
    private int selectedRectIdx = -1;
    private boolean useSnapShot = true;
    private ScreenSnapshot screenShot = new ScreenSnapshot();
    private Image scaledImage = null;
    private long scaledImageTime = 0L;
    private int scaledImageWidth = 0;
    private int scaledImageHeight = 0;
    private Thread scalerThread = null;
    private Thread snapThread = null;
    private volatile boolean snapStale = false;
    private boolean forceSnap = false;
    private ZoomPanel zoomer = new ZoomPanel(16, 16);

    public RegionBrowser() {
        this.aScreen = new Rectangle(ORIGIN, this.toolkit.getScreenSize());
        this.setPreferredSize(new Dimension(this.aScreen.width / 5, this.aScreen.height / 5));
        this.cursors[0] = Cursor.getPredefinedCursor(13);
        this.cursors[3] = Cursor.getPredefinedCursor(7);
        this.cursors[5] = Cursor.getPredefinedCursor(6);
        this.cursors[10] = Cursor.getPredefinedCursor(5);
        this.cursors[12] = Cursor.getPredefinedCursor(4);
        this.cursors[1] = Cursor.getPredefinedCursor(8);
        this.cursors[8] = Cursor.getPredefinedCursor(9);
        this.cursors[2] = Cursor.getPredefinedCursor(11);
        this.cursors[4] = Cursor.getPredefinedCursor(10);
        this.cursors[16] = Cursor.getPredefinedCursor(1);
        this.cursors[32] = Cursor.getPredefinedCursor(0);
        this.setCursor(this.cursors[this.mode]);
        this.add(this.zoomer);
        this.addMouseMotionListener(this);
        this.addMouseListener(this);
        try {
            this.setFocusable(true);
            KeyAdapter keyMaster = new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent ev) {
                    int key = ev.getKeyCode();
                    if (key == 8) {
                        RegionBrowser.this.setRegion(null);
                    } else if (key == 127) {
                        RegionBrowser.this.setRegion(null);
                    } else if (key == 37) {
                        RegionBrowser.this.selectPreviousRect();
                    } else if (key == 40) {
                        RegionBrowser.this.selectPreviousRect();
                    } else if (key == 39) {
                        RegionBrowser.this.selectNextRect();
                    } else if (key == 38) {
                        RegionBrowser.this.selectNextRect();
                    } else {
                        return;
                    }
                    ev.consume();
                }
            };
            this.addKeyListener(keyMaster);
        }
        catch (Throwable ignored) {
            // empty catch block
        }
        LineBorder focusBorder = new LineBorder(Color.BLACK, 1){
            private final Color BLANK;
            private final Color FOCUS;
            {
                this.BLANK = new Color(0, 0, 0, 0);
                this.FOCUS = new Color(96, 96, 255);
            }

            @Override
            public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
                this.lineColor = c.isFocusOwner() ? this.FOCUS : this.BLANK;
                super.paintBorder(c, g, x, y, w, h);
            }
        };
        Border spacerBorder = BorderFactory.createEmptyBorder(1, 1, 1, 1);
        this.setBorder(BorderFactory.createCompoundBorder(focusBorder, spacerBorder));
        this.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent ev) {
                RegionBrowser.this.repaint();
            }

            @Override
            public void focusLost(FocusEvent ev) {
                RegionBrowser.this.repaint();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        Debug.lockEnter((Object)this, (String)"dispose", null, (Object)this);
        RegionBrowser regionBrowser = this;
        synchronized (regionBrowser) {
            this.snapStale = false;
            this.snapThread = null;
        }
        Debug.lockLeave((Object)this, (String)"dispose", null, (Object)this);
        this.screenShot.clear();
        if (this.scaledImage != null) {
            this.scaledImage.flush();
        }
        this.scaledImage = null;
        this.zoomer.dispose();
    }

    public boolean isUsingSnapShot() {
        return this.useSnapShot;
    }

    public void setUsingSnapShot(boolean snap) {
        if (snap == this.useSnapShot) {
            return;
        }
        this.useSnapShot = snap;
        this.forceSnap |= snap;
        this.repaint();
    }

    public void setZoom(boolean zoom) {
        this.zoomer.setVisible(zoom);
    }

    public void setZoomSize(int dim) {
        this.zoomer.setSize(dim, dim);
        this.zoomer.setVisible(dim > 0);
    }

    public boolean isZooming() {
        return this.zoomer.isVisible();
    }

    @Override
    public void setEnabled(boolean enable) {
        super.setEnabled(enable);
        if (enable) {
            this.mode = this.savedMode;
        } else {
            this.savedMode = this.mode;
            this.mode = 32;
        }
        this.setCursor(this.cursors[this.mode]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRegionListener(RegionListener l) {
        Debug.lockEnter((Object)this, (String)"addRegionListener", null, (Object)this);
        RegionBrowser regionBrowser = this;
        synchronized (regionBrowser) {
            if (!this.listeners.contains(l)) {
                ArrayList newList = (ArrayList)this.listeners.clone();
                newList.add(l);
                this.listeners = newList;
            }
        }
        Debug.lockLeave((Object)this, (String)"addRegionListener", null, (Object)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRegionListener(RegionListener l) {
        Debug.lockEnter((Object)this, (String)"addRegionListener", null, (Object)this);
        RegionBrowser regionBrowser = this;
        synchronized (regionBrowser) {
            ArrayList newList = (ArrayList)this.listeners.clone();
            newList.remove(l);
            this.listeners = newList;
        }
        Debug.lockLeave((Object)this, (String)"addRegionListener", null, (Object)this);
    }

    private void fireRegionChanged() {
        RegionEvent e = new RegionEvent(this, this.aRegion);
        for (RegionListener l : this.listeners) {
            try {
                l.regionChanged(e);
            }
            catch (Exception ex) {
                LogSupport.exception((Object)this, (String)"fireRegionChanged", (Throwable)ex, (boolean)true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addActionListener(ActionListener l) {
        Debug.lockEnter((Object)this, (String)"addActionListener", null, (Object)this);
        RegionBrowser regionBrowser = this;
        synchronized (regionBrowser) {
            if (!this.actionListeners.contains(l)) {
                ArrayList newList = (ArrayList)this.actionListeners.clone();
                newList.add(l);
                this.actionListeners = newList;
            }
        }
        Debug.lockLeave((Object)this, (String)"addActionListener", null, (Object)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeActionListener(ActionListener l) {
        Debug.lockEnter((Object)this, (String)"removeActionListener", null, (Object)this);
        RegionBrowser regionBrowser = this;
        synchronized (regionBrowser) {
            ArrayList newList = (ArrayList)this.actionListeners.clone();
            newList.remove(l);
            this.actionListeners = newList;
        }
        Debug.lockLeave((Object)this, (String)"removeActionListener", null, (Object)this);
    }

    private void fireActionPerformed(int id, String cmd, int mods) {
        ActionEvent e = new ActionEvent(this, id, cmd, mods);
        for (ActionListener l : this.actionListeners) {
            try {
                l.actionPerformed(e);
            }
            catch (Exception ex) {
                LogSupport.exception((Object)this, (String)"fireActionPerformed", (Throwable)ex, (boolean)true);
            }
        }
    }

    private void selectPreviousRect() {
        this.selectedRectIdx = this.aWindow.length == 0 || this.selectedRectIdx == this.aWindow.length - 1 ? -1 : (this.selectedRectIdx < 0 || this.selectedRectIdx >= this.aWindow.length ? 0 : (this.selectedRectIdx + 1) % this.aWindow.length);
        Rectangle toSelect = null;
        if (this.selectedRectIdx >= 0 && this.selectedRectIdx < this.aWindow.length) {
            toSelect = this.aWindow[this.selectedRectIdx];
        }
        this.setRegion(toSelect);
        this.repaint();
    }

    private void selectNextRect() {
        this.selectedRectIdx = this.aWindow.length == 0 || this.selectedRectIdx == 0 ? -1 : (this.selectedRectIdx < 0 || this.selectedRectIdx >= this.aWindow.length ? this.aWindow.length - 1 : (this.selectedRectIdx - 1) % this.aWindow.length);
        Rectangle toSelect = null;
        if (this.selectedRectIdx >= 0 && this.selectedRectIdx < this.aWindow.length) {
            toSelect = this.aWindow[this.selectedRectIdx];
        }
        this.setRegion(toSelect);
        this.repaint();
    }

    public Rectangle getRegion() {
        return this.aRegion;
    }

    public void setRegion(Rectangle rgn) {
        this.aRegion = rgn == null ? new Rectangle() : new Rectangle(rgn);
        if (this.selectedRectIdx >= 0 && this.selectedRectIdx < this.aWindow.length && !this.aRegion.equals(this.aWindow[this.selectedRectIdx])) {
            this.selectedRectIdx = -1;
        }
        this.clip(this.aRegion, this.aScreen);
        this.sRegion = this.getScaled(this.aRegion, this.sRegion);
        this.fireRegionChanged();
        this.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setWindows(Rectangle[] wins) {
        boolean showing;
        Rectangle selectedRect = null;
        if (this.selectedRectIdx >= 0 && this.selectedRectIdx < this.aWindow.length) {
            selectedRect = this.aWindow[this.selectedRectIdx];
        }
        this.selectedRectIdx = -1;
        this.aWindow = wins;
        boolean changed = this.sWindow == null || this.sWindow.length != wins.length;
        Rectangle[] tmpWindow = new Rectangle[this.aWindow.length];
        for (int i = 0; i < this.aWindow.length; ++i) {
            if (selectedRect != null && this.selectedRectIdx < 0 && this.aWindow[i].equals(selectedRect)) {
                this.selectedRectIdx = i;
            }
            tmpWindow[i] = this.getScaled(this.aWindow[i], null);
            if (changed) continue;
            changed = !tmpWindow[i].equals(this.sWindow[i]);
        }
        if (changed) {
            this.sWindow = tmpWindow;
        }
        if (showing = this.isShowing()) {
            try {
                Point where = this.getLocationOnScreen();
                Dimension size = this.getSize();
                Rectangle bounds = new Rectangle(where, size);
                Rectangle desktop = GuiUtils.getDesktopBounds();
                showing = bounds.intersects(desktop);
            }
            catch (Throwable t) {
                showing = false;
            }
        }
        if (!showing) {
            this.forceSnap = true;
            return;
        }
        long dt = System.currentTimeMillis() - this.screenShot.getSnapTime();
        if (changed || dt > 15000L || this.forceSnap) {
            this.forceSnap = false;
            if (!this.useSnapShot) {
                this.repaint();
                return;
            }
            Debug.lockEnter((Object)this, (String)"setWindows", null, (Object)this);
            RegionBrowser regionBrowser = this;
            synchronized (regionBrowser) {
                if (this.snapThread == null || !this.snapThread.isAlive()) {
                    this.snapStale = false;
                    this.snapThread = new WorkerThread("Region Browser SnapShot Thread"){
                        Runnable repainter;
                        {
                            this.repainter = new Runnable(){

                                @Override
                                public void run() {
                                    RegionBrowser.this.repaint();
                                    RegionBrowser.this.zoomer.repaint();
                                }
                            };
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         * Enabled aggressive block sorting
                         * Enabled unnecessary exception pruning
                         * Enabled aggressive exception aggregation
                         * Converted monitor instructions to comments
                         * Lifted jumps to return sites
                         */
                        public void run() {
                            while (true) {
                                block11: {
                                    if (RegionBrowser.this.screenShot.takeSnapshot(RegionBrowser.this.aScreen)) {
                                        SwingRunnerSupport.invokeLater((Runnable)this.repainter);
                                    }
                                    Debug.lockEnter((Object)((Object)this), (String)"run", null, (Object)RegionBrowser.this);
                                    RegionBrowser regionBrowser = RegionBrowser.this;
                                    // MONITORENTER : regionBrowser
                                    if (RegionBrowser.this.snapThread == this) break block11;
                                    // MONITOREXIT : regionBrowser
                                    Debug.lockLeave((Object)((Object)this), (String)"run", null, (Object)RegionBrowser.this);
                                    return;
                                }
                                if (!RegionBrowser.this.snapStale) {
                                    RegionBrowser.this.snapThread = null;
                                    // MONITOREXIT : regionBrowser
                                    Debug.lockLeave((Object)((Object)this), (String)"run", null, (Object)RegionBrowser.this);
                                    return;
                                }
                                try {
                                    RegionBrowser.this.snapStale = false;
                                    // MONITOREXIT : regionBrowser
                                    continue;
                                }
                                finally {
                                    Debug.lockLeave((Object)((Object)this), (String)"run", null, (Object)RegionBrowser.this);
                                    continue;
                                }
                                break;
                            }
                        }
                    };
                    this.snapThread.setDaemon(true);
                    this.snapThread.start();
                } else {
                    this.snapStale |= changed;
                }
            }
            Debug.lockLeave((Object)this, (String)"setWindows", null, (Object)this);
            this.repaint();
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        boolean wireframe;
        Dimension size = this.getSize();
        boolean bl = wireframe = !this.useSnapShot;
        if (size.height < 1 || size.width < 1) {
            return;
        }
        this.rescale();
        Rectangle r = new Rectangle(0, 0, 0, 0);
        Insets insets = this.getInsets();
        size.width -= insets.left + insets.right;
        size.height -= insets.top + insets.bottom;
        Graphics2D g2 = (Graphics2D)g.create(insets.left, insets.top, size.width, size.height);
        g2.setColor(this.getBackground());
        g2.fillRect(0, 0, size.width, size.height);
        if (!wireframe && this.screenShot.hasSnapshot()) {
            if (!(this.scaledImage != null && this.scaledImageTime == this.screenShot.getSnapTime() && this.scaledImageWidth == this.sScreen.width && this.scaledImageHeight == this.sScreen.height || this.scalerThread != null && this.scalerThread.isAlive())) {
                this.scalerThread = new WorkerThread("RegionBrowser Scaling Thread"){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        try {
                            final Image tmpImage = RegionBrowser.this.scaledImage;
                            if (tmpImage != null) {
                                SwingRunnerSupport.invokeLater((Runnable)new Runnable(){

                                    @Override
                                    public void run() {
                                        tmpImage.flush();
                                    }
                                });
                            }
                            RegionBrowser.this.scaledImageTime = RegionBrowser.this.screenShot.getSnapTime();
                            RegionBrowser.this.scaledImageWidth = ((RegionBrowser)RegionBrowser.this).sScreen.width;
                            RegionBrowser.this.scaledImageHeight = ((RegionBrowser)RegionBrowser.this).sScreen.height;
                            RegionBrowser.this.scaledImage = RegionBrowser.this.screenShot.getScaledImage(RegionBrowser.this.aScreen, RegionBrowser.this.scaledImageWidth, RegionBrowser.this.scaledImageHeight, AppShareDebug.REGION_SCALE.show());
                            RegionBrowser.this.repaint();
                        }
                        catch (Throwable t) {
                            LogSupport.message((Object)((Object)this), (String)"run (for RegionBrowser.paintComponent)", (String)Debug.getStackTrace((Throwable)t));
                            RegionBrowser.this.scaledImage = null;
                        }
                        finally {
                            RegionBrowser.this.scalerThread = null;
                        }
                    }
                };
                this.scalerThread.setDaemon(true);
                this.scalerThread.start();
            }
            if (this.scaledImage != null) {
                g2.drawImage(this.scaledImage, 0, 0, null);
            }
        } else {
            g2.setColor(this.outBackground);
            g2.fillRect(0, 0, this.sScreen.width, this.sScreen.height);
            wireframe = true;
        }
        if (wireframe && this.sRegion != null) {
            g2.setColor(this.inBackground);
            g2.fillRect(this.sRegion.x, this.sRegion.y, this.sRegion.width, this.sRegion.height);
        }
        Rectangle[] paintList = this.sWindow;
        for (int i = paintList.length - 1; i >= 0; --i) {
            r.setBounds(paintList[i]);
            this.clip(r, this.sScreen);
            if (r.width <= 0 || r.height <= 0) continue;
            if (wireframe) {
                if (this.sRegion == null) {
                    this.paintOut(g2, r);
                    continue;
                }
                if (this.sRegion.intersects(r)) {
                    this.paintOut(g2, r);
                    this.paintIn(g2, this.sRegion.intersection(r));
                    continue;
                }
                this.paintOut(g2, r);
                continue;
            }
            boolean obscured = false;
            for (int j = i - 1; j >= 0; --j) {
                if (!paintList[j].intersection(r).equals(r)) continue;
                obscured = true;
                break;
            }
            if (!obscured) continue;
        }
        if (this.sRegion != null && !this.sRegion.isEmpty() && this.sRegion.intersects(this.sScreen)) {
            if (!wireframe) {
                g2.setColor(this.outSelectAlpha);
                if (this.sRegion.x > 0) {
                    g2.fillRect(0, 0, this.sRegion.x, this.sScreen.height);
                }
                if (this.sRegion.x + this.sRegion.width < this.sScreen.width) {
                    g2.fillRect(this.sRegion.x + this.sRegion.width, 0, this.sScreen.width - this.sRegion.x - this.sRegion.width, this.sScreen.height);
                }
                if (this.sRegion.y > 0) {
                    g2.fillRect(this.sRegion.x, 0, this.sRegion.width, this.sRegion.y);
                }
                if (this.sRegion.y + this.sRegion.height < this.sScreen.height) {
                    g2.fillRect(this.sRegion.x, this.sRegion.y + this.sRegion.height, this.sRegion.width, this.sScreen.height - this.sRegion.y - this.sRegion.height);
                }
                g2.setColor(this.inSelectAlpha);
                g2.fillRect(this.sRegion.x, this.sRegion.y, this.sRegion.width, this.sRegion.height);
            }
            g2.setColor(this.getForeground());
            g2.drawRect(this.sRegion.x, this.sRegion.y, this.sRegion.width, this.sRegion.height);
        }
    }

    private void paintIn(Graphics g, Rectangle r) {
        g.setColor(this.inFillColor);
        g.fillRect(r.x, r.y, r.width, r.height);
        g.setColor(this.inEdgeColor);
        g.drawRect(r.x, r.y, r.width, r.height);
    }

    private void paintOut(Graphics g, Rectangle r) {
        g.setColor(this.outFillColor);
        g.fillRect(r.x, r.y, r.width, r.height);
        g.setColor(this.outEdgeColor);
        g.drawRect(r.x, r.y, r.width, r.height);
    }

    private void rescale() {
        Dimension scr = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension size = this.getSize();
        Insets insets = this.getInsets();
        size.width -= insets.left + insets.right;
        size.height -= insets.top + insets.bottom;
        float xFactor = (float)size.width / (float)scr.width;
        float yFactor = (float)size.height / (float)scr.height;
        float factor = xFactor < yFactor ? xFactor : yFactor;
        if ((double)Math.abs(factor - this.scale) > 1.0E-4) {
            this.scale = factor;
            this.aScreen = new Rectangle(ORIGIN, scr);
            this.sScreen = this.getScaled(this.aScreen, this.sScreen);
            this.sRegion = this.getScaled(this.aRegion, this.sRegion);
            for (int i = 0; i < this.aWindow.length; ++i) {
                this.sWindow[i] = this.getScaled(this.aWindow[i], this.sWindow[i]);
            }
        }
    }

    private Rectangle getScaled(Rectangle in, Rectangle out) {
        if (in == null) {
            return null;
        }
        if (out == null) {
            out = new Rectangle();
        }
        out.setBounds(this.getScaled(in.x), this.getScaled(in.y), this.getScaled(in.width), this.getScaled(in.height));
        return out;
    }

    private Rectangle getUnscaled(Rectangle in, Rectangle out) {
        if (in == null) {
            return null;
        }
        if (out == null) {
            out = new Rectangle();
        }
        out.setBounds(this.getUnscaled(in.x), this.getUnscaled(in.y), this.getUnscaled(in.width), this.getUnscaled(in.height));
        return out;
    }

    private Point getScaled(Point in, Point out) {
        if (in == null) {
            return null;
        }
        if (out == null) {
            out = new Point(in);
        }
        out.x = this.getScaled(in.x);
        out.y = this.getScaled(in.y);
        return out;
    }

    private Point getUnscaled(Point in, Point out) {
        if (in == null) {
            return null;
        }
        if (out == null) {
            out = new Point(in);
        }
        out.x = this.getUnscaled(in.x);
        out.y = this.getUnscaled(in.y);
        return out;
    }

    private int getScaled(int d) {
        return (int)((float)d * this.scale);
    }

    private int getUnscaled(int d) {
        return (int)((float)d / this.scale);
    }

    private Point getCorner(Rectangle rect, int which) {
        switch (which) {
            case 5: {
                return new Point(rect.x, rect.y);
            }
            case 3: {
                return new Point(rect.x + rect.width, rect.y);
            }
            case 12: {
                return new Point(rect.x, rect.y + rect.height);
            }
            case 10: {
                return new Point(rect.x + rect.width, rect.y + rect.height);
            }
        }
        return null;
    }

    private boolean clip(Rectangle in, Rectangle clip) {
        boolean clipped;
        int x1 = Math.max(in.x, clip.x);
        int x2 = Math.min(in.x + in.width, clip.x + clip.width);
        int y1 = Math.max(in.y, clip.y);
        int y2 = Math.min(in.y + in.height, clip.y + clip.height);
        int w = x2 - x1;
        int h = y2 - y1;
        boolean bl = clipped = in.x != x1 || in.y != y1 || in.width != w || in.height != h;
        if (clipped) {
            if (w < 0 || h < 0) {
                in.x = clip.x;
                in.y = clip.y;
                in.width = 0;
                in.height = 0;
            } else {
                in.x = x1;
                in.y = y1;
                in.width = w;
                in.height = h;
            }
        }
        return clipped;
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        int newMode;
        Insets insets = this.getInsets();
        Point pt = new Point(e.getX(), e.getY());
        pt.x -= insets.left;
        pt.y -= insets.top;
        if (this.sRegion == null) {
            newMode = 16;
        } else {
            newMode = 0;
            if (Math.abs(pt.x - (this.sRegion.x + this.sRegion.width)) <= 1) {
                newMode += 2;
            } else if (Math.abs(pt.x - this.sRegion.x) <= 1) {
                newMode += 4;
            }
            if (Math.abs(pt.y - (this.sRegion.y + this.sRegion.height)) <= 1) {
                newMode += 8;
            } else if (Math.abs(pt.y - this.sRegion.y) <= 1) {
                ++newMode;
            }
            if (newMode == 0 && !this.sRegion.contains(pt)) {
                newMode = 16;
            }
        }
        if (this.mode == 32) {
            this.savedMode = newMode;
        } else if (newMode != this.mode) {
            this.mode = newMode;
            this.setCursor(this.cursors[this.mode]);
        }
        if (this.zoomer.isVisible()) {
            Point uPt = this.getUnscaled(pt, null);
            this.zoomer.centerOn(uPt, e.getPoint());
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (this.mode == 32) {
            return;
        }
        Insets insets = this.getInsets();
        Point pt = new Point(e.getX(), e.getY());
        pt.x -= insets.left;
        pt.y -= insets.top;
        if (AppShareDebug.REGION_DRAG.show()) {
            LogSupport.message((Object)this, (String)"mouseDragged", (String)("@" + pt.x + "," + pt.y + " " + e.paramString()));
        }
        Point uPt = this.getUnscaled(pt, null);
        boolean changed = false;
        if (!this.sScreen.contains(pt)) {
            return;
        }
        if (this.last != null && !pt.equals(this.last)) {
            this.didDrag = true;
        }
        if (this.aRegion == null) {
            this.sRegion = this.last != null ? new Rectangle(this.last, new Dimension(0, 0)) : new Rectangle(pt, new Dimension(0, 0));
            this.aRegion = this.getUnscaled(this.sRegion, this.aRegion);
        }
        if (this.mode == 0) {
            if (this.last != null) {
                int dx = this.getUnscaled(pt.x - this.last.x);
                int dy = this.getUnscaled(pt.y - this.last.y);
                this.aRegion.translate(dx, dy);
                if (this.aRegion.x < 0) {
                    this.aRegion.x = 0;
                }
                if (this.aRegion.y < 0) {
                    this.aRegion.y = 0;
                }
                if (this.aRegion.x + this.aRegion.width > this.aScreen.width) {
                    this.aRegion.x = this.aScreen.width - this.aRegion.width;
                }
                if (this.aRegion.y + this.aRegion.height > this.aScreen.height) {
                    this.aRegion.y = this.aScreen.height - this.aRegion.height;
                }
            }
        } else if (this.mode == 8 || this.mode == 1) {
            if (this.anchor == null) {
                this.anchor = this.mode == 8 ? this.getCorner(this.aRegion, 5) : this.getCorner(this.aRegion, 12);
            }
            int y = Math.min(this.anchor.y, uPt.y);
            int h = Math.abs(this.anchor.y - uPt.y);
            this.aRegion.setBounds(this.aRegion.x, y, this.aRegion.width, h);
        } else if (this.mode == 4 || this.mode == 2) {
            if (this.anchor == null) {
                this.anchor = this.mode == 2 ? this.getCorner(this.aRegion, 5) : this.getCorner(this.aRegion, 3);
            }
            int x = Math.min(this.anchor.x, uPt.x);
            int w = Math.abs(this.anchor.x - uPt.x);
            this.aRegion.setBounds(x, this.aRegion.y, w, this.aRegion.height);
        } else {
            if (this.anchor == null) {
                switch (this.mode) {
                    case 3: {
                        this.anchor = this.getCorner(this.aRegion, 12);
                        break;
                    }
                    case 5: {
                        this.anchor = this.getCorner(this.aRegion, 10);
                        break;
                    }
                    case 10: {
                        this.anchor = this.getCorner(this.aRegion, 5);
                        break;
                    }
                    case 12: {
                        this.anchor = this.getCorner(this.aRegion, 3);
                        break;
                    }
                    case 16: {
                        this.anchor = this.getUnscaled(this.last, null);
                    }
                }
            }
            int x = Math.min(this.anchor.x, uPt.x);
            int y = Math.min(this.anchor.y, uPt.y);
            int w = Math.abs(this.anchor.x - uPt.x);
            int h = Math.abs(this.anchor.y - uPt.y);
            this.aRegion.setBounds(x, y, w, h);
        }
        this.clip(this.aRegion, this.aScreen);
        this.sRegion = this.getScaled(this.aRegion, this.sRegion);
        this.fireRegionChanged();
        this.last = pt;
        this.repaint();
        if (this.zoomer.isVisible()) {
            this.zoomer.centerOn(uPt, e.getPoint());
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (this.mode == 32) {
            return;
        }
        Insets insets = this.getInsets();
        Point pt = new Point(e.getX(), e.getY());
        pt.x -= insets.left;
        pt.y -= insets.top;
        if (AppShareDebug.REGION_DRAG.show()) {
            LogSupport.message((Object)this, (String)"mousePressed", (String)("@" + pt.x + "," + pt.y + " " + e.paramString()));
        }
        this.didDrag = false;
        this.last = pt;
        this.anchor = null;
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (this.mode == 32) {
            return;
        }
        Insets insets = this.getInsets();
        Point pt = new Point(e.getX(), e.getY());
        pt.x -= insets.left;
        pt.y -= insets.top;
        if (AppShareDebug.REGION_DRAG.show()) {
            LogSupport.message((Object)this, (String)"mouseReleased", (String)("@" + pt.x + "," + pt.y + " " + e.paramString()));
        }
        this.last = null;
        this.anchor = null;
        this.requestFocus();
        if (this.didDrag) {
            return;
        }
        int numClicks = e.getClickCount();
        if (numClicks == 1) {
            if (this.sRegion != null && this.sRegion.contains(pt)) {
                return;
            }
            Rectangle[] winList = this.sWindow;
            for (int i = 0; i < winList.length; ++i) {
                if (!winList[i].contains(pt)) continue;
                if (e.isShiftDown() && this.aRegion != null) {
                    this.aRegion = this.aRegion.union(this.aWindow[i]);
                    this.clip(this.aRegion, this.aScreen);
                    this.sRegion = this.getScaled(this.aRegion, this.sRegion);
                } else {
                    this.aRegion = new Rectangle(this.aWindow[i]);
                    this.clip(this.aRegion, this.aScreen);
                    this.sRegion = this.getScaled(this.aRegion, this.sRegion);
                }
                this.selectedRectIdx = this.aRegion.equals(this.aWindow[i]) ? i : -1;
                this.mouseMoved(e);
                this.fireRegionChanged();
                this.repaint();
                return;
            }
            this.setRegion(null);
            this.selectedRectIdx = -1;
        } else if (numClicks == 2) {
            int mouseMods = e.getModifiers();
            int actionMods = 0;
            if ((mouseMods & 8) != 0) {
                actionMods |= 8;
            }
            if ((mouseMods & 2) != 0) {
                actionMods |= 2;
            }
            if ((mouseMods & 4) != 0) {
                actionMods |= 4;
            }
            if ((mouseMods & 1) != 0) {
                actionMods |= 1;
            }
            this.fireActionPerformed(1, DOUBLE_CLICK_CMD, actionMods);
        }
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    private class ZoomPanel
    extends JPanel {
        private Rectangle origBounds;
        private Rectangle imgBounds;
        private int drawX = 0;
        private int drawY = 0;
        private Image img = null;
        private Color lineColour = new Color(0, 0, 0, 128);

        ZoomPanel(int w, int h) {
            this.origBounds = new Rectangle();
            this.imgBounds = new Rectangle();
            this.setSize(w, h);
            this.setPreferredSize(new Dimension(w, h));
            this.setMaximumSize(new Dimension(w, h));
            this.setMinimumSize(new Dimension(w, h));
            this.origBounds.setBounds(0, 0, w, h);
            this.setBorder(BorderFactory.createLineBorder(Color.DARK_GRAY, 1));
        }

        void dispose() {
            if (this.img != null) {
                this.img.flush();
            }
            this.img = null;
            this.imgBounds.setBounds(0, 0, 0, 0);
        }

        @Override
        public void setBounds(int x, int y, int w, int h) {
            Rectangle bounds = this.getBounds();
            if (w != bounds.width || h != bounds.height) {
                this.setPreferredSize(new Dimension(w, h));
                this.setMaximumSize(new Dimension(w, h));
                this.setMinimumSize(new Dimension(w, h));
            }
            Point centre = new Point(x + w / 2, y + h / 2);
            Point orig = RegionBrowser.this.getUnscaled(centre, null);
            this.origBounds.setBounds(orig.x - w / 2, orig.y - h / 2, w, h);
            this.repaint();
            super.setBounds(x, y, w, h);
        }

        void centerOn(Point orig, Point scaled) {
            int x = orig.x - this.origBounds.width / 2;
            int y = orig.y - this.origBounds.height / 2;
            if (x == this.origBounds.x && y == this.origBounds.y) {
                return;
            }
            this.origBounds.setLocation(x, y);
            super.setBounds(scaled.x - this.origBounds.width / 2, scaled.y - this.origBounds.height / 2, this.origBounds.width, this.origBounds.height);
            this.repaint();
        }

        @Override
        public void paintComponent(Graphics g) {
            Rectangle r;
            if (!this.isShowing()) {
                return;
            }
            Rectangle bounds = this.getBounds();
            bounds.y = 0;
            bounds.x = 0;
            Insets ins = this.getInsets();
            bounds.x += ins.left;
            bounds.y += ins.top;
            bounds.width -= ins.left + ins.right;
            bounds.height -= ins.top + ins.bottom;
            g.clearRect(bounds.x, bounds.y, bounds.width, bounds.height);
            if (RegionBrowser.this.useSnapShot && RegionBrowser.this.screenShot.hasSnapshot()) {
                if (this.img == null || !this.imgBounds.equals(this.origBounds)) {
                    try {
                        this.drawY = 0;
                        this.drawX = 0;
                        Rectangle area = RegionBrowser.this.screenShot.getBounds();
                        Rectangle clipped = area.intersection(this.origBounds);
                        if (!clipped.isEmpty()) {
                            this.img = RegionBrowser.this.screenShot.getImage(clipped);
                            this.imgBounds.setBounds(clipped);
                            if (this.origBounds.x < clipped.x) {
                                this.drawX = clipped.x - this.origBounds.x;
                            }
                            if (this.origBounds.y < clipped.y) {
                                this.drawY = clipped.y - this.origBounds.y;
                            }
                        }
                    }
                    catch (Throwable t) {
                        this.img = null;
                        this.imgBounds.setBounds(0, 0, 0, 0);
                        LogSupport.exception((Object)this, (String)"paintComponent", (Throwable)t, (boolean)true, (String)("Getting image for " + this.origBounds + " from " + RegionBrowser.this.screenShot));
                    }
                }
                if (this.img != null) {
                    g.drawImage(this.img, this.drawX, this.drawY, null);
                    this.img.flush();
                }
            }
            if (this.intersectsEdge(this.origBounds, r = new Rectangle(RegionBrowser.this.aRegion))) {
                r.translate(-this.origBounds.x, -this.origBounds.y);
                g.setColor(this.lineColour);
                g.drawRect(r.x, r.y, r.width, r.height);
                g.drawRect(r.x - 1, r.y - 1, r.width + 2, r.height + 2);
            }
        }

        private boolean intersectsEdge(Rectangle area, Rectangle bounds) {
            if (area.isEmpty()) {
                return false;
            }
            if (!area.intersects(bounds)) {
                return false;
            }
            int areaRight = area.x + area.width - 1;
            int areaBottom = area.y + area.height - 1;
            int edgeRight = bounds.x + bounds.width - 1;
            int edgeBottom = bounds.y + bounds.height - 1;
            if (bounds.x >= area.x && bounds.x <= areaRight) {
                return true;
            }
            if (edgeRight >= area.x && edgeRight <= areaRight) {
                return true;
            }
            if (bounds.y >= area.y && bounds.y <= areaBottom) {
                return true;
            }
            return edgeBottom >= area.y && edgeBottom <= areaBottom;
        }
    }
}

