/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.appshare.module;

import com.elluminate.groupware.appshare.module.Java7Translucency;
import com.elluminate.groupware.appshare.module.TranslucencyHelper;
import com.elluminate.util.Debug;
import com.elluminate.util.log.LogSupport;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Window;
import java.lang.reflect.Field;
import java.lang.reflect.Method;

class Java6Translucency
extends TranslucencyHelper {
    private boolean available = false;
    private boolean translucencySupport = false;
    private boolean shapeSupport = false;
    private Class<?> utilitiesClass;
    private Method isCapableMethod;
    private Method setOpaqueMethod;
    private Method setShapeMethod;

    Java6Translucency() {
        try {
            this.utilitiesClass = Class.forName("com.sun.awt.AWTUtilities");
            this.setOpaqueMethod = this.utilitiesClass.getMethod("setWindowOpaque", Window.class, Boolean.TYPE);
            this.setShapeMethod = this.utilitiesClass.getMethod("setWindowShape", Window.class, Shape.class);
            this.isCapableMethod = this.utilitiesClass.getMethod("isTranslucencyCapable", GraphicsConfiguration.class);
            if (TRANS_OVERRIDE || !LINUX_TRANS_BUG) {
                if (TRANS_OVERRIDE && LINUX_TRANS_BUG) {
                    LogSupport.message(Java6Translucency.class, (String)"<init>", (String)"Transparency override in effect.");
                }
                this.available = this.checkPerPixelTranslucency();
            }
        }
        catch (Throwable t) {
            LogSupport.message(Java6Translucency.class, (String)"<init>", (String)Debug.getStackTrace((Throwable)t));
            this.available = false;
        }
    }

    @Override
    public boolean isAvailable() {
        return this.available;
    }

    @Override
    public boolean isWindowTranslucencySupported() {
        return this.translucencySupport;
    }

    @Override
    public GraphicsConfiguration getCompatibleGC(GraphicsDevice gDev) {
        if (!this.available) {
            throw new UnsupportedOperationException("No shaped/translucent window support.");
        }
        if (gDev == null) {
            gDev = this.getDefaultDevice();
        }
        GraphicsConfiguration gc = gDev.getDefaultConfiguration();
        Rectangle bounds = gc.getBounds();
        if (this.isCapable(gc)) {
            return gc;
        }
        GraphicsConfiguration[] gcList = gDev.getConfigurations();
        for (int ix = 0; ix < gcList.length; ++ix) {
            gc = gcList[ix];
            if (!bounds.equals(gc.getBounds()) || !this.isCapable(gc)) continue;
            return gc;
        }
        LogSupport.message(Java6Translucency.class, (String)"getCompatibleGC", (String)"No translucency capable configuration available.");
        throw new UnsupportedOperationException("No capable configuration found for device.");
    }

    @Override
    public void setWindowOpaque(Window win, boolean opaque) {
        if (!this.available) {
            LogSupport.message(Java6Translucency.class, (String)"setWindowOpaque", (String)"not available");
            return;
        }
        try {
            this.setOpaqueMethod.invoke(null, win, opaque);
        }
        catch (Throwable t) {
            LogSupport.message((Object)this, (String)"setWindowOpaque", (String)Debug.getStackTrace((Throwable)t));
        }
    }

    @Override
    public void setWindowShape(Window win, Shape shape) {
        if (IS_MAC) {
            return;
        }
        if (!this.available) {
            LogSupport.message(Java6Translucency.class, (String)"setWindowShape", (String)"translucency not available");
            return;
        }
        if (!this.shapeSupport) {
            LogSupport.message(Java6Translucency.class, (String)"setWindowShape", (String)"shaped windows not available");
            return;
        }
        try {
            this.setShapeMethod.invoke(null, win, shape);
        }
        catch (Throwable t) {
            LogSupport.message((Object)this, (String)"setWindowShape", (String)Debug.getStackTrace((Throwable)t));
        }
    }

    private boolean checkPerPixelTranslucency() {
        try {
            GraphicsDevice gDev = this.getDefaultDevice();
            if (gDev == null) {
                LogSupport.message(Java7Translucency.class, (String)"checkPerPixelTranslucency", (String)"Unable to obtain default GraphicsDevice.");
                return false;
            }
            Class<?> trns = Class.forName("com.sun.awt.AWTUtilities$Translucency");
            Method mthd = this.utilitiesClass.getMethod("isTranslucencySupported", trns);
            Field translucent = trns.getField("TRANSLUCENT");
            Field perPixelTranslucent = trns.getField("PERPIXEL_TRANSLUCENT");
            Field perPixelTransparent = trns.getField("PERPIXEL_TRANSPARENT");
            Boolean result = (Boolean)mthd.invoke(null, translucent.get(null));
            boolean bl = this.translucencySupport = TRANS_OVERRIDE || result != false;
            if (!this.translucencySupport) {
                LogSupport.message(Java6Translucency.class, (String)"checkPerPixelTranslucency", (String)"Window translucency not supported by JRE.");
            }
            result = (Boolean)mthd.invoke((Object)gDev, perPixelTransparent.get(null));
            this.shapeSupport = result;
            if (this.shapeSupport) {
                return true;
            }
            result = (Boolean)mthd.invoke((Object)gDev, perPixelTranslucent.get(null));
            if (result.booleanValue()) {
                if (!IS_MAC) {
                    LogSupport.message(Java6Translucency.class, (String)"checkPerPixelTranslucency", (String)"No shaped window support, faking it with translucency.");
                }
                return true;
            }
            LogSupport.message(Java6Translucency.class, (String)"checkPerPixelTranslucency", (String)"Per-pixel translucency not supported by JRE.");
        }
        catch (Throwable t) {
            LogSupport.message(Java6Translucency.class, (String)"checkPerPixelTranslucency", (String)Debug.getStackTrace((Throwable)t));
        }
        return false;
    }

    private boolean isCapable(GraphicsConfiguration gc) {
        try {
            Boolean result = (Boolean)this.isCapableMethod.invoke(null, gc);
            if (result.booleanValue()) {
                return true;
            }
        }
        catch (Throwable t) {
            LogSupport.message(Java6Translucency.class, (String)"isCapable", (String)Debug.getStackTrace((Throwable)t));
        }
        return false;
    }
}

