/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.appshare.module;

import com.elluminate.groupware.appshare.module.AppShareBean;
import com.elluminate.groupware.appshare.module.AppShareHostActions;
import com.elluminate.groupware.appshare.module.AppSharingHost;
import com.elluminate.groupware.appshare.module.StringsProperties;
import com.elluminate.gui.GuiUtils;
import com.elluminate.gui.component.AbstractPreferencesPanel;
import com.elluminate.gui.component.CColorPicker;
import com.elluminate.gui.component.PreferencesPanelOwner;
import com.elluminate.util.I18n;
import com.elluminate.util.Preferences;
import com.elluminate.util.PropertiesEnum;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

@Singleton
public class HostingOptionsPrefsPanel
extends AbstractPreferencesPanel {
    private I18n i18n;
    private JCheckBox hideContentBox;
    private JCheckBox bringToFrontBox;
    private CColorPicker aoiColorBtn;
    private JCheckBox adornCursorBox;
    private CColorPicker adornCursorColor;
    private JCheckBox showNotificationBox;
    private JComboBox imageQualityPopup;

    @Inject
    public HostingOptionsPrefsPanel(PreferencesPanelOwner owner, I18n i18n) {
        super(owner, i18n.getString((PropertiesEnum)StringsProperties.HOSTINGOPTIONS_TITLE));
        this.i18n = i18n;
    }

    protected void createContent() {
        this.setLayout(new BorderLayout());
        JPanel p = new JPanel(new BorderLayout(0, 6));
        this.add(p, "North");
        JPanel top = new JPanel(new GridBagLayout());
        p.add((Component)top, "Center");
        int kIndent = 20;
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.gridx = 0;
        gbc.weightx = 1.0;
        JLabel l = new JLabel(this.i18n.getString((PropertiesEnum)StringsProperties.HOSTINGOPTIONS_HOSTINGSTARTTITLE));
        gbc.insets.top = 8;
        gbc.insets.bottom = 3;
        top.add((Component)l, gbc);
        gbc.insets.top = 0;
        gbc.insets.bottom = 0;
        this.hideContentBox = new JCheckBox(this.i18n.getString((PropertiesEnum)StringsProperties.HOSTINGOPTIONS_HIDECONTENTBTN));
        gbc.insets.left = 20;
        top.add((Component)this.hideContentBox, gbc);
        Box aoiPane = Box.createHorizontalBox();
        JLabel aoiColorLabel = new JLabel(this.i18n.getString((PropertiesEnum)StringsProperties.HOSTINGOPTIONS_AOILABEL));
        this.aoiColorBtn = new CColorPicker(AppShareBean.DFT_AOI_COLOR);
        this.aoiColorBtn.setEnabled(AppSharingHost.isApertureAvailable());
        this.aoiColorBtn.getAccessibleContext().setAccessibleName(this.i18n.getString((PropertiesEnum)StringsProperties.HOSTINGOPTIONS_AOILABEL));
        this.aoiColorBtn.getAccessibleContext().setAccessibleDescription(this.i18n.getString((PropertiesEnum)StringsProperties.HOSTINGOPTIONS_AOILABEL));
        aoiColorLabel.setLabelFor((Component)this.aoiColorBtn);
        aoiPane.add(aoiColorLabel);
        aoiPane.add(Box.createHorizontalStrut(12));
        aoiPane.add((Component)this.aoiColorBtn);
        aoiPane.add(Box.createHorizontalGlue());
        gbc.insets.left = 0;
        gbc.insets.top = 18;
        top.add((Component)aoiPane, gbc);
        JPanel bottom = new JPanel(new GridBagLayout());
        p.add((Component)bottom, "South");
        gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.gridx = 0;
        l = new JLabel(this.i18n.getString((PropertiesEnum)StringsProperties.HOSTINGOPTIONS_OTHERTITLE));
        gbc.insets.top = 18;
        gbc.insets.bottom = 3;
        gbc.insets.left = 0;
        bottom.add((Component)l, gbc);
        gbc.insets.top = 0;
        gbc.insets.bottom = 0;
        gbc.insets.left = 20;
        this.bringToFrontBox = new JCheckBox(this.i18n.getString((PropertiesEnum)StringsProperties.HOSTINGOPTIONS_RAISEBTN));
        this.bringToFrontBox.setToolTipText(this.i18n.getString((PropertiesEnum)StringsProperties.HOSTINGOPTIONS_RAISETIP));
        bottom.add((Component)this.bringToFrontBox, gbc);
        Box adornPane = Box.createHorizontalBox();
        this.adornCursorBox = new JCheckBox(this.i18n.getString((PropertiesEnum)StringsProperties.HOSTINGOPTIONS_ADORNBTN));
        this.adornCursorBox.setToolTipText(this.i18n.getString((PropertiesEnum)StringsProperties.HOSTINGOPTIONS_ADORNTIP));
        this.adornCursorColor = new CColorPicker(AppShareBean.DFT_ADORN_CURSOR_COLOR);
        this.adornCursorColor.getAccessibleContext().setAccessibleName(this.i18n.getString((PropertiesEnum)StringsProperties.HOSTINGOPTIONS_ADORNCOLORPICKER));
        this.adornCursorColor.getAccessibleContext().setAccessibleDescription(this.i18n.getString((PropertiesEnum)StringsProperties.HOSTINGOPTIONS_ADORNCOLORPICKER));
        adornPane.add(this.adornCursorBox);
        adornPane.add(Box.createHorizontalStrut(12));
        adornPane.add((Component)this.adornCursorColor);
        adornPane.add(Box.createHorizontalGlue());
        gbc.insets.left = 20;
        bottom.add((Component)adornPane, gbc);
        this.showNotificationBox = new JCheckBox(this.i18n.getString((PropertiesEnum)StringsProperties.HOSTINGOPTIONS_NOTIFYBTN));
        this.showNotificationBox.setToolTipText(this.i18n.getString((PropertiesEnum)StringsProperties.HOSTINGOPTIONS_NOTIFYTIP));
        bottom.add((Component)this.showNotificationBox, gbc);
        JPanel p2 = new JPanel(new GridBagLayout());
        GridBagConstraints gbc2 = new GridBagConstraints();
        p2.add((Component)new JLabel(this.i18n.getString((PropertiesEnum)StringsProperties.HOSTINGOPTIONS_OPTLABEL)), gbc2);
        gbc2.insets.left = 6;
        this.imageQualityPopup = new JComboBox();
        this.imageQualityPopup.setToolTipText(this.i18n.getString((PropertiesEnum)StringsProperties.HOSTINGOPTIONS_OPTTIP));
        this.imageQualityPopup.setEditable(false);
        this.imageQualityPopup.addItem(this.i18n.getString((PropertiesEnum)StringsProperties.HOSTINGOPTIONS_OPTQUALITY0));
        this.imageQualityPopup.addItem(this.i18n.getString((PropertiesEnum)StringsProperties.HOSTINGOPTIONS_OPTQUALITY1));
        this.imageQualityPopup.addItem(this.i18n.getString((PropertiesEnum)StringsProperties.HOSTINGOPTIONS_OPTQUALITY2));
        this.imageQualityPopup.addItem(this.i18n.getString((PropertiesEnum)StringsProperties.HOSTINGOPTIONS_OPTQUALITY3));
        this.imageQualityPopup.addItem(this.i18n.getString((PropertiesEnum)StringsProperties.HOSTINGOPTIONS_OPTQUALITY4));
        p2.add((Component)this.imageQualityPopup, gbc2);
        gbc2.weightx = 1.0;
        gbc2.fill = 2;
        gbc2.insets.left = 0;
        p2.add(Box.createHorizontalGlue(), gbc2);
        gbc.insets.top = 18;
        gbc.insets.left = 0;
        bottom.add((Component)p2, gbc);
        gbc.insets.top = 0;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        bottom.add(Box.createHorizontalGlue(), gbc);
        this.hideContentBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HostingOptionsPrefsPanel.this.doHideContentBox();
            }
        });
        this.bringToFrontBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HostingOptionsPrefsPanel.this.doBringToFrontBox();
            }
        });
        this.adornCursorBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HostingOptionsPrefsPanel.this.doAdornCursorBox();
            }
        });
        this.showNotificationBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HostingOptionsPrefsPanel.this.doShowNotificationBox();
            }
        });
        this.imageQualityPopup.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HostingOptionsPrefsPanel.this.doImageQualityPopup();
            }
        });
        PropertyChangeListener colorListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent ev) {
                HostingOptionsPrefsPanel.this.doAOIColorBtn();
            }
        };
        this.aoiColorBtn.addPropertyChangeListener("color", colorListener);
        PropertyChangeListener adornListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent ev) {
                HostingOptionsPrefsPanel.this.doAdornCursorColor();
            }
        };
        this.adornCursorColor.addPropertyChangeListener("color", adornListener);
    }

    private void doHideContentBox() {
        this.setModified(true);
    }

    private void doBringToFrontBox() {
        this.setModified(true);
    }

    private void doAOIColorBtn() {
        this.setModified(true);
    }

    private void doAdornCursorBox() {
        this.setModified(true);
    }

    private void doAdornCursorColor() {
        this.setModified(true);
    }

    private void doShowNotificationBox() {
        this.setModified(true);
    }

    private void doImageQualityPopup() {
        this.setModified(true);
    }

    protected void populate(Preferences preferences) {
        String prefix = this.getOwnerPrefix();
        int actions = AppShareHostActions.getActions(prefix, preferences);
        int quality = AppShareHostActions.getQuality(prefix, preferences);
        this.bringToFrontBox.setSelected(AppShareHostActions.isRaiseActionEnabled(actions));
        this.aoiColorBtn.setColor(preferences.getColorSetting(prefix + ".aoiColor", AppShareBean.DFT_AOI_COLOR));
        this.adornCursorBox.setSelected(AppShareHostActions.isAdornCursorActionEnabled(actions));
        this.adornCursorColor.setColor(preferences.getColorSetting(prefix + ".adornCursorColor", AppShareBean.DFT_ADORN_CURSOR_COLOR));
        this.showNotificationBox.setSelected(AppShareHostActions.isNotifyActionEnabled(actions));
        if (quality >= 0 && quality < this.imageQualityPopup.getItemCount()) {
            this.imageQualityPopup.setSelectedIndex(quality);
        } else {
            this.imageQualityPopup.setSelectedIndex(2);
        }
        this.hideContentBox.setSelected(AppShareHostActions.isHideContentActionEnabled(actions));
    }

    protected void apply(Preferences preferences) {
        int actions = 0;
        int quality = 0;
        if (this.bringToFrontBox.isSelected()) {
            actions = AppShareHostActions.setRaiseActionEnabled(actions, true);
        }
        if (this.adornCursorBox.isSelected()) {
            actions = AppShareHostActions.setAdornCursorActionEnabled(actions, true);
        }
        if (this.showNotificationBox.isSelected()) {
            actions = AppShareHostActions.setNotifyActionEnabled(actions, true);
        }
        quality = this.imageQualityPopup.getSelectedIndex();
        if (this.hideContentBox.isSelected()) {
            actions = AppShareHostActions.setHideContentActionEnabled(actions, true);
        }
        String prefix = this.getOwnerPrefix();
        AppShareHostActions.setActions(prefix, preferences, actions);
        AppShareHostActions.setQuality(prefix, preferences, quality);
        preferences.setSetting(prefix + ".aoiColor", this.aoiColorBtn.getColor());
        preferences.setSetting(prefix + ".adornCursorColor", this.adornCursorColor.getColor());
    }

    protected void reset(Preferences preferences) {
        String prefix = this.getOwnerPrefix();
        AppShareHostActions.setActions(prefix, preferences, AppShareHostActions.getDefaultActions());
        AppShareHostActions.setQuality(prefix, preferences, AppShareHostActions.getDefaultQuality());
        preferences.setSetting(prefix + ".aoiColor", AppShareBean.DFT_AOI_COLOR);
        preferences.setSetting(prefix + ".adornCursorColor", AppShareBean.DFT_ADORN_CURSOR_COLOR);
    }

    private static boolean checkScreens() {
        Rectangle[] screens = GuiUtils.getScreenBounds(null);
        return screens.length > 1;
    }
}

