/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.appshare.module;

import java.util.EventObject;

public final class CursorDefinitionEvent
extends EventObject {
    private short height;
    private short hotspotX;
    private short hotspotY;
    private short index;
    private short[] pixels16;
    private int[] pixels32;
    private short width;
    private static final int CURSOR_MAX_INDEX = 255;
    static final int CURSOR_MAX_SIZE255 = 255;
    static final int CURSOR_MAX_SIZE_HALF = 127;

    public CursorDefinitionEvent(Object source, int index, int width, int height, int hotspotX, int hotspotY, short[] pixels) {
        super(source);
        if (pixels == null) {
            throw new IllegalArgumentException("Illegal pixels: null");
        }
        this.validateAndSetArguments(index, width, height, hotspotX, hotspotY);
        this.cropAndSaveCursorImageIfRequired(width, height, pixels, null, hotspotX, hotspotY);
    }

    public CursorDefinitionEvent(Object source, int index, int width, int height, int hotspotX, int hotspotY, int[] pixels) {
        super(source);
        if (pixels == null) {
            throw new IllegalArgumentException("Illegal pixels: null");
        }
        this.validateAndSetArguments(index, width, height, hotspotX, hotspotY);
        this.cropAndSaveCursorImageIfRequired(width, height, null, pixels, hotspotX, hotspotY);
    }

    private void cropAndSaveCursorImageIfRequired(int width, int height, short[] sPixels, int[] iPixels, int hotspotX, int hotspotY) {
        boolean isShort;
        boolean bl = isShort = sPixels != null;
        if (width > 255 || height > 255) {
            int newWidth = width;
            int startWidth = 0;
            if (width > 255) {
                newWidth = 255;
                startWidth = hotspotX - 127;
                if (startWidth < 0) {
                    startWidth = 0;
                }
                if (startWidth + 255 > width) {
                    startWidth = width - 255;
                }
                this.hotspotX = (short)(hotspotX - startWidth);
                this.width = (short)newWidth;
            }
            int newHeight = height;
            int startHeight = 0;
            if (height > 255) {
                newHeight = 255;
                startHeight = hotspotY - 127;
                if (startHeight < 0) {
                    startHeight = 0;
                }
                if (startHeight + 255 > height) {
                    startHeight = height - 255;
                }
                this.hotspotY = (short)(this.hotspotY - startHeight);
                this.height = (short)newHeight;
            }
            short[] sNewPixels = null;
            int[] iNewPixels = null;
            if (isShort) {
                sNewPixels = new short[newWidth * newHeight];
            } else {
                iNewPixels = new int[newWidth * newHeight];
            }
            int insertPnt = 0;
            for (int i = startHeight; i < startHeight + newHeight; ++i) {
                int extractPnt = i * width + startWidth;
                if (isShort) {
                    System.arraycopy(sPixels, extractPnt, sNewPixels, insertPnt, newWidth);
                } else {
                    System.arraycopy(iPixels, extractPnt, iNewPixels, insertPnt, newWidth);
                }
                insertPnt += newWidth;
            }
            if (isShort) {
                this.pixels16 = sNewPixels;
            } else {
                this.pixels32 = iNewPixels;
            }
            return;
        }
        if (isShort) {
            this.pixels16 = new short[width * height];
            System.arraycopy(sPixels, 0, this.pixels16, 0, width * height);
        }
        if (!isShort) {
            this.pixels32 = new int[width * height];
            System.arraycopy(iPixels, 0, this.pixels32, 0, width * height);
        }
    }

    private void validateAndSetArguments(int index, int width, int height, int hotspotX, int hotspotY) {
        if (index < 0 || index > 255) {
            throw new IllegalArgumentException("Illegal index: " + index);
        }
        if (width < 0) {
            throw new IllegalArgumentException("Illegal width: " + width);
        }
        if (height < 0) {
            throw new IllegalArgumentException("Illegal height: " + height);
        }
        if (hotspotX < 0 || hotspotX > 255) {
            throw new IllegalArgumentException("Illegal hotspotX: " + hotspotX);
        }
        if (hotspotY < 0 || hotspotY > 255) {
            throw new IllegalArgumentException("Illegal hotspotY: " + hotspotY);
        }
        this.index = (short)index;
        this.width = (short)width;
        this.height = (short)height;
        this.hotspotX = (short)hotspotX;
        this.hotspotY = (short)hotspotY;
    }

    public short getHeight() {
        return this.height;
    }

    public short getHotspotX() {
        return this.hotspotX;
    }

    public short getHotspotY() {
        return this.hotspotY;
    }

    public short getIndex() {
        return this.index;
    }

    public boolean has16BitPixels() {
        return this.pixels16 != null;
    }

    public boolean has32BitPixels() {
        return this.pixels32 != null;
    }

    public short[] getPixels16() {
        return this.pixels16;
    }

    public int[] getPixels32() {
        return this.pixels32;
    }

    public short getWidth() {
        return this.width;
    }
}

