/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.appshare.module;

import com.elluminate.contentcapture.ContentCaptureProvider;
import com.elluminate.groupware.appshare.AppShareDebug;
import com.elluminate.groupware.appshare.AppShareTile;
import com.elluminate.groupware.appshare.AppShareTileDecoder;
import com.elluminate.groupware.appshare.AppShareTileDefn;
import com.elluminate.groupware.appshare.AppShareTileDesc;
import com.elluminate.groupware.appshare.module.ButtonInputEvent;
import com.elluminate.groupware.appshare.module.ButtonInputListener;
import com.elluminate.groupware.appshare.module.CanvasDefinitionEvent;
import com.elluminate.groupware.appshare.module.CanvasDefinitionListener;
import com.elluminate.groupware.appshare.module.CursorChangeEvent;
import com.elluminate.groupware.appshare.module.CursorChangeListener;
import com.elluminate.groupware.appshare.module.CursorDefinitionEvent;
import com.elluminate.groupware.appshare.module.CursorDefinitionListener;
import com.elluminate.groupware.appshare.module.CursorMoveEvent;
import com.elluminate.groupware.appshare.module.CursorMoveListener;
import com.elluminate.groupware.appshare.module.KeyInputEvent;
import com.elluminate.groupware.appshare.module.KeyInputListener;
import com.elluminate.groupware.appshare.module.MouseMoveEvent;
import com.elluminate.groupware.appshare.module.MouseMoveListener;
import com.elluminate.groupware.appshare.module.ScrollWheelEvent;
import com.elluminate.groupware.appshare.module.ScrollWheelListener;
import com.elluminate.groupware.appshare.module.SimulatedKeyStroke;
import com.elluminate.groupware.appshare.module.StringsProperties;
import com.elluminate.groupware.appshare.module.TilesEncodingEvent;
import com.elluminate.groupware.appshare.module.TilesEncodingListener;
import com.elluminate.groupware.imps.ScalableComponent;
import com.elluminate.gui.GUIDebug;
import com.elluminate.platform.Platform;
import com.elluminate.util.DebugFlag;
import com.elluminate.util.I18n;
import com.elluminate.util.IntKeyedCollection;
import com.elluminate.util.LightweightTimer;
import com.elluminate.util.PropertiesEnum;
import com.elluminate.util.SwingRunnerSupport;
import com.elluminate.util.log.LogSupport;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.MemoryImageSource;
import java.awt.image.WritableRaster;
import java.util.Collection;
import java.util.EventListener;
import javax.swing.JPanel;
import javax.swing.Scrollable;
import javax.swing.SwingUtilities;

public final class AppSharingObserverPanel
extends JPanel
implements CanvasDefinitionListener,
CursorChangeListener,
CursorDefinitionListener,
CursorMoveListener,
TilesEncodingListener,
KeyListener,
MouseListener,
MouseMotionListener,
MouseWheelListener,
Scrollable,
Runnable,
ScalableComponent {
    public static final char UNDEFINED_CHAR = '\uffff';
    public static final int MOUSE_INTERVAL = 50;
    private static final int DRAG_MOUSE_INTERVAL = 10;
    private I18n i18n = I18n.create((Object)this);
    private AppShareTile[] decoderTileArray = null;
    private volatile BufferedImage img = null;
    private volatile Rectangle imgRect = null;
    private volatile AppShareTileDecoder decoder = null;
    private volatile Rectangle region = null;
    private ButtonInputListener buttonLst = null;
    private KeyInputListener keyLst = null;
    private MouseMoveListener mouseLst = null;
    private ScrollWheelListener scrollLst = null;
    private InputEnabledListener inputEnabledLst = null;
    private boolean inputEnabled = false;
    protected Image dftCursorImg = this.i18n.getImage((PropertiesEnum)StringsProperties.APPSHARINGOBSERVERPANEL_DEFAULTCURSOR);
    protected Image ctrlCursorImg = this.i18n.getImage((PropertiesEnum)StringsProperties.APPSHARINGOBSERVERPANEL_CONTROLCURSOR);
    protected CursorDefn[] cursorDefnVec = new CursorDefn[256];
    protected Image hostCursorImg = null;
    protected Point hostCursorPos = new Point(0, 0);
    protected Rectangle hostCursorRect = new Rectangle(0, 0, 0, 0);
    protected Cursor controllerCursor = null;
    private LightweightTimer mouseTimer = new LightweightTimer((Runnable)this);
    private int lastX = -1;
    private int lastY = -1;
    private int mouseBtnMask = 0;
    private boolean shift = false;
    private boolean control = false;
    private boolean alt = false;
    private boolean meta = false;
    private boolean[] button = new boolean[]{false, false, false};
    private boolean simulatingKey = false;
    private boolean allowRepaints = true;
    private volatile boolean scaleToFit = false;
    private volatile double scale = 1.0;
    private int scaleWidth = -1;
    private int scaleHeight = -1;
    private final Object displayLock = new Object();
    private long totalTileBytes = 0L;
    private long numTileMsgs = 0L;
    private IntKeyedCollection triggerKeys = new IntKeyedCollection();
    private static double slowDrawingThreshold = 100.0;
    private static long slowDrawingPenalty = 800L;
    private static long slowDrawingCountThreshold = 4000L;
    private long slowDrawingCount = 0L;
    private double runningDrawTimeAvg = 0.0;
    private final int MAX_TE_EVENTS = 256;
    private int[] x0 = new int[256];
    private int[] y0 = new int[256];
    private int[] w0 = new int[256];
    private int[] h0 = new int[256];
    private int[] offset = new int[256];
    private static final DebugFlag DRAG_ALL_PTS = DebugFlag.get((String)"appShare.dragAllPoints");

    public AppSharingObserverPanel(ContentCaptureProvider contentCaptureProvider) {
        super(null);
        if (this.ctrlCursorImg != null) {
            int w = this.ctrlCursorImg.getWidth(null);
            int h = this.ctrlCursorImg.getHeight(null);
            Toolkit tk = Toolkit.getDefaultToolkit();
            Dimension cursorSize = tk.getBestCursorSize(w, h);
            if (cursorSize.width > 0 && cursorSize.height > 0) {
                try {
                    String hotSpotText = this.i18n.getString((PropertiesEnum)StringsProperties.APPSHARINGOBSERVERPANEL_CONTROLCURSOR_HOTSPOT);
                    String[] tokens = hotSpotText.trim().split(",");
                    if (tokens.length == 2) {
                        int x = Integer.parseInt(tokens[0].trim());
                        int y = Integer.parseInt(tokens[1].trim());
                        Point hotSpot = new Point(x, y);
                        BufferedImage bestCursorImg = new BufferedImage(cursorSize.width, cursorSize.height, 2);
                        bestCursorImg.getGraphics().drawImage(this.ctrlCursorImg, 0, 0, null);
                        this.controllerCursor = tk.createCustomCursor(bestCursorImg, hotSpot, "ControllerCursor");
                    }
                }
                catch (Throwable t) {
                    LogSupport.exception((Object)this, (String)"<init>", (Throwable)t, (boolean)true);
                }
            }
        }
        if (this.controllerCursor == null) {
            this.controllerCursor = Cursor.getPredefinedCursor(1);
        }
        this.setCursor(Cursor.getPredefinedCursor(0));
    }

    public boolean isScaling() {
        return this.scaleToFit;
    }

    public int getScalePercent() {
        if (!this.scaleToFit) {
            return 100;
        }
        return (int)(this.scale * 100.0 + 0.5);
    }

    public Rectangle getScaledBounds() {
        Rectangle result = new Rectangle();
        double scale = 1.0;
        if (this.scaleToFit) {
            scale = this.scale;
        }
        result.x = (int)Math.rint((double)this.getX() * scale);
        result.y = (int)Math.rint((double)this.getY() * scale);
        result.width = (int)((double)this.getWidth() * scale + 0.5);
        result.height = (int)((double)this.getHeight() * scale + 0.5);
        return result;
    }

    public void setScaleSize(int w, int h) {
        this.scaleWidth = w;
        this.scaleHeight = h;
        this.computeScaling();
        if (!DebugFlag.get((String)"vclass.repaintThread").show() || SwingUtilities.isEventDispatchThread()) {
            this.repaint();
        } else {
            SwingRunnerSupport.invokeLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    AppSharingObserverPanel.this.repaint();
                }
            });
        }
    }

    public void setScaling(boolean scalingValue) {
        boolean wasScaling = this.scaleToFit;
        this.scaleToFit = scalingValue;
        this.computeScaling();
        if (!DebugFlag.get((String)"vclass.repaintThread").show() || SwingUtilities.isEventDispatchThread()) {
            this.repaint();
        } else {
            SwingRunnerSupport.invokeLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    AppSharingObserverPanel.this.repaint();
                }
            });
        }
        if (!this.scaleToFit && wasScaling && AppShareDebug.SCALE.show()) {
            LogSupport.message((Object)this, (String)"setScaling", (String)"Scaling off");
        }
        if (wasScaling && !this.scaleToFit) {
            this.slowDrawingCount = 0L;
            if (AppShareDebug.SCALE_SPEED_STATS.show()) {
                LogSupport.message((Object)this, (String)"setScaling", (String)"Resetting slowDrawingCount.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void computeScaling() {
        Object object = this.displayLock;
        synchronized (object) {
            this.computeScalingLocked();
        }
    }

    private void computeScalingLocked() {
        if (!this.scaleToFit || this.scaleWidth <= 0 || this.scaleHeight <= 0 || this.region == null || this.region.isEmpty()) {
            this.scale = 1.0;
            return;
        }
        double scaleFactor = 1.0;
        double scaleX = (double)this.scaleWidth / (double)this.region.width;
        double scaleY = (double)this.scaleHeight / (double)this.region.height;
        if (scaleX < scaleFactor) {
            scaleFactor = scaleX;
        }
        if (scaleY < scaleFactor) {
            scaleFactor = scaleY;
        }
        if (Math.abs(scaleFactor - this.scale) > 5.0E-4 && AppShareDebug.SCALE.show()) {
            LogSupport.message((Object)this, (String)"computeScaling", (String)("Scaling " + this.region.width + "x" + this.region.height + " => " + this.scaleWidth + "x" + this.scaleHeight + " @ " + (double)((int)(scaleFactor * 10000.0 + 0.5)) / 100.0 + "%"));
        }
        this.scale = scaleFactor;
    }

    public void setAllowRepaint(boolean b) {
        this.allowRepaints = b;
        if (b) {
            this.repaint();
        }
    }

    public void addInputEnabledListener(InputEnabledListener listener) {
        if (this.inputEnabledLst != null) {
            throw new RuntimeException("Too many Input Enabled Listeners.");
        }
        this.inputEnabledLst = listener;
    }

    public void removeInputEnabledListener(InputEnabledListener listener) {
        if (this.inputEnabledLst == listener) {
            this.inputEnabledLst = null;
        }
    }

    protected void fireInputEnabled(boolean enabled) {
        InputEnabledListener lst = this.inputEnabledLst;
        if (lst == null) {
            return;
        }
        try {
            lst.inputEnableChanged(enabled);
        }
        catch (Throwable t) {
            LogSupport.exception((Object)this, (String)"fireInputEnabled", (Throwable)t, (boolean)true);
        }
    }

    public void addButtonInputListener(ButtonInputListener listener) {
        if (this.buttonLst != null) {
            throw new RuntimeException("Too many Button Input Listeners.");
        }
        this.buttonLst = listener;
    }

    public void removeButtonInputListener(ButtonInputListener listener) {
        if (this.buttonLst == listener) {
            this.buttonLst = null;
        }
    }

    protected void fireButtonInput(boolean buttonDown, MouseEvent e) {
        if (this.buttonLst == null) {
            return;
        }
        this.requestFocus();
        int btn = 0;
        btn = AppSharingObserverPanel.getWhichButton(e);
        if (btn >= 1 && btn <= 3) {
            this.button[btn - 1] = buttonDown;
        }
        this.flushMouseMoved();
        try {
            this.buttonLst.buttonInput(new ButtonInputEvent(this, btn, buttonDown));
        }
        catch (Throwable ex) {
            LogSupport.exception((Object)this, (String)"fireButtonInput", (Throwable)ex, (boolean)true);
        }
    }

    public void addKeyInputListener(KeyInputListener listener) {
        if (this.keyLst != null) {
            throw new RuntimeException("Too many Key Input Listeners.");
        }
        this.keyLst = listener;
    }

    public void removeKeyInputListener(KeyInputListener listener) {
        if (this.keyLst == listener) {
            this.keyLst = null;
        }
    }

    protected void fireKeyInput(boolean keyDown, KeyEvent e) {
        if (this.keyLst == null) {
            return;
        }
        int javaKeyCode = e.getKeyCode();
        int unicode = e.getKeyChar();
        if (unicode == 65535) {
            unicode = 65535;
        } else if (e.isControlDown()) {
            if (unicode == 64) {
                unicode = 0;
                javaKeyCode = 0;
            } else if (unicode == 91) {
                unicode = 27;
                javaKeyCode = 91;
            } else if (unicode == 92) {
                unicode = 28;
                javaKeyCode = 92;
            } else if (unicode == 93) {
                unicode = 29;
                javaKeyCode = 93;
            } else if (unicode == 94) {
                unicode = 30;
                javaKeyCode = 0;
            } else if (unicode == 95) {
                unicode = 31;
                javaKeyCode = 0;
            }
        } else if (unicode == 0) {
            unicode = 65535;
        }
        if (Platform.getPlatform() == 1 && !keyDown && javaKeyCode == 154) {
            this.fireKeyInput(true, javaKeyCode, (char)unicode);
        }
        this.fireKeyInput(keyDown, javaKeyCode, (char)unicode);
    }

    protected void fireKeyInput(boolean keyDown, int javaKeyCode, char unicode) {
        if (this.keyLst == null) {
            return;
        }
        if (javaKeyCode == 0) {
            javaKeyCode = 0;
        }
        if (javaKeyCode == 0 && unicode == '\uffff') {
            return;
        }
        switch (javaKeyCode) {
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 109: 
            case 110: 
            case 111: {
                unicode = (char)65535;
            }
        }
        try {
            this.keyLst.keyInput(new KeyInputEvent(this, unicode, javaKeyCode, keyDown));
        }
        catch (Throwable ex) {
            LogSupport.exception((Object)this, (String)"fireKeyInput", (Throwable)ex, (boolean)true);
        }
    }

    public void addMouseMoveListener(MouseMoveListener listener) {
        if (this.mouseLst != null) {
            throw new RuntimeException("Too many Mouse Move Listeners.");
        }
        this.mouseLst = listener;
    }

    public void removeMouseMoveListener(MouseMoveListener listener) {
        if (this.mouseLst == listener) {
            this.mouseLst = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireMouseMoved(MouseEvent e) {
        if (this.mouseLst == null) {
            return;
        }
        Object object = this.displayLock;
        synchronized (object) {
            int y;
            if (this.region == null) {
                return;
            }
            int x = e.getX() + this.region.x;
            if (!this.region.contains(x, y = e.getY() + this.region.y)) {
                return;
            }
            this.lastX = x;
            this.lastY = y;
        }
        if (DRAG_ALL_PTS.show() && this.mouseBtnMask != 0) {
            this.mouseTimer.cancel();
            this.run();
        } else if (!this.mouseTimer.isScheduled()) {
            long dt = 50L;
            if (this.mouseBtnMask != 0) {
                dt = 10L;
            }
            this.mouseTimer.scheduleIn(dt);
        }
    }

    protected void flushMouseMoved() {
        if (this.mouseTimer.isScheduled()) {
            this.mouseTimer.cancel();
            this.run();
        }
    }

    public void addScrollWheelListener(ScrollWheelListener listener) {
        if (this.scrollLst != null) {
            throw new RuntimeException("Too many Scroll Wheel Listeners.");
        }
        this.scrollLst = listener;
    }

    public void removeScrollWheelListener(ScrollWheelListener listener) {
        if (this.scrollLst == listener) {
            this.scrollLst = null;
        }
    }

    public void fireScrollWheel(MouseWheelEvent ev) {
        if (this.scrollLst == null) {
            return;
        }
        int rot = ev.getWheelRotation();
        if (rot == 0) {
            return;
        }
        try {
            this.scrollLst.scrollWheelMoved(new ScrollWheelEvent(this, rot));
        }
        catch (Throwable ex) {
            LogSupport.exception((Object)this, (String)"fireScrollWheel", (Throwable)ex, (boolean)true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void purgeHistory() {
        Object object = this.displayLock;
        synchronized (object) {
            if (this.decoder != null) {
                this.decoder.purgeHistory();
            }
            if (this.img != null) {
                Graphics2D g = null;
                try {
                    g = this.img.createGraphics();
                    g.setColor(this.getBackground());
                    g.fillRect(0, 0, this.img.getWidth(), this.img.getHeight());
                }
                finally {
                    if (g != null) {
                        g.dispose();
                    }
                }
            }
        }
        if (!this.allowRepaints) {
            return;
        }
        if (!DebugFlag.get((String)"vclass.repaintThread").show() || SwingUtilities.isEventDispatchThread()) {
            this.repaint();
        } else {
            SwingRunnerSupport.invokeLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    AppSharingObserverPanel.this.repaint();
                }
            });
        }
    }

    @Override
    public void repaint() {
        if (this.allowRepaints) {
            super.repaint();
        }
    }

    public void setCacheSize(int newSize) {
        if (this.decoder != null) {
            this.decoder.setCacheSize(newSize);
        }
    }

    public int getCacheSize() {
        if (this.decoder != null) {
            return this.decoder.getCacheSize();
        }
        return 0;
    }

    @Override
    public void run() {
        try {
            this.mouseLst.mouseMoved(new MouseMoveEvent(this, this.lastX, this.lastY));
        }
        catch (Exception ex) {
            LogSupport.exception((Object)this, (String)"sendMouseMotionInfo", (Throwable)ex, (boolean)true);
        }
    }

    public void enableInput(boolean enable) {
        if (this.inputEnabled != enable) {
            this.inputEnabled = enable;
            if (this.inputEnabled) {
                this.mouseBtnMask = 0;
                this.addKeyListener(this);
                this.addMouseListener(this);
                this.addMouseMotionListener(this);
                this.addMouseWheelListener(this);
                this.setCursor(this.controllerCursor);
                this.requestFocus();
            } else {
                this.setCursor(Cursor.getPredefinedCursor(0));
                this.removeKeyListener(this);
                this.removeMouseListener(this);
                this.removeMouseMotionListener(this);
                this.removeMouseWheelListener(this);
                this.mouseBtnMask = 0;
            }
            this.shift = false;
            this.control = false;
            this.alt = false;
            this.meta = false;
            this.button[0] = false;
            this.button[1] = false;
            this.button[2] = false;
            this.triggerKeys.clear();
            this.fireInputEnabled(enable);
        }
    }

    public void defineTriggerKeys(Collection keys) {
        this.triggerKeys.clear();
        for (SimulatedKeyStroke stroke : keys) {
            if (!stroke.isTriggerKeyDefined()) continue;
            this.triggerKeys.add((Object)new TriggerKey(stroke));
        }
    }

    @Override
    public void canvasDefined(final CanvasDefinitionEvent e) {
        try {
            SwingRunnerSupport.invokeAndWait((Runnable)new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    BufferedImage oldImg = null;
                    Object object = AppSharingObserverPanel.this.displayLock;
                    synchronized (object) {
                        oldImg = AppSharingObserverPanel.this.img;
                        short rgb15 = e.getColor();
                        AppSharingObserverPanel.this.region = new Rectangle(e.getX(), e.getY(), e.getWidth(), e.getHeight());
                        AppSharingObserverPanel.this.decoder = new AppShareTileDecoder(-1, e.getHistoryCount(), rgb15);
                        AppSharingObserverPanel.access$402(AppSharingObserverPanel.this, new AppShareTile[256]);
                        for (int i = 0; i < AppSharingObserverPanel.this.decoderTileArray.length; ++i) {
                            ((AppSharingObserverPanel)AppSharingObserverPanel.this).decoderTileArray[i] = new AppShareTile(0, 0, new int[256]);
                        }
                        AppSharingObserverPanel.this.totalTileBytes = 0L;
                        AppSharingObserverPanel.this.numTileMsgs = 0L;
                        int argb = -16777216;
                        for (int i = 0; i < 3; ++i) {
                            int chnl = rgb15 >> i * 5 & 0x1F;
                            chnl = chnl << 3 | chnl >> 2;
                            argb |= chnl << i * 8;
                        }
                        Color bg = new Color(argb);
                        AppSharingObserverPanel.this.setBackground(bg);
                        if (AppSharingObserverPanel.this.region.isEmpty()) {
                            AppSharingObserverPanel.this.img = null;
                            AppSharingObserverPanel.this.imgRect = null;
                        } else {
                            AppSharingObserverPanel.this.img = new BufferedImage(((AppSharingObserverPanel)AppSharingObserverPanel.this).region.width, ((AppSharingObserverPanel)AppSharingObserverPanel.this).region.height, 1);
                            AppSharingObserverPanel.this.imgRect = AppSharingObserverPanel.this.region;
                        }
                        if (AppSharingObserverPanel.this.scaleToFit) {
                            AppSharingObserverPanel.this.computeScalingLocked();
                        }
                    }
                    if (oldImg != null) {
                        oldImg.flush();
                    }
                }
            });
        }
        catch (InterruptedException intx) {
            Thread.currentThread().interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean areaChanged(Rectangle area) {
        if (this.region.equals(area)) {
            return true;
        }
        boolean imageOK = true;
        BufferedImage oldImg = this.img;
        Rectangle oldRegion = this.region;
        this.region = new Rectangle(area);
        if (area.isEmpty()) {
            Object object = this.displayLock;
            synchronized (object) {
                this.region.y = 0;
                this.region.x = 0;
                this.img = null;
                this.imgRect = null;
                int deltaX = this.region.x - oldRegion.x;
                int deltaY = this.region.y - oldRegion.y;
                this.hostCursorPos.translate(deltaX, deltaY);
                this.hostCursorRect.translate(deltaX, deltaY);
                if (this.scaleToFit) {
                    this.computeScalingLocked();
                }
            }
            if (oldImg != null) {
                oldImg.flush();
            }
            return true;
        }
        if (AppShareDebug.AOI.show()) {
            LogSupport.message((Object)this, (String)"areaChanged", (String)("New area = " + this.region));
        }
        Image neoImg = null;
        try {
            try {
                neoImg = new BufferedImage(area.width, area.height, 1);
            }
            catch (Throwable t) {
                LogSupport.exception((Object)this, (String)"areaChanged", (Throwable)t, (boolean)true, (String)"Creating new image for new area");
                boolean bl = false;
                if (oldImg != null) {
                    oldImg.flush();
                }
                if (neoImg != null) {
                    neoImg.flush();
                }
                return bl;
            }
            if (Thread.interrupted()) {
                boolean t = true;
                return t;
            }
            Rectangle retain = oldRegion.intersection(area);
            Object object = this.displayLock;
            synchronized (object) {
                if (oldImg != null && !retain.isEmpty()) {
                    BufferedImage toKeep = oldImg.getSubimage(retain.x - oldRegion.x, retain.y - oldRegion.y, retain.width, retain.height);
                    Graphics2D g = null;
                    try {
                        g = ((BufferedImage)neoImg).createGraphics();
                        g.drawImage((Image)toKeep, retain.x - area.x, retain.y - area.y, null);
                    }
                    finally {
                        if (g != null) {
                            g.dispose();
                        }
                    }
                }
                this.hostCursorPos.translate(this.region.x - oldRegion.x, this.region.y - oldRegion.y);
                this.hostCursorRect.translate(this.region.x - oldRegion.x, this.region.y - oldRegion.y);
                this.img = neoImg;
                this.imgRect = this.region;
                neoImg = null;
                if (this.scaleToFit) {
                    this.computeScalingLocked();
                }
            }
        }
        finally {
            if (oldImg != null) {
                oldImg.flush();
            }
            if (neoImg != null) {
                neoImg.flush();
            }
        }
        return imageOK;
    }

    public Rectangle getArea() {
        return new Rectangle(this.region);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        BufferedImage oldImg = null;
        Image oldCursorImg = null;
        AppShareTileDecoder oldDecoder = null;
        StringBuffer statusMsg = null;
        Object object = this.displayLock;
        synchronized (object) {
            if (AppShareDebug.STATS.show()) {
                statusMsg = new StringBuffer(512);
                if (this.decoder != null) {
                    this.decoder.showHistogramData();
                    statusMsg.append(this.decoder.getStats());
                }
                if (this.numTileMsgs > 0L) {
                    if (statusMsg.length() > 0) {
                        statusMsg.append("\n");
                    }
                    statusMsg.append("Avg tile bytes/msg: " + (double)((this.totalTileBytes * 10L + this.numTileMsgs / 2L) / this.numTileMsgs) / 10.0);
                }
            }
            oldImg = this.img;
            oldCursorImg = this.hostCursorImg;
            oldDecoder = this.decoder;
            this.region = null;
            this.img = null;
            this.imgRect = null;
            this.hostCursorImg = null;
            this.decoder = null;
            this.totalTileBytes = 0L;
            this.numTileMsgs = 0L;
            this.decoderTileArray = null;
        }
        if (oldImg != null) {
            oldImg.flush();
        }
        if (oldCursorImg != null) {
            oldCursorImg.flush();
        }
        if (oldDecoder != null) {
            oldDecoder.purgeHistory();
        }
        if (statusMsg != null && statusMsg.length() > 0) {
            LogSupport.message((Object)this, (String)"shutdown", (String)statusMsg.toString());
        }
        if (!DebugFlag.get((String)"vclass.repaintThread").show() || SwingUtilities.isEventDispatchThread()) {
            this.repaint();
        } else {
            SwingRunnerSupport.invokeLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    AppSharingObserverPanel.this.repaint();
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cursorChanged(CursorChangeEvent e) {
        short cursorDefnIdx = e.getIndex();
        if (this.cursorDefnVec[cursorDefnIdx] != null) {
            Object object = this.displayLock;
            synchronized (object) {
                Rectangle prevCursorRect = this.scaledCursorRect(this.hostCursorRect, this.hostCursorPos);
                CursorDefn cursorDefn = this.cursorDefnVec[cursorDefnIdx];
                this.hostCursorRect.setBounds(this.hostCursorPos.x - cursorDefn.hotspotX, this.hostCursorPos.y - cursorDefn.hotspotY, cursorDefn.width, cursorDefn.height);
                this.hostCursorImg = cursorDefn.image;
                this.repaintArea(prevCursorRect);
                this.repaintArea(this.scaledCursorRect(this.hostCursorRect, this.hostCursorPos));
            }
        }
        Object object = this.displayLock;
        synchronized (object) {
            Rectangle prevCursorRect = this.scaledCursorRect(this.hostCursorRect, this.hostCursorPos);
            this.hostCursorRect.setBounds(this.hostCursorPos.x, this.hostCursorPos.y, this.dftCursorImg.getWidth(null), this.dftCursorImg.getHeight(null));
            this.hostCursorImg = this.dftCursorImg;
            this.repaintArea(prevCursorRect);
            this.repaintArea(this.scaledCursorRect(this.hostCursorRect, this.hostCursorPos));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cursorDefined(CursorDefinitionEvent e) {
        Object[] pixels;
        short cursorDefnIdx = e.getIndex();
        short cursorWidth = e.getWidth();
        short cursorHeight = e.getHeight();
        short hotspotX = e.getHotspotX();
        short hotspotY = e.getHotspotY();
        int pixelCnt = cursorWidth * cursorHeight;
        int[] cursorPix = new int[pixelCnt];
        int cursorPixIdx = 0;
        if (e.has16BitPixels()) {
            pixels = e.getPixels16();
            for (int pixelIdx = 0; pixelIdx < pixelCnt; ++pixelIdx) {
                short pixel15 = pixels[pixelIdx];
                cursorPix[cursorPixIdx++] = pixel15 < 0 ? 0 : AppShareTileDecoder.expandColor((short)pixel15);
            }
        } else if (e.has32BitPixels()) {
            pixels = e.getPixels32();
            System.arraycopy(pixels, 0, cursorPix, 0, pixelCnt);
        }
        if (Thread.interrupted()) {
            return;
        }
        MemoryImageSource memImgSrc = new MemoryImageSource(cursorWidth, cursorHeight, cursorPix, 0, cursorWidth);
        Image cursorImg = this.createImage(memImgSrc);
        Object object = this.displayLock;
        synchronized (object) {
            CursorDefn cursorDefn = this.cursorDefnVec[cursorDefnIdx];
            if (cursorDefn == null) {
                this.cursorDefnVec[cursorDefnIdx] = cursorDefn = new CursorDefn();
            } else {
                cursorDefn.image.flush();
            }
            cursorDefn.height = cursorHeight;
            cursorDefn.image = cursorImg;
            cursorDefn.hotspotX = hotspotX;
            cursorDefn.hotspotY = hotspotY;
            cursorDefn.width = cursorWidth;
            Rectangle prevCursorRect = this.scaledCursorRect(this.hostCursorRect, this.hostCursorPos);
            this.hostCursorRect.setBounds(this.hostCursorPos.x - hotspotX, this.hostCursorPos.y - hotspotY, cursorWidth, cursorHeight);
            this.hostCursorImg = cursorImg;
            this.repaintArea(prevCursorRect);
            this.repaintArea(this.scaledCursorRect(this.hostCursorRect, this.hostCursorPos));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cursorMoved(CursorMoveEvent e) {
        Object object = this.displayLock;
        synchronized (object) {
            int x = e.getX();
            int y = e.getY();
            Rectangle prevCursorRect = null;
            Rectangle newCursorRect = null;
            if (AppShareDebug.CURSOR.show()) {
                LogSupport.message((Object)this, (String)"cursorMoved", (String)(" => " + x + "," + y + " " + this.region));
            }
            if (this.region == null || !this.region.contains(x, y)) {
                return;
            }
            x -= this.region.x;
            y -= this.region.y;
            prevCursorRect = this.scaledCursorRect(this.hostCursorRect, this.hostCursorPos);
            if (this.hostCursorImg == null) {
                this.hostCursorRect.setBounds(this.hostCursorPos.x, this.hostCursorPos.y, this.dftCursorImg.getWidth(null), this.dftCursorImg.getHeight(null));
                this.hostCursorImg = this.dftCursorImg;
            }
            int deltaX = x - this.hostCursorPos.x;
            int deltaY = y - this.hostCursorPos.y;
            this.hostCursorPos.translate(deltaX, deltaY);
            this.hostCursorRect.translate(deltaX, deltaY);
            newCursorRect = this.scaledCursorRect(this.hostCursorRect, this.hostCursorPos);
            this.repaintArea(prevCursorRect);
            this.repaintArea(newCursorRect);
        }
    }

    private void repaintArea(Rectangle area) {
        this.repaintArea(area.x, area.y, area.width, area.height);
    }

    private void repaintArea(final int x, final int y, final int w, final int h) {
        if (!this.allowRepaints) {
            return;
        }
        if (!GUIDebug.REPAINT_THREAD.show() || SwingUtilities.isEventDispatchThread()) {
            this.repaint(x, y, w, h);
        } else {
            SwingRunnerSupport.invokeLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    AppSharingObserverPanel.this.repaint(x, y, w, h);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void tilesEncoded(TilesEncodingEvent e) {
        byte[] buffer = e.getEncoding();
        int bufLen = buffer.length;
        int start = 0;
        int nBytes = 0;
        int minX = this.region == null ? 65535 : this.region.x + this.region.width;
        int minY = this.region == null ? 65535 : this.region.y + this.region.height;
        int maxX = (this.region == null ? -1 : this.region.x) - 1;
        int maxY = (this.region == null ? -1 : this.region.y) - 1;
        AppShareTile[] tileArray = this.decoderTileArray;
        if (tileArray == null) {
            tileArray = new AppShareTile[256];
            for (int i = 0; i < tileArray.length; ++i) {
                tileArray[i] = new AppShareTile(0, 0, new int[256]);
            }
        }
        AppShareTileDesc desc = null;
        if (AppShareDebug.TILE_INFO.show()) {
            desc = new AppShareTileDesc();
            LogSupport.message((Object)this, (String)"tilesEncoded", (String)("Decoding " + bufLen + " bytes int AOI " + this.region));
        }
        if (AppShareDebug.STATS.show()) {
            this.totalTileBytes += (long)bufLen;
            ++this.numTileMsgs;
        }
        start = 0;
        AppShareTileDecoder localDecoder = null;
        BufferedImage localImg = null;
        localDecoder = this.decoder;
        localImg = this.img;
        Rectangle localRegion = this.region;
        if (localDecoder == null || localRegion == null) {
            if (AppShareDebug.TILE_INFO.show()) {
                LogSupport.message((Object)this, (String)"tilesEncoded", (String)("Asynchronous termination: discarding " + (buffer.length - start) + "/" + buffer.length + " bytes"));
            }
            return;
        }
        int it = 0;
        while (true) {
            int orig = -999999;
            int tileOff = start;
            if (Thread.interrupted()) {
                return;
            }
            if (++it >= 256) {
                throw new RuntimeException("too many tilesEncoded events");
            }
            nBytes = localDecoder.decodeTileDefn(buffer, start, bufLen, desc, tileArray[it - 1]);
            if (nBytes <= 0) {
                --it;
                break;
            }
            start += nBytes;
            int x = tileArray[it - 1].col * 16;
            int y = tileArray[it - 1].row * 16;
            int w = 16;
            int h = 16;
            if (AppShareDebug.TILE_INFO.show()) {
                orig = localDecoder.getHistory().lookupDuplicate(desc.defn);
                LogSupport.message((String)("Decoded @ " + tileOff + " " + nBytes + " byte type " + AppShareTileDefn.typeName((byte)desc.defn.type) + " tile at " + tileArray[it - 1].row + "," + tileArray[it - 1].col + " global=[" + x + "," + y + "] window=[" + (x - localRegion.x) + "," + (y - localRegion.y) + "] cache=" + orig));
            }
            this.x0[it - 1] = x - localRegion.x;
            this.y0[it - 1] = y - localRegion.y;
            this.w0[it - 1] = w;
            this.h0[it - 1] = h;
            this.offset[it - 1] = 0;
            if (this.x0[it - 1] < 0) {
                int dx = -this.x0[it - 1];
                this.x0[it - 1] = 0;
                int n = it - 1;
                this.w0[n] = this.w0[n] - dx;
                int n2 = it - 1;
                this.offset[n2] = this.offset[n2] + dx;
            }
            if (this.y0[it - 1] < 0) {
                int dy = -this.y0[it - 1];
                this.y0[it - 1] = 0;
                int n = it - 1;
                this.h0[n] = this.h0[n] - dy;
                int n3 = it - 1;
                this.offset[n3] = this.offset[n3] + dy * w;
            }
            if (this.x0[it - 1] + this.w0[it - 1] > localRegion.width) {
                this.w0[it - 1] = localRegion.width - this.x0[it - 1];
            }
            if (this.y0[it - 1] + this.h0[it - 1] > localRegion.height) {
                this.h0[it - 1] = localRegion.height - this.y0[it - 1];
            }
            if (y < minY) {
                minY = y;
            }
            if (x < minX) {
                minX = x;
            }
            if (y + h > maxY) {
                maxY = y + h;
            }
            if (x + w <= maxX) continue;
            maxX = x + w;
        }
        minX -= localRegion.x;
        minY -= localRegion.y;
        maxY -= localRegion.y;
        if ((maxX -= localRegion.x) >= localRegion.width) {
            maxX = localRegion.width - 1;
        }
        if (maxY >= localRegion.height) {
            maxY = localRegion.height - 1;
        }
        if (minX < 0) {
            minX = 0;
        }
        if (minY < 0) {
            minY = 0;
        }
        if (this.scaleToFit) {
            int x1 = minX;
            int y1 = minY;
            int x2 = maxX;
            int y2 = maxY;
            minX = (int)Math.floor((double)minX * this.scale);
            minY = (int)Math.floor((double)minY * this.scale);
            maxX = (int)Math.ceil((double)maxX * this.scale);
            maxY = (int)Math.ceil((double)maxY * this.scale);
            if (AppShareDebug.SCALE.show()) {
                LogSupport.message((String)("Scaled repaint bounds: [" + x1 + "," + y1 + "] .. [" + x2 + "," + y2 + "] by " + this.scale + " => [" + minX + "," + minY + "] .. [" + maxX + "," + maxY + "]"));
            }
        }
        if (localImg != null) {
            Object object = this.displayLock;
            synchronized (object) {
                for (int i = 0; i < it; ++i) {
                    localImg.setRGB(this.x0[i], this.y0[i], this.w0[i], this.h0[i], tileArray[i].pixels, this.offset[i], 16);
                }
                if (this.decoderTileArray == null) {
                    this.decoderTileArray = tileArray;
                }
            }
        }
        this.repaintArea(minX, minY, maxX - minX, maxY - minY);
        if (start < bufLen) {
            throw new RuntimeException("Unprocessed tile encoding data left over: " + (bufLen - start) + " bytes");
        }
    }

    @Override
    public void flushBufferedTiles(TilesEncodingEvent e) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void paintOver(int colour) {
        Rectangle r = null;
        Graphics g = null;
        Color col = new Color(colour & 0xFFFFFF);
        try {
            Object object = this.displayLock;
            synchronized (object) {
                if (this.img != null && this.region != null && !this.region.isEmpty()) {
                    r = this.region;
                    g = this.img.createGraphics();
                    g.setColor(col);
                    g.fillRect(0, 0, this.region.width, this.region.height);
                }
            }
        }
        finally {
            if (g != null) {
                g.dispose();
            }
        }
        if (r != null) {
            this.repaintArea(r);
        }
    }

    @Override
    public boolean isManagingFocus() {
        return true;
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (AppShareDebug.KEYS.show()) {
            LogSupport.message((Object)this, (String)"keyPressed", (String)("code=" + e.getKeyCode() + " " + KeyEvent.getKeyText(e.getKeyCode()) + " glyph=0x" + Integer.toHexString(e.getKeyChar() & 0xFFFF) + (Character.isISOControl(e.getKeyChar()) ? " " : " '" + e.getKeyChar() + "'") + " modifiers=" + KeyEvent.getKeyModifiersText(e.getModifiers())));
        }
        e.consume();
        if (this.inputEnabled) {
            int key = e.getModifiers() << 16 | e.getKeyCode();
            TriggerKey trigger = (TriggerKey)this.triggerKeys.get(key);
            if (trigger != null && !this.simulatingKey) {
                this.simulateKey(this, trigger.send.getKeyCode(), trigger.send.getKeyModifiers());
            } else if (this.updateModifiers(true, e)) {
                this.fireKeyInput(true, e);
            }
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
        int key;
        TriggerKey trigger;
        if (AppShareDebug.KEYS.show()) {
            LogSupport.message((Object)this, (String)"keyReleased", (String)("code=" + e.getKeyCode() + " " + KeyEvent.getKeyText(e.getKeyCode()) + " glyph=0x" + Integer.toHexString(e.getKeyChar() & 0xFFFF) + (Character.isISOControl(e.getKeyChar()) ? " " : " '" + e.getKeyChar() + "'") + " modifiers=" + KeyEvent.getKeyModifiersText(e.getModifiers())));
        }
        e.consume();
        if (this.inputEnabled && (trigger = (TriggerKey)this.triggerKeys.get(key = e.getModifiers() << 16 | e.getKeyCode())) == null) {
            if (this.updateModifiers(false, e)) {
                this.fireKeyInput(false, e);
            }
            if (e.getModifiers() == 0 && this.getModState() != 0 && !this.simulatingKey) {
                this.setModState(0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void simulateKey(Component cmp, int code, int mods) {
        if (!this.inputEnabled) {
            return;
        }
        try {
            this.simulatingKey = true;
            if (cmp == null) {
                cmp = this;
            }
            long t0 = System.currentTimeMillis();
            int oldMods = this.getModState();
            int toRelease = oldMods & ~mods;
            if (toRelease != 0) {
                this.setModState(oldMods & ~toRelease);
            }
            this.keyPressed(new KeyEvent(cmp, 401, t0, mods, code, '\uffff'));
            this.keyReleased(new KeyEvent(cmp, 402, t0, mods, code, '\uffff'));
        }
        finally {
            this.simulatingKey = false;
        }
    }

    private boolean updateModifiers(boolean press, KeyEvent e) {
        int code = e.getKeyCode();
        char ch = e.getKeyChar();
        if (code == 20 || code == 144) {
            return false;
        }
        if (code == 16) {
            if (press != this.shift) {
                this.shift = press;
                return true;
            }
            return false;
        }
        if (code == 17) {
            if (press != this.control) {
                this.control = press;
                return true;
            }
            return false;
        }
        if (code == 18) {
            if (press != this.alt) {
                this.alt = press;
                return true;
            }
            return false;
        }
        if (code == 157) {
            if (press != this.meta) {
                this.meta = press;
                return true;
            }
            return false;
        }
        if (Character.isUpperCase(ch)) {
            if (!this.shift) {
                this.fireKeyInput(true, 16, '\uffff');
                this.shift = true;
            }
            this.control = this.checkMod(e.isControlDown(), this.control, 17);
            this.alt = this.checkMod(e.isAltDown(), this.alt, 18);
            this.meta = this.checkMod(e.isMetaDown(), this.meta, 157);
        } else if (Character.isLowerCase(ch)) {
            if (this.shift) {
                this.fireKeyInput(false, 16, '\uffff');
                this.shift = false;
            }
            this.control = this.checkMod(e.isControlDown(), this.control, 17);
            this.alt = this.checkMod(e.isAltDown(), this.alt, 18);
            this.meta = this.checkMod(e.isMetaDown(), this.meta, 157);
        } else {
            this.shift = this.checkMod(e.isShiftDown(), this.shift, 16);
            this.control = this.checkMod(e.isControlDown(), this.control, 17);
            this.alt = this.checkMod(e.isAltDown(), this.alt, 18);
            this.meta = this.checkMod(e.isMetaDown(), this.meta, 157);
        }
        return true;
    }

    private void setModState(int mods) {
        this.shift = this.checkMod(this.checkMask(mods, 1), this.shift, 16);
        this.control = this.checkMod(this.checkMask(mods, 2), this.control, 17);
        this.alt = this.checkMod(this.checkMask(mods, 8), this.alt, 18);
        this.meta = this.checkMod(this.checkMask(mods, 4), this.meta, 157);
    }

    private int getModState() {
        return this.getMaskForFlag(this.control, 2) | this.getMaskForFlag(this.shift, 1) | this.getMaskForFlag(this.meta, 4) | this.getMaskForFlag(this.alt, 8);
    }

    private int getMaskForFlag(boolean flag, int mask) {
        if (flag) {
            return mask;
        }
        return 0;
    }

    private boolean checkMask(int flags, int mask) {
        return (flags & mask) != 0;
    }

    private boolean checkMod(boolean mod, boolean state, int code) {
        if (mod == state) {
            return state;
        }
        this.fireKeyInput(mod, code, '\uffff');
        if (AppShareDebug.KEYS.show()) {
            LogSupport.message((Object)this, (String)"checkMod", (String)("Synthesizing modifier key event for " + code + " " + KeyEvent.getKeyText(code) + ": " + (mod ? "pressed" : "released")));
        }
        return mod;
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    private void scaleMouseEvent(MouseEvent e) {
        int x = (int)((double)e.getX() / this.scale + 0.5);
        int y = (int)((double)e.getY() / this.scale + 0.5);
        e.translatePoint(x - e.getX(), y - e.getY());
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (this.inputEnabled) {
            if (this.scaleToFit) {
                this.scaleMouseEvent(e);
            }
            this.fireMouseMoved(e);
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        if (this.inputEnabled) {
            if (this.scaleToFit) {
                this.scaleMouseEvent(e);
            }
            this.fireMouseMoved(e);
        }
    }

    private static int getWhichButton(MouseEvent e) {
        int which = e.getButton();
        if (which == 2) {
            return 2;
        }
        if (which == 3) {
            return 3;
        }
        return 1;
    }

    private boolean isShiftDownEx(MouseEvent ev) {
        return this.isModifierKeyDown(ev, 64);
    }

    private boolean isControlDownEx(MouseEvent ev) {
        return this.isModifierKeyDown(ev, 128);
    }

    private boolean isMetaDownEx(MouseEvent ev) {
        return this.isModifierKeyDown(ev, 256);
    }

    private boolean isAltDownEx(MouseEvent ev) {
        return this.isModifierKeyDown(ev, 512);
    }

    private boolean isModifierKeyDown(MouseEvent ev, int extMask) {
        return (ev.getModifiersEx() & extMask) == extMask;
    }

    private void updateMouseMask(MouseEvent me) {
        int btnNo = AppSharingObserverPanel.getWhichButton(me);
        int mask = 1 << btnNo - 1;
        switch (me.getID()) {
            case 501: {
                this.mouseBtnMask |= mask;
                break;
            }
            case 502: {
                this.mouseBtnMask &= ~mask;
                break;
            }
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (this.inputEnabled) {
            this.updateMouseMask(e);
            if (this.scaleToFit) {
                this.scaleMouseEvent(e);
            }
            this.shift = this.checkMod(this.isShiftDownEx(e), this.shift, 16);
            this.control = this.checkMod(this.isControlDownEx(e), this.control, 17);
            this.alt = this.checkMod(this.isAltDownEx(e), this.alt, 18);
            this.meta = this.checkMod(this.isMetaDownEx(e), this.meta, 157);
            if (AppShareDebug.CURSOR.show()) {
                LogSupport.message((Object)this, (String)"mousePressed", (String)("Mouse button " + AppSharingObserverPanel.getWhichButton(e) + " pressed, mod=" + e.getModifiers()));
            }
            this.fireButtonInput(true, e);
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (this.inputEnabled) {
            this.updateMouseMask(e);
            if (this.scaleToFit) {
                this.scaleMouseEvent(e);
            }
            if (AppShareDebug.CURSOR.show()) {
                LogSupport.message((Object)this, (String)"mousePressed", (String)("Mouse button " + AppSharingObserverPanel.getWhichButton(e) + " released, mod=" + e.getModifiers()));
            }
            this.fireButtonInput(false, e);
        }
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent ev) {
        if (this.inputEnabled) {
            this.fireScrollWheel(ev);
        }
    }

    @Override
    protected void paintComponent(Graphics gc) {
        if (this.allowRepaints) {
            this.paintComponentLocal(gc, this.scaleToFit);
        }
    }

    public void paintUnscaled(Graphics streamGraphics) {
        this.paintComponentLocal(streamGraphics, false);
    }

    public Dimension getUnscaledSize() {
        if (this.region == null) {
            return new Dimension();
        }
        return this.region.getSize();
    }

    public double getScaleFactorX() {
        return this.scale;
    }

    public double getScaleFactorY() {
        return this.scale;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void paintComponentLocal(Graphics gc, boolean scaleToFit) {
        block36: {
            if (gc == null) {
                return;
            }
            try {
                double localScale;
                Rectangle localImgRect;
                BufferedImage localImg;
                Object object = this.displayLock;
                synchronized (object) {
                    localImg = this.img;
                    localImgRect = this.imgRect;
                    localScale = this.scale;
                }
                if (localImg != null && localImgRect != null) {
                    int imgWidth = localImgRect.width;
                    int imgHeight = localImgRect.height;
                    int cursorX = 0;
                    int cursorY = 0;
                    if (this.hostCursorPos != null) {
                        cursorX = this.hostCursorPos.x;
                        cursorY = this.hostCursorPos.y;
                    }
                    if (scaleToFit) {
                        imgWidth = (int)((double)imgWidth * localScale + 0.5);
                        imgHeight = (int)((double)imgHeight * localScale + 0.5);
                        cursorX = (int)((double)cursorX * localScale + 0.5);
                        cursorY = (int)((double)cursorY * localScale + 0.5);
                    }
                    if (imgWidth < this.getWidth()) {
                        gc.clearRect(imgWidth, 0, this.getWidth() - imgWidth, this.getHeight());
                    }
                    if (imgHeight < this.getHeight()) {
                        gc.clearRect(0, imgHeight, this.getWidth(), this.getHeight() - imgHeight);
                    }
                    Graphics g2 = null;
                    try {
                        long lockDuration;
                        if (scaleToFit && this.scale < 0.995) {
                            g2 = (Graphics2D)gc.create();
                            AffineTransform newTransform = new AffineTransform();
                            newTransform.setToScale(localScale, localScale);
                            ((Graphics2D)g2).transform(newTransform);
                            if (this.slowDrawingCount <= slowDrawingCountThreshold) {
                                ((Graphics2D)g2).setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
                            } else {
                                ((Graphics2D)g2).setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
                            }
                        }
                        if (g2 != null) {
                            BufferedImage bi;
                            long drawStartTime = 0L;
                            long drawDuration = 0L;
                            int g2x = g2.getClipBounds().x;
                            int g2y = g2.getClipBounds().y;
                            int g2Width = (int)g2.getClipBounds().getWidth();
                            int g2Height = (int)g2.getClipBounds().getHeight();
                            drawStartTime = System.currentTimeMillis();
                            Object object2 = this.displayLock;
                            synchronized (object2) {
                                bi = this.biCopy(localImg, g2x, g2y, g2Width, g2Height);
                            }
                            lockDuration = System.currentTimeMillis() - drawStartTime;
                            if (bi != null) {
                                g2.drawImage(bi, g2x, g2y, null);
                            }
                            drawDuration = System.currentTimeMillis() - drawStartTime;
                            this.runningDrawTimeAvg = this.runningDrawTimeAvg / 2.0 + (double)drawDuration / 2.0;
                            if (AppShareDebug.SCALE_SPEED_STATS.show()) {
                                LogSupport.message((Object)this, (String)"paintComponentLocal", (String)((this.slowDrawingCount <= slowDrawingCountThreshold ? "[ QUALITY ] " : "[ SPEED ] ") + "drawDuration: " + drawDuration + " ms  " + "avg: " + (int)this.runningDrawTimeAvg + " ms  slowDrawingCount: " + this.slowDrawingCount));
                            }
                            if (this.runningDrawTimeAvg > slowDrawingThreshold) {
                                this.slowDrawingCount += slowDrawingPenalty;
                                if (AppShareDebug.SCALE_SPEED_STATS.show()) {
                                    LogSupport.message((Object)this, (String)"paintComponentLocal", (String)"Slow draw detected!");
                                }
                            } else if (this.slowDrawingCount > 0L) {
                                --this.slowDrawingCount;
                            }
                        } else {
                            BufferedImage bi;
                            int gcx = gc.getClipBounds().x;
                            int gcy = gc.getClipBounds().y;
                            int gcWidth = (int)gc.getClipBounds().getWidth();
                            int gcHeight = (int)gc.getClipBounds().getHeight();
                            long lockStartTime = System.currentTimeMillis();
                            Object object3 = this.displayLock;
                            synchronized (object3) {
                                bi = this.biCopy(localImg, gcx, gcy, gcWidth, gcHeight);
                            }
                            lockDuration = System.currentTimeMillis() - lockStartTime;
                            if (bi != null) {
                                gc.drawImage(bi, gcx, gcy, null);
                            }
                        }
                        if (AppShareDebug.RENDER_LOCKTIME.show()) {
                            LogSupport.message((Object)this, (String)"paintComponentLocal", (String)("Lock held " + lockDuration + " ms"));
                        }
                    }
                    finally {
                        if (g2 != null) {
                            g2.dispose();
                            g2 = null;
                        }
                    }
                    if (this.hostCursorRect != null && this.hostCursorImg != null) {
                        int dx = this.hostCursorRect.x - this.hostCursorPos.x;
                        int dy = this.hostCursorRect.y - this.hostCursorPos.y;
                        gc.drawImage(this.hostCursorImg, cursorX + dx, cursorY + dy, null);
                    }
                    break block36;
                }
                gc.clearRect(0, 0, this.getWidth(), this.getHeight());
            }
            catch (Throwable t) {
                LogSupport.exception((Object)this, (String)"paintComponentLocal", (Throwable)t, (boolean)true);
            }
        }
    }

    private BufferedImage biCopy(BufferedImage bi, int x, int y, int w, int h) {
        WritableRaster raster;
        ColorModel cm = bi.getColorModel();
        boolean isAlphaPremultiplied = cm.isAlphaPremultiplied();
        int oldX = x;
        int oldY = y;
        int oldW = w;
        int oldH = h;
        if (w > bi.getWidth()) {
            if (AppShareDebug.RENDER_BUFFER.show()) {
                LogSupport.message((Object)this, (String)"biCopy", (String)("trimmed w to buffer width: " + w + " -> " + bi.getWidth()));
            }
            w = bi.getWidth();
        }
        if (h > bi.getHeight()) {
            if (AppShareDebug.RENDER_BUFFER.show()) {
                LogSupport.message((Object)this, (String)"biCopy", (String)("trimmed h to buffer height: " + h + " -> " + bi.getHeight()));
            }
            h = bi.getHeight();
        }
        if (x > bi.getWidth()) {
            if (AppShareDebug.RENDER_BUFFER.show()) {
                LogSupport.message((Object)this, (String)"biCopy", (String)("trimmed x to buffer width: " + x + " -> " + bi.getWidth()));
            }
            w = bi.getWidth();
        }
        if (y > bi.getHeight()) {
            if (AppShareDebug.RENDER_BUFFER.show()) {
                LogSupport.message((Object)this, (String)"biCopy", (String)("trimmed y to buffer height: " + y + " -> " + bi.getHeight()));
            }
            h = bi.getHeight();
        }
        if (x < 0) {
            if (AppShareDebug.RENDER_BUFFER.show()) {
                LogSupport.message((Object)this, (String)"biCopy", (String)("bumped up x to 0, from " + x + "  <====="));
            }
            w += x;
            x = 0;
        }
        if (y < 0) {
            if (AppShareDebug.RENDER_BUFFER.show()) {
                LogSupport.message((Object)this, (String)"biCopy", (String)("bumped up y to 0, from " + y + "  <====="));
            }
            h += y;
            y = 0;
        }
        if (x + w > bi.getWidth()) {
            w = bi.getWidth() - x;
            if (AppShareDebug.RENDER_BUFFER.show()) {
                LogSupport.message((Object)this, (String)"biCopy", (String)("w+x (" + oldW + "+" + x + ") > buffer width (" + bi.getWidth() + ") dropping w to " + w));
            }
        }
        if (y + h > bi.getHeight()) {
            h = bi.getHeight() - y;
            if (AppShareDebug.RENDER_BUFFER.show()) {
                LogSupport.message((Object)this, (String)"biCopy", (String)("h+y (" + oldH + "+" + y + ") > buffer height (" + bi.getHeight() + ") dropping h to " + h));
            }
        }
        try {
            WritableRaster parentRaster = bi.getSubimage(x, y, w, h).copyData(null);
            raster = parentRaster.createWritableChild(0, 0, w, h, 0, 0, null);
        }
        catch (Exception e) {
            LogSupport.message((Object)this, (String)"biCopy", (String)("x: " + x + "  y: " + y + "  w: " + w + "  h: " + h + "  oldX: " + oldX + "  oldY: " + oldY + "  oldW: " + oldW + "  oldH: " + oldH + "  BUFFER: min x: " + bi.getMinX() + "  min y: " + bi.getMinY() + "  width: " + bi.getWidth() + "  height: " + bi.getHeight() + "  Exception: " + e.toString()));
            return null;
        }
        return new BufferedImage(cm, raster, isAlphaPremultiplied, null);
    }

    private Rectangle scaledCursorRect(Rectangle globalRect, Point hotSpot) {
        Rectangle result = new Rectangle(globalRect);
        if (this.scaleToFit) {
            result.x = (int)((double)hotSpot.x * this.scale + 0.5) + globalRect.x - hotSpot.x;
            result.y = (int)((double)hotSpot.y * this.scale + 0.5) + globalRect.y - hotSpot.y;
        }
        return result;
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    @Override
    public int getScrollableUnitIncrement(Rectangle vis, int orient, int dir) {
        return 16;
    }

    @Override
    public int getScrollableBlockIncrement(Rectangle vis, int orient, int dir) {
        if (orient == 1) {
            return vis.height / 16 * 16;
        }
        return vis.width / 16 * 16;
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        return false;
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        return false;
    }

    static /* synthetic */ AppShareTile[] access$402(AppSharingObserverPanel x0, AppShareTile[] x1) {
        x0.decoderTileArray = x1;
        return x1;
    }

    protected final class CursorDefn {
        public int height;
        public int hotspotX;
        public int hotspotY;
        public Image image;
        public int width;

        protected CursorDefn() {
        }
    }

    public static interface InputEnabledListener
    extends EventListener {
        public void inputEnableChanged(boolean var1);
    }

    private static final class TriggerKey
    implements IntKeyedCollection.Element {
        SimulatedKeyStroke send;

        TriggerKey(SimulatedKeyStroke key) {
            this.send = key;
        }

        public int getKey() {
            return this.send.getTriggerKeyModifiers() << 16 | this.send.getTriggerKeyCode();
        }
    }
}

