/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.invite.module;

import com.elluminate.platform.Platform;
import com.elluminate.util.Preferences;

public class InvitePreferences {
    private static final String EMAIL_ENCODING_PREF = ".emailEncoding";
    private static final String EMAIL_ENCODING_DEFAULT = Platform.getPlatform() == 1 ? System.getProperty("file.encoding") : "UTF-8";

    private InvitePreferences() {
    }

    public static boolean isEmailEncodingConfigurable() {
        return !"UTF-8".equals(System.getProperty("file.encoding"));
    }

    public static String getDefaultEmailEncoding() {
        return EMAIL_ENCODING_DEFAULT;
    }

    public static String getEmailEncoding(String prefix, Preferences preferences) {
        return preferences.getSetting(prefix + EMAIL_ENCODING_PREF, EMAIL_ENCODING_DEFAULT);
    }

    public static void setEmailEncoding(String prefix, Preferences preferences, String encoding) {
        preferences.setSetting(prefix + EMAIL_ENCODING_PREF, encoding);
    }
}

