/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.invite.module;

import com.elluminate.groupware.invite.module.InvitePreferences;
import com.elluminate.groupware.invite.module.StringsProperties;
import com.elluminate.gui.component.AbstractPreferencesPanel;
import com.elluminate.gui.component.ComboBoxCellRenderer;
import com.elluminate.gui.component.MultilineLabel;
import com.elluminate.gui.component.PreferencesPanelOwner;
import com.elluminate.util.I18n;
import com.elluminate.util.Preferences;
import com.elluminate.util.PropertiesEnum;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;

@Singleton
public class InviteOptionsPrefsPanel
extends AbstractPreferencesPanel {
    private I18n i18n;
    private JComboBox emailEncodingPopup;

    @Inject
    public InviteOptionsPrefsPanel(PreferencesPanelOwner owner, I18n i18n) {
        super(owner, i18n.getString((PropertiesEnum)StringsProperties.INVITEOPTIONS_TITLE));
        this.i18n = i18n;
    }

    protected void createContent() {
        this.setLayout(new BorderLayout(0, 6));
        this.add((Component)new MultilineLabel(this.i18n.getString((PropertiesEnum)StringsProperties.INVITEOPTIONS_EMAILENCODINGEXPLANATION)), "North");
        JPanel p = new JPanel(new GridBagLayout());
        this.add(p, "Center");
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.gridy = 0;
        gbc.gridx = 0;
        gbc.weightx = 0.0;
        gbc.insets.left = 0;
        p.add((Component)new JLabel(this.i18n.getString((PropertiesEnum)StringsProperties.INVITEOPTIONS_EMAILENCODINGLABEL)), gbc);
        gbc.gridx = 1;
        gbc.weightx = 100.0;
        gbc.insets.left = 6;
        this.emailEncodingPopup = new JComboBox();
        this.emailEncodingPopup.setMaximumRowCount(20);
        this.emailEncodingPopup.setRenderer(new EncodingRenderer(this.emailEncodingPopup.getRenderer()));
        this.emailEncodingPopup.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                InviteOptionsPrefsPanel.this.setModified(true);
            }
        });
        p.add((Component)this.emailEncodingPopup, gbc);
        Encoding enc = new Encoding();
        enc.name = "UTF-8";
        enc.displayName = this.i18n.getString((PropertiesEnum)StringsProperties.INVITEOPTIONS_ENCODINGUTF8DISPLAYNAME);
        this.emailEncodingPopup.addItem(enc);
        enc = new Encoding();
        enc.name = System.getProperty("file.encoding");
        enc.displayName = this.i18n.getString((PropertiesEnum)StringsProperties.INVITEOPTIONS_ENCODINGPLATFORMDISPLAYNAME, new Object[]{enc.name});
        this.emailEncodingPopup.addItem(enc);
    }

    protected void populate(Preferences preferences) {
        String prefix = this.getOwnerPrefix();
        this.setSelectedEncoding(InvitePreferences.getEmailEncoding(prefix, preferences));
    }

    protected void apply(Preferences preferences) {
        String prefix = this.getOwnerPrefix();
        InvitePreferences.setEmailEncoding(prefix, preferences, this.getSelectedEncoding());
    }

    protected void reset(Preferences preferences) {
        String prefix = this.getOwnerPrefix();
        InvitePreferences.setEmailEncoding(prefix, preferences, InvitePreferences.getDefaultEmailEncoding());
    }

    private String getSelectedEncoding() {
        Encoding enc = (Encoding)this.emailEncodingPopup.getSelectedItem();
        if (enc != null && enc instanceof Encoding) {
            return enc.name;
        }
        return null;
    }

    private void setSelectedEncoding(String encodingName) {
        int row = -1;
        for (int i = 0; i < this.emailEncodingPopup.getItemCount(); ++i) {
            Encoding enc = (Encoding)this.emailEncodingPopup.getItemAt(i);
            if (enc == null || !(enc instanceof Encoding) || !enc.name.equals(encodingName)) continue;
            row = i;
            break;
        }
        this.emailEncodingPopup.setSelectedIndex(row);
    }

    private static class Encoding {
        public String name;
        public String displayName;

        private Encoding() {
        }
    }

    private static class EncodingRenderer
    extends ComboBoxCellRenderer {
        public EncodingRenderer(ListCellRenderer defaultRenderer) {
            super(defaultRenderer);
        }

        protected void prepareComponent(Component cmp, JList list, Object value, int index, boolean selected, boolean focused) {
            if (value != null && value instanceof Encoding && cmp instanceof JLabel) {
                ((JLabel)cmp).setText(((Encoding)value).displayName);
            }
        }
    }
}

