/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.invite.module;

import com.elluminate.groupware.invite.InviteDebug;
import com.elluminate.groupware.invite.module.InviteModule;
import com.elluminate.groupware.invite.module.InvitePreferences;
import com.elluminate.groupware.invite.module.StringsProperties;
import com.elluminate.gui.Mnemonic;
import com.elluminate.gui.ModalDialog;
import com.elluminate.gui.component.EasyDialog;
import com.elluminate.util.Debug;
import com.elluminate.util.I18n;
import com.elluminate.util.PropertiesEnum;
import com.elluminate.util.browser.BrowserUtil;
import com.elluminate.util.log.LogSupport;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Locale;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;

public class InviteDialog
extends EasyDialog {
    private static final String COPY_ACTION_KEY = "copy-action";
    private static final String EMAIL_ACTION_KEY = "email-action";
    private I18n i18n = I18n.create((Object)((Object)this));
    private InviteModule module = null;
    private JTextPane messageField;
    private JTextPane linkField;
    private JCheckBox keepOpenBox;
    private JButton cancelButton;

    public InviteDialog(Component owner, String title, InviteModule module) {
        super(owner, title, true);
        this.module = module;
        this.setDefaultCloseOperation(2);
        JPanel p = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.anchor = 17;
        gbc.insets.top = 0;
        p.add((Component)new JLabel(this.i18n.getString((PropertiesEnum)StringsProperties.INVITEDIALOG_MESSAGELABEL)), gbc);
        gbc.anchor = 10;
        gbc.insets.top = 6;
        this.messageField = new JTextPane();
        this.messageField.setToolTipText(this.i18n.getString((PropertiesEnum)StringsProperties.INVITEDIALOG_MESSAGEEDITORTIP));
        this.messageField.setMargin(new Insets(1, 2, 1, 2));
        JScrollPane sp = new JScrollPane(this.messageField, 22, 31);
        sp.setPreferredSize(new Dimension(400, 90));
        p.add((Component)sp, gbc);
        gbc.anchor = 10;
        gbc.insets.top = 6;
        this.linkField = new JTextPane();
        this.linkField.setToolTipText(this.i18n.getString((PropertiesEnum)StringsProperties.INVITEDIALOG_LINKFIELDTIP));
        this.linkField.setMargin(new Insets(1, 2, 1, 2));
        this.linkField.setEditable(false);
        sp = new JScrollPane(this.linkField, 20, 31);
        sp.setPreferredSize(new Dimension(400, 65));
        p.add((Component)sp, gbc);
        gbc.anchor = 17;
        gbc.insets.top = 6;
        this.keepOpenBox = new JCheckBox(this.i18n.getString((PropertiesEnum)StringsProperties.INVITEDIALOG_KEEPWINDOWOPENBOX));
        this.keepOpenBox.setToolTipText(this.i18n.getString((PropertiesEnum)StringsProperties.INVITEDIALOG_KEEPWINDOWOPENBOXTIP));
        this.keepOpenBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (InviteDialog.this.keepOpenBox.isSelected()) {
                    InviteDialog.this.cancelButton.setText(InviteDialog.this.i18n.getString((PropertiesEnum)StringsProperties.INVITEDIALOG_DONEBUTTON));
                } else {
                    InviteDialog.this.cancelButton.setText(InviteDialog.this.i18n.getString((PropertiesEnum)StringsProperties.INVITEDIALOG_CANCELBUTTON));
                }
            }
        });
        p.add((Component)this.keepOpenBox, gbc);
        this.setContent(p);
        this.addCopyButton();
        this.addEmailButton();
        this.addCancelButton();
        this.messageField.setText(this.i18n.getString((PropertiesEnum)StringsProperties.INVITEDIALOG_DEFAULTMESSAGE, new Object[]{module.getSessionLabel(), module.getSessionDisplayName()}));
        StringBuffer b = new StringBuffer();
        b.append(module.getGuestLink());
        if (module.isSessionPasswordAvailable()) {
            b.append("\n");
            b.append(this.i18n.getString((PropertiesEnum)StringsProperties.INVITEDIALOG_DISPLAYAREAPASSWORDCONTENTS, new Object[]{module.getSessionPassword()}));
        }
        this.linkField.setText(b.toString());
    }

    private void doCopyToClipboard() {
        StringBuffer b = new StringBuffer();
        b.append(this.module.getGuestLink());
        if (this.module.isSessionPasswordAvailable()) {
            b.append("\n");
            b.append(this.i18n.getString((PropertiesEnum)StringsProperties.INVITEDIALOG_DISPLAYAREAPASSWORDCONTENTS, new Object[]{this.module.getSessionPassword()}));
        }
        b.append("\n");
        Clipboard cb = Toolkit.getDefaultToolkit().getSystemClipboard();
        cb.setContents(new StringSelection(b.toString()), null);
    }

    private boolean doEmail() {
        boolean result = false;
        try {
            StringBuffer sb = new StringBuffer();
            sb.append("mailto:");
            if (InviteDebug.FAKE_TO.show()) {
                sb.append("nobody@example.com");
            }
            if (InviteDebug.TEST_SUBJECT.show()) {
                sb.append("?subject=");
                sb.append("Test%20Subject");
            } else if (!InviteDebug.NO_SUBJECT.show()) {
                sb.append("?subject=");
                String sessionLabel = this.module.getSessionTitleLabel();
                String subj = this.i18n.getString((PropertiesEnum)StringsProperties.INVITEDIALOG_EMAILSUBJECT, new Object[]{sessionLabel});
                if (!InviteDebug.NO_ENCODE.show()) {
                    subj = this.encodeStringForURI(subj);
                }
                sb.append(subj);
            }
            if (!InviteDebug.NO_BODY.show()) {
                StringBuffer body = new StringBuffer();
                body.append(this.messageField.getText());
                body.append("\n\n");
                body.append(this.module.getGuestLink());
                if (this.module.isSessionPasswordAvailable() && !InviteDebug.NO_PASSWORD.show()) {
                    if (!InviteDebug.NO_NEWLINES.show()) {
                        body.append("\n");
                        body.append("\n");
                    }
                    body.append(this.i18n.getString((PropertiesEnum)StringsProperties.INVITEDIALOG_DISPLAYAREAPASSWORDCONTENTS, new Object[]{this.module.getSessionPassword()}));
                }
                String bodyText = body.toString();
                if (!InviteDebug.NO_ENCODE.show()) {
                    bodyText = this.encodeStringForURI(bodyText);
                }
                sb.append("&body=" + bodyText);
            }
            String uri = sb.toString();
            BrowserUtil.gotoURL((String)uri);
            result = true;
        }
        catch (IOException iox) {
            LogSupport.message((Object)((Object)this), (String)"doEmail", (String)Debug.getStackTrace((Throwable)iox));
            String title = this.i18n.getString((PropertiesEnum)StringsProperties.INVITEDIALOG_IOERRORDIALOGTITLE);
            String msg = this.i18n.getString((PropertiesEnum)StringsProperties.INVITEDIALOG_IOERRORDIALOGMSG, new Object[]{iox.toString()});
            ModalDialog.showMessageDialogAsync((int)-1, (Component)((Object)this), (Object)msg, (String)title, (int)0);
        }
        catch (Throwable t) {
            LogSupport.exception((Object)((Object)this), (String)"doEmail", (Throwable)t, (boolean)true);
        }
        return result;
    }

    private String encodeStringForURI(String s) throws UnsupportedEncodingException {
        StringBuffer b = new StringBuffer();
        String enc = InvitePreferences.getEmailEncoding(this.module.getPrefix(), this.module.getPreferences());
        byte[] data = s.getBytes(enc);
        for (int ix = 0; ix < data.length; ++ix) {
            int c = data[ix] & 0xFF;
            if (c == 10) {
                b.append("%0D%0A");
                continue;
            }
            if (c == 63) {
                b.append(this.encodeChar(c));
                continue;
            }
            if (c == 61) {
                b.append(this.encodeChar(c));
                continue;
            }
            if (c == 38) {
                b.append(this.encodeChar(c));
                continue;
            }
            if (c == 32) {
                b.append(this.encodeChar(c));
                continue;
            }
            if (c == 60) {
                b.append(this.encodeChar(c));
                continue;
            }
            if (c == 62) {
                b.append(this.encodeChar(c));
                continue;
            }
            if (c == 34) {
                b.append(this.encodeChar(c));
                continue;
            }
            if (c == 35) {
                b.append(this.encodeChar(c));
                continue;
            }
            if (c == 37) {
                b.append(this.encodeChar(c));
                continue;
            }
            if (c == 123) {
                b.append(this.encodeChar(c));
                continue;
            }
            if (c == 125) {
                b.append(this.encodeChar(c));
                continue;
            }
            if (c == 124) {
                b.append(this.encodeChar(c));
                continue;
            }
            if (c == 92) {
                b.append(this.encodeChar(c));
                continue;
            }
            if (c == 94) {
                b.append(this.encodeChar(c));
                continue;
            }
            if (c == 126) {
                b.append(this.encodeChar(c));
                continue;
            }
            if (c == 91) {
                b.append(this.encodeChar(c));
                continue;
            }
            if (c == 93) {
                b.append(this.encodeChar(c));
                continue;
            }
            if (c == 96) {
                b.append(this.encodeChar(c));
                continue;
            }
            if (c < 32) {
                b.append(this.encodeChar(c));
                continue;
            }
            if (c > 127) {
                b.append(this.encodeChar(c));
                continue;
            }
            b.append((char)c);
        }
        return b.toString();
    }

    private String encodeChar(int c) {
        StringBuffer result = new StringBuffer(8);
        result.append('%');
        if (c < 16) {
            result.append('0');
        }
        if (c > 255 && c < 4096) {
            result.append('0');
        }
        result.append(Integer.toHexString(c).toUpperCase(Locale.ENGLISH));
        return result.toString();
    }

    private void addCopyButton() {
        String copyButtonLookupString = this.i18n.getString((PropertiesEnum)StringsProperties.INVITEDIALOG_COPYBUTTONLABEL);
        JButton copyButton = new JButton();
        copyButton.setAction(new AbstractAction(Mnemonic.getText((String)copyButtonLookupString)){

            @Override
            public void actionPerformed(ActionEvent e) {
                InviteDialog.this.doCopyToClipboard();
                if (!InviteDialog.this.keepOpenBox.isSelected()) {
                    InviteDialog.this.performDefaultCloseOperation();
                }
            }

            @Override
            public Object getValue(String key) {
                if ("ShortDescription".equals(key)) {
                    return InviteDialog.this.i18n.getString((PropertiesEnum)StringsProperties.INVITEDIALOG_COPYBUTTONTIP);
                }
                return super.getValue(key);
            }
        });
        Mnemonic.setMnemonic((AbstractButton)copyButton, (String)copyButtonLookupString);
        KeyStroke copyKeyStroke = KeyStroke.getKeyStroke((int)Mnemonic.getMnemonic((String)copyButtonLookupString), 0);
        this.getRootPane().getLayeredPane().getActionMap().put(COPY_ACTION_KEY, copyButton.getAction());
        this.getRootPane().getLayeredPane().getInputMap(1).put(copyKeyStroke, COPY_ACTION_KEY);
        this.addAlternateActionButton(copyButton);
    }

    private void addEmailButton() {
        String emailButtonLookupString = this.i18n.getString((PropertiesEnum)StringsProperties.INVITEDIALOG_EMAILBUTTONLABEL);
        JButton emailButton = new JButton();
        emailButton.setAction(new AbstractAction(Mnemonic.getText((String)emailButtonLookupString)){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean success = InviteDialog.this.doEmail();
                if (success && !InviteDialog.this.keepOpenBox.isSelected()) {
                    InviteDialog.this.performDefaultCloseOperation();
                }
            }

            @Override
            public Object getValue(String key) {
                if ("ShortDescription".equals(key)) {
                    return InviteDialog.this.i18n.getString((PropertiesEnum)StringsProperties.INVITEDIALOG_EMAILBUTTONTIP);
                }
                return super.getValue(key);
            }
        });
        Mnemonic.setMnemonic((AbstractButton)emailButton, (String)emailButtonLookupString);
        KeyStroke emailKeyStroke = KeyStroke.getKeyStroke((int)Mnemonic.getMnemonic((String)emailButtonLookupString), 0);
        this.getRootPane().getLayeredPane().getActionMap().put(EMAIL_ACTION_KEY, emailButton.getAction());
        this.getRootPane().getLayeredPane().getInputMap(1).put(emailKeyStroke, EMAIL_ACTION_KEY);
        this.addActionButton(emailButton, true);
    }

    private void addCancelButton() {
        this.cancelButton = this.makeButton(this.i18n.getString((PropertiesEnum)StringsProperties.INVITEDIALOG_CANCELBUTTON));
        this.addCancelButton(this.cancelButton);
    }
}

