/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.quiz;

import com.elluminate.groupware.quiz.Answer;
import com.elluminate.groupware.quiz.Question;
import com.elluminate.groupware.quiz.Quiz;
import com.elluminate.groupware.quiz.QuizException;
import com.elluminate.groupware.quiz.QuizInvalidException;
import com.elluminate.groupware.quiz.QuizReadException;
import com.elluminate.groupware.quiz.Response;
import com.elluminate.util.ShortList;
import com.elluminate.util.log.LogSupport;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import org.jdom.Attribute;
import org.jdom.Content;
import org.jdom.Element;

public class Responses
implements Cloneable {
    public static final String MARKING_GUIDE = "  *** MARKING GUIDE ***  ";
    public static final String ME = "  *** ME ***  ";
    private static final byte ENC_DONE = 0;
    private static final byte ENC_INDEX = 1;
    private static final byte ENC_TEXT = 2;
    private String user = null;
    private boolean complete = false;
    private HashMap responses = new HashMap();

    public Responses(String forUser) {
        this.user = forUser;
    }

    public Responses(DataInputStream str) throws IOException {
        byte type;
        this.user = str.readUTF();
        this.complete = str.readBoolean();
        while ((type = str.readByte()) != 0) {
            short q = str.readShort();
            Response r = null;
            switch (type) {
                case 1: {
                    r = new Response(str.readShort());
                    break;
                }
                case 2: {
                    r = new Response(str.readUTF());
                    break;
                }
                default: {
                    throw new IOException("Unknown response encoding " + type);
                }
            }
            this.setResponse(q, r);
        }
    }

    public String getResponseOwner() {
        return this.user;
    }

    public boolean isComplete() {
        return this.complete;
    }

    public void setComplete(boolean done) {
        this.complete = done;
    }

    public short getResponseCount() {
        return (short)this.responses.size();
    }

    public Response getResponse(short question) {
        Short key = ShortList.get((short)question);
        return (Response)this.responses.get(key);
    }

    public void setResponse(short question, Response resp) {
        Short key = ShortList.get((short)question);
        if (resp == null) {
            this.responses.remove(key);
        } else {
            this.responses.put(key, resp);
        }
    }

    public void trim(short count) {
        Iterator i = this.responses.keySet().iterator();
        while (i.hasNext()) {
            Short key = (Short)i.next();
            if (key < count) continue;
            i.remove();
        }
    }

    public Object clone() {
        Responses other;
        try {
            other = (Responses)super.clone();
        }
        catch (CloneNotSupportedException ex) {
            return null;
        }
        other.responses = new HashMap();
        for (Short key : this.responses.keySet()) {
            Response resp = (Response)this.responses.get(key);
            other.responses.put(key, resp);
        }
        return other;
    }

    public void encode(DataOutputStream str) {
        try {
            str.writeUTF(this.user);
            str.writeBoolean(this.complete);
            for (Short q : this.responses.keySet()) {
                Response r = (Response)this.responses.get(q);
                if (r.hasSelection()) {
                    str.writeByte(1);
                    str.writeShort(q.shortValue());
                    str.writeShort(r.getSelection());
                    continue;
                }
                str.writeByte(2);
                str.writeShort(q.shortValue());
                str.writeUTF(r.getText());
            }
            str.writeByte(0);
        }
        catch (IOException ex) {
            LogSupport.exception((Object)this, (String)"encode", (Throwable)ex, (boolean)true);
        }
    }

    public String toString() {
        return this.toString("");
    }

    public String toString(String prefix) {
        StringBuffer buf = new StringBuffer();
        buf.append(prefix);
        buf.append("Responses for '");
        buf.append(this.user);
        buf.append("':\n");
        for (Short key : this.responses.keySet()) {
            Response resp = (Response)this.responses.get(key);
            buf.append(prefix);
            buf.append("    ");
            buf.append(key);
            buf.append("=");
            buf.append(resp);
            buf.append("\n");
        }
        return buf.toString();
    }

    public void validate(Quiz quiz) throws QuizException {
        for (Short key : this.responses.keySet()) {
            Response resp = (Response)this.responses.get(key);
            try {
                Answer a;
                Question question = quiz.getQuestion(key);
                if (resp == null) continue;
                if (resp.hasSelection() && !question.isMultipleChoice() || !resp.hasSelection() && !question.isShortAnswer()) {
                    throw new QuizInvalidException("mismatchedQuestionResponse", quiz.getText());
                }
                if (!resp.hasSelection() || (a = question.getAnswer(resp.getSelection())) != null) continue;
                throw new QuizInvalidException("invalidResponse", quiz.getText());
            }
            catch (IndexOutOfBoundsException ex) {
                throw new QuizInvalidException("invalidResponse", quiz.getText());
            }
        }
    }

    public void writeXML(Element top) {
        top.setAttribute("name", this.user);
        for (Short key : this.responses.keySet()) {
            Response resp = (Response)this.responses.get(key);
            Element e = new Element("value");
            e.setAttribute("q", key.toString());
            if (resp.hasSelection()) {
                e.setAttribute("a", Short.toString(resp.getSelection()));
            } else {
                e.addContent(resp.getText());
            }
            top.addContent((Content)e);
        }
    }

    public void readXML(String src, Element top) throws QuizException {
        Attribute attr = top.getAttribute("name");
        if (attr == null || attr.getValue().equals("")) {
            throw new QuizReadException(src, "noResponseName");
        }
        this.user = attr.getValue();
        this.responses = new HashMap();
        this.complete = true;
        for (Element e : top.getChildren("value")) {
            try {
                Response r;
                attr = e.getAttribute("q");
                if (attr == null) {
                    throw new QuizReadException(src, "missingQuestionIndex", this.user);
                }
                short q = (short)attr.getIntValue();
                attr = e.getAttribute("a");
                if (attr != null) {
                    short a = (short)attr.getIntValue();
                    r = new Response(a);
                } else {
                    String txt = e.getTextTrim();
                    r = new Response(txt);
                }
                this.responses.put(ShortList.get((short)q), r);
            }
            catch (Exception ex) {
                String arg = attr != null ? attr.getValue() : "";
                throw new QuizReadException(src, "conversionError", arg);
            }
        }
    }
}

