/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.quiz;

import com.elluminate.groupware.quiz.QuizEvent;
import com.elluminate.groupware.quiz.QuizListener;
import com.elluminate.util.Debug;
import com.elluminate.util.log.LogSupport;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class QuizPart
implements QuizListener,
Cloneable {
    private String text = null;
    private String html = null;
    private QuizPart parent = null;
    private short index = (short)-1;
    private ArrayList listeners = new ArrayList();
    private Object listenerLock = new Object();

    public QuizPart getParent() {
        return this.parent;
    }

    protected void setParent(QuizPart parent) {
        this.parent = parent;
    }

    public short getIndex() {
        return this.index;
    }

    public void setIndex(short idx) {
        this.index = idx;
    }

    public short getStatsTotal() {
        return this.parent.getStatsTotal();
    }

    public short getStatsCount() {
        return 0;
    }

    public boolean hasText() {
        return this.text != null;
    }

    protected void clearHtml() {
        this.html = null;
    }

    public void setText(String text) {
        this.text = text;
        this.clearHtml();
        this.fireTextChanged();
    }

    public String getText() {
        return this.text;
    }

    public String getHtml() {
        return this.getHtml(null, null);
    }

    public String getHtml(String pre, String post) {
        String txt = this.getText();
        if (this.html == null && txt != null && !txt.equals("")) {
            StringBuffer buf = new StringBuffer();
            buf.append("<html>\n  <head></head>\n  <body>\n");
            if (pre != null) {
                buf.append(pre);
            }
            QuizPart.textToHtml(buf, txt, "    ");
            if (post != null) {
                buf.append(post);
            }
            buf.append("  </body>\n</html>\n");
            this.html = buf.toString();
        }
        if (this.html != null) {
            return this.html;
        }
        return "";
    }

    public static String textToHtml(String text) {
        StringBuffer buf = new StringBuffer();
        QuizPart.textToHtml(buf, text, "");
        return buf.toString();
    }

    public static void textToHtml(StringBuffer buf, String text, String prefix) {
        StringTokenizer parser = new StringTokenizer(text, "\n");
        String brk = null;
        while (parser.hasMoreTokens()) {
            String line = parser.nextToken();
            buf.append(prefix);
            if (brk != null) {
                buf.append(brk);
            }
            buf.append(line);
            if (parser.hasMoreTokens()) {
                buf.append("\n");
            }
            brk = "<br>";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addQuizListener(QuizListener lst) {
        Debug.lockEnter((Object)this, (String)"addQuizListener", (String)"listenerLock", (Object)this.listenerLock);
        Object object = this.listenerLock;
        synchronized (object) {
            if (!this.listeners.contains(lst)) {
                ArrayList<QuizListener> newList = new ArrayList<QuizListener>(this.listeners);
                newList.add(lst);
                this.listeners = newList;
            }
        }
        Debug.lockLeave((Object)this, (String)"addQuizListener", (String)"listenerLock", (Object)this.listenerLock);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeQuizListener(QuizListener lst) {
        Debug.lockEnter((Object)this, (String)"removeQuizListener", (String)"listenerLock", (Object)this.listenerLock);
        Object object = this.listenerLock;
        synchronized (object) {
            if (this.listeners.contains(lst)) {
                ArrayList newList = new ArrayList(this.listeners);
                newList.remove(lst);
                this.listeners = newList;
            }
        }
        Debug.lockLeave((Object)this, (String)"removeQuizListener", (String)"listenerLock", (Object)this.listenerLock);
    }

    protected void fireQuizChange(byte action, byte detail, short qIdx, short arg) {
        this.fireQuizChange(new QuizEvent(this, action, detail, qIdx, arg));
    }

    protected void fireQuizChange(byte action, short qIdx, short arg) {
        this.fireQuizChange(new QuizEvent(this, action, qIdx, arg));
    }

    protected void fireQuizChange(byte action, short qIdx) {
        this.fireQuizChange(new QuizEvent(this, action, qIdx));
    }

    protected void fireQuizChange(byte action) {
        this.fireQuizChange(new QuizEvent(this, action));
    }

    protected void fireQuizChange(QuizEvent e) {
        if (this.parent != null) {
            this.parent.fireQuizChange(e);
        } else {
            this.fireQuizChangeLocal(e);
        }
    }

    protected void fireQuizChangeLocal(QuizEvent e) {
        for (QuizListener lst : this.listeners) {
            try {
                lst.onQuizChange(e);
            }
            catch (Throwable t) {
                LogSupport.exception((Object)this, (String)"fireQuizChanged", (Throwable)t, (boolean)true, (String)("while calling " + lst));
            }
        }
    }

    public void fireTextChanged() {
    }

    @Override
    public void onQuizChange(QuizEvent e) {
    }

    public Object clone() {
        try {
            QuizPart part = (QuizPart)super.clone();
            part.listeners = new ArrayList();
            return part;
        }
        catch (CloneNotSupportedException ex) {
            return null;
        }
    }
}

