/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.quiz;

import com.elluminate.groupware.quiz.Question;
import com.elluminate.groupware.quiz.QuizEvent;
import com.elluminate.groupware.quiz.QuizPart;
import com.elluminate.groupware.quiz.Response;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.StringTokenizer;
import org.jdom.Element;

public class Answer
extends QuizPart
implements Cloneable {
    private boolean selectable;

    public Answer() {
        this.selectable = false;
    }

    public Answer(String desc) {
        this.selectable = true;
        this.setText(desc);
    }

    public Answer(DataInputStream str) throws IOException {
        this.selectable = str.readBoolean();
        if (this.selectable) {
            this.setText(str.readUTF());
        }
    }

    @Override
    public short getStatsCount() {
        Question question = (Question)this.getParent();
        return question.getStatsCount(this.getIndex());
    }

    @Override
    public String getText() {
        if (this.selectable) {
            return super.getText();
        }
        Question q = (Question)this.getParent();
        Response r = q.getResponse();
        if (r == null) {
            return null;
        }
        return r.getText();
    }

    @Override
    public void setText(String txt) {
        if (this.selectable) {
            super.setText(txt);
        } else {
            this.clearHtml();
            Question q = (Question)this.getParent();
            if (q == null) {
                return;
            }
            if (txt == null || txt.equals("")) {
                q.setResponse(null);
            } else {
                q.setResponse(new Response(txt));
            }
        }
    }

    public boolean isSelectable() {
        return this.selectable;
    }

    public boolean isSelected() {
        return this.isSelectedBy("  *** ME ***  ");
    }

    public boolean isSelectedBy(String name) {
        if (!this.selectable) {
            throw new UnsupportedOperationException("This answer is not selectable.");
        }
        Question question = (Question)this.getParent();
        if (question == null) {
            throw new IllegalStateException("Unable to determine selection of an answer not part of a quiz.");
        }
        Response response = question.getResponseFor(name);
        if (response == null) {
            return false;
        }
        return response.getSelection() == this.getIndex();
    }

    public void setSelected(boolean select) {
        this.setSelectedBy("  *** ME ***  ", select);
    }

    public void setSelectedBy(String name, boolean select) {
        if (!this.selectable) {
            throw new UnsupportedOperationException("This answer is not selectable.");
        }
        Question question = (Question)this.getParent();
        if (question == null) {
            throw new IllegalStateException("Unable to set selection of an answer not part of a quiz.");
        }
        if (select) {
            question.setResponseFor(name, new Response(this.getIndex()));
        } else if (this.isSelectedBy(name)) {
            question.setResponseFor(name, null);
        }
    }

    public boolean isCorrect() {
        if (!this.selectable) {
            throw new UnsupportedOperationException("This answer is not selectable.");
        }
        Question question = (Question)this.getParent();
        Response response = question.getCorrectResponse();
        if (response == null) {
            return false;
        }
        return response.getSelection() == this.getIndex();
    }

    public void setCorrect(boolean select) {
        if (!this.selectable) {
            throw new UnsupportedOperationException("This answer is not selectable.");
        }
        Question question = (Question)this.getParent();
        if (select) {
            question.setCorrectResponse(new Response(this.getIndex()));
        } else if (this.isCorrect()) {
            question.setCorrectResponse(null);
        }
    }

    @Override
    public void onQuizChange(QuizEvent e) {
        if (e.getAction() == 3) {
            return;
        }
        if (e.getAnswerIndex() == this.getIndex() || e.getAnswerIndex() == -1) {
            this.fireQuizChangeLocal(e);
        }
    }

    @Override
    public void fireTextChanged() {
        QuizPart parent = this.getParent();
        short px = parent != null ? (short)parent.getIndex() : (short)-2;
        this.fireQuizChange((byte)4, px, this.getIndex());
    }

    @Override
    public Object clone() {
        return super.clone();
    }

    public void encode(DataOutputStream str) throws IOException {
        str.writeBoolean(this.selectable);
        if (this.selectable) {
            str.writeUTF(this.getText());
        }
    }

    public String toString() {
        return this.toString("");
    }

    public String toString(String prefix) {
        StringBuffer buf = new StringBuffer();
        buf.append(prefix);
        if (this.selectable) {
            StringTokenizer parser = new StringTokenizer(this.getText(), "\n", true);
            while (parser.hasMoreTokens()) {
                String line = parser.nextToken();
                buf.append(line);
                if (!line.equals("\n")) continue;
                buf.append(prefix);
            }
        } else {
            buf.append("[]");
        }
        return buf.toString();
    }

    public void validate(Question q, short idx) {
        if (this.getParent() != q) {
            throw new RuntimeException("Quiz tree structure corrupt.\nAnswer " + idx + " of question " + q.getText() + " has wrong parent.");
        }
        if (this.getIndex() != idx) {
            throw new RuntimeException("Index mismatch in answer '" + (this.hasText() ? this.getText() : "<short answer>") + "' of question " + q.getText() + "\n  actual=" + idx + ", stored=" + this.getIndex());
        }
    }

    public void repair(Question q, short idx) {
        this.setParent(q);
        this.setIndex(idx);
    }

    public void writeXML(Element top) {
        if (this.isSelectable()) {
            top.addContent(this.getText());
        }
    }

    public void readXML(String src, Element top) {
        String txt = top.getTextTrim();
        if (txt == null || txt.equals("")) {
            this.selectable = false;
        } else {
            this.selectable = true;
            this.setText(txt);
        }
    }
}

